/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.io;

import ipsk.io.FloatStream;
import ipsk.io.InterleavedFloatStream;
import java.io.IOException;
import java.util.Arrays;

public class InterleavedJoinFloatStream
implements InterleavedFloatStream {
    private static final int DEF_BUF_SIZE = 1024;
    private int bufSize = 1024;
    private FloatStream[] srcStreams;
    private Channel[] channels;

    public InterleavedJoinFloatStream(FloatStream[] srcStreams) {
        this.srcStreams = srcStreams;
        this.channels = new Channel[srcStreams.length];
        for (int ch = 0; ch < this.channels.length; ++ch) {
            Channel c = this.channels[ch];
            c.srcStream = srcStreams[ch];
            c.buf = new double[this.bufSize];
        }
    }

    @Override
    public int read(double[][] buf, int offset, int len) throws IOException {
        if (len > this.bufSize) {
            len = this.bufSize;
        }
        int minAvail = Integer.MAX_VALUE;
        int maxAvail = Integer.MIN_VALUE;
        boolean allEof = true;
        for (Channel c : this.channels) {
            if (!c.eof) {
                allEof = false;
            }
            if (c.avail < minAvail) {
                minAvail = c.avail;
            }
            if (c.avail <= maxAvail) continue;
            maxAvail = c.avail;
        }
        if (allEof) {
            return -1;
        }
        if (minAvail == 0) {
            minAvail = Integer.MAX_VALUE;
            for (int ch = 0; ch < this.channels.length; ++ch) {
                Channel c = this.channels[ch];
                if (c.eof) {
                    c.avail = this.bufSize;
                } else {
                    int os = c.avail;
                    int toRead = len - os;
                    if (toRead > 0) {
                        int r = c.srcStream.read(c.buf, os, toRead);
                        if (r == -1) {
                            c.eof = true;
                            Arrays.fill(c.buf, 0.0);
                            c.avail = this.bufSize;
                        } else {
                            c.avail += r;
                        }
                    }
                }
                if (c.avail >= minAvail) continue;
                minAvail = c.avail;
            }
        }
        return 0;
    }

    @Override
    public long skip(long skip) throws IOException {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        for (FloatStream fs : this.srcStreams) {
            fs.close();
        }
    }

    @Override
    public Integer getChannels() {
        return this.srcStreams.length;
    }

    public class Channel {
        FloatStream srcStream;
        int avail = 0;
        int bufPos = 0;
        double[] buf;
        boolean eof = false;
    }
}

