/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Path;

public class Utils {
    public static URI createAsciiURIFromFile(File file) throws URISyntaxException {
        URI fileURInonAscii = file.toURI();
        String fileURIAsciiStr = fileURInonAscii.toASCIIString();
        URI fileURIAscii = new URI(fileURIAsciiStr);
        return fileURIAscii;
    }

    public static URL createAsciiURLFromFile(File file) throws URISyntaxException, MalformedURLException {
        URI asciiURI = Utils.createAsciiURIFromFile(file);
        URL asciiURL = asciiURI.toURL();
        return asciiURL;
    }

    public static String createAsciiURLExtFormFromFile(File file) throws URISyntaxException, MalformedURLException {
        URL url = Utils.createAsciiURLFromFile(file);
        return url.toExternalForm();
    }

    @Deprecated
    public static File fileFromURL(URL url) {
        String path;
        if ("file".equalsIgnoreCase(url.getProtocol()) && (path = url.getPath()) != null && !"".equals(path)) {
            return new File(path);
        }
        return null;
    }

    public static File fileFromDecodedURL(URL url) throws UnsupportedEncodingException {
        String path;
        if ("file".equalsIgnoreCase(url.getProtocol()) && (path = url.getPath()) != null && !"".equals(path)) {
            String decpath = URLDecoder.decode(path, Charset.defaultCharset().name());
            return new File(decpath);
        }
        return null;
    }

    public static Path pathFromDecodedURL(URL url) throws UnsupportedEncodingException {
        String path;
        if ("file".equalsIgnoreCase(url.getProtocol()) && (path = url.getPath()) != null && !"".equals(path)) {
            String decpath = URLDecoder.decode(path, Charset.defaultCharset().name());
            return Path.of(decpath, new String[0]);
        }
        return null;
    }
}

