/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.text.xml;

import ipsk.awt.AWTEventTransferAgent;
import ipsk.swing.text.xml.XMLParserEvent;
import ipsk.swing.text.xml.XMLParserListener;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import org.xml.sax.InputSource;

public class XMLParserThread
extends Thread {
    private AWTEventTransferAgent<XMLParserListener, XMLParserEvent> etTa = new AWTEventTransferAgent<XMLParserListener, XMLParserEvent>(){

        @Override
        protected void fireEvent(XMLParserListener listener, XMLParserEvent event) {
            listener.update(event);
        }
    };
    private volatile DOMConverter domConverter;
    private volatile InputSource inputSource;

    public XMLParserThread(ThreadGroup group, InputSource inputSource) throws DOMConverterException {
        super(group, "XML Validator");
        this.inputSource = inputSource;
        this.domConverter = new DOMConverter();
        this.domConverter.setValidating(true);
    }

    @Override
    public void run() {
        try {
            this.domConverter.readXML(this.inputSource);
            this.etTa.fireAWTEventLater(new XMLParserEvent(this));
        }
        catch (DOMConverterException e) {
            this.etTa.fireAWTEventLater(new XMLParserEvent(this, e));
        }
    }

    public synchronized void addListener(XMLParserListener listener) {
        this.etTa.addListener(listener);
    }

    public synchronized void removeListener(XMLParserListener listener) {
        this.etTa.removeListener(listener);
    }
}

