/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

public class MediaTimeFormat
extends Format {
    public static Format MEDIA_TIME_FORMAT = new MediaTimeFormat();
    private double seconds;
    private DecimalFormat hourMinSecFormatter = new DecimalFormat("00");
    private DecimalFormat secMilliSecFormatter = new DecimalFormat("00.000");
    private boolean showMilliSeconds = true;

    private String toHourMinuteSecondMilliSecond(double seconds) {
        int minutes = (int)seconds / 60;
        double rest = seconds - (double)minutes * 60.0;
        int hours = minutes / 60;
        minutes -= hours * 60;
        StringBuffer sb = new StringBuffer();
        sb.append(this.hourMinSecFormatter.format(hours));
        sb.append(":");
        sb.append(this.hourMinSecFormatter.format(minutes));
        sb.append(":");
        if (this.showMilliSeconds) {
            sb.append(this.secMilliSecFormatter.format(rest));
        } else {
            sb.append(this.hourMinSecFormatter.format(rest));
        }
        return sb.toString();
    }

    private String toHourMinuteSecondMilliSecond(long nanoseconds) {
        double seconds = (double)nanoseconds / 1.0E9;
        return this.toHourMinuteSecondMilliSecond(seconds);
    }

    @Override
    public Object parseObject(String timeStr, ParsePosition parsePosition) {
        double seconds;
        int pInd = parsePosition.getIndex();
        if (parsePosition == null) {
            throw new NullPointerException();
        }
        try {
            seconds = 3600.0 * Double.parseDouble(timeStr.substring(pInd, pInd + 2));
        }
        catch (NumberFormatException nfe) {
            parsePosition.setErrorIndex(pInd);
            return null;
        }
        if (timeStr.charAt(pInd += 2) != ':') {
            parsePosition.setErrorIndex(pInd);
            return null;
        }
        ++pInd;
        try {
            String subStr = timeStr.substring(pInd, pInd + 2);
            seconds += 60.0 * Double.parseDouble(subStr);
        }
        catch (NumberFormatException nfe) {
            parsePosition.setErrorIndex(pInd);
            return null;
        }
        if (timeStr.charAt(pInd += 2) != ':') {
            parsePosition.setErrorIndex(pInd);
            return null;
        }
        ++pInd;
        try {
            seconds += Double.parseDouble(timeStr.substring(pInd, pInd + 2));
        }
        catch (NumberFormatException nfe) {
            parsePosition.setErrorIndex(pInd);
            return null;
        }
        if (timeStr.charAt(pInd += 2) != '.') {
            parsePosition.setErrorIndex(pInd);
            return null;
        }
        try {
            double nanos = 1000.0 * Double.parseDouble(timeStr.substring(pInd, pInd + 3));
        }
        catch (NumberFormatException nfe) {
            parsePosition.setErrorIndex(pInd);
            return null;
        }
        parsePosition.setIndex(pInd += 3);
        return nanos += seconds * 1.0E9;
    }

    @Override
    public StringBuffer format(Object arg0, StringBuffer arg1, FieldPosition arg2) {
        if (arg0 == null) {
            return new StringBuffer("--:--:--");
        }
        if (arg0 instanceof Double) {
            double val = (Double)arg0;
            arg1.append(this.toHourMinuteSecondMilliSecond(val));
            return arg1;
        }
        if (arg0 instanceof Long) {
            long val = (Long)arg0;
            arg1.append(this.toHourMinuteSecondMilliSecond(val));
            return arg1;
        }
        return null;
    }

    public static void main(String[] args) {
        MediaTimeFormat mtf = new MediaTimeFormat();
        String result = mtf.format(36012.0);
        System.out.println(result);
        try {
            System.out.println(mtf.parseObject(result));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            System.out.println(mtf.parseObject("01:02:09.897"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public boolean isShowMilliSeconds() {
        return this.showMilliSeconds;
    }

    public void setShowMilliSeconds(boolean showMilliSeconds) {
        this.showMilliSeconds = showMilliSeconds;
    }
}

