/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text.html;

public class HTMLTextEncoder {
    public static String encode(String fm) {
        return HTMLTextEncoder.encode(fm, true);
    }

    public static String encode(String fm, boolean encodeNewLines) {
        int len = fm.length();
        int i = 0;
        while (i < len) {
            String c;
            if (fm.charAt(i) == '&') {
                c = fm.substring(0, i);
                c = c.concat("&#38;");
                fm = c = c.concat(fm.substring(i + 1));
                i += 5;
                len = fm.length();
                continue;
            }
            if (fm.charAt(i) == ';') {
                c = fm.substring(0, i);
                c = c.concat("&#59;");
                fm = c = c.concat(fm.substring(i + 1));
                i += 5;
                len = fm.length();
                continue;
            }
            ++i;
        }
        fm = fm.replaceAll("<", "&#60;");
        fm = fm.replaceAll(">", "&#62;");
        fm = fm.replaceAll("\"", "&#34;");
        fm = fm.replaceAll("\\\\", "&#92;");
        fm = fm.replaceAll("%", "&#37;");
        fm = fm.replaceAll("[(]", "&#40;");
        fm = fm.replaceAll("[)]", "&#41;");
        fm = fm.replaceAll("[+]", "&#43;");
        if (encodeNewLines) {
            fm = fm.replaceAll("\n", "<br>");
        }
        return fm;
    }

    public static void main(String[] args) {
        String testString = "Input string: Hello World ! <> && ;; &auml;";
        System.out.println("HTML Encoded: " + HTMLTextEncoder.encode(testString));
    }
}

