//    IPS Java Utils
//    (c) Copyright 2009-2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.sql;

import java.util.List;

import ipsk.text.StringSequenceBuilder;

/**
 * SQL/JPQL group by clause.
 * @author klausj
 *
 */
public class GroupByClause {

	private List<String> columns;

	
	public GroupByClause(List<String> columns){
		this.columns=columns;
	}
	
	public List<String> getColumns() {
		return columns;
	}

	public String toSQLString(){
		if (columns==null || columns.size()==0) return "";
		String groupByStr=" GROUP BY ";
		String colsStr=StringSequenceBuilder.buildString(columns, ',');
		
		return groupByStr+colsStr;
	}
	
	public String toJPQLString(String jpqlSelectExpression){
		if (columns==null || columns.size()==0) return "";
		String groupByStr=" GROUP BY ";
		int colsSize=columns.size();
		for(int i=0;i<colsSize;i++){
			String column=columns.get(i);
			groupByStr=groupByStr.concat(jpqlSelectExpression+"."+column);
			if (i<colsSize-1){
				groupByStr=groupByStr.concat(", ");
			}
		}
		return groupByStr;
	}
	
}
