/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.apps;

import ipsk.awt.ProgressListener;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressEvent;
import ipsk.io.VectorBufferedInputStream;
import ipsk.io.VectorBufferedOutputStream;
import ipsk.net.URLContentLoader;
import ipsk.text.ParserException;
import ipsk.text.StringTokenizer;
import ipsk.text.Version;
import ipsk.text.VersionPattern;
import ipsk.util.apps.UpdateManagerEvent;
import ipsk.util.apps.UpdateManagerListener;
import ipsk.util.apps.descriptor.ApplicationDescriptor;
import ipsk.util.apps.descriptor.ApplicationVersionDescriptor;
import ipsk.util.apps.descriptor.Change;
import ipsk.util.apps.descriptor.InstallationPackage;
import ipsk.util.apps.event.UpdateAvailableEvent;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

public class UpdateManager
implements ProgressListener {
    private static final boolean DEBUG = false;
    public final String APPLICATION_DESCRIPTOR_KEY = "ipsk.util.apps.descriptor.url";
    public final String APPLICATION_DESCRIPTOR_INSTALLATION_TYPE = "ipsk.util.apps.descriptor.installationType";
    public final String APPLICATION_DESCRIPTOR_OPTIONS = "ipsk.util.apps.descriptor.options";
    private static final int DEFAULT_NETWORK_TIMEOUT = 300000;
    private int netWorkTimeout = 300000;
    private URL applicationDescriptorURL = null;
    private ApplicationDescriptor applicationDescriptor;
    private Version currentVersion;
    private volatile URLContentLoader loader;
    private volatile VectorBufferedOutputStream loaderOutputStream;
    private Vector<UpdateManagerListener> listeners = new Vector();
    private String osName;
    private String installationType;
    private List<Option> optionsList = null;
    private String osArch;
    private String osVersion;
    private Status status = Status.IDLE;
    private Desktop desktop = null;

    public URL getApplicationDescriptorURL() {
        return this.applicationDescriptorURL;
    }

    public void setApplicationDescriptorURL(URL applicationDescriptorURL) {
        this.applicationDescriptorURL = applicationDescriptorURL;
    }

    public Version getCurrentVersion() {
        return this.currentVersion;
    }

    public Status getStatus() {
        return this.status;
    }

    protected UpdateManager() {
        this.installationType = System.getProperty("ipsk.util.apps.descriptor.installationType");
        String optionsString = System.getProperty("ipsk.util.apps.descriptor.options");
        if (optionsString != null) {
            this.optionsList = this.parseOptions(optionsString);
        }
        this.osName = System.getProperty("os.name");
        this.osArch = System.getProperty("os.arch");
        this.osVersion = System.getProperty("os.version");
        if (Desktop.isDesktopSupported()) {
            this.desktop = Desktop.getDesktop();
        }
    }

    public void printPlatformInfos() {
        System.out.println("Running platform:");
        System.out.println("osName: " + this.osName);
        System.out.println("osArch: " + this.osArch);
        System.out.println("osVersion: " + this.osVersion);
    }

    private List<Option> parseOptions(String optionsString) {
        String[] optionsArr;
        ArrayList<Option> optionsList = new ArrayList<Option>();
        for (String option : optionsArr = StringTokenizer.split(optionsString, ',', true)) {
            String key = null;
            String value = null;
            int kvSepI = option.indexOf(58);
            if (kvSepI > 0) {
                key = option.substring(0, kvSepI);
                value = option.substring(kvSepI + 1);
            } else {
                key = option;
            }
            if (key == null) continue;
            Option o = new Option();
            o.key = key;
            o.value = value;
            optionsList.add(o);
        }
        return optionsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateManager(Version currentVersion, ApplicationDescriptor applicationDescriptor) {
        this();
        this.currentVersion = currentVersion;
        this.applicationDescriptor = applicationDescriptor;
        this.applyPlatformDependencies();
        Vector<UpdateManagerListener> vector = this.listeners;
        synchronized (vector) {
            if (this.applicationDescriptor != null) {
                this.status = Status.SUCCESS;
            }
        }
    }

    public UpdateManager(Version currentVersion) {
        this();
        this.currentVersion = currentVersion;
        this.applicationDescriptor = null;
    }

    public void startLoadApplicationDescriptor() {
        String appDescrUrlParam;
        if (this.applicationDescriptorURL == null && (appDescrUrlParam = System.getProperty("ipsk.util.apps.descriptor.url")) != null) {
            try {
                this.applicationDescriptorURL = new URL(appDescrUrlParam);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.startLoadApplicationDescriptor(this.applicationDescriptorURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoadApplicationDescriptor(URL url) {
        if (this.applicationDescriptor != null) {
            return;
        }
        this.applicationDescriptorURL = url;
        Vector<UpdateManagerListener> vector = this.listeners;
        synchronized (vector) {
            if (this.loaderOutputStream == null) {
                this.loaderOutputStream = new VectorBufferedOutputStream();
            }
            if (this.loader != null) {
                this.loader.removeProgressListener(this);
                this.loader.cancel();
                try {
                    this.loader.close();
                }
                catch (Exception e) {
                    this.status = Status.ERROR;
                }
                this.loader = null;
            }
            if (this.loader == null) {
                this.loader = new URLContentLoader(url, this.loaderOutputStream, "Applicationdescriptor loader");
                this.loader.setTimeouts(this.netWorkTimeout);
                this.loader.addProgressListener(this);
            }
            try {
                this.loader.open();
                this.loader.start();
                this.status = Status.LOADING;
            }
            catch (WorkerException e) {
                try {
                    this.loader.close();
                }
                catch (WorkerException workerException) {
                    // empty catch block
                }
                this.loader = null;
                this.status = Status.ERROR;
            }
        }
    }

    public boolean desktopDownloadPossible() {
        return this.desktop != null;
    }

    public void desktopBrowseApplicationDownload(ApplicationVersionDescriptor applicationVersionDescriptor) throws IOException {
        URL downloadURL;
        InstallationPackage ip;
        if (this.desktop != null && (ip = applicationVersionDescriptor.getPlatformInstallationPackage()) != null && (downloadURL = ip.getDownloadURL()) != null) {
            try {
                URI downloadURI = downloadURL.toURI();
                this.desktop.browse(downloadURI);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        return this.applicationDescriptor;
    }

    public void applyPlatformDependencies() {
        List<ApplicationVersionDescriptor> appds = this.applicationDescriptor.getVersions();
        for (ApplicationVersionDescriptor appD : appds) {
            InstallationPackage inPP = this.installationPackageForCurrentPlatform(appD);
            appD.setPlatformInstallationPackage(inPP);
        }
    }

    public List<ApplicationVersionDescriptor> sortedVersions() {
        ArrayList<ApplicationVersionDescriptor> versionsAvailSorted = new ArrayList<ApplicationVersionDescriptor>();
        versionsAvailSorted.addAll(this.applicationDescriptor.getVersions());
        Collections.sort(versionsAvailSorted);
        return versionsAvailSorted;
    }

    public List<ApplicationVersionDescriptor> sortedVersionsDesc() {
        List<ApplicationVersionDescriptor> sVs = this.sortedVersions();
        Collections.reverse(sVs);
        return sVs;
    }

    public ApplicationVersionDescriptor latestVersion() {
        ApplicationVersionDescriptor lv = null;
        List<ApplicationVersionDescriptor> sVs = this.sortedVersions();
        int vsCount = sVs.size();
        if (vsCount > 0) {
            lv = sVs.get(vsCount - 1);
        }
        return lv;
    }

    public ApplicationVersionDescriptor latestVersionForPlatform() {
        List<ApplicationVersionDescriptor> sVs = this.sortedVersionsDesc();
        for (ApplicationVersionDescriptor avd : sVs) {
            InstallationPackage ip = this.installationPackageForCurrentPlatform(avd);
            if (ip == null) continue;
            return avd;
        }
        return null;
    }

    public List<ApplicationVersionDescriptor> newerVersions() {
        List<ApplicationVersionDescriptor> sVs = this.sortedVersions();
        ArrayList<ApplicationVersionDescriptor> nVs = new ArrayList<ApplicationVersionDescriptor>();
        for (ApplicationVersionDescriptor avd : sVs) {
            Version av = avd.getVersion();
            if (this.currentVersion.compareTo(av) >= 0) continue;
            nVs.add(avd);
        }
        return nVs;
    }

    public List<ApplicationVersionDescriptor> newerVersionsDescending() {
        List<ApplicationVersionDescriptor> sVs = this.sortedVersions();
        ArrayList<ApplicationVersionDescriptor> nVs = new ArrayList<ApplicationVersionDescriptor>();
        for (ApplicationVersionDescriptor avd : sVs) {
            Version av = avd.getVersion();
            if (this.currentVersion.compareTo(av) >= 0) continue;
            nVs.add(avd);
        }
        return nVs;
    }

    public InstallationPackage installationPackageForCurrentPlatform(ApplicationVersionDescriptor appVd) {
        Object ip = null;
        if (appVd != null) {
            List<InstallationPackage> aips = appVd.getInstallationPackages();
            ArrayList<InstallationPackage> fAips = new ArrayList<InstallationPackage>();
            for (InstallationPackage aip : aips) {
                String aOsVersionPattern;
                String aOsArch;
                String aOsName = aip.getOsName();
                if (aOsName != null && !aOsName.equals(this.osName) || (aOsArch = aip.getOsArch()) != null && !aOsArch.equals(this.osArch) || (aOsVersionPattern = aip.getOsVersionPattern()) != null && !this.osVersion.matches(aOsVersionPattern)) continue;
                fAips.add(aip);
            }
            if (this.optionsList != null && this.optionsList.size() > 0) {
                ArrayList fmoAips = null;
                fmoAips = new ArrayList(fAips);
                fAips.clear();
                for (Option o : this.optionsList) {
                    ArrayList<InstallationPackage> fmcoAips = new ArrayList<InstallationPackage>();
                    for (InstallationPackage aip : fmoAips) {
                        Map<String, String> aipOpts = aip.getOptions();
                        if (aipOpts == null || !aipOpts.containsKey(o.key) || !aipOpts.get(o.key).equals(o.value)) continue;
                        fmcoAips.add(aip);
                    }
                    if (fmcoAips.size() <= 0) continue;
                    fmoAips = new ArrayList(fmcoAips);
                }
                fAips = fmoAips;
            }
            if (this.installationType != null) {
                ArrayList<InstallationPackage> fAInAips = new ArrayList<InstallationPackage>();
                for (InstallationPackage aip : fAips) {
                    if (!this.installationType.equals(aip.getType())) continue;
                    fAInAips.add(aip);
                }
                if (fAInAips.size() > 0) {
                    fAips = fAInAips;
                }
            }
            if (fAips.size() == 0) {
                return null;
            }
            return (InstallationPackage)fAips.get(0);
        }
        return null;
    }

    public boolean importantUpdatesAvailable() {
        List<ApplicationVersionDescriptor> versionsAvail = this.newerVersions();
        for (ApplicationVersionDescriptor avd : versionsAvail) {
            Version av = avd.getVersion();
            if (this.currentVersion.compareTo(av) >= 0) continue;
            List<Change> changes = avd.getChanges();
            for (Change change : changes) {
                Change.Priority pr;
                VersionPattern affects = change.getAffectsVersions();
                if (affects != null && !affects.matches(this.currentVersion) || (pr = change.getPriority()) == null || !pr.equals((Object)Change.Priority.STRONGLY_RECOMMENDED)) continue;
                return true;
            }
        }
        return false;
    }

    public Change.Priority updatePriority() {
        Change.Priority p = null;
        List<ApplicationVersionDescriptor> versionsAvail = this.newerVersions();
        for (ApplicationVersionDescriptor avd : versionsAvail) {
            List<Change> changes = avd.getChanges();
            for (Change change : changes) {
                Change.Priority pr;
                VersionPattern affects = change.getAffectsVersions();
                if (affects != null && !affects.matches(this.currentVersion) || (pr = change.getPriority()) == null) continue;
                if (p == null) {
                    p = pr;
                    continue;
                }
                if (pr.compareTo(p) <= 0) continue;
                p = pr;
            }
        }
        return p;
    }

    public ApplicationVersionDescriptor updateAvailable() {
        ApplicationVersionDescriptor lv = this.latestVersion();
        Version lvv = lv.getVersion();
        if (this.currentVersion.compareTo(lvv) < 0) {
            return lv;
        }
        return null;
    }

    public ApplicationVersionDescriptor updateAvailableForPlatform() {
        ApplicationVersionDescriptor lv = this.latestVersionForPlatform();
        if (lv == null) {
            return null;
        }
        Version lvv = lv.getVersion();
        if (this.currentVersion.compareTo(lvv) < 0) {
            return lv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ProgressEvent progressEvent) {
        if (progressEvent.getProgressStatus().isDone()) {
            Vector<UpdateManagerListener> vector = this.listeners;
            synchronized (vector) {
                VectorBufferedInputStream is = new VectorBufferedInputStream(this.loaderOutputStream.getVectorBuffer());
                try {
                    this.applicationDescriptor = (ApplicationDescriptor)JAXB.unmarshal((InputStream)is, ApplicationDescriptor.class);
                }
                catch (DataBindingException e) {
                    e.printStackTrace();
                    this.status = Status.ERROR;
                    UpdateManagerEvent ee = new UpdateManagerEvent(this, this.status);
                    this.fireEvent(ee);
                    return;
                }
                if (this.applicationDescriptor != null) {
                    this.applyPlatformDependencies();
                    this.status = Status.SUCCESS;
                    UpdateManagerEvent dle = new UpdateManagerEvent(this, this.status);
                    this.fireEvent(dle);
                    ApplicationVersionDescriptor uvd = this.updateAvailableForPlatform();
                    if (uvd != null) {
                        Change.Priority updPriority = this.updatePriority();
                        UpdateAvailableEvent uae = new UpdateAvailableEvent(this, this.status, updPriority);
                        this.fireEvent(uae);
                    }
                }
            }
        }
        if (progressEvent.getProgressStatus().isError()) {
            Vector<UpdateManagerListener> vector = this.listeners;
            synchronized (vector) {
                this.status = Status.ERROR;
                UpdateManagerEvent dle = new UpdateManagerEvent(this, this.status);
                this.fireEvent(dle);
            }
        }
    }

    private void fireEvent(UpdateManagerEvent event) {
        ArrayList<UpdateManagerListener> umListeners = new ArrayList<UpdateManagerListener>(this.listeners);
        for (UpdateManagerListener l : umListeners) {
            l.update(event);
        }
    }

    public void addUpdateManagerListener(UpdateManagerListener l) {
        this.listeners.add(l);
    }

    public void removeUpdateManagerListener(UpdateManagerListener l) {
        this.listeners.remove(l);
    }

    public static void main(String[] args) {
        try {
            Version currentVersion = Version.parseString(args[0]);
            URL appDescrUrl = null;
            if (args.length > 1) {
                appDescrUrl = new URL(args[1]);
            }
            final UpdateManager um = new UpdateManager(currentVersion);
            um.printPlatformInfos();
            um.addUpdateManagerListener(new UpdateManagerListener(){

                @Override
                public void update(UpdateManagerEvent event) {
                    if (Status.SUCCESS.equals((Object)event.getStatus())) {
                        System.out.println(event);
                        ApplicationVersionDescriptor ad = um.latestVersionForPlatform();
                        System.out.println(ad);
                        InstallationPackage ip = um.installationPackageForCurrentPlatform(ad);
                        if (ip != null) {
                            System.out.println("Download URL: " + ip.getDownloadURL());
                        }
                    }
                }
            });
            if (appDescrUrl != null) {
                um.startLoadApplicationDescriptor(appDescrUrl);
            } else {
                um.startLoadApplicationDescriptor();
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static enum Status {
        IDLE,
        LOADING,
        ERROR,
        SUCCESS;

    }

    public class Option {
        String key;
        String value;
    }
}

