/*
 * Decompiled with CFR 0.152.
 */
package ipsk.awt;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;

public abstract class AWTEventTransferAgent<L extends EventListener, E extends EventObject> {
    private Vector<L> listeners = new Vector();
    protected boolean eventsInAWTEventThread = true;

    public synchronized void addListener(L eventListener) {
        if (eventListener != null && !this.listeners.contains(eventListener)) {
            this.listeners.addElement(eventListener);
        }
    }

    public synchronized void removeListener(L eventListener) {
        if (eventListener != null) {
            this.listeners.removeElement(eventListener);
        }
    }

    public synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    public void fireEvent(E event) {
        if (this.eventsInAWTEventThread) {
            this.fireAWTEventLater(event);
        } else {
            for (EventListener l : this.listeners) {
                this.fireEvent(l, event);
            }
        }
    }

    public void fireEventAndWait(E event) {
        if (this.eventsInAWTEventThread) {
            this.fireAWTEventAndWait(event);
        } else {
            for (EventListener l : this.listeners) {
                this.fireEvent(l, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAWTEventAndWait(E event) {
        if (EventQueue.isDispatchThread()) {
            Vector<L> vector = this.listeners;
            synchronized (vector) {
                for (EventListener l : this.listeners) {
                    this.fireEvent(l, event);
                }
            }
        }
        EventRunnable eventRunnable = new EventRunnable(this, event);
        try {
            EventQueue.invokeAndWait(eventRunnable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAWTEventLater(E event) {
        if (EventQueue.isDispatchThread()) {
            Vector<L> vector = this.listeners;
            synchronized (vector) {
                for (EventListener l : this.listeners) {
                    this.fireEvent(l, event);
                }
            }
        } else {
            EventRunnable eventRunnable = new EventRunnable(this, event);
            EventQueue.invokeLater(eventRunnable);
        }
    }

    protected abstract void fireEvent(L var1, E var2);

    public boolean isEventsInAWTEventThread() {
        return this.eventsInAWTEventThread;
    }

    public void setEventsInAWTEventThread(boolean eventsInAWTEventThread) {
        this.eventsInAWTEventThread = eventsInAWTEventThread;
    }

    public static class EventRunnable
    implements Runnable {
        private E event;
        final /* synthetic */ AWTEventTransferAgent this$0;

        public EventRunnable(E event) {
            this.this$0 = this$0;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Vector vector = this.this$0.listeners;
            synchronized (vector) {
                for (EventListener l : this.this$0.listeners) {
                    this.this$0.fireEvent(l, this.event);
                }
            }
        }
    }
}

