/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.text.StringSequenceBuilder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;

public class URLContext {
    private URL context;

    public URLContext() {
    }

    public URLContext(URL context) {
        this.context = context;
    }

    public URL getContextURL(URL relURL) throws MalformedURLException {
        return URLContext.getContextURL(this.context, relURL);
    }

    public URL getContextURL(String spec) throws MalformedURLException {
        return URLContext.getContextURL(this.context, spec);
    }

    public static URL getContextURL(URL contextURL, URL relURL) throws MalformedURLException {
        if (contextURL == null) {
            return relURL;
        }
        if (relURL.getProtocol().equals("file")) {
            String dirPath = relURL.getPath();
            File tmpFile = new File(dirPath);
            if (!dirPath.startsWith("/") && tmpFile.isAbsolute()) {
                dirPath = "/".concat(dirPath);
            }
            return new URL(contextURL, "file:" + dirPath);
        }
        return new URL(contextURL, relURL.toExternalForm());
    }

    public static URL getContextURL(URL contextURL, String spec) throws MalformedURLException {
        URI specURI = null;
        try {
            URI sURI = new URI(spec);
            specURI = new URI(sURI.toASCIIString());
            if (specURI.isAbsolute()) {
                URL relURL = new URL(spec);
                return URLContext.getContextURL(contextURL, relURL);
            }
        }
        catch (URISyntaxException e1) {
            try {
                URI sURI = new URI(null, spec, null);
                String sURIAscii = sURI.toASCIIString();
                specURI = new URI(sURIAscii);
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        URI contextUri = null;
        try {
            contextUri = contextURL.toURI();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        URI resURI = contextUri.resolve(specURI);
        URL resURL = resURI.toURL();
        return resURL;
    }

    public static URL getContextURLStrict(URL contextURL, String spec) throws MalformedURLException {
        URI specURI = URI.create(spec);
        if (specURI.isAbsolute()) {
            return specURI.toURL();
        }
        URI contextUri = null;
        try {
            contextUri = contextURL.toURI();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        URI resURI = contextUri.resolve(spec);
        URL resURL = resURI.toURL();
        return resURL;
    }

    public boolean inContext(URL url) {
        String relPath = URLContext.relativize(this.context, url);
        return relPath != null;
    }

    public String renameContextSpec(URL newContext, String spec) throws MalformedURLException {
        URI specURI = URI.create(spec);
        if (specURI.isAbsolute()) {
            String relSpec = URLContext.relativize(this.context, specURI.toURL());
            if (relSpec == null) {
                return spec;
            }
            URL renamedURL = URLContext.getContextURL(newContext, relSpec);
            return renamedURL.toString();
        }
        return spec;
    }

    private static String[] parsePath(String path) {
        if (path.matches("^\\p{Alpha}:.*")) {
            String[] sPath;
            String[] bsPath = path.split("\\\\+");
            if (bsPath.length > (sPath = path.split("/+")).length) {
                return bsPath;
            }
            return sPath;
        }
        return path.split("/+");
    }

    public static String relativize(URL context, URL url) {
        String ctxProto = context.getProtocol();
        String urlProto = url.getProtocol();
        String ctxHost = context.getHost();
        String urlHost = url.getHost();
        String ctxPathStr = context.getPath();
        String urlPathStr = url.getPath();
        String urlQ = url.getQuery();
        String urlRef = url.getRef();
        if (ctxProto.equalsIgnoreCase(urlProto)) {
            boolean hostMatch = false;
            if (ctxHost == null) {
                if (urlHost == null) {
                    hostMatch = true;
                }
            } else {
                hostMatch = ctxHost.equalsIgnoreCase(urlHost);
            }
            if (hostMatch) {
                String[] ctxPath = URLContext.parsePath(ctxPathStr);
                String[] urlPath = URLContext.parsePath(urlPathStr);
                if (urlPath.length < ctxPath.length) {
                    return null;
                }
                if (ctxPath.length <= 0 || !"".equals(ctxPath[1])) {
                    // empty if block
                }
                for (int i = 0; i < ctxPath.length; ++i) {
                    if (ctxPath[i].equals(urlPath[i])) continue;
                    return null;
                }
                int urlPathidx = ctxPath.length;
                String[] relUrlPath = Arrays.copyOfRange(urlPath, urlPathidx, urlPath.length);
                Object relPathStr = StringSequenceBuilder.buildString(Arrays.asList(relUrlPath), '/');
                if (urlQ != null) {
                    relPathStr = (String)relPathStr + "?" + urlQ;
                }
                if (urlRef != null) {
                    relPathStr = (String)relPathStr + "#" + urlRef;
                }
                return relPathStr;
            }
        }
        return null;
    }

    public URL getContext() {
        return this.context;
    }

    public void setContext(URL url) {
        this.context = url;
    }

    public static URL baseContextFromResourceURL(URL resURL) throws MalformedURLException {
        String proto = resURL.getProtocol();
        String host = resURL.getHost();
        int port = resURL.getPort();
        String path = resURL.getPath();
        String newPath = path.replaceAll("[^/]*$", "");
        URL baseURL = new URL(proto, host, port, newPath);
        return baseURL;
    }

    public static void main(String[] args) {
        try {
            URL testDirUrl;
            File testDir = new File("/homes/klausj/test blank/testDirSS\u028a\u028a\u0299\u0298\u02a7\u00f6\u00fc\u00df");
            File testFile = new File(testDir, "testFileSS\u028a\u028a\u0299\u0298\u02a7\u00f6\u00fc\u00df.txt");
            URI unicodeTest = new URI("t\u028a.txt");
            String unicodeAsciiStr = unicodeTest.toASCIIString();
            URI unicodeTest2 = new URI("t\u00e4.txt");
            String unicodeAsciiStr2 = unicodeTest2.toASCIIString();
            File tf3 = new File("/t#.txt");
            URI unicodeTest3 = tf3.toURI();
            String unicodeAsciiStr3 = unicodeTest3.toASCIIString();
            URI uri3 = new URI(unicodeAsciiStr3);
            URL url3 = uri3.toURL();
            String url3ext = url3.toExternalForm();
            URI testDirUri = testDir.toURI();
            String testDirUriStr = testDirUri.toASCIIString();
            URI testDirsciiUri = new URI(testDirUriStr);
            URL context1 = testDirUrl = testDirsciiUri.toURL();
            URL fileinCtx = URLContext.getContextURL(context1, testFile.getAbsolutePath().toString());
            URI testFileUri = testFile.toURI();
            URL testFileUrl = testFileUri.toURL();
            URI decTestUri = testFileUrl.toURI();
            URL decTestUrl = decTestUri.toURL();
            String decTestFilePath = decTestUri.getPath();
            File decTestFile = new File(decTestFilePath);
            boolean testOk = testFile.equals(decTestFile);
            System.out.println("Test OK:" + testOk + " Exists:" + decTestFile.exists());
            URL resUrl = new URL("https://webapptest.phonetik.uni-muenchen.de:443/corpusmachine/session/WebrecorderPrj.jsp?id=101236905&amp;amp;wait_for_complete_upload=true&amp;amp;transfer_rate_limit=-1");
            URL uRL = URLContext.baseContextFromResourceURL(resUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

