/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import ipsk.awt.ProgressListener;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressErrorEvent;
import ipsk.awt.event.ProgressEvent;
import ipsk.awt.test.DemoWorker;
import ipsk.swing.JDialogPanel;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class JProgressDialogPanel
extends JDialogPanel
implements ProgressListener {
    private Worker worker;
    private JLabel messageLabel;
    private Dimension maxLabelSize = new Dimension();
    private JProgressBar progressBar = new JProgressBar(0, 100);

    public JProgressDialogPanel(Worker worker, String title, String message) {
        this(title, message);
        this.setWorker(worker);
    }

    public JProgressDialogPanel(String title, String message) {
        super(JDialogPanel.Options.CANCEL, title);
        this.progressBar.setStringPainted(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.messageLabel = new JLabel(message);
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        this.setResizable(false);
        URL imgURL = this.getClass().getResource("/toolbarButtonGraphics/general/Information24.gif");
        if (imgURL != null) {
            ImageIcon infoIcon = new ImageIcon(imgURL);
            gc.gridheight = 2;
            this.getContentPane().add((Component)new JLabel(infoIcon), gc);
            ++gc.gridx;
        }
        gc.gridheight = 1;
        this.getContentPane().add((Component)this.messageLabel, gc);
        ++gc.gridy;
        gc.fill = 2;
        gc.weightx = 2.0;
        this.getContentPane().add((Component)this.progressBar, gc);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.progressBar.setEnabled(enabled);
        this.cancelButton.setEnabled(this.cancelButton.isEnabled() && enabled);
    }

    @Override
    public void update(ProgressEvent progressEvent) {
        if (progressEvent instanceof ProgressErrorEvent) {
            this.setEnabled(false);
            this.disposeDialog();
        } else {
            ProgressStatus ps = progressEvent.getProgressStatus();
            if (ps != null) {
                LocalizableMessage message;
                Short pProgr = ps.getPercentProgress();
                if (pProgr != null) {
                    this.progressBar.setValue(ps.getPercentProgress().shortValue());
                }
                if ((message = ps.getMessage()) != null) {
                    this.messageLabel.setText(message.localize());
                    Dimension sizeNow = this.messageLabel.getPreferredSize();
                    if (sizeNow.width > this.maxLabelSize.width || sizeNow.height > this.maxLabelSize.height) {
                        this.maxLabelSize = sizeNow;
                        this.messageLabel.revalidate();
                        this.revalidate();
                        if (this.dialog != null) {
                            this.dialog.pack();
                        }
                    }
                    this.repaint();
                }
                if (ps.isDone()) {
                    this.cancelButton.setEnabled(false);
                    this.setValue(0);
                    this.disposeDialog();
                }
            }
        }
    }

    @Override
    protected void doCancel() {
        super.doCancel();
        this.worker.cancel();
    }

    public static void main(String[] args) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DemoWorker dw = new DemoWorker();
                JProgressDialogPanel jpdp = new JProgressDialogPanel(dw, "Progress title", "Progress message");
                try {
                    dw.open();
                }
                catch (WorkerException e) {
                    e.printStackTrace();
                }
                dw.start();
                Object res = jpdp.showDialog(new JFrame());
                if (res.equals(2)) {
                    System.out.println("Cancelled");
                }
                try {
                    dw.close();
                    dw.reset();
                }
                catch (WorkerException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                System.exit(0);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public Worker getWorker() {
        return this.worker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
        if (worker != null) {
            worker.addProgressListener(this);
        }
    }
}

