/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.dsp;

import ips.dsp.IIRFilter;
import ipsk.io.InterleavedFloatStream;
import java.io.IOException;

public class IIRFilterMultiStream
implements InterleavedFloatStream {
    private InterleavedFloatStream srcStream;
    private double[][] buf;
    private double[] aCoeff;
    private double[] bCoeff;
    private IIRFilter[] filters = null;
    private int delayLen;
    private int chs;
    private Integer channels;

    public IIRFilterMultiStream(InterleavedFloatStream srcStream, double[] aCoeff, double[] bCoeff) {
        this.srcStream = srcStream;
        this.aCoeff = aCoeff;
        this.bCoeff = bCoeff;
        this.delayLen = aCoeff.length;
        if (bCoeff.length > this.delayLen) {
            this.delayLen = bCoeff.length;
        }
        this.channels = srcStream.getChannels();
        if (this.channels != null) {
            this.init(this.channels);
        }
    }

    private void init(int chs) {
        this.chs = chs;
        this.filters = new IIRFilter[chs];
        for (int i = 0; i < chs; ++i) {
            this.filters[i] = new IIRFilter(this.aCoeff, this.bCoeff);
        }
        this.buf = new double[this.delayLen][chs];
    }

    @Override
    public int read(double[][] buf, int offset, int len) throws IOException {
        int r;
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (this.channels == null) {
            this.channels = buf[0].length;
            this.init(this.channels);
        }
        if (this.buf.length < len) {
            this.buf = new double[len][this.channels.intValue()];
        }
        if ((r = this.srcStream.read(this.buf, 0, len)) == -1) {
            return -1;
        }
        for (int i = 0; i < r; ++i) {
            for (int ch = 0; ch < this.channels; ++ch) {
                buf[offset + i][ch] = this.filters[ch].step(this.buf[i][ch]);
            }
        }
        return r;
    }

    @Override
    public long skip(long skip) throws IOException {
        long skipped = 0L;
        long saveSkipable = skip - (long)this.delayLen;
        if (saveSkipable > 0L) {
            return this.srcStream.skip(saveSkipable);
        }
        int toRead = (int)skip;
        int r = this.srcStream.read(this.buf, 0, toRead);
        if (r == -1) {
            return 0L;
        }
        skipped = r;
        for (int i = 0; i < r; ++i) {
            for (int ch = 0; ch < this.channels; ++ch) {
                this.filters[ch].step(this.buf[i][ch]);
            }
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        this.srcStream.close();
    }

    @Override
    public Integer getChannels() {
        return this.channels;
    }
}

