/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.text;

import ipsk.swing.text.TableFormatSelector;
import ipsk.text.TableTextFormat;
import ipsk.text.TableTextFormats;
import ipsk.text.TableWriter;
import ipsk.text.table.ColumnDescriptor;
import ipsk.text.table.TableExportProvider;
import ipsk.text.table.TableExportSchemaProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class TableTextfileExporter<S extends TableExportSchemaProvider, E extends TableExportProvider>
extends JPanel
implements ActionListener,
ClipboardOwner {
    private static final long serialVersionUID = 6263115966298640582L;
    private List<ColumnDescriptor> colDescriptors = null;
    private TableFormatSelector formatSelector;
    private JButton clipboardButton;
    private JButton browseButton;
    private JFileChooser fileChooser;
    private File textFile;
    private JTextField textFilePathField;
    private JButton fileExportButton;
    private E data;
    private List<JComboBox<ColumnSelectionItem>> colDescriptorChoosers = new ArrayList<JComboBox<ColumnSelectionItem>>();
    private boolean exportPossible = false;
    private Clipboard clipboard;
    public static final String EXPORT_POSSIBLE_PROPNAME = "exportPossible";

    public void setSelectedProfile(TableTextFormats.Profile profile) {
        this.formatSelector.setSelectedProfile(profile);
    }

    public TableTextfileExporter(S schemaProvider) {
        super(new GridBagLayout());
        try {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (SecurityException se) {
            System.err.println("WARNING: System clipboard not accessible.");
            this.clipboard = null;
        }
        this.colDescriptors = schemaProvider.getColumnDescriptors();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 2.0;
        c.fill = 2;
        JPanel mappingPanel = new JPanel(new GridBagLayout());
        TitledBorder mapBrd = BorderFactory.createTitledBorder("Mapping");
        mappingPanel.setBorder(mapBrd);
        GridBagConstraints c3 = new GridBagConstraints();
        if (this.colDescriptors != null) {
            c3.gridx = 0;
            c3.gridy = 0;
            c3.gridwidth = 1;
            for (ColumnDescriptor cd : this.colDescriptors) {
                ColumnSelectionItems colModel = new ColumnSelectionItems(this.colDescriptors);
                ColumnSelectionItem csi = new ColumnSelectionItem(cd);
                JComboBox<ColumnSelectionItem> ch = new JComboBox<ColumnSelectionItem>(colModel);
                this.colDescriptorChoosers.add(ch);
                ch.setSelectedItem(csi);
                mappingPanel.add(ch, c3);
                ++c3.gridx;
            }
        }
        this.add((Component)mappingPanel, c);
        c.gridx = 0;
        ++c.gridy;
        this.formatSelector = new TableFormatSelector();
        TitledBorder fmtBrd = BorderFactory.createTitledBorder("Format");
        this.formatSelector.setBorder(fmtBrd);
        this.add((Component)this.formatSelector, c);
        c.gridx = 0;
        ++c.gridy;
        JPanel exportDestinationPanel = new JPanel(new GridBagLayout());
        TitledBorder cbb = BorderFactory.createTitledBorder("Export destination");
        exportDestinationPanel.setBorder(cbb);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.insets = new Insets(2, 2, 2, 2);
        c2.gridx = 0;
        c2.gridy = 0;
        exportDestinationPanel.add((Component)new JLabel("Clipboard:"), c2);
        c2.gridx = 3;
        c2.fill = 0;
        c2.anchor = 13;
        this.clipboardButton = new JButton("Export to Clipboard");
        this.clipboardButton.addActionListener(this);
        exportDestinationPanel.add((Component)this.clipboardButton, c2);
        c2.gridx = 0;
        ++c2.gridy;
        c2.anchor = 17;
        exportDestinationPanel.add((Component)new JLabel("Table file:"), c2);
        ++c2.gridx;
        c2.weightx = 3.0;
        c2.fill = 2;
        this.textFilePathField = new JTextField(30);
        this.textFilePathField.setEnabled(false);
        this.textFilePathField.setEditable(false);
        exportDestinationPanel.add((Component)this.textFilePathField, c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        c2.anchor = 13;
        c2.fill = 0;
        this.browseButton = new JButton("Browse...");
        this.browseButton.addActionListener(this);
        exportDestinationPanel.add((Component)this.browseButton, c2);
        ++c2.gridx;
        this.fileExportButton = new JButton("Export to file");
        this.fileExportButton.addActionListener(this);
        exportDestinationPanel.add((Component)this.fileExportButton, c2);
        this.add((Component)exportDestinationPanel, c);
        this.setDependencies();
    }

    public void setData(E data) {
        this.data = data;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        for (JComboBox<ColumnSelectionItem> rdch : this.colDescriptorChoosers) {
            if (src != rdch) continue;
            this.setDependencies();
            return;
        }
        if (src == this.clipboardButton) {
            try {
                this.writeClipboard();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error writing table to system clipboard: " + e.getMessage());
            }
        } else if (src == this.browseButton) {
            this.fileChooser = new JFileChooser();
            int res = this.fileChooser.showDialog(this, "Select");
            if (res == 0) {
                this.textFile = this.fileChooser.getSelectedFile();
                boolean oldExportPossible = this.exportPossible;
                this.exportPossible = true;
                if (oldExportPossible != this.exportPossible) {
                    this.firePropertyChange(EXPORT_POSSIBLE_PROPNAME, oldExportPossible, this.exportPossible);
                }
                this.setDependencies();
            }
        } else if (src == this.fileExportButton && this.textFile != null) {
            try {
                this.writeFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error writing table to file: " + e.getMessage());
            }
        }
    }

    public void writeTable(Writer writer) throws IOException {
        TableTextFormat format = this.formatSelector.getFormat();
        TableWriter tw = new TableWriter(writer, format);
        ArrayList<ColumnDescriptor> selColList = new ArrayList<ColumnDescriptor>();
        for (JComboBox<ColumnSelectionItem> colSelBox : this.colDescriptorChoosers) {
            ColumnSelectionItem csi = (ColumnSelectionItem)colSelBox.getSelectedItem();
            ColumnDescriptor cd = csi.getColumnDescriptor();
            if (cd == null) continue;
            selColList.add(cd);
        }
        List<List<List<String>>> groups = this.data.tableData(selColList);
        try {
            tw.writeGroups(groups);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            tw.close();
        }
    }

    public void writeClipboard() throws IOException {
        if (this.clipboard != null) {
            StringWriter sw = new StringWriter();
            this.writeTable(sw);
            StringSelection sSel = new StringSelection(sw.toString());
            this.clipboard.setContents(sSel, this);
        }
    }

    public void writeFile() throws IOException {
        if (this.textFile != null) {
            int ans;
            if (this.textFile.exists() && (ans = JOptionPane.showConfirmDialog(this, this.textFile.getName() + " exists!\nDo you want to overwrite?", "Overwrite table export file", 0, 2)) != 0) {
                return;
            }
            FileWriter fw = new FileWriter(this.textFile);
            this.writeTable(fw);
        }
    }

    private void setDependencies() {
        if (this.textFile != null) {
            this.textFilePathField.setText("file:" + this.textFile.getPath());
            this.textFilePathField.setEnabled(true);
        } else {
            this.textFilePathField.setText("");
            this.textFilePathField.setEnabled(false);
        }
        this.clipboardButton.setEnabled(this.clipboard != null);
        this.fileExportButton.setEnabled(this.exportPossible && this.textFile != null);
    }

    public boolean isExportPossible() {
        return this.exportPossible;
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    public class ColumnSelectionItems
    extends Vector<ColumnSelectionItem> {
        private static final long serialVersionUID = 4941993831808427879L;

        public ColumnSelectionItems(List<ColumnDescriptor> colDescrs) {
            this.add(new ColumnSelectionItem());
            for (ColumnDescriptor cd : colDescrs) {
                this.add(new ColumnSelectionItem(cd));
            }
        }
    }

    public static class ColumnSelectionItem {
        private ColumnDescriptor columnDescriptor = null;
        private String notAssignedText = "-Not assigned-";

        public ColumnSelectionItem(ColumnDescriptor columnDescriptor) {
            this.columnDescriptor = columnDescriptor;
        }

        public ColumnSelectionItem() {
        }

        public String toString() {
            if (this.columnDescriptor != null) {
                return this.columnDescriptor.toString();
            }
            return this.notAssignedText;
        }

        public boolean equals(Object o) {
            if (o instanceof ColumnSelectionItem) {
                ColumnSelectionItem csio = (ColumnSelectionItem)o;
                ColumnDescriptor cdo = csio.getColumnDescriptor();
                if (cdo == null) {
                    if (this.columnDescriptor == null) {
                        return true;
                    }
                } else {
                    return cdo.equals(this.columnDescriptor);
                }
            }
            return false;
        }

        public ColumnDescriptor getColumnDescriptor() {
            return this.columnDescriptor;
        }
    }
}

