/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.apps.ui;

import ipsk.swing.text.EditorKitMenu;
import ipsk.util.apps.descriptor.ApplicationVersionDescriptor;
import ipsk.util.apps.descriptor.InstallationPackage;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ApplicationVersionDescriptorUI
extends JPanel
implements ActionListener {
    private ApplicationVersionDescriptor applicationVersionDescriptor;
    private boolean downloadEnabled = false;
    private JButton downloadButton;
    private URI downloadURI;
    private ActionListener actionListener;

    public boolean isDownloadEnabled() {
        return this.downloadEnabled;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public ApplicationVersionDescriptorUI(ApplicationVersionDescriptor avd, boolean downloadEnbled) {
        super(new GridBagLayout());
        URL downloadURL;
        Insets insets;
        this.downloadEnabled = downloadEnbled;
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = insets = new Insets(1, 1, 1, 1);
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 2.0;
        this.applicationVersionDescriptor = avd;
        JLabel versionLabel = new JLabel(this.applicationVersionDescriptor.getVersion().toString());
        this.add((Component)versionLabel, gc);
        InstallationPackage ip = this.applicationVersionDescriptor.getPlatformInstallationPackage();
        if (ip != null && (downloadURL = ip.getDownloadURL()) != null) {
            try {
                JTextField downloadUrlField = new JTextField(downloadURL.toString());
                downloadUrlField.setEditable(false);
                EditorKitMenu editorKitMenu = new EditorKitMenu((JTextComponent)downloadUrlField, false);
                ++gc.gridy;
                this.add((Component)downloadUrlField, gc);
                this.downloadURI = downloadURL.toURI();
                if (downloadEnbled && this.downloadURI != null) {
                    this.downloadButton = new JButton("Start download in desktop browser and quit");
                    this.downloadButton.addActionListener(this);
                    ++gc.gridy;
                    gc.weightx = 1.0;
                    gc.fill = 0;
                    this.add((Component)this.downloadButton, gc);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.downloadButton) {
            DownloadActionEvent dae = new DownloadActionEvent((Object)this, e.getID(), this.applicationVersionDescriptor);
            this.actionListener.actionPerformed(dae);
        }
    }

    public static class DownloadActionEvent
    extends ActionEvent {
        private ApplicationVersionDescriptor applicationVersionDescriptor;

        public ApplicationVersionDescriptor getApplicationVersionDescriptor() {
            return this.applicationVersionDescriptor;
        }

        public DownloadActionEvent(Object source, int id, ApplicationVersionDescriptor applicationVersionDescriptor) {
            super(source, id, "start_download_and_quit");
            this.applicationVersionDescriptor = applicationVersionDescriptor;
        }
    }
}

