/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.services;

import ipsk.text.ParserException;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.ServiceDescriptor;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestServiceDescriptor
implements ServiceDescriptor {
    private URL packageURL;
    private Class<?> serviceClass;
    private String serviceImplementationClassname;
    private Attributes mainAttributes;
    private Attributes serviceSectionAttributes;

    public ManifestServiceDescriptor(Class<?> serviceClass, String serviceImplementationClassname, Manifest manifest) {
        this.serviceClass = serviceClass;
        this.serviceImplementationClassname = serviceImplementationClassname;
        if (manifest != null) {
            this.mainAttributes = manifest.getMainAttributes();
            this.serviceSectionAttributes = manifest.getAttributes(serviceImplementationClassname);
        }
    }

    private String getAttribute(Attributes.Name key) {
        Object value;
        if (this.serviceSectionAttributes != null && (value = this.serviceSectionAttributes.get(key)) != null && value instanceof String) {
            return (String)value;
        }
        if (this.mainAttributes != null && (value = this.mainAttributes.get(key)) != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private LocalizableMessage getAttributeAsLocalizableMessage(Attributes.Name key) {
        Object value;
        if (this.serviceSectionAttributes != null && (value = this.serviceSectionAttributes.get(key)) != null && value instanceof String) {
            return new LocalizableMessage((String)value);
        }
        if (this.mainAttributes != null && (value = this.mainAttributes.get(key)) != null && value instanceof String) {
            return new LocalizableMessage((String)value);
        }
        return null;
    }

    private Version getAttributeAsVersion(Attributes.Name key) {
        String versStr = this.getAttribute(key);
        if (versStr != null) {
            try {
                return Version.parseString(versStr);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public LocalizableMessage getTitle() {
        return this.getAttributeAsLocalizableMessage(Attributes.Name.IMPLEMENTATION_TITLE);
    }

    @Override
    public LocalizableMessage getDescription() {
        return null;
    }

    @Override
    public String getVendor() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_VENDOR);
    }

    @Override
    public Version getSpecificationVersion() {
        return this.getAttributeAsVersion(Attributes.Name.SPECIFICATION_VERSION);
    }

    @Override
    public Version getImplementationVersion() {
        return this.getAttributeAsVersion(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public String getServiceImplementationClassname() {
        return this.serviceImplementationClassname;
    }

    public URL getPackageURL() {
        return this.packageURL;
    }

    public void setPackageURL(URL packageURL) {
        this.packageURL = packageURL;
    }
}

