/*
 * Decompiled with CFR 0.152.
 */
package ipsk.xml;

import ipsk.text.xml.XMLFactoryBuilder;
import ipsk.xml.DOMConverterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMConverter
implements ErrorHandler {
    private volatile DocumentBuilderFactory dbf = null;
    private Boolean validating = null;
    private SAXParseException saxException = null;
    private int indentNumber = 2;

    private void initializeFactory() throws ParserConfigurationException {
        if (this.dbf == null) {
            this.dbf = XMLFactoryBuilder.safeDocumentBuilderFactoryInstance(true, true);
            if (this.validating != null) {
                this.dbf.setValidating(this.validating);
            }
        }
    }

    public Document newDocument() throws DOMConverterException {
        try {
            this.initializeFactory();
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            return db.newDocument();
        }
        catch (ParserConfigurationException e1) {
            throw new DOMConverterException(e1);
        }
    }

    @Deprecated
    public void writeXML(Document document, OutputStream out) throws DOMConverterException {
        this.writeXML(document, null, null, out);
    }

    @Deprecated
    public void writeXML(Document document, String publicId, String systemId, OutputStream out) throws DOMConverterException {
        TransformerFactory tff = XMLFactoryBuilder.safeTransformerFactoryInstance();
        try {
            tff.setAttribute("indent-number", new Integer(this.indentNumber));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer tf = null;
        try {
            tf = tff.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new DOMConverterException(e);
        }
        tf.setOutputProperty("method", "xml");
        tf.setOutputProperty("indent", "yes");
        if (publicId != null) {
            tf.setOutputProperty("doctype-public", publicId);
        }
        if (systemId != null) {
            tf.setOutputProperty("doctype-system", systemId);
        }
        DOMSource ds = new DOMSource(document);
        StreamResult sr = new StreamResult(out);
        try {
            tf.transform(ds, sr);
        }
        catch (TransformerException e) {
            throw new DOMConverterException(e);
        }
    }

    public void writeXML(Document document, Writer out) throws DOMConverterException {
        this.writeXML(document, null, null, out);
    }

    public void writeXMLFragment(Document document, Writer out) throws DOMConverterException {
        this.writeXML(document, null, null, out, true);
    }

    public void writeXML(Document document, String publicId, String systemId, Writer out) throws DOMConverterException {
        this.writeXML(document, publicId, systemId, out, false);
    }

    public void writeXML(Document document, String publicId, String systemId, Writer out, boolean omitXMLDeclaration) throws DOMConverterException {
        TransformerFactory tff = XMLFactoryBuilder.safeTransformerFactoryInstance();
        try {
            tff.setAttribute("indent-number", this.indentNumber);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer tf = null;
        try {
            tf = tff.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new DOMConverterException(e);
        }
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("method", "xml");
        if (omitXMLDeclaration) {
            tf.setOutputProperty("omit-xml-declaration", "yes");
        }
        tf.setOutputProperty("indent", "yes");
        if (publicId != null) {
            tf.setOutputProperty("doctype-public", publicId);
        }
        if (systemId != null) {
            tf.setOutputProperty("doctype-system", systemId);
        }
        DOMSource ds = new DOMSource(document);
        StreamResult sr = new StreamResult(out);
        try {
            tf.transform(ds, sr);
        }
        catch (TransformerException e) {
            throw new DOMConverterException(e);
        }
    }

    public void writeXML(Document document, Result res) throws DOMConverterException {
        TransformerFactory tff = XMLFactoryBuilder.safeTransformerFactoryInstance();
        try {
            tff.setAttribute("indent-number", this.indentNumber);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer tf = null;
        try {
            tf = tff.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new DOMConverterException(e);
        }
        tf.setOutputProperty("method", "xml");
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("media-type", "text/xml");
        DOMSource ds = new DOMSource(document);
        try {
            tf.transform(ds, res);
        }
        catch (TransformerException e) {
            throw new DOMConverterException(e);
        }
    }

    public String writeToString(Document d) throws DOMConverterException {
        StringWriter sw = new StringWriter();
        this.writeXML(d, sw);
        return sw.toString();
    }

    public String writeFragmentToString(Document d) throws DOMConverterException {
        StringWriter sw = new StringWriter();
        this.writeXMLFragment(d, sw);
        return sw.toString();
    }

    public Document readXML(InputStream is) throws DOMConverterException {
        return this.readXML(is, null);
    }

    public Document readXML(Reader is) throws DOMConverterException {
        return this.readXML(new InputSource(is));
    }

    public Document readXML(InputStream is, String systemId) throws DOMConverterException {
        InputSource iSrc = new InputSource(is);
        if (systemId != null) {
            iSrc.setSystemId(systemId);
        }
        return this.readXML(iSrc);
    }

    public Document readXML(InputSource is) throws DOMConverterException {
        return this.readXML(is, (EntityResolver)null);
    }

    public Document readXML(InputSource is, EntityResolver entityResolver) throws DOMConverterException {
        DocumentBuilder db = null;
        try {
            this.initializeFactory();
            db = this.dbf.newDocumentBuilder();
            if (db.isValidating()) {
                db.setErrorHandler(this);
            }
            if (entityResolver != null) {
                db.setEntityResolver(entityResolver);
            }
        }
        catch (ParserConfigurationException e) {
            throw new DOMConverterException(e);
        }
        Document d = null;
        this.saxException = null;
        try {
            d = db.parse(is);
            if (this.saxException != null) {
                throw this.saxException;
            }
        }
        catch (SAXParseException ex) {
            throw new DOMConverterException("SAXParse-Exception in line " + ex.getLineNumber() + ", column " + ex.getColumnNumber() + ":\n " + ex.getLocalizedMessage(), ex);
        }
        catch (SAXException ex) {
            throw new DOMConverterException(ex);
        }
        catch (IOException ex) {
            throw new DOMConverterException(ex);
        }
        finally {
            if (is != null) {
                try {
                    Reader reader = is.getCharacterStream();
                    if (reader != null) {
                        reader.close();
                    } else {
                        InputStream byteStream = is.getByteStream();
                        if (byteStream != null) {
                            byteStream.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new DOMConverterException("Could not close XMLinput stream!");
                }
            }
        }
        return d;
    }

    public Document readXML(String uri) throws DOMConverterException {
        return this.readXML((InputSource)null, uri);
    }

    public Document readXML(InputSource is, String uri) throws DOMConverterException {
        DocumentBuilder db = null;
        try {
            this.initializeFactory();
            db = this.dbf.newDocumentBuilder();
            if (db.isValidating()) {
                db.setErrorHandler(this);
            }
        }
        catch (ParserConfigurationException e) {
            throw new DOMConverterException(e);
        }
        Document d = null;
        try {
            d = is != null ? db.parse(is) : db.parse(uri);
            if (this.saxException != null) {
                throw this.saxException;
            }
        }
        catch (SAXParseException ex) {
            throw new DOMConverterException("SAXParse-Exception in line " + ex.getLineNumber() + ", column " + ex.getColumnNumber() + ":\n " + ex.getLocalizedMessage());
        }
        catch (SAXException ex) {
            throw new DOMConverterException(ex);
        }
        catch (IOException ex) {
            throw new DOMConverterException(ex);
        }
        return d;
    }

    public void setValidating(boolean b) {
        this.validating = b;
        if (this.dbf != null) {
            this.dbf.setValidating(b);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.saxException = exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.saxException = exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }
}

