/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.decode;

import com.wavpack.decode.Bitstream;
import java.io.DataInputStream;

class BitsUtils {
    BitsUtils() {
    }

    static Bitstream getbit(Bitstream bs) {
        int uns_buf = 0;
        if (bs.bc > 0) {
            --bs.bc;
        } else {
            bs.ptr = (short)(bs.ptr + 1);
            ++bs.buf_index;
            bs.bc = 7;
            if (bs.ptr == bs.end) {
                bs = BitsUtils.bs_read(bs);
            }
            uns_buf = bs.buf[bs.buf_index] & 0xFF;
            bs.sr = uns_buf;
        }
        if ((bs.sr & 1L) > 0L) {
            bs.sr >>= 1;
            bs.bitval = 1;
            return bs;
        }
        bs.sr >>= 1;
        bs.bitval = 0;
        return bs;
    }

    static long getbits(int nbits, Bitstream bs) {
        while (nbits > bs.bc) {
            bs.ptr = (short)(bs.ptr + 1);
            ++bs.buf_index;
            if (bs.ptr == bs.end) {
                bs = BitsUtils.bs_read(bs);
            }
            int uns_buf = bs.buf[bs.buf_index] & 0xFF;
            bs.sr |= (long)(uns_buf << bs.bc);
            bs.bc += 8;
        }
        long value = bs.sr;
        if (bs.bc > 32) {
            bs.bc -= nbits;
            bs.sr = bs.ptr >> 8 - bs.bc;
        } else {
            bs.bc -= nbits;
            bs.sr >>= nbits;
        }
        return value;
    }

    static Bitstream bs_open_read(byte[] stream, short buffer_start, short buffer_end, DataInputStream file, long file_bytes, int passed) {
        Bitstream bs = new Bitstream();
        bs.buf = stream;
        bs.buf_index = buffer_start;
        bs.end = buffer_end;
        bs.sr = 0L;
        bs.bc = 0;
        if (passed != 0) {
            bs.ptr = (short)(bs.end - 1);
            bs.file_bytes = file_bytes;
            bs.file = file;
        } else {
            bs.buf_index = -1;
            bs.ptr = (short)-1;
        }
        return bs;
    }

    static Bitstream bs_read(Bitstream bs) {
        if (bs.file_bytes > 0L) {
            long bytes_read;
            long bytes_to_read = 1024L;
            if (bytes_to_read > bs.file_bytes) {
                bytes_to_read = bs.file_bytes;
            }
            try {
                byte[] buf = new byte[1024];
                bytes_read = bs.file.read(buf, 0, (int)bytes_to_read);
                bs.buf_index = 0;
                bs.buf = buf;
            }
            catch (Exception e) {
                System.err.println("Big error while reading file: " + e);
                bytes_read = 0L;
            }
            if (bytes_read > 0L) {
                bs.end = (short)bytes_read;
                bs.file_bytes -= bytes_read;
            } else {
                int i = 0;
                while (i < bs.end - bs.buf_index) {
                    bs.buf[i] = -1;
                    ++i;
                }
                bs.error = 1;
            }
        } else {
            bs.error = 1;
        }
        if (bs.error > 0) {
            int i = 0;
            while (i < bs.end - bs.buf_index) {
                bs.buf[i] = -1;
                ++i;
            }
        }
        bs.ptr = 0;
        bs.buf_index = 0;
        return bs;
    }
}

