/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.decode;

import com.wavpack.decode.Defines;
import com.wavpack.decode.WavpackMetadata;
import com.wavpack.decode.WavpackStream;

class FloatUtils {
    FloatUtils() {
    }

    static int read_float_info(WavpackStream wps, WavpackMetadata wpmd) {
        int bytecnt = wpmd.byte_length;
        byte[] byteptr = wpmd.data;
        int counter = 0;
        if (bytecnt != 4) {
            return Defines.FALSE;
        }
        wps.float_flags = byteptr[counter];
        wps.float_shift = byteptr[++counter];
        wps.float_max_exp = byteptr[++counter];
        wps.float_norm_exp = byteptr[++counter];
        return Defines.TRUE;
    }

    static int[] float_values(WavpackStream wps, int[] values, long num_values) {
        int shift = wps.float_max_exp - wps.float_norm_exp + wps.float_shift;
        int value_counter = 0;
        if (shift > 32) {
            shift = 32;
        } else if (shift < -32) {
            shift = -32;
        }
        while (num_values > 0L) {
            if (shift > 0) {
                int n = value_counter;
                values[n] = values[n] << shift;
            } else if (shift < 0) {
                int n = value_counter;
                values[n] = values[n] >> -shift;
            }
            if ((long)values[value_counter] > 0x7FFFFFL) {
                values[value_counter] = 0x7FFFFF;
            } else if ((long)values[value_counter] < -8388608L) {
                values[value_counter] = -8388608;
            }
            ++value_counter;
            --num_values;
        }
        return values;
    }
}

