/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.decode;

import com.wavpack.decode.Defines;
import com.wavpack.decode.FloatUtils;
import com.wavpack.decode.UnpackUtils;
import com.wavpack.decode.WavpackContext;
import com.wavpack.decode.WavpackMetadata;
import com.wavpack.decode.WavpackStream;
import com.wavpack.decode.WordsUtils;

class MetadataUtils {
    MetadataUtils() {
    }

    static int read_metadata_buff(WavpackContext wpc, WavpackMetadata wpmd) {
        int bytes_read;
        short tchar;
        if (wpmd.bytecount >= wpc.stream.wphdr.ckSize) {
            return Defines.FALSE;
        }
        try {
            wpmd.id = (short)wpc.infile.readUnsignedByte();
            tchar = (short)wpc.infile.readUnsignedByte();
        }
        catch (Exception e) {
            wpmd.status = 1;
            return Defines.FALSE;
        }
        wpmd.bytecount += 2L;
        wpmd.byte_length = tchar << 1;
        if ((wpmd.id & Defines.ID_LARGE) != 0) {
            wpmd.id = (short)(wpmd.id & ~Defines.ID_LARGE);
            try {
                tchar = (short)wpc.infile.readUnsignedByte();
            }
            catch (Exception e) {
                wpmd.status = 1;
                return Defines.FALSE;
            }
            wpmd.byte_length += tchar << 9;
            try {
                tchar = (short)wpc.infile.readUnsignedByte();
            }
            catch (Exception e) {
                wpmd.status = 1;
                return Defines.FALSE;
            }
            wpmd.byte_length += tchar << 17;
            wpmd.bytecount += 2L;
        }
        if ((wpmd.id & Defines.ID_ODD_SIZE) != 0) {
            wpmd.id = (short)(wpmd.id & ~Defines.ID_ODD_SIZE);
            --wpmd.byte_length;
        }
        if (wpmd.byte_length == 0 || wpmd.id == 10) {
            wpmd.hasdata = Defines.FALSE;
            return Defines.TRUE;
        }
        long bytes_to_read = wpmd.byte_length + (wpmd.byte_length & 1);
        wpmd.bytecount += bytes_to_read;
        if (bytes_to_read > (long)wpc.read_buffer.length) {
            wpmd.hasdata = Defines.FALSE;
            while (bytes_to_read > (long)wpc.read_buffer.length) {
                try {
                    bytes_read = wpc.infile.read(wpc.read_buffer, 0, wpc.read_buffer.length);
                    if (bytes_read != wpc.read_buffer.length) {
                        return Defines.FALSE;
                    }
                }
                catch (Exception e) {
                    return Defines.FALSE;
                }
                bytes_to_read -= (long)wpc.read_buffer.length;
            }
        } else {
            wpmd.hasdata = Defines.TRUE;
            wpmd.data = wpc.read_buffer;
        }
        if (bytes_to_read != 0L) {
            try {
                bytes_read = wpc.infile.read(wpc.read_buffer, 0, (int)bytes_to_read);
                if (bytes_read != (int)bytes_to_read) {
                    wpmd.hasdata = Defines.FALSE;
                    return Defines.FALSE;
                }
            }
            catch (Exception e) {
                wpmd.hasdata = Defines.FALSE;
                return Defines.FALSE;
            }
        }
        return Defines.TRUE;
    }

    static int process_metadata(WavpackContext wpc, WavpackMetadata wpmd) {
        WavpackStream wps = wpc.stream;
        switch (wpmd.id) {
            case 0: {
                return Defines.TRUE;
            }
            case 2: {
                return UnpackUtils.read_decorr_terms(wps, wpmd);
            }
            case 3: {
                return UnpackUtils.read_decorr_weights(wps, wpmd);
            }
            case 4: {
                return UnpackUtils.read_decorr_samples(wps, wpmd);
            }
            case 5: {
                return WordsUtils.read_entropy_vars(wps, wpmd);
            }
            case 6: {
                return WordsUtils.read_hybrid_profile(wps, wpmd);
            }
            case 8: {
                return FloatUtils.read_float_info(wps, wpmd);
            }
            case 9: {
                return UnpackUtils.read_int32_info(wps, wpmd);
            }
            case 13: {
                return UnpackUtils.read_channel_info(wpc, wpmd);
            }
            case 39: {
                return UnpackUtils.read_sample_rate(wpc, wpmd);
            }
            case 37: {
                return UnpackUtils.read_config_info(wpc, wpmd);
            }
            case 10: {
                return UnpackUtils.init_wv_bitstream(wpc, wpmd);
            }
            case 7: 
            case 11: 
            case 12: {
                return Defines.TRUE;
            }
        }
        if ((wpmd.id & Defines.ID_OPTIONAL_DATA) != 0) {
            return Defines.TRUE;
        }
        return Defines.FALSE;
    }
}

