/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.decode;

import com.wavpack.decode.BitsUtils;
import com.wavpack.decode.Defines;
import com.wavpack.decode.FloatUtils;
import com.wavpack.decode.MetadataUtils;
import com.wavpack.decode.WavpackContext;
import com.wavpack.decode.WavpackMetadata;
import com.wavpack.decode.WavpackStream;
import com.wavpack.decode.WordsUtils;
import com.wavpack.decode.decorr_pass;

class UnpackUtils {
    UnpackUtils() {
    }

    static int unpack_init(WavpackContext wpc) {
        WavpackStream wps = wpc.stream;
        WavpackMetadata wpmd = new WavpackMetadata();
        if (wps.wphdr.block_samples > 0L && wps.wphdr.block_index != -1L) {
            wps.sample_index = wps.wphdr.block_index;
        }
        wps.mute_error = 0;
        wps.crc = -1L;
        wps.wvbits.sr = 0L;
        while (MetadataUtils.read_metadata_buff(wpc, wpmd) == Defines.TRUE) {
            if (MetadataUtils.process_metadata(wpc, wpmd) == Defines.FALSE) {
                wpc.error = true;
                wpc.error_message = "invalid metadata!";
                return Defines.FALSE;
            }
            if (wpmd.id == 10) break;
        }
        if (wps.wphdr.block_samples != 0L && wps.wvbits.file == null) {
            wpc.error_message = "invalid WavPack file!";
            wpc.error = true;
            return Defines.FALSE;
        }
        if (wps.wphdr.block_samples != 0L) {
            if ((wps.wphdr.flags & (long)Defines.INT32_DATA) != 0L && wps.int32_sent_bits != 0) {
                wpc.lossy_blocks = 1;
            }
            if ((wps.wphdr.flags & (long)Defines.FLOAT_DATA) != 0L && (wps.float_flags & (Defines.FLOAT_EXCEPTIONS | Defines.FLOAT_ZEROS_SENT | Defines.FLOAT_SHIFT_SENT | Defines.FLOAT_SHIFT_SAME)) != 0) {
                wpc.lossy_blocks = 1;
            }
        }
        wpc.error = false;
        wpc.stream = wps;
        return Defines.TRUE;
    }

    static int init_wv_bitstream(WavpackContext wpc, WavpackMetadata wpmd) {
        WavpackStream wps = wpc.stream;
        if (wpmd.hasdata == Defines.TRUE) {
            wps.wvbits = BitsUtils.bs_open_read(wpmd.data, (short)0, (short)wpmd.byte_length, wpc.infile, 0L, 0);
        } else if (wpmd.byte_length > 0) {
            int len = wpmd.byte_length & 1;
            wps.wvbits = BitsUtils.bs_open_read(wpc.read_buffer, (short)-1, (short)wpc.read_buffer.length, wpc.infile, wpmd.byte_length + len, 1);
        }
        return Defines.TRUE;
    }

    static int read_decorr_terms(WavpackStream wps, WavpackMetadata wpmd) {
        int termcnt = wpmd.byte_length;
        byte[] byteptr = wpmd.data;
        WavpackStream tmpwps = new WavpackStream();
        int counter = 0;
        int dcounter = 0;
        if (termcnt > Defines.MAX_NTERMS) {
            return Defines.FALSE;
        }
        tmpwps.num_terms = termcnt;
        dcounter = termcnt - 1;
        dcounter = termcnt - 1;
        while (dcounter >= 0) {
            tmpwps.decorr_passes[dcounter].term = (short)((byteptr[counter] & 0x1F) - 5);
            tmpwps.decorr_passes[dcounter].delta = (short)(byteptr[counter] >> 5 & 7);
            ++counter;
            if (tmpwps.decorr_passes[dcounter].term < -3 || tmpwps.decorr_passes[dcounter].term > Defines.MAX_TERM && tmpwps.decorr_passes[dcounter].term < 17 || tmpwps.decorr_passes[dcounter].term > 18) {
                return Defines.FALSE;
            }
            --dcounter;
        }
        wps.decorr_passes = tmpwps.decorr_passes;
        wps.num_terms = tmpwps.num_terms;
        return Defines.TRUE;
    }

    static int read_decorr_weights(WavpackStream wps, WavpackMetadata wpmd) {
        int termcnt = wpmd.byte_length;
        byte[] byteptr = wpmd.data;
        decorr_pass dpp = new decorr_pass();
        int counter = 0;
        int myiterator = 0;
        if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
            termcnt /= 2;
        }
        if (termcnt > wps.num_terms) {
            return Defines.FALSE;
        }
        int tcount = wps.num_terms;
        while (tcount > 0) {
            dpp.weight_B = 0;
            dpp.weight_A = 0;
            --tcount;
        }
        myiterator = wps.num_terms;
        while (termcnt > 0) {
            int dpp_idx = myiterator - 1;
            wps.decorr_passes[dpp_idx].weight_A = dpp.weight_A = (short)WordsUtils.restore_weight(byteptr[counter]);
            ++counter;
            if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                dpp.weight_B = (short)WordsUtils.restore_weight(byteptr[counter]);
                ++counter;
            }
            wps.decorr_passes[dpp_idx].weight_B = dpp.weight_B;
            --myiterator;
            --termcnt;
        }
        return Defines.TRUE;
    }

    static int read_decorr_samples(WavpackStream wps, WavpackMetadata wpmd) {
        byte[] byteptr = wpmd.data;
        decorr_pass dpp = new decorr_pass();
        int counter = 0;
        int dpp_index = 0;
        int sample_counter = 0;
        dpp_index = 0;
        int tcount = wps.num_terms;
        while (tcount > 0) {
            dpp.term = wps.decorr_passes[dpp_index].term;
            int internalc = 0;
            while (internalc < Defines.MAX_TERM) {
                dpp.samples_A[internalc] = 0;
                dpp.samples_B[internalc] = 0;
                wps.decorr_passes[dpp_index].samples_A[internalc] = 0;
                wps.decorr_passes[dpp_index].samples_B[internalc] = 0;
                ++internalc;
            }
            ++dpp_index;
            --tcount;
        }
        if (wps.wphdr.version == 1026 && (wps.wphdr.flags & (long)Defines.HYBRID_FLAG) > 0L) {
            counter += 2;
            if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                counter += 2;
            }
        }
        --dpp_index;
        while (counter < wpmd.byte_length) {
            int uns_buf3;
            int uns_buf2;
            int uns_buf1;
            int uns_buf0;
            if (dpp.term > Defines.MAX_TERM) {
                uns_buf0 = byteptr[counter] & 0xFF;
                uns_buf1 = byteptr[counter + 1] & 0xFF;
                uns_buf2 = byteptr[counter + 2] & 0xFF;
                uns_buf3 = byteptr[counter + 3] & 0xFF;
                dpp.samples_A[0] = WordsUtils.exp2s((short)(uns_buf0 + (uns_buf1 << 8)));
                dpp.samples_A[1] = WordsUtils.exp2s((short)(uns_buf2 + (uns_buf3 << 8)));
                counter += 4;
                if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                    uns_buf0 = byteptr[counter] & 0xFF;
                    uns_buf1 = byteptr[counter + 1] & 0xFF;
                    uns_buf2 = byteptr[counter + 2] & 0xFF;
                    uns_buf3 = byteptr[counter + 3] & 0xFF;
                    dpp.samples_B[0] = WordsUtils.exp2s((short)(uns_buf0 + (uns_buf1 << 8)));
                    dpp.samples_B[1] = WordsUtils.exp2s((short)(uns_buf2 + (uns_buf3 << 8)));
                    counter += 4;
                }
            } else if (dpp.term < 0) {
                uns_buf0 = byteptr[counter] & 0xFF;
                uns_buf1 = byteptr[counter + 1] & 0xFF;
                uns_buf2 = byteptr[counter + 2] & 0xFF;
                uns_buf3 = byteptr[counter + 3] & 0xFF;
                dpp.samples_A[0] = WordsUtils.exp2s((short)(uns_buf0 + (uns_buf1 << 8)));
                dpp.samples_B[0] = WordsUtils.exp2s((short)(uns_buf2 + (uns_buf3 << 8)));
                counter += 4;
            } else {
                int m = 0;
                int cnt = dpp.term;
                while (cnt > 0) {
                    uns_buf0 = byteptr[counter] & 0xFF;
                    uns_buf1 = byteptr[counter + 1] & 0xFF;
                    dpp.samples_A[m] = WordsUtils.exp2s((short)(uns_buf0 + (uns_buf1 << 8)));
                    counter += 2;
                    if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                        uns_buf0 = byteptr[counter] & 0xFF;
                        uns_buf1 = byteptr[counter + 1] & 0xFF;
                        dpp.samples_B[m] = WordsUtils.exp2s((short)(uns_buf0 + (uns_buf1 << 8)));
                        counter += 2;
                    }
                    ++m;
                    --cnt;
                }
            }
            sample_counter = 0;
            while (sample_counter < Defines.MAX_TERM) {
                wps.decorr_passes[dpp_index].samples_A[sample_counter] = dpp.samples_A[sample_counter];
                wps.decorr_passes[dpp_index].samples_B[sample_counter] = dpp.samples_B[sample_counter];
                ++sample_counter;
            }
            --dpp_index;
        }
        return Defines.TRUE;
    }

    static int read_int32_info(WavpackStream wps, WavpackMetadata wpmd) {
        int bytecnt = wpmd.byte_length;
        byte[] byteptr = wpmd.data;
        int counter = 0;
        if (bytecnt != 4) {
            return Defines.FALSE;
        }
        wps.int32_sent_bits = byteptr[counter];
        wps.int32_zeros = byteptr[++counter];
        wps.int32_ones = byteptr[++counter];
        wps.int32_dups = byteptr[++counter];
        return Defines.TRUE;
    }

    static int read_channel_info(WavpackContext wpc, WavpackMetadata wpmd) {
        int bytecnt = wpmd.byte_length;
        int shift = 0;
        byte[] byteptr = wpmd.data;
        int counter = 0;
        long mask = 0L;
        if (bytecnt == 0 || bytecnt > 5) {
            return Defines.FALSE;
        }
        wpc.config.num_channels = byteptr[counter];
        ++counter;
        while (bytecnt >= 0) {
            mask |= (long)((byteptr[counter] & 0xFF) << shift);
            ++counter;
            shift += 8;
            --bytecnt;
        }
        wpc.config.channel_mask = mask;
        return Defines.TRUE;
    }

    static int read_config_info(WavpackContext wpc, WavpackMetadata wpmd) {
        int bytecnt = wpmd.byte_length;
        byte[] byteptr = wpmd.data;
        int counter = 0;
        if (bytecnt >= 3) {
            wpc.config.flags &= 0xFFL;
            wpc.config.flags |= (long)((byteptr[counter] & 0xFF) << 8);
            wpc.config.flags |= (long)((byteptr[++counter] & 0xFF) << 16);
            wpc.config.flags |= (long)((byteptr[++counter] & 0xFF) << 24);
        }
        return Defines.TRUE;
    }

    static int read_sample_rate(WavpackContext wpc, WavpackMetadata wpmd) {
        int bytecnt = wpmd.byte_length;
        byte[] byteptr = wpmd.data;
        int counter = 0;
        if (bytecnt == 3) {
            wpc.config.sample_rate = byteptr[counter] & 0xFF;
            wpc.config.sample_rate |= (long)((byteptr[++counter] & 0xFF) << 8);
            wpc.config.sample_rate |= (long)((byteptr[++counter] & 0xFF) << 16);
        }
        return Defines.TRUE;
    }

    static long unpack_samples(WavpackContext wpc, int[] buffer, long sample_count) {
        decorr_pass dpp;
        int tcount;
        long i;
        int dpp_index;
        WavpackStream wps = wpc.stream;
        long flags = wps.wphdr.flags;
        int crc = (int)wps.crc;
        int mute_limit = (int)((1L << (int)((flags & Defines.MAG_MASK) >> Defines.MAG_LSB)) + 2L);
        int buffer_counter = 0;
        int[] temp_buffer = new int[Defines.SAMPLE_BUFFER_SIZE];
        int samples_processed = 0;
        if (wps.sample_index + sample_count > wps.wphdr.block_index + wps.wphdr.block_samples) {
            sample_count = wps.wphdr.block_index + wps.wphdr.block_samples - wps.sample_index;
        }
        if (wps.mute_error > 0) {
            long tempc = (flags & (long)Defines.MONO_FLAG) > 0L ? sample_count : 2L * sample_count;
            while (tempc > 0L) {
                buffer[buffer_counter] = 0;
                --tempc;
                ++buffer_counter;
            }
            wps.sample_index += sample_count;
            return sample_count;
        }
        if ((flags & (long)Defines.HYBRID_FLAG) > 0L) {
            mute_limit *= 2;
        }
        if ((flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) > 0L) {
            dpp_index = 0;
            i = WordsUtils.get_words(sample_count, flags, wps.w, wps.wvbits, temp_buffer);
            System.arraycopy(temp_buffer, 0, buffer, 0, (int)sample_count);
            tcount = wps.num_terms - 1;
            while (tcount >= 0) {
                dpp = wps.decorr_passes[dpp_index];
                UnpackUtils.decorr_mono_pass(dpp, buffer, sample_count, buffer_counter);
                ++dpp_index;
                --tcount;
            }
            int q = 0;
            while ((long)q < sample_count) {
                int bf_abs;
                int n = bf_abs = buffer[buffer_counter] < 0 ? -buffer[buffer_counter] : buffer[buffer_counter];
                if (bf_abs > mute_limit) {
                    i = q;
                    break;
                }
                crc = crc * 3 + buffer[q];
                ++q;
            }
        } else {
            int bf1_abs;
            int bf_abs;
            samples_processed = WordsUtils.get_words(sample_count, flags, wps.w, wps.wvbits, temp_buffer);
            i = samples_processed;
            System.arraycopy(temp_buffer, 0, buffer, 0, (int)(sample_count * 2L));
            if (sample_count < 16L) {
                dpp_index = 0;
                tcount = wps.num_terms - 1;
                while (tcount >= 0) {
                    dpp = wps.decorr_passes[dpp_index];
                    UnpackUtils.decorr_stereo_pass(dpp, buffer, sample_count, buffer_counter);
                    wps.decorr_passes[dpp_index] = dpp;
                    ++dpp_index;
                    --tcount;
                }
            } else {
                dpp_index = 0;
                tcount = wps.num_terms - 1;
                while (tcount >= 0) {
                    dpp = wps.decorr_passes[dpp_index];
                    UnpackUtils.decorr_stereo_pass(dpp, buffer, 8L, buffer_counter);
                    UnpackUtils.decorr_stereo_pass_cont(dpp, buffer, sample_count - 8L, buffer_counter + 16);
                    wps.decorr_passes[dpp_index] = dpp;
                    ++dpp_index;
                    --tcount;
                }
            }
            if ((flags & (long)Defines.JOINT_STEREO) > 0L) {
                buffer_counter = 0;
                while ((long)buffer_counter < sample_count * 2L) {
                    int n = buffer_counter;
                    int n2 = buffer_counter + 1;
                    int n3 = buffer[n2] - (buffer[buffer_counter] >> 1);
                    buffer[n2] = n3;
                    buffer[n] = buffer[n] + n3;
                    bf_abs = buffer[buffer_counter] < 0 ? -buffer[buffer_counter] : buffer[buffer_counter];
                    int n4 = bf1_abs = buffer[buffer_counter + 1] < 0 ? -buffer[buffer_counter + 1] : buffer[buffer_counter + 1];
                    if (bf_abs > mute_limit || bf1_abs > mute_limit) {
                        i = buffer_counter / 2;
                        break;
                    }
                    crc = (crc * 3 + buffer[buffer_counter]) * 3 + buffer[buffer_counter + 1];
                    buffer_counter += 2;
                }
            } else {
                buffer_counter = 0;
                while ((long)buffer_counter < sample_count * 2L) {
                    bf_abs = buffer[buffer_counter] < 0 ? -buffer[buffer_counter] : buffer[buffer_counter];
                    int n = bf1_abs = buffer[buffer_counter + 1] < 0 ? -buffer[buffer_counter + 1] : buffer[buffer_counter + 1];
                    if (bf_abs > mute_limit || bf1_abs > mute_limit) {
                        i = buffer_counter / 2;
                        break;
                    }
                    crc = (crc * 3 + buffer[buffer_counter]) * 3 + buffer[buffer_counter + 1];
                    buffer_counter += 2;
                }
            }
        }
        if (i != sample_count) {
            long sc = 0L;
            sc = (flags & (long)Defines.MONO_FLAG) > 0L ? sample_count : 2L * sample_count;
            buffer_counter = 0;
            while (sc > 0L) {
                buffer[buffer_counter] = 0;
                --sc;
                ++buffer_counter;
            }
            wps.mute_error = 1;
            i = sample_count;
        }
        buffer = UnpackUtils.fixup_samples(wps, buffer, i);
        if ((flags & (long)Defines.FALSE_STEREO) > 0L) {
            int dest_idx = (int)i * 2;
            int src_idx = (int)i;
            int c = (int)i;
            --dest_idx;
            --src_idx;
            while (c > 0) {
                buffer[dest_idx] = buffer[src_idx];
                buffer[--dest_idx] = buffer[src_idx];
                --dest_idx;
                --src_idx;
                --c;
            }
        }
        wps.sample_index += i;
        wps.crc = crc;
        return i;
    }

    static void decorr_stereo_pass(decorr_pass dpp, int[] buffer, long sample_count, int buf_idx) {
        short delta = dpp.delta;
        int weight_A = dpp.weight_A;
        int weight_B = dpp.weight_B;
        int bptr_counter = 0;
        switch (dpp.term) {
            case 17: {
                bptr_counter = buf_idx;
                while ((long)bptr_counter < (long)buf_idx + sample_count * 2L) {
                    int sam_A = 2 * dpp.samples_A[0] - dpp.samples_A[1];
                    dpp.samples_A[1] = dpp.samples_A[0];
                    dpp.samples_A[0] = (int)((long)weight_A * (long)sam_A + 512L >> 10) + buffer[bptr_counter];
                    if (sam_A != 0 && buffer[bptr_counter] != 0) {
                        weight_A = (sam_A ^ buffer[bptr_counter]) < 0 ? (weight_A -= delta) : (weight_A += delta);
                    }
                    buffer[bptr_counter] = dpp.samples_A[0];
                    sam_A = 2 * dpp.samples_B[0] - dpp.samples_B[1];
                    dpp.samples_B[1] = dpp.samples_B[0];
                    dpp.samples_B[0] = (int)((long)weight_B * (long)sam_A + 512L >> 10) + buffer[bptr_counter + 1];
                    if (sam_A != 0 && buffer[bptr_counter + 1] != 0) {
                        weight_B = (sam_A ^ buffer[bptr_counter + 1]) < 0 ? (weight_B -= delta) : (weight_B += delta);
                    }
                    buffer[bptr_counter + 1] = dpp.samples_B[0];
                    bptr_counter += 2;
                }
                break;
            }
            case 18: {
                bptr_counter = buf_idx;
                while ((long)bptr_counter < (long)buf_idx + sample_count * 2L) {
                    int sam_A = 3 * dpp.samples_A[0] - dpp.samples_A[1] >> 1;
                    dpp.samples_A[1] = dpp.samples_A[0];
                    dpp.samples_A[0] = (int)((long)weight_A * (long)sam_A + 512L >> 10) + buffer[bptr_counter];
                    if (sam_A != 0 && buffer[bptr_counter] != 0) {
                        weight_A = (sam_A ^ buffer[bptr_counter]) < 0 ? (weight_A -= delta) : (weight_A += delta);
                    }
                    buffer[bptr_counter] = dpp.samples_A[0];
                    sam_A = 3 * dpp.samples_B[0] - dpp.samples_B[1] >> 1;
                    dpp.samples_B[1] = dpp.samples_B[0];
                    dpp.samples_B[0] = (int)((long)weight_B * (long)sam_A + 512L >> 10) + buffer[bptr_counter + 1];
                    if (sam_A != 0 && buffer[bptr_counter + 1] != 0) {
                        weight_B = (sam_A ^ buffer[bptr_counter + 1]) < 0 ? (weight_B -= delta) : (weight_B += delta);
                    }
                    buffer[bptr_counter + 1] = dpp.samples_B[0];
                    bptr_counter += 2;
                }
                break;
            }
            case -1: {
                bptr_counter = buf_idx;
                while ((long)bptr_counter < (long)buf_idx + sample_count * 2L) {
                    int sam_A = buffer[bptr_counter] + (int)((long)weight_A * (long)dpp.samples_A[0] + 512L >> 10);
                    if ((dpp.samples_A[0] ^ buffer[bptr_counter]) < 0) {
                        if (dpp.samples_A[0] != 0 && buffer[bptr_counter] != 0 && (weight_A -= delta) < -1024) {
                            weight_A = weight_A < 0 ? -1024 : 1024;
                        }
                    } else if (dpp.samples_A[0] != 0 && buffer[bptr_counter] != 0 && (weight_A += delta) > 1024) {
                        weight_A = weight_A < 0 ? -1024 : 1024;
                    }
                    buffer[bptr_counter] = sam_A;
                    dpp.samples_A[0] = buffer[bptr_counter + 1] + (int)((long)weight_B * (long)sam_A + 512L >> 10);
                    if ((sam_A ^ buffer[bptr_counter + 1]) < 0) {
                        if (sam_A != 0 && buffer[bptr_counter + 1] != 0 && (weight_B -= delta) < -1024) {
                            weight_B = weight_B < 0 ? -1024 : 1024;
                        }
                    } else if (sam_A != 0 && buffer[bptr_counter + 1] != 0 && (weight_B += delta) > 1024) {
                        weight_B = weight_B < 0 ? -1024 : 1024;
                    }
                    buffer[bptr_counter + 1] = dpp.samples_A[0];
                    bptr_counter += 2;
                }
                break;
            }
            case -2: {
                int sam_B = 0;
                boolean sam_A = false;
                bptr_counter = buf_idx;
                while ((long)bptr_counter < (long)buf_idx + sample_count * 2L) {
                    sam_B = buffer[bptr_counter + 1] + (int)((long)weight_B * (long)dpp.samples_B[0] + 512L >> 10);
                    if ((dpp.samples_B[0] ^ buffer[bptr_counter + 1]) < 0) {
                        if (dpp.samples_B[0] != 0 && buffer[bptr_counter + 1] != 0 && (weight_B -= delta) < -1024) {
                            weight_B = weight_B < 0 ? -1024 : 1024;
                        }
                    } else if (dpp.samples_B[0] != 0 && buffer[bptr_counter + 1] != 0 && (weight_B += delta) > 1024) {
                        weight_B = weight_B < 0 ? -1024 : 1024;
                    }
                    buffer[bptr_counter + 1] = sam_B;
                    dpp.samples_B[0] = buffer[bptr_counter] + (int)((long)weight_A * (long)sam_B + 512L >> 10);
                    if ((sam_B ^ buffer[bptr_counter]) < 0) {
                        if (sam_B != 0 && buffer[bptr_counter] != 0 && (weight_A -= delta) < -1024) {
                            weight_A = weight_A < 0 ? -1024 : 1024;
                        }
                    } else if (sam_B != 0 && buffer[bptr_counter] != 0 && (weight_A += delta) > 1024) {
                        weight_A = weight_A < 0 ? -1024 : 1024;
                    }
                    buffer[bptr_counter] = dpp.samples_B[0];
                    bptr_counter += 2;
                }
                break;
            }
            case -3: {
                int sam_A = 0;
                bptr_counter = buf_idx;
                while ((long)bptr_counter < (long)buf_idx + sample_count * 2L) {
                    sam_A = buffer[bptr_counter] + (int)((long)weight_A * (long)dpp.samples_A[0] + 512L >> 10);
                    if ((dpp.samples_A[0] ^ buffer[bptr_counter]) < 0) {
                        if (dpp.samples_A[0] != 0 && buffer[bptr_counter] != 0 && (weight_A -= delta) < -1024) {
                            weight_A = weight_A < 0 ? -1024 : 1024;
                        }
                    } else if (dpp.samples_A[0] != 0 && buffer[bptr_counter] != 0 && (weight_A += delta) > 1024) {
                        weight_A = weight_A < 0 ? -1024 : 1024;
                    }
                    int sam_B = buffer[bptr_counter + 1] + (int)((long)weight_B * (long)dpp.samples_B[0] + 512L >> 10);
                    if ((dpp.samples_B[0] ^ buffer[bptr_counter + 1]) < 0) {
                        if (dpp.samples_B[0] != 0 && buffer[bptr_counter + 1] != 0 && (weight_B -= delta) < -1024) {
                            weight_B = weight_B < 0 ? -1024 : 1024;
                        }
                    } else if (dpp.samples_B[0] != 0 && buffer[bptr_counter + 1] != 0 && (weight_B += delta) > 1024) {
                        weight_B = weight_B < 0 ? -1024 : 1024;
                    }
                    buffer[bptr_counter] = dpp.samples_B[0] = sam_A;
                    buffer[bptr_counter + 1] = dpp.samples_A[0] = sam_B;
                    bptr_counter += 2;
                }
                break;
            }
            default: {
                int sam_A = 0;
                int m = 0;
                int k = dpp.term & Defines.MAX_TERM - 1;
                bptr_counter = buf_idx;
                while ((long)bptr_counter < (long)buf_idx + sample_count * 2L) {
                    sam_A = dpp.samples_A[m];
                    dpp.samples_A[k] = (int)((long)weight_A * (long)sam_A + 512L >> 10) + buffer[bptr_counter];
                    if (sam_A != 0 && buffer[bptr_counter] != 0) {
                        weight_A = (sam_A ^ buffer[bptr_counter]) < 0 ? (weight_A -= delta) : (weight_A += delta);
                    }
                    buffer[bptr_counter] = dpp.samples_A[k];
                    sam_A = dpp.samples_B[m];
                    dpp.samples_B[k] = (int)((long)weight_B * (long)sam_A + 512L >> 10) + buffer[bptr_counter + 1];
                    if (sam_A != 0 && buffer[bptr_counter + 1] != 0) {
                        weight_B = (sam_A ^ buffer[bptr_counter + 1]) < 0 ? (weight_B -= delta) : (weight_B += delta);
                    }
                    buffer[bptr_counter + 1] = dpp.samples_B[k];
                    m = m + 1 & Defines.MAX_TERM - 1;
                    k = k + 1 & Defines.MAX_TERM - 1;
                    bptr_counter += 2;
                }
                if (m == 0) break;
                int[] temp_samples = new int[Defines.MAX_TERM];
                int t = 0;
                while (t < dpp.samples_A.length) {
                    temp_samples[t] = dpp.samples_A[t];
                    ++t;
                }
                k = 0;
                while (k < Defines.MAX_TERM) {
                    dpp.samples_A[k] = temp_samples[m & Defines.MAX_TERM - 1];
                    ++k;
                    ++m;
                }
                System.arraycopy(dpp.samples_B, 0, temp_samples, 0, dpp.samples_B.length);
                k = 0;
                while (k < Defines.MAX_TERM) {
                    dpp.samples_B[k] = temp_samples[m & Defines.MAX_TERM - 1];
                    ++k;
                    ++m;
                }
                break block0;
            }
        }
        dpp.weight_A = (short)weight_A;
        dpp.weight_B = (short)weight_B;
    }

    static void decorr_stereo_pass_cont(decorr_pass dpp, int[] buffer, long sample_count, int buf_idx) {
        short delta = dpp.delta;
        int weight_A = dpp.weight_A;
        int weight_B = dpp.weight_B;
        int buffer_index = buf_idx;
        long end_index = (long)buf_idx + sample_count * 2L;
        switch (dpp.term) {
            case 17: {
                buffer_index = buf_idx;
                while ((long)buffer_index < end_index) {
                    int sam_A = 2 * buffer[buffer_index - 2] - buffer[buffer_index - 4];
                    int sam_B = buffer[buffer_index];
                    buffer[buffer_index] = (int)((long)weight_A * (long)sam_A + 512L >> 10) + sam_B;
                    if (sam_A != 0 && sam_B != 0) {
                        weight_A += ((sam_A ^ sam_B) >> 30 | 1) * delta;
                    }
                    sam_A = 2 * buffer[buffer_index - 1] - buffer[buffer_index - 3];
                    sam_B = buffer[buffer_index + 1];
                    buffer[buffer_index + 1] = (int)((long)weight_B * (long)sam_A + 512L >> 10) + sam_B;
                    if (sam_A != 0 && sam_B != 0) {
                        weight_B += ((sam_A ^ sam_B) >> 30 | 1) * delta;
                    }
                    buffer_index += 2;
                }
                dpp.samples_B[0] = buffer[buffer_index - 1];
                dpp.samples_A[0] = buffer[buffer_index - 2];
                dpp.samples_B[1] = buffer[buffer_index - 3];
                dpp.samples_A[1] = buffer[buffer_index - 4];
                break;
            }
            case 18: {
                buffer_index = buf_idx;
                while ((long)buffer_index < end_index) {
                    int sam_A = 3 * buffer[buffer_index - 2] - buffer[buffer_index - 4] >> 1;
                    int sam_B = buffer[buffer_index];
                    buffer[buffer_index] = (int)((long)weight_A * (long)sam_A + 512L >> 10) + sam_B;
                    if (sam_A != 0 && sam_B != 0) {
                        weight_A += ((sam_A ^ sam_B) >> 30 | 1) * delta;
                    }
                    sam_A = 3 * buffer[buffer_index - 1] - buffer[buffer_index - 3] >> 1;
                    sam_B = buffer[buffer_index + 1];
                    buffer[buffer_index + 1] = (int)((long)weight_B * (long)sam_A + 512L >> 10) + sam_B;
                    if (sam_A != 0 && sam_B != 0) {
                        weight_B += ((sam_A ^ sam_B) >> 30 | 1) * delta;
                    }
                    buffer_index += 2;
                }
                dpp.samples_B[0] = buffer[buffer_index - 1];
                dpp.samples_A[0] = buffer[buffer_index - 2];
                dpp.samples_B[1] = buffer[buffer_index - 3];
                dpp.samples_A[1] = buffer[buffer_index - 4];
                break;
            }
            case -1: {
                buffer_index = buf_idx;
                while ((long)buffer_index < end_index) {
                    int sam_A = buffer[buffer_index];
                    buffer[buffer_index] = (int)((long)weight_A * (long)buffer[buffer_index - 1] + 512L >> 10) + sam_A;
                    if ((buffer[buffer_index - 1] ^ sam_A) < 0) {
                        if (buffer[buffer_index - 1] != 0 && sam_A != 0 && (weight_A -= delta) < -1024) {
                            weight_A = weight_A < 0 ? -1024 : 1024;
                        }
                    } else if (buffer[buffer_index - 1] != 0 && sam_A != 0 && (weight_A += delta) > 1024) {
                        weight_A = weight_A < 0 ? -1024 : 1024;
                    }
                    sam_A = buffer[buffer_index + 1];
                    buffer[buffer_index + 1] = (int)((long)weight_B * (long)buffer[buffer_index] + 512L >> 10) + sam_A;
                    if ((buffer[buffer_index] ^ sam_A) < 0) {
                        if (buffer[buffer_index] != 0 && sam_A != 0 && (weight_B -= delta) < -1024) {
                            weight_B = weight_B < 0 ? -1024 : 1024;
                        }
                    } else if (buffer[buffer_index] != 0 && sam_A != 0 && (weight_B += delta) > 1024) {
                        weight_B = weight_B < 0 ? -1024 : 1024;
                    }
                    buffer_index += 2;
                }
                dpp.samples_A[0] = buffer[buffer_index - 1];
                break;
            }
            case -2: {
                int sam_A = 0;
                boolean sam_B = false;
                buffer_index = buf_idx;
                while ((long)buffer_index < end_index) {
                    sam_A = buffer[buffer_index + 1];
                    buffer[buffer_index + 1] = (int)((long)weight_B * (long)buffer[buffer_index - 2] + 512L >> 10) + sam_A;
                    if ((buffer[buffer_index - 2] ^ sam_A) < 0) {
                        if (buffer[buffer_index - 2] != 0 && sam_A != 0 && (weight_B -= delta) < -1024) {
                            weight_B = weight_B < 0 ? -1024 : 1024;
                        }
                    } else if (buffer[buffer_index - 2] != 0 && sam_A != 0 && (weight_B += delta) > 1024) {
                        weight_B = weight_B < 0 ? -1024 : 1024;
                    }
                    sam_A = buffer[buffer_index];
                    buffer[buffer_index] = (int)((long)weight_A * (long)buffer[buffer_index + 1] + 512L >> 10) + sam_A;
                    if ((buffer[buffer_index + 1] ^ sam_A) < 0) {
                        if (buffer[buffer_index + 1] != 0 && sam_A != 0 && (weight_A -= delta) < -1024) {
                            weight_A = weight_A < 0 ? -1024 : 1024;
                        }
                    } else if (buffer[buffer_index + 1] != 0 && sam_A != 0 && (weight_A += delta) > 1024) {
                        weight_A = weight_A < 0 ? -1024 : 1024;
                    }
                    buffer_index += 2;
                }
                dpp.samples_B[0] = buffer[buffer_index - 2];
                break;
            }
            case -3: {
                buffer_index = buf_idx;
                while ((long)buffer_index < end_index) {
                    int sam_A = buffer[buffer_index];
                    buffer[buffer_index] = (int)((long)weight_A * (long)buffer[buffer_index - 1] + 512L >> 10) + sam_A;
                    if ((buffer[buffer_index - 1] ^ sam_A) < 0) {
                        if (buffer[buffer_index - 1] != 0 && sam_A != 0 && (weight_A -= delta) < -1024) {
                            weight_A = weight_A < 0 ? -1024 : 1024;
                        }
                    } else if (buffer[buffer_index - 1] != 0 && sam_A != 0 && (weight_A += delta) > 1024) {
                        weight_A = weight_A < 0 ? -1024 : 1024;
                    }
                    sam_A = buffer[buffer_index + 1];
                    buffer[buffer_index + 1] = (int)((long)weight_B * (long)buffer[buffer_index - 2] + 512L >> 10) + sam_A;
                    if ((buffer[buffer_index - 2] ^ sam_A) < 0) {
                        if (buffer[buffer_index - 2] != 0 && sam_A != 0 && (weight_B -= delta) < -1024) {
                            weight_B = weight_B < 0 ? -1024 : 1024;
                        }
                    } else if (buffer[buffer_index - 2] != 0 && sam_A != 0 && (weight_B += delta) > 1024) {
                        weight_B = weight_B < 0 ? -1024 : 1024;
                    }
                    buffer_index += 2;
                }
                dpp.samples_A[0] = buffer[buffer_index - 1];
                dpp.samples_B[0] = buffer[buffer_index - 2];
                break;
            }
            default: {
                int tptr = buf_idx - dpp.term * 2;
                buffer_index = buf_idx;
                while ((long)buffer_index < end_index) {
                    int sam_A = buffer[buffer_index];
                    buffer[buffer_index] = (int)((long)weight_A * (long)buffer[tptr] + 512L >> 10) + sam_A;
                    if (buffer[tptr] != 0 && sam_A != 0) {
                        weight_A += ((buffer[tptr] ^ sam_A) >> 30 | 1) * delta;
                    }
                    sam_A = buffer[buffer_index + 1];
                    buffer[buffer_index + 1] = (int)((long)weight_B * (long)buffer[tptr + 1] + 512L >> 10) + sam_A;
                    if (buffer[tptr + 1] != 0 && sam_A != 0) {
                        weight_B += ((buffer[tptr + 1] ^ sam_A) >> 30 | 1) * delta;
                    }
                    tptr += 2;
                    buffer_index += 2;
                }
                --buffer_index;
                int k = dpp.term - 1;
                int i = 8;
                while (i > 0) {
                    --i;
                    dpp.samples_B[k & Defines.MAX_TERM - 1] = buffer[buffer_index];
                    dpp.samples_A[k & Defines.MAX_TERM - 1] = buffer[--buffer_index];
                    --buffer_index;
                    --k;
                }
                break block0;
            }
        }
        dpp.weight_A = (short)weight_A;
        dpp.weight_B = (short)weight_B;
    }

    static void decorr_mono_pass(decorr_pass dpp, int[] buffer, long sample_count, int buf_idx) {
        short delta = dpp.delta;
        int weight_A = dpp.weight_A;
        int bptr_counter = 0;
        switch (dpp.term) {
            case 17: {
                bptr_counter = buf_idx;
                while ((long)bptr_counter < (long)buf_idx + sample_count) {
                    int sam_A = 2 * dpp.samples_A[0] - dpp.samples_A[1];
                    dpp.samples_A[1] = dpp.samples_A[0];
                    dpp.samples_A[0] = (int)((long)weight_A * (long)sam_A + 512L >> 10) + buffer[bptr_counter];
                    if (sam_A != 0 && buffer[bptr_counter] != 0) {
                        weight_A = (sam_A ^ buffer[bptr_counter]) < 0 ? (weight_A -= delta) : (weight_A += delta);
                    }
                    buffer[bptr_counter] = dpp.samples_A[0];
                    ++bptr_counter;
                }
                break;
            }
            case 18: {
                bptr_counter = buf_idx;
                while ((long)bptr_counter < (long)buf_idx + sample_count) {
                    int sam_A = 3 * dpp.samples_A[0] - dpp.samples_A[1] >> 1;
                    dpp.samples_A[1] = dpp.samples_A[0];
                    dpp.samples_A[0] = (int)((long)weight_A * (long)sam_A + 512L >> 10) + buffer[bptr_counter];
                    if (sam_A != 0 && buffer[bptr_counter] != 0) {
                        weight_A = (sam_A ^ buffer[bptr_counter]) < 0 ? (weight_A -= delta) : (weight_A += delta);
                    }
                    buffer[bptr_counter] = dpp.samples_A[0];
                    ++bptr_counter;
                }
                break;
            }
            default: {
                int m = 0;
                int k = dpp.term & Defines.MAX_TERM - 1;
                bptr_counter = buf_idx;
                while ((long)bptr_counter < (long)buf_idx + sample_count) {
                    int sam_A = dpp.samples_A[m];
                    dpp.samples_A[k] = (int)((long)weight_A * (long)sam_A + 512L >> 10) + buffer[bptr_counter];
                    if (sam_A != 0 && buffer[bptr_counter] != 0) {
                        weight_A = (sam_A ^ buffer[bptr_counter]) < 0 ? (weight_A -= delta) : (weight_A += delta);
                    }
                    buffer[bptr_counter] = dpp.samples_A[k];
                    m = m + 1 & Defines.MAX_TERM - 1;
                    k = k + 1 & Defines.MAX_TERM - 1;
                    ++bptr_counter;
                }
                if (m == 0) break;
                int[] temp_samples = new int[Defines.MAX_TERM];
                System.arraycopy(dpp.samples_A, 0, temp_samples, 0, dpp.samples_A.length);
                k = 0;
                while (k < Defines.MAX_TERM) {
                    dpp.samples_A[k] = temp_samples[m & Defines.MAX_TERM - 1];
                    ++k;
                    ++m;
                }
                break block0;
            }
        }
        dpp.weight_A = (short)weight_A;
    }

    static int[] fixup_samples(WavpackStream wps, int[] buffer, long sample_count) {
        block24: {
            int shift;
            long flags;
            block23: {
                int max_shifted;
                int max_value;
                int min_shifted;
                int min_value;
                int buffer_counter;
                flags = wps.wphdr.flags;
                shift = (int)((flags & Defines.SHIFT_MASK) >> Defines.SHIFT_LSB);
                if ((flags & (long)Defines.FLOAT_DATA) > 0L) {
                    long sc = 0L;
                    sc = (flags & (long)Defines.MONO_FLAG) > 0L ? sample_count : sample_count * 2L;
                    buffer = FloatUtils.float_values(wps, buffer, sc);
                }
                if ((flags & (long)Defines.INT32_DATA) > 0L) {
                    short sent_bits = wps.int32_sent_bits;
                    short zeros = wps.int32_zeros;
                    short ones = wps.int32_ones;
                    short dups = wps.int32_dups;
                    buffer_counter = 0;
                    long count = (flags & (long)Defines.MONO_FLAG) > 0L ? sample_count : sample_count * 2L;
                    if ((flags & (long)Defines.HYBRID_FLAG) == 0L && sent_bits == 0 && zeros + ones + dups != 0) {
                        while (count > 0L) {
                            if (zeros != 0) {
                                int n = buffer_counter;
                                buffer[n] = buffer[n] << zeros;
                            } else if (ones != 0) {
                                buffer[buffer_counter] = (buffer[buffer_counter] + 1 << ones) - 1;
                            } else if (dups != 0) {
                                buffer[buffer_counter] = (buffer[buffer_counter] + (buffer[buffer_counter] & 1) << dups) - (buffer[buffer_counter] & 1);
                            }
                            ++buffer_counter;
                            --count;
                        }
                    } else {
                        shift += zeros + sent_bits + ones + dups;
                    }
                }
                if ((flags & (long)Defines.HYBRID_FLAG) <= 0L) break block23;
                buffer_counter = 0;
                switch ((int)(flags & (long)Defines.BYTES_STORED)) {
                    case 0: {
                        min_value = -128 >> shift;
                        min_shifted = min_value << shift;
                        max_value = 127 >> shift;
                        max_shifted = max_value << shift;
                        break;
                    }
                    case 1: {
                        min_value = Short.MIN_VALUE >> shift;
                        min_shifted = min_value << shift;
                        max_value = Short.MAX_VALUE >> shift;
                        max_shifted = max_value << shift;
                        break;
                    }
                    case 2: {
                        min_value = -8388608 >> shift;
                        min_shifted = min_value << shift;
                        max_value = 0x7FFFFF >> shift;
                        max_shifted = max_value << shift;
                        break;
                    }
                    default: {
                        min_value = Integer.MIN_VALUE >> shift;
                        min_shifted = min_value << shift;
                        max_value = Integer.MAX_VALUE >> shift;
                        max_shifted = max_value << shift;
                    }
                }
                if ((flags & (long)Defines.MONO_FLAG) == 0L) {
                    sample_count *= 2L;
                }
                while (sample_count > 0L) {
                    if (buffer[buffer_counter] < min_value) {
                        buffer[buffer_counter] = min_shifted;
                    } else if (buffer[buffer_counter] > max_value) {
                        buffer[buffer_counter] = max_shifted;
                    } else {
                        int n = buffer_counter;
                        buffer[n] = buffer[n] << shift;
                    }
                    ++buffer_counter;
                    --sample_count;
                }
                break block24;
            }
            if (shift == 0) break block24;
            int buffer_counter = 0;
            if ((flags & (long)Defines.MONO_FLAG) == 0L) {
                sample_count *= 2L;
            }
            while (sample_count > 0L) {
                buffer[buffer_counter] = buffer[buffer_counter] << shift;
                ++buffer_counter;
                --sample_count;
            }
        }
        return buffer;
    }

    static int check_crc_error(WavpackContext wpc) {
        WavpackStream wps = wpc.stream;
        int result = 0;
        if (wps.crc != wps.wphdr.crc) {
            ++result;
        }
        return result;
    }
}

