/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.decode;

import com.wavpack.decode.Defines;
import com.wavpack.decode.UnpackUtils;
import com.wavpack.decode.WavpackContext;
import com.wavpack.decode.WavpackHeader;
import com.wavpack.decode.WavpackStream;
import java.io.DataInputStream;

public class WavPackUtils {
    static long[] sample_rates = new long[]{6000L, 8000L, 9600L, 11025L, 12000L, 16000L, 22050L, 24000L, 32000L, 44100L, 48000L, 64000L, 88200L, 96000L, 192000L};

    public static WavpackContext WavpackOpenFileInput(DataInputStream infile) {
        WavpackContext wpc = new WavpackContext();
        WavpackStream wps = wpc.stream;
        wpc.infile = infile;
        wpc.total_samples = -1L;
        wpc.norm_offset = 0;
        wpc.open_flags = 0;
        while (wps.wphdr.block_samples == 0L) {
            wps.wphdr = WavPackUtils.read_next_header(wpc.infile, wps.wphdr);
            if (wps.wphdr.status == 1) {
                wpc.error_message = "not compatible with this version of WavPack file!";
                wpc.error = true;
                return wpc;
            }
            if (wps.wphdr.block_samples > 0L && wps.wphdr.total_samples != -1L) {
                wpc.total_samples = wps.wphdr.total_samples;
            }
            wpc.stream = wps;
            if (UnpackUtils.unpack_init(wpc) != Defines.FALSE) continue;
            wpc.error = true;
            return wpc;
        }
        wpc.config.flags &= 0xFFFFFFFFFFFFFF00L;
        wpc.config.flags |= wps.wphdr.flags & 0xFFL;
        wpc.config.bytes_per_sample = (int)((wps.wphdr.flags & (long)Defines.BYTES_STORED) + 1L);
        wpc.config.float_norm_exp = wps.float_norm_exp;
        wpc.config.bits_per_sample = (int)((long)(wpc.config.bytes_per_sample * 8) - ((wps.wphdr.flags & Defines.SHIFT_MASK) >> Defines.SHIFT_LSB));
        if ((wpc.config.flags & (long)Defines.FLOAT_DATA) > 0L) {
            wpc.config.bytes_per_sample = 3;
            wpc.config.bits_per_sample = 24;
        }
        if (wpc.config.sample_rate == 0L) {
            wpc.config.sample_rate = wps.wphdr.block_samples == 0L || (wps.wphdr.flags & Defines.SRATE_MASK) == Defines.SRATE_MASK ? 44100L : sample_rates[(int)((wps.wphdr.flags & Defines.SRATE_MASK) >> Defines.SRATE_LSB)];
        }
        if (wpc.config.num_channels == 0) {
            wpc.config.num_channels = (wps.wphdr.flags & (long)Defines.MONO_FLAG) > 0L ? 1 : 2;
            wpc.config.channel_mask = 5 - wpc.config.num_channels;
        }
        if ((wps.wphdr.flags & (long)Defines.FINAL_BLOCK) == 0L) {
            wpc.reduced_channels = (wps.wphdr.flags & (long)Defines.MONO_FLAG) != 0L ? 1 : 2;
        }
        return wpc;
    }

    static int WavpackGetMode(WavpackContext wpc) {
        int mode = 0;
        if (wpc != null) {
            if ((wpc.config.flags & Defines.CONFIG_HYBRID_FLAG) != 0L) {
                mode |= Defines.MODE_HYBRID;
            } else if ((wpc.config.flags & Defines.CONFIG_LOSSY_MODE) == 0L) {
                mode |= Defines.MODE_LOSSLESS;
            }
            if (wpc.lossy_blocks != 0) {
                mode &= ~Defines.MODE_LOSSLESS;
            }
            if ((wpc.config.flags & Defines.CONFIG_FLOAT_DATA) != 0L) {
                mode |= Defines.MODE_FLOAT;
            }
            if ((wpc.config.flags & Defines.CONFIG_HIGH_FLAG) != 0L) {
                mode |= Defines.MODE_HIGH;
            }
            if ((wpc.config.flags & Defines.CONFIG_FAST_FLAG) != 0L) {
                mode |= Defines.MODE_FAST;
            }
        }
        return mode;
    }

    public static long WavpackUnpackSamples(WavpackContext wpc, int[] buffer, long samples) {
        WavpackStream wps = wpc.stream;
        long samples_unpacked = 0L;
        int num_channels = wpc.config.num_channels;
        int bcounter = 0;
        int[] temp_buffer = new int[Defines.SAMPLE_BUFFER_SIZE];
        int buf_idx = 0;
        int bytes_returned = 0;
        while (samples > 0L) {
            long samples_to_unpack;
            if (wps.wphdr.block_samples == 0L || (wps.wphdr.flags & (long)Defines.INITIAL_BLOCK) == 0L || wps.sample_index >= wps.wphdr.block_index + wps.wphdr.block_samples) {
                wps.wphdr = WavPackUtils.read_next_header(wpc.infile, wps.wphdr);
                if (wps.wphdr.status == 1 || (wps.wphdr.block_samples == 0L || wps.sample_index == wps.wphdr.block_index) && UnpackUtils.unpack_init(wpc) == Defines.FALSE) break;
            }
            if (wps.wphdr.block_samples == 0L || (wps.wphdr.flags & (long)Defines.INITIAL_BLOCK) == 0L || wps.sample_index >= wps.wphdr.block_index + wps.wphdr.block_samples) continue;
            if (wps.sample_index < wps.wphdr.block_index) {
                samples_to_unpack = wps.wphdr.block_index - wps.sample_index;
                if (samples_to_unpack > samples) {
                    samples_to_unpack = samples;
                }
                wps.sample_index += samples_to_unpack;
                samples_unpacked += samples_to_unpack;
                samples -= samples_to_unpack;
                samples_to_unpack = wpc.reduced_channels > 0 ? (samples_to_unpack *= (long)wpc.reduced_channels) : (samples_to_unpack *= (long)num_channels);
                while (samples_to_unpack > 0L) {
                    temp_buffer[bcounter] = 0;
                    ++bcounter;
                    --samples_to_unpack;
                }
                continue;
            }
            samples_to_unpack = wps.wphdr.block_index + wps.wphdr.block_samples - wps.sample_index;
            if (samples_to_unpack > samples) {
                samples_to_unpack = samples;
            }
            UnpackUtils.unpack_samples(wpc, temp_buffer, samples_to_unpack);
            bytes_returned = wpc.reduced_channels > 0 ? (int)(samples_to_unpack * (long)wpc.reduced_channels) : (int)(samples_to_unpack * (long)num_channels);
            System.arraycopy(temp_buffer, 0, buffer, buf_idx, bytes_returned);
            buf_idx += bytes_returned;
            samples_unpacked += samples_to_unpack;
            samples -= samples_to_unpack;
            if (wps.sample_index == wps.wphdr.block_index + wps.wphdr.block_samples && UnpackUtils.check_crc_error(wpc) > 0) {
                ++wpc.crc_errors;
            }
            if (wps.sample_index == wpc.total_samples) break;
        }
        return samples_unpacked;
    }

    public static long WavpackGetNumSamples(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.total_samples;
        }
        return -1L;
    }

    static long WavpackGetSampleIndex(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.stream.sample_index;
        }
        return -1L;
    }

    public static long WavpackGetNumErrors(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.crc_errors;
        }
        return 0L;
    }

    static int WavpackLossyBlocks(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.lossy_blocks;
        }
        return 0;
    }

    public static long WavpackGetSampleRate(WavpackContext wpc) {
        if (wpc != null && wpc.config.sample_rate != 0L) {
            return wpc.config.sample_rate;
        }
        return 44100L;
    }

    static int WavpackGetNumChannels(WavpackContext wpc) {
        if (wpc != null && wpc.config.num_channels != 0) {
            return wpc.config.num_channels;
        }
        return 2;
    }

    static int WavpackGetBitsPerSample(WavpackContext wpc) {
        if (wpc != null && wpc.config.bits_per_sample != 0) {
            return wpc.config.bits_per_sample;
        }
        return 16;
    }

    public static int WavpackGetBytesPerSample(WavpackContext wpc) {
        if (wpc != null && wpc.config.bytes_per_sample != 0) {
            return wpc.config.bytes_per_sample;
        }
        return 2;
    }

    public static int WavpackGetReducedChannels(WavpackContext wpc) {
        if (wpc != null && wpc.reduced_channels != 0) {
            return wpc.reduced_channels;
        }
        if (wpc != null && wpc.config.num_channels != 0) {
            return wpc.config.num_channels;
        }
        return 2;
    }

    static WavpackHeader read_next_header(DataInputStream infile, WavpackHeader wphdr) {
        byte[] buffer = new byte[32];
        byte[] temp = new byte[32];
        long bytes_skipped = 0L;
        int bleft = 0;
        int counter = 0;
        int i = 0;
        do {
            i = 0;
            while (i < bleft) {
                buffer[i] = buffer[32 - bleft + i];
                ++i;
            }
            counter = 0;
            try {
                if (infile.read(temp, 0, 32 - bleft) != 32 - bleft) {
                    wphdr.status = 1;
                    return wphdr;
                }
            }
            catch (Exception e) {
                wphdr.status = 1;
                return wphdr;
            }
            i = 0;
            while (i < 32 - bleft) {
                buffer[bleft + i] = temp[i];
                ++i;
            }
            bleft = 32;
            if (buffer[0] == 119 && buffer[1] == 118 && buffer[2] == 112 && buffer[3] == 107 && (buffer[4] & 1) == 0 && buffer[6] < 16 && buffer[7] == 0 && buffer[9] == 4 && buffer[8] >= (Defines.MIN_STREAM_VERS & 0xFF) && buffer[8] <= (Defines.MAX_STREAM_VERS & 0xFF)) {
                wphdr.ckID[0] = 119;
                wphdr.ckID[1] = 118;
                wphdr.ckID[2] = 112;
                wphdr.ckID[3] = 107;
                wphdr.ckSize = (buffer[7] & 0xFF) << 24;
                wphdr.ckSize += (long)((buffer[6] & 0xFF) << 16);
                wphdr.ckSize += (long)((buffer[5] & 0xFF) << 8);
                wphdr.ckSize += (long)(buffer[4] & 0xFF);
                wphdr.version = (short)(buffer[9] << 8);
                wphdr.version = (short)(wphdr.version + (short)buffer[8]);
                wphdr.track_no = buffer[10];
                wphdr.index_no = buffer[11];
                wphdr.total_samples = (buffer[15] & 0xFF) << 24;
                wphdr.total_samples += (long)((buffer[14] & 0xFF) << 16);
                wphdr.total_samples += (long)((buffer[13] & 0xFF) << 8);
                wphdr.total_samples += (long)(buffer[12] & 0xFF);
                wphdr.block_index = (buffer[19] & 0xFF) << 24;
                wphdr.block_index += (long)((buffer[18] & 0xFF) << 16);
                wphdr.block_index += (long)((buffer[17] & 0xFF) << 8);
                wphdr.block_index += (long)buffer[16] & 0xFFL;
                wphdr.block_samples = (buffer[23] & 0xFF) << 24;
                wphdr.block_samples += (long)((buffer[22] & 0xFF) << 16);
                wphdr.block_samples += (long)((buffer[21] & 0xFF) << 8);
                wphdr.block_samples += (long)(buffer[20] & 0xFF);
                wphdr.flags = (buffer[27] & 0xFF) << 24;
                wphdr.flags += (long)((buffer[26] & 0xFF) << 16);
                wphdr.flags += (long)((buffer[25] & 0xFF) << 8);
                wphdr.flags += (long)(buffer[24] & 0xFF);
                wphdr.crc = (buffer[31] & 0xFF) << 24;
                wphdr.crc += (long)((buffer[30] & 0xFF) << 16);
                wphdr.crc += (long)((buffer[29] & 0xFF) << 8);
                wphdr.crc += (long)(buffer[28] & 0xFF);
                wphdr.status = 0;
                return wphdr;
            }
            ++counter;
            --bleft;
            while (bleft > 0 && buffer[counter] != 119) {
                ++counter;
                --bleft;
            }
        } while ((bytes_skipped += (long)counter) <= 0x100000L);
        wphdr.status = 1;
        return wphdr;
    }
}

