/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.decode;

import com.wavpack.decode.ChunkHeader;
import com.wavpack.decode.Defines;
import com.wavpack.decode.RiffChunkHeader;
import com.wavpack.decode.WavPackUtils;
import com.wavpack.decode.WaveHeader;
import com.wavpack.decode.WavpackContext;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class WvDemo {
    static int[] temp_buffer = new int[Defines.SAMPLE_BUFFER_SIZE];
    static byte[] pcm_buffer = new byte[4 * Defines.SAMPLE_BUFFER_SIZE];

    public static void main(String[] args) {
        ChunkHeader FormatChunkHeader = new ChunkHeader();
        ChunkHeader DataChunkHeader = new ChunkHeader();
        RiffChunkHeader myRiffChunkHeader = new RiffChunkHeader();
        WaveHeader WaveHeader2 = new WaveHeader();
        byte[] myRiffChunkHeaderAsByteArray = new byte[12];
        byte[] myFormatChunkHeaderAsByteArray = new byte[8];
        byte[] myWaveHeaderAsByteArray = new byte[16];
        byte[] myDataChunkHeaderAsByteArray = new byte[8];
        long total_unpacked_samples = 0L;
        WavpackContext wpc = new WavpackContext();
        String inputWVFile = args.length == 0 ? "input.wv" : args[0];
        try {
            FileInputStream fistream = new FileInputStream(inputWVFile);
            DataInputStream in = new DataInputStream(fistream);
            wpc = WavPackUtils.WavpackOpenFileInput(in);
        }
        catch (FileNotFoundException fe) {
            System.err.println("Input file not found");
            System.exit(1);
        }
        if (wpc.error) {
            System.err.println("Sorry an error has occured");
            System.err.println(wpc.error_message);
            System.exit(1);
        }
        int num_channels = WavPackUtils.WavpackGetReducedChannels(wpc);
        System.out.println("The wavpack file has " + num_channels + " channels");
        long total_samples = WavPackUtils.WavpackGetNumSamples(wpc);
        System.out.println("The wavpack file has " + total_samples + " samples");
        int bps = WavPackUtils.WavpackGetBytesPerSample(wpc);
        System.out.println("The wavpack file has " + bps + " bytes per sample");
        myRiffChunkHeader.ckID[0] = 82;
        myRiffChunkHeader.ckID[1] = 73;
        myRiffChunkHeader.ckID[2] = 70;
        myRiffChunkHeader.ckID[3] = 70;
        myRiffChunkHeader.ckSize = total_samples * (long)num_channels * (long)bps + 16L + 16L + 4L;
        myRiffChunkHeader.formType[0] = 87;
        myRiffChunkHeader.formType[1] = 65;
        myRiffChunkHeader.formType[2] = 86;
        myRiffChunkHeader.formType[3] = 69;
        FormatChunkHeader.ckID[0] = 102;
        FormatChunkHeader.ckID[1] = 109;
        FormatChunkHeader.ckID[2] = 116;
        FormatChunkHeader.ckID[3] = 32;
        FormatChunkHeader.ckSize = 16L;
        WaveHeader2.FormatTag = 1;
        WaveHeader2.NumChannels = num_channels;
        WaveHeader2.SampleRate = WavPackUtils.WavpackGetSampleRate(wpc);
        WaveHeader2.BlockAlign = num_channels * bps;
        WaveHeader2.BytesPerSecond = WaveHeader2.SampleRate * (long)WaveHeader2.BlockAlign;
        WaveHeader2.BitsPerSample = WavPackUtils.WavpackGetBitsPerSample(wpc);
        DataChunkHeader.ckID[0] = 100;
        DataChunkHeader.ckID[1] = 97;
        DataChunkHeader.ckID[2] = 116;
        DataChunkHeader.ckID[3] = 97;
        DataChunkHeader.ckSize = total_samples * (long)num_channels * (long)bps;
        myRiffChunkHeaderAsByteArray[0] = (byte)myRiffChunkHeader.ckID[0];
        myRiffChunkHeaderAsByteArray[1] = (byte)myRiffChunkHeader.ckID[1];
        myRiffChunkHeaderAsByteArray[2] = (byte)myRiffChunkHeader.ckID[2];
        myRiffChunkHeaderAsByteArray[3] = (byte)myRiffChunkHeader.ckID[3];
        myRiffChunkHeaderAsByteArray[7] = (byte)(myRiffChunkHeader.ckSize >>> 24);
        myRiffChunkHeaderAsByteArray[6] = (byte)(myRiffChunkHeader.ckSize >>> 16);
        myRiffChunkHeaderAsByteArray[5] = (byte)(myRiffChunkHeader.ckSize >>> 8);
        myRiffChunkHeaderAsByteArray[4] = (byte)myRiffChunkHeader.ckSize;
        myRiffChunkHeaderAsByteArray[8] = (byte)myRiffChunkHeader.formType[0];
        myRiffChunkHeaderAsByteArray[9] = (byte)myRiffChunkHeader.formType[1];
        myRiffChunkHeaderAsByteArray[10] = (byte)myRiffChunkHeader.formType[2];
        myRiffChunkHeaderAsByteArray[11] = (byte)myRiffChunkHeader.formType[3];
        myFormatChunkHeaderAsByteArray[0] = (byte)FormatChunkHeader.ckID[0];
        myFormatChunkHeaderAsByteArray[1] = (byte)FormatChunkHeader.ckID[1];
        myFormatChunkHeaderAsByteArray[2] = (byte)FormatChunkHeader.ckID[2];
        myFormatChunkHeaderAsByteArray[3] = (byte)FormatChunkHeader.ckID[3];
        myFormatChunkHeaderAsByteArray[7] = (byte)(FormatChunkHeader.ckSize >>> 24);
        myFormatChunkHeaderAsByteArray[6] = (byte)(FormatChunkHeader.ckSize >>> 16);
        myFormatChunkHeaderAsByteArray[5] = (byte)(FormatChunkHeader.ckSize >>> 8);
        myFormatChunkHeaderAsByteArray[4] = (byte)FormatChunkHeader.ckSize;
        myWaveHeaderAsByteArray[1] = (byte)(WaveHeader2.FormatTag >>> 8);
        myWaveHeaderAsByteArray[0] = (byte)WaveHeader2.FormatTag;
        myWaveHeaderAsByteArray[3] = (byte)(WaveHeader2.NumChannels >>> 8);
        myWaveHeaderAsByteArray[2] = (byte)WaveHeader2.NumChannels;
        myWaveHeaderAsByteArray[7] = (byte)(WaveHeader2.SampleRate >>> 24);
        myWaveHeaderAsByteArray[6] = (byte)(WaveHeader2.SampleRate >>> 16);
        myWaveHeaderAsByteArray[5] = (byte)(WaveHeader2.SampleRate >>> 8);
        myWaveHeaderAsByteArray[4] = (byte)WaveHeader2.SampleRate;
        myWaveHeaderAsByteArray[11] = (byte)(WaveHeader2.BytesPerSecond >>> 24);
        myWaveHeaderAsByteArray[10] = (byte)(WaveHeader2.BytesPerSecond >>> 16);
        myWaveHeaderAsByteArray[9] = (byte)(WaveHeader2.BytesPerSecond >>> 8);
        myWaveHeaderAsByteArray[8] = (byte)WaveHeader2.BytesPerSecond;
        myWaveHeaderAsByteArray[13] = (byte)(WaveHeader2.BlockAlign >>> 8);
        myWaveHeaderAsByteArray[12] = (byte)WaveHeader2.BlockAlign;
        myWaveHeaderAsByteArray[15] = (byte)(WaveHeader2.BitsPerSample >>> 8);
        myWaveHeaderAsByteArray[14] = (byte)WaveHeader2.BitsPerSample;
        myDataChunkHeaderAsByteArray[0] = (byte)DataChunkHeader.ckID[0];
        myDataChunkHeaderAsByteArray[1] = (byte)DataChunkHeader.ckID[1];
        myDataChunkHeaderAsByteArray[2] = (byte)DataChunkHeader.ckID[2];
        myDataChunkHeaderAsByteArray[3] = (byte)DataChunkHeader.ckID[3];
        myDataChunkHeaderAsByteArray[7] = (byte)(DataChunkHeader.ckSize >>> 24);
        myDataChunkHeaderAsByteArray[6] = (byte)(DataChunkHeader.ckSize >>> 16);
        myDataChunkHeaderAsByteArray[5] = (byte)(DataChunkHeader.ckSize >>> 8);
        myDataChunkHeaderAsByteArray[4] = (byte)DataChunkHeader.ckSize;
        try {
            long samples_unpacked;
            FileOutputStream fostream = new FileOutputStream("output.wav");
            fostream.write(myRiffChunkHeaderAsByteArray);
            fostream.write(myFormatChunkHeaderAsByteArray);
            fostream.write(myWaveHeaderAsByteArray);
            fostream.write(myDataChunkHeaderAsByteArray);
            long start = System.currentTimeMillis();
            do {
                samples_unpacked = WavPackUtils.WavpackUnpackSamples(wpc, temp_buffer, Defines.SAMPLE_BUFFER_SIZE / num_channels);
                total_unpacked_samples += samples_unpacked;
                if (samples_unpacked <= 0L) continue;
                pcm_buffer = WvDemo.format_samples(bps, temp_buffer, samples_unpacked *= (long)num_channels);
                fostream.write(pcm_buffer, 0, (int)samples_unpacked * bps);
            } while (samples_unpacked != 0L);
            long end = System.currentTimeMillis();
            System.out.println(String.valueOf(end - start) + " milli seconds to process WavPack file in main loop");
        }
        catch (Exception e) {
            System.err.println("Error when writing wav file, sorry: ");
            e.printStackTrace();
            System.exit(1);
        }
        if (WavPackUtils.WavpackGetNumSamples(wpc) != -1L && total_unpacked_samples != WavPackUtils.WavpackGetNumSamples(wpc)) {
            System.err.println("Incorrect number of samples");
            System.exit(1);
        }
        if (WavPackUtils.WavpackGetNumErrors(wpc) > 0L) {
            System.err.println("CRC errors detected");
            System.exit(1);
        }
        System.exit(0);
    }

    public static byte[] format_samples(int bps, int[] src, long samcnt) {
        int counter = 0;
        int counter2 = 0;
        byte[] dst = new byte[4 * Defines.SAMPLE_BUFFER_SIZE];
        switch (bps) {
            case 1: {
                while (samcnt > 0L) {
                    dst[counter] = (byte)(0xFF & src[counter] + 128);
                    ++counter;
                    --samcnt;
                }
                break;
            }
            case 2: {
                while (samcnt > 0L) {
                    int temp = src[counter2];
                    dst[counter] = (byte)temp;
                    dst[++counter] = (byte)(temp >>> 8);
                    ++counter;
                    ++counter2;
                    --samcnt;
                }
                break;
            }
            case 3: {
                while (samcnt > 0L) {
                    int temp = src[counter2];
                    dst[counter] = (byte)temp;
                    dst[++counter] = (byte)(temp >>> 8);
                    dst[++counter] = (byte)(temp >>> 16);
                    ++counter;
                    ++counter2;
                    --samcnt;
                }
                break;
            }
            case 4: {
                while (samcnt > 0L) {
                    int temp = src[counter2];
                    dst[counter] = (byte)temp;
                    dst[++counter] = (byte)(temp >>> 8);
                    dst[++counter] = (byte)(temp >>> 16);
                    dst[++counter] = (byte)(temp >>> 24);
                    ++counter;
                    ++counter2;
                    --samcnt;
                }
                break;
            }
        }
        return dst;
    }
}

