/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.encode;

import com.wavpack.encode.BitsUtils;
import com.wavpack.encode.Defines;
import com.wavpack.encode.WavpackContext;
import com.wavpack.encode.WavpackMetadata;
import com.wavpack.encode.WavpackStream;
import com.wavpack.encode.WordsUtils;

class PackUtils {
    static short[] very_high_terms;
    static short[] high_terms;
    static short[] default_terms;
    static short[] fast_terms;

    static {
        short[] sArray = new short[17];
        sArray[0] = 18;
        sArray[1] = 18;
        sArray[2] = 2;
        sArray[3] = 3;
        sArray[4] = -2;
        sArray[5] = 18;
        sArray[6] = 2;
        sArray[7] = 4;
        sArray[8] = 7;
        sArray[9] = 5;
        sArray[10] = 3;
        sArray[11] = 6;
        sArray[12] = 8;
        sArray[13] = -1;
        sArray[14] = 18;
        sArray[15] = 2;
        very_high_terms = sArray;
        short[] sArray2 = new short[11];
        sArray2[0] = 18;
        sArray2[1] = 18;
        sArray2[2] = 18;
        sArray2[3] = -2;
        sArray2[4] = 2;
        sArray2[5] = 3;
        sArray2[6] = 5;
        sArray2[7] = -1;
        sArray2[8] = 17;
        sArray2[9] = 4;
        high_terms = sArray2;
        short[] sArray3 = new short[6];
        sArray3[0] = 18;
        sArray3[1] = 18;
        sArray3[2] = 2;
        sArray3[3] = 17;
        sArray3[4] = 3;
        default_terms = sArray3;
        short[] sArray4 = new short[3];
        sArray4[0] = 18;
        sArray4[1] = 17;
        fast_terms = sArray4;
    }

    PackUtils() {
    }

    static void pack_init(WavpackContext wpc) {
        WavpackStream wps = wpc.stream;
        long flags = wps.wphdr.flags;
        int dpp_idx = 0;
        wps.sample_index = 0L;
        if ((flags & (long)Defines.HYBRID_SHAPE) > 0L) {
            int weight = wpc.config.shaping_weight;
            if (weight <= -1000) {
                weight = -1000;
            }
            wps.dc.shaping_acc[0] = wps.dc.shaping_acc[1] = weight << 16;
        }
        short[] term_string = (wpc.config.flags & Defines.CONFIG_VERY_HIGH_FLAG) > 0L ? very_high_terms : ((wpc.config.flags & Defines.CONFIG_HIGH_FLAG) > 0L ? high_terms : ((wpc.config.flags & Defines.CONFIG_FAST_FLAG) > 0L ? fast_terms : default_terms));
        int ti = 0;
        while (ti < term_string.length - 1) {
            if (term_string[ti] >= 0 || (flags & (long)Defines.CROSS_DECORR) > 0L) {
                wps.decorr_passes[dpp_idx].term = term_string[ti];
                wps.decorr_passes[dpp_idx].delta = (short)2;
                ++dpp_idx;
            } else if ((flags & (long)Defines.MONO_FLAG) == 0L) {
                wps.decorr_passes[dpp_idx].term = (short)-3;
                wps.decorr_passes[dpp_idx].delta = (short)2;
                ++dpp_idx;
            }
            ++ti;
        }
        wps.num_terms = dpp_idx;
        WordsUtils.init_words(wps);
    }

    static void write_decorr_terms(WavpackStream wps, WavpackMetadata wpmd) {
        int byte_idx = 0;
        int dpp_idx = 0;
        wpmd.data = wpmd.temp_data;
        byte[] byteptr = wpmd.temp_data;
        wpmd.id = (short)2;
        int tcount = wps.num_terms;
        while (tcount > 0) {
            byteptr[byte_idx] = (byte)(wps.decorr_passes[dpp_idx].term + 5 & 0x1F | wps.decorr_passes[dpp_idx].delta << 5 & 0xE0);
            ++byte_idx;
            --tcount;
            ++dpp_idx;
        }
        wpmd.byte_length = byte_idx;
    }

    static void write_decorr_weights(WavpackStream wps, WavpackMetadata wpmd) {
        int byte_idx = 0;
        wpmd.data = wpmd.temp_data;
        byte[] byteptr = wpmd.temp_data;
        wpmd.id = (short)3;
        int i = wps.num_terms - 1;
        while (i >= 0) {
            if (WordsUtils.store_weight(wps.decorr_passes[i].weight_A) != 0 || (wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L && WordsUtils.store_weight(wps.decorr_passes[i].weight_B) != 0) break;
            --i;
        }
        int tcount = i + 1;
        i = 0;
        while (i < wps.num_terms) {
            if (i < tcount) {
                byteptr[byte_idx] = WordsUtils.store_weight(wps.decorr_passes[i].weight_A);
                wps.decorr_passes[i].weight_A = (short)WordsUtils.restore_weight(byteptr[byte_idx]);
                ++byte_idx;
                if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                    byteptr[byte_idx] = WordsUtils.store_weight(wps.decorr_passes[i].weight_B);
                    wps.decorr_passes[i].weight_B = (short)WordsUtils.restore_weight(byteptr[byte_idx]);
                    ++byte_idx;
                }
            } else {
                wps.decorr_passes[i].weight_B = 0;
                wps.decorr_passes[i].weight_A = 0;
            }
            ++i;
        }
        wpmd.byte_length = byte_idx;
    }

    static void write_decorr_samples(WavpackStream wps, WavpackMetadata wpmd) {
        int wcount = 1;
        int byte_idx = 0;
        int dpp_idx = 0;
        wpmd.data = wpmd.temp_data;
        byte[] byteptr = wpmd.temp_data;
        wpmd.id = (short)4;
        int tcount = wps.num_terms;
        while (tcount > 0) {
            if (wcount != 0) {
                int temp;
                if (wps.decorr_passes[dpp_idx].term > Defines.MAX_TERM) {
                    temp = WordsUtils.log2s(wps.decorr_passes[dpp_idx].samples_A[0]);
                    wps.decorr_passes[dpp_idx].samples_A[0] = WordsUtils.exp2s(temp);
                    byteptr[byte_idx] = (byte)temp;
                    byteptr[++byte_idx] = (byte)(temp >> 8);
                    temp = WordsUtils.log2s(wps.decorr_passes[dpp_idx].samples_A[1]);
                    wps.decorr_passes[dpp_idx].samples_A[1] = WordsUtils.exp2s(temp);
                    byteptr[++byte_idx] = (byte)temp;
                    byteptr[++byte_idx] = (byte)(temp >> 8);
                    ++byte_idx;
                    if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                        temp = WordsUtils.log2s(wps.decorr_passes[dpp_idx].samples_B[0]);
                        wps.decorr_passes[dpp_idx].samples_B[0] = WordsUtils.exp2s(temp);
                        byteptr[byte_idx] = (byte)temp;
                        byteptr[++byte_idx] = (byte)(temp >> 8);
                        temp = WordsUtils.log2s(wps.decorr_passes[dpp_idx].samples_B[1]);
                        wps.decorr_passes[dpp_idx].samples_B[1] = WordsUtils.exp2s(temp);
                        byteptr[++byte_idx] = (byte)temp;
                        byteptr[++byte_idx] = (byte)(temp >> 8);
                        ++byte_idx;
                    }
                } else if (wps.decorr_passes[dpp_idx].term < 0) {
                    temp = WordsUtils.log2s(wps.decorr_passes[dpp_idx].samples_A[0]);
                    wps.decorr_passes[dpp_idx].samples_A[0] = WordsUtils.exp2s(temp);
                    byteptr[byte_idx] = (byte)temp;
                    byteptr[++byte_idx] = (byte)(temp >> 8);
                    temp = WordsUtils.log2s(wps.decorr_passes[dpp_idx].samples_B[0]);
                    wps.decorr_passes[dpp_idx].samples_B[0] = WordsUtils.exp2s(temp);
                    byteptr[++byte_idx] = (byte)temp;
                    byteptr[++byte_idx] = (byte)(temp >> 8);
                    ++byte_idx;
                } else {
                    int m = 0;
                    int cnt = wps.decorr_passes[dpp_idx].term;
                    while (cnt > 0) {
                        temp = WordsUtils.log2s(wps.decorr_passes[dpp_idx].samples_A[m]);
                        wps.decorr_passes[dpp_idx].samples_A[m] = WordsUtils.exp2s(temp);
                        byteptr[byte_idx] = (byte)temp;
                        byteptr[++byte_idx] = (byte)(temp >> 8);
                        ++byte_idx;
                        if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                            temp = WordsUtils.log2s(wps.decorr_passes[dpp_idx].samples_B[m]);
                            wps.decorr_passes[dpp_idx].samples_B[m] = WordsUtils.exp2s(temp);
                            byteptr[byte_idx] = (byte)temp;
                            byteptr[++byte_idx] = (byte)(temp >> 8);
                            ++byte_idx;
                        }
                        ++m;
                        --cnt;
                    }
                }
                --wcount;
            } else {
                int internalc = 0;
                while (internalc < Defines.MAX_TERM) {
                    wps.decorr_passes[dpp_idx].samples_A[internalc] = 0;
                    wps.decorr_passes[dpp_idx].samples_B[internalc] = 0;
                    ++internalc;
                }
            }
            ++dpp_idx;
            --tcount;
        }
        wpmd.byte_length = byte_idx;
    }

    static void write_shaping_info(WavpackStream wps, WavpackMetadata wpmd) {
        int byte_idx = 0;
        wpmd.data = wpmd.temp_data;
        byte[] byteptr = wpmd.temp_data;
        wpmd.id = (short)7;
        int temp = WordsUtils.log2s(wps.dc.error[0]);
        wps.dc.error[0] = WordsUtils.exp2s(temp);
        byteptr[byte_idx] = (byte)temp;
        byteptr[++byte_idx] = (byte)(temp >> 8);
        temp = WordsUtils.log2s(wps.dc.shaping_acc[0]);
        wps.dc.shaping_acc[0] = WordsUtils.exp2s(temp);
        byteptr[++byte_idx] = (byte)temp;
        byteptr[++byte_idx] = (byte)(temp >> 8);
        ++byte_idx;
        if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
            temp = WordsUtils.log2s(wps.dc.error[1]);
            wps.dc.error[1] = WordsUtils.exp2s(temp);
            byteptr[byte_idx] = (byte)temp;
            byteptr[++byte_idx] = (byte)(temp >> 8);
            temp = WordsUtils.log2s(wps.dc.shaping_acc[1]);
            wps.dc.shaping_acc[1] = WordsUtils.exp2s(temp);
            byteptr[++byte_idx] = (byte)temp;
            byteptr[++byte_idx] = (byte)(temp >> 8);
            ++byte_idx;
        }
        if ((wps.dc.shaping_delta[0] | wps.dc.shaping_delta[1]) != 0) {
            temp = WordsUtils.log2s(wps.dc.shaping_delta[0]);
            wps.dc.shaping_delta[0] = WordsUtils.exp2s(temp);
            byteptr[byte_idx] = (byte)temp;
            byteptr[++byte_idx] = (byte)(temp >> 8);
            ++byte_idx;
            if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                temp = WordsUtils.log2s(wps.dc.shaping_delta[1]);
                wps.dc.shaping_delta[1] = WordsUtils.exp2s(temp);
                byteptr[byte_idx] = (byte)temp;
                byteptr[++byte_idx] = (byte)(temp >> 8);
                ++byte_idx;
            }
        }
        wpmd.byte_length = byte_idx;
    }

    static void write_config_info(WavpackContext wpc, WavpackMetadata wpmd) {
        int byte_idx = 0;
        wpmd.data = wpmd.temp_data;
        byte[] byteptr = wpmd.temp_data;
        wpmd.id = (short)37;
        byteptr[byte_idx] = (byte)(wpc.config.flags >> 8);
        byteptr[++byte_idx] = (byte)(wpc.config.flags >> 16);
        byteptr[++byte_idx] = (byte)(wpc.config.flags >> 24);
        wpmd.byte_length = ++byte_idx;
    }

    static void write_sample_rate(WavpackContext wpc, WavpackMetadata wpmd) {
        int byte_idx = 0;
        wpmd.data = wpmd.temp_data;
        byte[] byteptr = wpmd.temp_data;
        wpmd.id = (short)39;
        byteptr[byte_idx] = (byte)wpc.config.sample_rate;
        byteptr[++byte_idx] = (byte)(wpc.config.sample_rate >> 8);
        byteptr[++byte_idx] = (byte)(wpc.config.sample_rate >> 16);
        wpmd.byte_length = ++byte_idx;
    }

    static int pack_start_block(WavpackContext wpc) {
        WavpackStream wps = wpc.stream;
        long flags = wps.wphdr.flags;
        WavpackMetadata wpmd = new WavpackMetadata();
        boolean i = false;
        wps.lossy_block = Defines.FALSE;
        wps.wphdr.crc = -1L;
        wps.wphdr.block_samples = 0L;
        wps.wphdr.ckSize = Defines.WAVPACK_HEADER_SIZE - 8;
        wps.blockbuff[0] = (byte)wps.wphdr.ckID[0];
        wps.blockbuff[1] = (byte)wps.wphdr.ckID[1];
        wps.blockbuff[2] = (byte)wps.wphdr.ckID[2];
        wps.blockbuff[3] = (byte)wps.wphdr.ckID[3];
        wps.blockbuff[4] = (byte)wps.wphdr.ckSize;
        wps.blockbuff[5] = (byte)(wps.wphdr.ckSize >>> 8);
        wps.blockbuff[6] = (byte)(wps.wphdr.ckSize >>> 16);
        wps.blockbuff[7] = (byte)(wps.wphdr.ckSize >>> 24);
        wps.blockbuff[8] = (byte)wps.wphdr.version;
        wps.blockbuff[9] = (byte)(wps.wphdr.version >>> 8);
        wps.blockbuff[10] = (byte)wps.wphdr.track_no;
        wps.blockbuff[11] = (byte)wps.wphdr.index_no;
        wps.blockbuff[12] = (byte)wps.wphdr.total_samples;
        wps.blockbuff[13] = (byte)(wps.wphdr.total_samples >>> 8);
        wps.blockbuff[14] = (byte)(wps.wphdr.total_samples >>> 16);
        wps.blockbuff[15] = (byte)(wps.wphdr.total_samples >>> 24);
        wps.blockbuff[16] = (byte)wps.wphdr.block_index;
        wps.blockbuff[17] = (byte)(wps.wphdr.block_index >>> 8);
        wps.blockbuff[18] = (byte)(wps.wphdr.block_index >>> 16);
        wps.blockbuff[19] = (byte)(wps.wphdr.block_index >>> 24);
        wps.blockbuff[20] = (byte)wps.wphdr.block_samples;
        wps.blockbuff[21] = (byte)(wps.wphdr.block_samples >>> 8);
        wps.blockbuff[22] = (byte)(wps.wphdr.block_samples >>> 16);
        wps.blockbuff[23] = (byte)(wps.wphdr.block_samples >>> 24);
        wps.blockbuff[24] = (byte)wps.wphdr.flags;
        wps.blockbuff[25] = (byte)(wps.wphdr.flags >>> 8);
        wps.blockbuff[26] = (byte)(wps.wphdr.flags >>> 16);
        wps.blockbuff[27] = (byte)(wps.wphdr.flags >>> 24);
        wps.blockbuff[28] = (byte)wps.wphdr.crc;
        wps.blockbuff[29] = (byte)(wps.wphdr.crc >>> 8);
        wps.blockbuff[30] = (byte)(wps.wphdr.crc >>> 16);
        wps.blockbuff[31] = (byte)(wps.wphdr.crc >>> 24);
        PackUtils.write_decorr_terms(wps, wpmd);
        PackUtils.copy_metadata(wpmd, wps.blockbuff, wps.blockend);
        PackUtils.write_decorr_weights(wps, wpmd);
        PackUtils.copy_metadata(wpmd, wps.blockbuff, wps.blockend);
        PackUtils.write_decorr_samples(wps, wpmd);
        PackUtils.copy_metadata(wpmd, wps.blockbuff, wps.blockend);
        WordsUtils.write_entropy_vars(wps, wpmd);
        PackUtils.copy_metadata(wpmd, wps.blockbuff, wps.blockend);
        if ((flags & Defines.SRATE_MASK) == Defines.SRATE_MASK && wpc.config.sample_rate != 44100L) {
            PackUtils.write_sample_rate(wpc, wpmd);
            PackUtils.copy_metadata(wpmd, wps.blockbuff, wps.blockend);
        }
        if ((flags & (long)Defines.HYBRID_FLAG) != 0L) {
            WordsUtils.write_hybrid_profile(wps, wpmd);
            PackUtils.copy_metadata(wpmd, wps.blockbuff, wps.blockend);
        }
        if ((flags & (long)Defines.INITIAL_BLOCK) > 0L && wps.sample_index == 0L) {
            PackUtils.write_config_info(wpc, wpmd);
            PackUtils.copy_metadata(wpmd, wps.blockbuff, wps.blockend);
        }
        long chunkSize = (wps.blockbuff[4] & 0xFF) + ((wps.blockbuff[5] & 0xFF) << 8) + ((wps.blockbuff[6] & 0xFF) << 16) + ((wps.blockbuff[7] & 0xFF) << 24);
        BitsUtils.bs_open_write(wps.wvbits, (int)(chunkSize + 12L), wps.blockend);
        if (wpc.wvc_flag != 0) {
            wps.block2buff[0] = (byte)wps.wphdr.ckID[0];
            wps.block2buff[1] = (byte)wps.wphdr.ckID[1];
            wps.block2buff[2] = (byte)wps.wphdr.ckID[2];
            wps.block2buff[3] = (byte)wps.wphdr.ckID[3];
            wps.block2buff[4] = (byte)wps.wphdr.ckSize;
            wps.block2buff[5] = (byte)(wps.wphdr.ckSize >>> 8);
            wps.block2buff[6] = (byte)(wps.wphdr.ckSize >>> 16);
            wps.block2buff[7] = (byte)(wps.wphdr.ckSize >>> 24);
            wps.block2buff[8] = (byte)wps.wphdr.version;
            wps.block2buff[9] = (byte)(wps.wphdr.version >>> 8);
            wps.block2buff[10] = (byte)wps.wphdr.track_no;
            wps.block2buff[11] = (byte)wps.wphdr.index_no;
            wps.block2buff[12] = (byte)wps.wphdr.total_samples;
            wps.block2buff[13] = (byte)(wps.wphdr.total_samples >>> 8);
            wps.block2buff[14] = (byte)(wps.wphdr.total_samples >>> 16);
            wps.block2buff[15] = (byte)(wps.wphdr.total_samples >>> 24);
            wps.block2buff[16] = (byte)wps.wphdr.block_index;
            wps.block2buff[17] = (byte)(wps.wphdr.block_index >>> 8);
            wps.block2buff[18] = (byte)(wps.wphdr.block_index >>> 16);
            wps.block2buff[19] = (byte)(wps.wphdr.block_index >>> 24);
            wps.block2buff[20] = (byte)wps.wphdr.block_samples;
            wps.block2buff[21] = (byte)(wps.wphdr.block_samples >>> 8);
            wps.block2buff[22] = (byte)(wps.wphdr.block_samples >>> 16);
            wps.block2buff[23] = (byte)(wps.wphdr.block_samples >>> 24);
            wps.block2buff[24] = (byte)wps.wphdr.flags;
            wps.block2buff[25] = (byte)(wps.wphdr.flags >>> 8);
            wps.block2buff[26] = (byte)(wps.wphdr.flags >>> 16);
            wps.block2buff[27] = (byte)(wps.wphdr.flags >>> 24);
            wps.block2buff[28] = (byte)wps.wphdr.crc;
            wps.block2buff[29] = (byte)(wps.wphdr.crc >>> 8);
            wps.block2buff[30] = (byte)(wps.wphdr.crc >>> 16);
            wps.block2buff[31] = (byte)(wps.wphdr.crc >>> 24);
            if ((flags & (long)Defines.HYBRID_SHAPE) != 0L) {
                PackUtils.write_shaping_info(wps, wpmd);
                PackUtils.copy_metadata(wpmd, wps.block2buff, wps.block2end);
            }
            chunkSize = (wps.block2buff[4] & 0xFF) + ((wps.block2buff[5] & 0xFF) << 8) + ((wps.block2buff[6] & 0xFF) << 16) + ((wps.block2buff[7] & 0xFF) << 24);
            BitsUtils.bs_open_write(wps.wvcbits, (int)(chunkSize + 12L), wps.block2end);
        }
        return Defines.TRUE;
    }

    static long pack_samples(WavpackContext wpc, long[] buffer, long sample_count) {
        WavpackStream wps = wpc.stream;
        long flags = wps.wphdr.flags;
        int lossy = 0;
        int byte_idx = 0;
        int dpp_idx = 0;
        if (sample_count == 0L) {
            return 0L;
        }
        byte_idx = wpc.byte_idx;
        long i = 0L;
        long block_samples = (wps.blockbuff[23] & 0xFF) << 24;
        block_samples += (long)((wps.blockbuff[22] & 0xFF) << 16);
        block_samples += (long)((wps.blockbuff[21] & 0xFF) << 8);
        int m = (int)((block_samples += (long)(wps.blockbuff[20] & 0xFF)) & (long)(Defines.MAX_TERM - 1));
        long crc = (wps.blockbuff[31] & 0xFF) << 24;
        crc += (long)((wps.blockbuff[30] & 0xFF) << 16);
        crc += (long)((wps.blockbuff[29] & 0xFF) << 8);
        crc += (long)(wps.blockbuff[28] & 0xFF);
        long crc2 = 0L;
        if (wpc.wvc_flag != 0) {
            crc2 = (wps.block2buff[31] & 0xFF) << 24;
            crc2 += (long)((wps.block2buff[30] & 0xFF) << 16);
            crc2 += (long)((wps.block2buff[29] & 0xFF) << 8);
            crc2 += (long)(wps.block2buff[28] & 0xFF);
        }
        if ((flags & (long)Defines.HYBRID_FLAG) == 0L && (flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) != 0L) {
            long[] bptr = buffer;
            i = 0L;
            while (i < sample_count) {
                if (BitsUtils.bs_remain_write(wps.wvbits) < 64L) break;
                int code = (int)bptr[byte_idx];
                crc = crc * 3L + (long)code;
                ++byte_idx;
                dpp_idx = 0;
                int tcount = wps.num_terms;
                while (tcount > 0) {
                    int sam;
                    if (wps.decorr_passes[dpp_idx].term > Defines.MAX_TERM) {
                        sam = (wps.decorr_passes[dpp_idx].term & 1) != 0 ? 2 * wps.decorr_passes[dpp_idx].samples_A[0] - wps.decorr_passes[dpp_idx].samples_A[1] : 3 * wps.decorr_passes[dpp_idx].samples_A[0] - wps.decorr_passes[dpp_idx].samples_A[1] >> 1;
                        wps.decorr_passes[dpp_idx].samples_A[1] = wps.decorr_passes[dpp_idx].samples_A[0];
                        wps.decorr_passes[dpp_idx].samples_A[0] = code;
                    } else {
                        sam = wps.decorr_passes[dpp_idx].samples_A[m];
                        wps.decorr_passes[dpp_idx].samples_A[m + wps.decorr_passes[dpp_idx].term & Defines.MAX_TERM - 1] = code;
                    }
                    wps.decorr_passes[dpp_idx].weight_A = PackUtils.update_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].delta, sam, code -= PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_A, sam));
                    ++dpp_idx;
                    --tcount;
                }
                m = m + 1 & Defines.MAX_TERM - 1;
                WordsUtils.send_word_lossless(wps, code, 0);
                ++i;
            }
            wpc.byte_idx = byte_idx;
        } else if ((flags & (long)Defines.HYBRID_FLAG) == 0L && (flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
            long[] bptr = buffer;
            i = 0L;
            while (i < sample_count) {
                if (BitsUtils.bs_remain_write(wps.wvbits) < 128L) break;
                int left = (int)bptr[byte_idx];
                crc = crc * 3L + (long)left;
                int right = (int)bptr[byte_idx + 1];
                crc = crc * 3L + (long)right;
                if ((flags & (long)Defines.JOINT_STEREO) > 0L) {
                    left -= right;
                    right += left >> 1;
                }
                dpp_idx = 0;
                int tcount = wps.num_terms;
                while (tcount > 0) {
                    int sam_B;
                    int sam_A;
                    if (wps.decorr_passes[dpp_idx].term > 0) {
                        if (wps.decorr_passes[dpp_idx].term > Defines.MAX_TERM) {
                            if ((wps.decorr_passes[dpp_idx].term & 1) != 0) {
                                sam_A = 2 * wps.decorr_passes[dpp_idx].samples_A[0] - wps.decorr_passes[dpp_idx].samples_A[1];
                                sam_B = 2 * wps.decorr_passes[dpp_idx].samples_B[0] - wps.decorr_passes[dpp_idx].samples_B[1];
                            } else {
                                sam_A = 3 * wps.decorr_passes[dpp_idx].samples_A[0] - wps.decorr_passes[dpp_idx].samples_A[1] >> 1;
                                sam_B = 3 * wps.decorr_passes[dpp_idx].samples_B[0] - wps.decorr_passes[dpp_idx].samples_B[1] >> 1;
                            }
                            wps.decorr_passes[dpp_idx].samples_A[1] = wps.decorr_passes[dpp_idx].samples_A[0];
                            wps.decorr_passes[dpp_idx].samples_B[1] = wps.decorr_passes[dpp_idx].samples_B[0];
                            wps.decorr_passes[dpp_idx].samples_A[0] = left;
                            wps.decorr_passes[dpp_idx].samples_B[0] = right;
                        } else {
                            int k = m + wps.decorr_passes[dpp_idx].term & Defines.MAX_TERM - 1;
                            sam_A = wps.decorr_passes[dpp_idx].samples_A[m];
                            sam_B = wps.decorr_passes[dpp_idx].samples_B[m];
                            wps.decorr_passes[dpp_idx].samples_A[k] = left;
                            wps.decorr_passes[dpp_idx].samples_B[k] = right;
                        }
                        wps.decorr_passes[dpp_idx].weight_A = PackUtils.update_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].delta, sam_A, left -= PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_A, sam_A));
                        wps.decorr_passes[dpp_idx].weight_B = PackUtils.update_weight(wps.decorr_passes[dpp_idx].weight_B, wps.decorr_passes[dpp_idx].delta, sam_B, right -= PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_B, sam_B));
                    } else {
                        sam_A = wps.decorr_passes[dpp_idx].term == -2 ? right : wps.decorr_passes[dpp_idx].samples_A[0];
                        sam_B = wps.decorr_passes[dpp_idx].term == -1 ? left : wps.decorr_passes[dpp_idx].samples_B[0];
                        wps.decorr_passes[dpp_idx].samples_A[0] = right;
                        wps.decorr_passes[dpp_idx].samples_B[0] = left;
                        wps.decorr_passes[dpp_idx].weight_A = PackUtils.update_weight_clip(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].delta, sam_A, left -= PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_A, sam_A));
                        wps.decorr_passes[dpp_idx].weight_B = PackUtils.update_weight_clip(wps.decorr_passes[dpp_idx].weight_B, wps.decorr_passes[dpp_idx].delta, sam_B, right -= PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_B, sam_B));
                    }
                    ++dpp_idx;
                    --tcount;
                }
                m = m + 1 & Defines.MAX_TERM - 1;
                WordsUtils.send_word_lossless(wps, left, 0);
                WordsUtils.send_word_lossless(wps, right, 1);
                ++i;
                byte_idx += 2;
            }
            wpc.byte_idx = byte_idx;
        } else if ((flags & (long)Defines.HYBRID_FLAG) != 0L && (flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) != 0L) {
            long[] bptr = buffer;
            i = 0L;
            while (i < sample_count) {
                if (BitsUtils.bs_remain_write(wps.wvbits) < 64L || wpc.wvc_flag != 0 && BitsUtils.bs_remain_write(wps.wvcbits) < 64L) break;
                int code = (int)bptr[byte_idx];
                crc2 = crc2 * 3L + (long)code;
                ++byte_idx;
                if ((flags & (long)Defines.HYBRID_SHAPE) != 0L) {
                    wps.dc.shaping_acc[0] = wps.dc.shaping_acc[0] + wps.dc.shaping_delta[0];
                    int shaping_weight = wps.dc.shaping_acc[0] >> 16;
                    int temp = -PackUtils.apply_weight(shaping_weight, wps.dc.error[0]);
                    if ((flags & (long)Defines.NEW_SHAPING) != 0L && shaping_weight < 0 && temp != 0) {
                        if (temp == wps.dc.error[0]) {
                            temp = temp < 0 ? temp + 1 : temp - 1;
                        }
                        wps.dc.error[0] = -code;
                        code += temp;
                    } else {
                        wps.dc.error[0] = -(code += temp);
                    }
                }
                dpp_idx = 0;
                int tcount = wps.num_terms;
                while (tcount > 0) {
                    if (wps.decorr_passes[dpp_idx].term > Defines.MAX_TERM) {
                        wps.decorr_passes[dpp_idx].samples_A[2] = (wps.decorr_passes[dpp_idx].term & 1) != 0 ? 2 * wps.decorr_passes[dpp_idx].samples_A[0] - wps.decorr_passes[dpp_idx].samples_A[1] : 3 * wps.decorr_passes[dpp_idx].samples_A[0] - wps.decorr_passes[dpp_idx].samples_A[1] >> 1;
                        wps.decorr_passes[dpp_idx].aweight_A = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].samples_A[2]);
                        code -= wps.decorr_passes[dpp_idx].aweight_A;
                    } else {
                        wps.decorr_passes[dpp_idx].aweight_A = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].samples_A[m]);
                        code -= wps.decorr_passes[dpp_idx].aweight_A;
                    }
                    ++dpp_idx;
                    --tcount;
                }
                code = WordsUtils.send_word(wps, code, 0);
                --dpp_idx;
                while (dpp_idx >= 0) {
                    if (wps.decorr_passes[dpp_idx].term > Defines.MAX_TERM) {
                        wps.decorr_passes[dpp_idx].weight_A = PackUtils.update_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].delta, wps.decorr_passes[dpp_idx].samples_A[2], code);
                        wps.decorr_passes[dpp_idx].samples_A[1] = wps.decorr_passes[dpp_idx].samples_A[0];
                        wps.decorr_passes[dpp_idx].samples_A[0] = code += wps.decorr_passes[dpp_idx].aweight_A;
                    } else {
                        int sam = wps.decorr_passes[dpp_idx].samples_A[m];
                        wps.decorr_passes[dpp_idx].weight_A = PackUtils.update_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].delta, sam, code);
                        wps.decorr_passes[dpp_idx].samples_A[m + wps.decorr_passes[dpp_idx].term & Defines.MAX_TERM - 1] = code += wps.decorr_passes[dpp_idx].aweight_A;
                    }
                    --dpp_idx;
                }
                wps.dc.error[0] = wps.dc.error[0] + code;
                m = m + 1 & Defines.MAX_TERM - 1;
                if ((crc = crc * 3L + (long)code) != crc2) {
                    lossy = Defines.TRUE;
                }
                ++i;
            }
            wpc.byte_idx = byte_idx;
        } else if ((flags & (long)Defines.HYBRID_FLAG) != 0L && (flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
            long[] bptr = buffer;
            i = 0L;
            while (i < sample_count) {
                if (BitsUtils.bs_remain_write(wps.wvbits) < 128L || wpc.wvc_flag != 0 && BitsUtils.bs_remain_write(wps.wvcbits) < 128L) break;
                int left = (int)bptr[byte_idx];
                int right = (int)bptr[++byte_idx];
                crc2 = (crc2 * 3L + (long)left) * 3L + (long)right;
                ++byte_idx;
                if ((flags & (long)Defines.HYBRID_SHAPE) != 0L) {
                    wps.dc.shaping_acc[0] = wps.dc.shaping_acc[0] + wps.dc.shaping_delta[0];
                    int shaping_weight = wps.dc.shaping_acc[0] >> 16;
                    int temp = -PackUtils.apply_weight(shaping_weight, wps.dc.error[0]);
                    if ((flags & (long)Defines.NEW_SHAPING) != 0L && shaping_weight < 0 && temp != 0) {
                        if (temp == wps.dc.error[0]) {
                            temp = temp < 0 ? temp + 1 : temp - 1;
                        }
                        wps.dc.error[0] = -left;
                        left += temp;
                    } else {
                        wps.dc.error[0] = -(left += temp);
                    }
                    wps.dc.shaping_acc[1] = wps.dc.shaping_acc[1] + wps.dc.shaping_delta[1];
                    shaping_weight = wps.dc.shaping_acc[1] >> 16;
                    temp = -PackUtils.apply_weight(shaping_weight, wps.dc.error[1]);
                    if ((flags & (long)Defines.NEW_SHAPING) != 0L && shaping_weight < 0 && temp != 0) {
                        if (temp == wps.dc.error[1]) {
                            temp = temp < 0 ? temp + 1 : temp - 1;
                        }
                        wps.dc.error[1] = -right;
                        right += temp;
                    } else {
                        wps.dc.error[1] = -(right += temp);
                    }
                }
                if ((flags & (long)Defines.JOINT_STEREO) != 0L) {
                    left -= right;
                    right += left >> 1;
                }
                dpp_idx = 0;
                int tcount = wps.num_terms;
                while (tcount > 0) {
                    if (wps.decorr_passes[dpp_idx].term > Defines.MAX_TERM) {
                        if ((wps.decorr_passes[dpp_idx].term & 1) != 0) {
                            wps.decorr_passes[dpp_idx].samples_A[2] = 2 * wps.decorr_passes[dpp_idx].samples_A[0] - wps.decorr_passes[dpp_idx].samples_A[1];
                            wps.decorr_passes[dpp_idx].samples_B[2] = 2 * wps.decorr_passes[dpp_idx].samples_B[0] - wps.decorr_passes[dpp_idx].samples_B[1];
                        } else {
                            wps.decorr_passes[dpp_idx].samples_A[2] = 3 * wps.decorr_passes[dpp_idx].samples_A[0] - wps.decorr_passes[dpp_idx].samples_A[1] >> 1;
                            wps.decorr_passes[dpp_idx].samples_B[2] = 3 * wps.decorr_passes[dpp_idx].samples_B[0] - wps.decorr_passes[dpp_idx].samples_B[1] >> 1;
                        }
                        wps.decorr_passes[dpp_idx].aweight_A = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].samples_A[2]);
                        left -= wps.decorr_passes[dpp_idx].aweight_A;
                        wps.decorr_passes[dpp_idx].aweight_B = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_B, wps.decorr_passes[dpp_idx].samples_B[2]);
                        right -= wps.decorr_passes[dpp_idx].aweight_B;
                    } else if (wps.decorr_passes[dpp_idx].term > 0) {
                        wps.decorr_passes[dpp_idx].aweight_A = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].samples_A[m]);
                        left -= wps.decorr_passes[dpp_idx].aweight_A;
                        wps.decorr_passes[dpp_idx].aweight_B = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_B, wps.decorr_passes[dpp_idx].samples_B[m]);
                        right -= wps.decorr_passes[dpp_idx].aweight_B;
                    } else {
                        if (wps.decorr_passes[dpp_idx].term == -1) {
                            wps.decorr_passes[dpp_idx].samples_B[0] = left;
                        } else if (wps.decorr_passes[dpp_idx].term == -2) {
                            wps.decorr_passes[dpp_idx].samples_A[0] = right;
                        }
                        wps.decorr_passes[dpp_idx].aweight_A = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].samples_A[0]);
                        left -= wps.decorr_passes[dpp_idx].aweight_A;
                        wps.decorr_passes[dpp_idx].aweight_B = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_B, wps.decorr_passes[dpp_idx].samples_B[0]);
                        right -= wps.decorr_passes[dpp_idx].aweight_B;
                    }
                    ++dpp_idx;
                    --tcount;
                }
                left = WordsUtils.send_word(wps, left, 0);
                right = WordsUtils.send_word(wps, right, 1);
                --dpp_idx;
                while (dpp_idx >= 0) {
                    if (wps.decorr_passes[dpp_idx].term > Defines.MAX_TERM) {
                        wps.decorr_passes[dpp_idx].weight_A = PackUtils.update_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].delta, wps.decorr_passes[dpp_idx].samples_A[2], left);
                        wps.decorr_passes[dpp_idx].weight_B = PackUtils.update_weight(wps.decorr_passes[dpp_idx].weight_B, wps.decorr_passes[dpp_idx].delta, wps.decorr_passes[dpp_idx].samples_B[2], right);
                        wps.decorr_passes[dpp_idx].samples_A[1] = wps.decorr_passes[dpp_idx].samples_A[0];
                        wps.decorr_passes[dpp_idx].samples_B[1] = wps.decorr_passes[dpp_idx].samples_B[0];
                        wps.decorr_passes[dpp_idx].samples_A[0] = left += wps.decorr_passes[dpp_idx].aweight_A;
                        wps.decorr_passes[dpp_idx].samples_B[0] = right += wps.decorr_passes[dpp_idx].aweight_B;
                    } else if (wps.decorr_passes[dpp_idx].term > 0) {
                        int k = m + wps.decorr_passes[dpp_idx].term & Defines.MAX_TERM - 1;
                        wps.decorr_passes[dpp_idx].weight_A = PackUtils.update_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].delta, wps.decorr_passes[dpp_idx].samples_A[m], left);
                        wps.decorr_passes[dpp_idx].samples_A[k] = left += wps.decorr_passes[dpp_idx].aweight_A;
                        wps.decorr_passes[dpp_idx].weight_B = PackUtils.update_weight(wps.decorr_passes[dpp_idx].weight_B, wps.decorr_passes[dpp_idx].delta, wps.decorr_passes[dpp_idx].samples_B[m], right);
                        wps.decorr_passes[dpp_idx].samples_B[k] = right += wps.decorr_passes[dpp_idx].aweight_B;
                    } else {
                        if (wps.decorr_passes[dpp_idx].term == -1) {
                            wps.decorr_passes[dpp_idx].samples_B[0] = left + wps.decorr_passes[dpp_idx].aweight_A;
                            wps.decorr_passes[dpp_idx].aweight_B = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_B, wps.decorr_passes[dpp_idx].samples_B[0]);
                        } else if (wps.decorr_passes[dpp_idx].term == -2) {
                            wps.decorr_passes[dpp_idx].samples_A[0] = right + wps.decorr_passes[dpp_idx].aweight_B;
                            wps.decorr_passes[dpp_idx].aweight_A = PackUtils.apply_weight(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].samples_A[0]);
                        }
                        wps.decorr_passes[dpp_idx].weight_A = PackUtils.update_weight_clip(wps.decorr_passes[dpp_idx].weight_A, wps.decorr_passes[dpp_idx].delta, wps.decorr_passes[dpp_idx].samples_A[0], left);
                        wps.decorr_passes[dpp_idx].weight_B = PackUtils.update_weight_clip(wps.decorr_passes[dpp_idx].weight_B, wps.decorr_passes[dpp_idx].delta, wps.decorr_passes[dpp_idx].samples_B[0], right);
                        wps.decorr_passes[dpp_idx].samples_B[0] = left += wps.decorr_passes[dpp_idx].aweight_A;
                        wps.decorr_passes[dpp_idx].samples_A[0] = right += wps.decorr_passes[dpp_idx].aweight_B;
                    }
                    --dpp_idx;
                }
                if ((flags & (long)Defines.JOINT_STEREO) != 0L) {
                    right -= left >> 1;
                    left += right;
                }
                wps.dc.error[0] = wps.dc.error[0] + left;
                wps.dc.error[1] = wps.dc.error[1] + right;
                m = m + 1 & Defines.MAX_TERM - 1;
                if ((crc = (crc * 3L + (long)left) * 3L + (long)right) != crc2) {
                    lossy = Defines.TRUE;
                }
                ++i;
            }
            wpc.byte_idx = byte_idx;
        }
        block_samples = (wps.blockbuff[23] & 0xFF) << 24;
        block_samples += (long)((wps.blockbuff[22] & 0xFF) << 16);
        block_samples += (long)((wps.blockbuff[21] & 0xFF) << 8);
        block_samples += (long)(wps.blockbuff[20] & 0xFF);
        wps.blockbuff[20] = (byte)(block_samples += i);
        wps.blockbuff[21] = (byte)(block_samples >>> 8);
        wps.blockbuff[22] = (byte)(block_samples >>> 16);
        wps.blockbuff[23] = (byte)(block_samples >>> 24);
        wps.blockbuff[28] = (byte)crc;
        wps.blockbuff[29] = (byte)(crc >>> 8);
        wps.blockbuff[30] = (byte)(crc >>> 16);
        wps.blockbuff[31] = (byte)(crc >>> 24);
        if (wpc.wvc_flag != 0) {
            block_samples = (wps.block2buff[23] & 0xFF) << 24;
            block_samples += (long)((wps.block2buff[22] & 0xFF) << 16);
            block_samples += (long)((wps.block2buff[21] & 0xFF) << 8);
            block_samples += (long)(wps.block2buff[20] & 0xFF);
            wps.block2buff[20] = (byte)(block_samples += i);
            wps.block2buff[21] = (byte)(block_samples >>> 8);
            wps.block2buff[22] = (byte)(block_samples >>> 16);
            wps.block2buff[23] = (byte)(block_samples >>> 24);
            wps.block2buff[28] = (byte)crc2;
            wps.block2buff[29] = (byte)(crc2 >>> 8);
            wps.block2buff[30] = (byte)(crc2 >>> 16);
            wps.block2buff[31] = (byte)(crc2 >>> 24);
        }
        if (lossy != 0) {
            wps.lossy_block = Defines.TRUE;
        }
        wps.sample_index += i;
        return i;
    }

    static int apply_weight(int weight, int sample) {
        return (int)((long)weight * (long)sample + 512L >> 10);
    }

    static short update_weight(short weight, short delta, int source, int result) {
        if (source != 0 && result != 0) {
            weight = (short)(weight + ((source ^ result) >> 30 | 1) * delta);
        }
        return weight;
    }

    static short update_weight_clip(short weight, short delta, int source, long result) {
        if (source != 0 && result != 0L && (((long)source ^ result) < 0L ? (weight = (short)(weight - delta)) < -1024 : (weight = (short)(weight + delta)) > 1024)) {
            weight = weight < 0 ? (short)-1024 : (short)1024;
        }
        return weight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int pack_finish_block(WavpackContext wpc) {
        WavpackStream wps = wpc.stream;
        int lossy = wps.lossy_block;
        long chunkSize = 0L;
        int dpp_idx = 0;
        long block_samples = (wps.blockbuff[23] & 0xFF) << 24;
        block_samples += (long)((wps.blockbuff[22] & 0xFF) << 16);
        block_samples += (long)((wps.blockbuff[21] & 0xFF) << 8);
        int m = (int)((block_samples += (long)(wps.blockbuff[20] & 0xFF)) & (long)(Defines.MAX_TERM - 1));
        if (m != 0) {
            int tcount = wps.num_terms;
            while (tcount > 0) {
                if (wps.decorr_passes[dpp_idx].term > 0 && wps.decorr_passes[dpp_idx].term <= Defines.MAX_TERM) {
                    int[] temp_A = new int[Defines.MAX_TERM];
                    int[] temp_B = new int[Defines.MAX_TERM];
                    System.arraycopy(wps.decorr_passes[dpp_idx].samples_A, 0, temp_A, 0, wps.decorr_passes[dpp_idx].samples_A.length);
                    System.arraycopy(wps.decorr_passes[dpp_idx].samples_B, 0, temp_B, 0, wps.decorr_passes[dpp_idx].samples_B.length);
                    int k = 0;
                    while (k < Defines.MAX_TERM) {
                        wps.decorr_passes[dpp_idx].samples_A[k] = temp_A[m];
                        wps.decorr_passes[dpp_idx].samples_B[k] = temp_B[m];
                        m = m + 1 & Defines.MAX_TERM - 1;
                        ++k;
                    }
                }
                --tcount;
                ++dpp_idx;
            }
        }
        WordsUtils.flush_word(wps);
        long data_count = BitsUtils.bs_close_write(wps);
        if (data_count != 0L) {
            if (data_count == -1L) return Defines.FALSE;
            int cptr_idx = 0;
            chunkSize = (wps.blockbuff[4] & 0xFF) + ((wps.blockbuff[5] & 0xFF) << 8) + ((wps.blockbuff[6] & 0xFF) << 16) + ((wps.blockbuff[7] & 0xFF) << 24);
            cptr_idx = (int)chunkSize + 8;
            wps.blockbuff[cptr_idx] = (byte)(0xA | Defines.ID_LARGE);
            wps.blockbuff[++cptr_idx] = (byte)(data_count >> 1);
            wps.blockbuff[++cptr_idx] = (byte)(data_count >> 9);
            wps.blockbuff[++cptr_idx] = (byte)(data_count >> 17);
            chunkSize = chunkSize + data_count + 4L;
            wps.blockbuff[4] = (byte)chunkSize;
            wps.blockbuff[5] = (byte)(chunkSize >> 8);
            wps.blockbuff[6] = (byte)(chunkSize >> 16);
            wps.blockbuff[7] = (byte)(chunkSize >> 24);
        }
        if (wpc.wvc_flag != 0) {
            data_count = BitsUtils.bs_close_correction_write(wps);
            if (data_count == 0L || lossy == 0) return Defines.TRUE;
            if (data_count == -1L) return Defines.FALSE;
            int cptr_idx = 0;
            chunkSize = (wps.block2buff[4] & 0xFF) + ((wps.block2buff[5] & 0xFF) << 8) + ((wps.block2buff[6] & 0xFF) << 16) + ((wps.block2buff[7] & 0xFF) << 24);
            cptr_idx = (int)chunkSize + 8;
            wps.block2buff[cptr_idx] = (byte)(0xB | Defines.ID_LARGE);
            wps.block2buff[++cptr_idx] = (byte)(data_count >> 1);
            wps.block2buff[++cptr_idx] = (byte)(data_count >> 9);
            wps.block2buff[++cptr_idx] = (byte)(data_count >> 17);
            ++cptr_idx;
            chunkSize = chunkSize + data_count + 4L;
            wps.block2buff[4] = (byte)chunkSize;
            wps.block2buff[5] = (byte)(chunkSize >> 8);
            wps.block2buff[6] = (byte)(chunkSize >> 16);
            wps.block2buff[7] = (byte)(chunkSize >> 24);
            return Defines.TRUE;
        } else {
            if (lossy == 0) return Defines.TRUE;
            wpc.lossy_blocks = Defines.TRUE;
        }
        return Defines.TRUE;
    }

    static int copy_metadata(WavpackMetadata wpmd, byte[] buffer_start, int buffer_end) {
        long chunkSize;
        long mdsize = wpmd.byte_length + (wpmd.byte_length & 1);
        int bufIdx = 0;
        if ((wpmd.byte_length & 1) != 0) {
            wpmd.data[wpmd.byte_length] = 0;
        }
        if ((long)(bufIdx = (int)((chunkSize = (long)((buffer_start[4] & 0xFF) + ((buffer_start[5] & 0xFF) << 8) + ((buffer_start[6] & 0xFF) << 16) + ((buffer_start[7] & 0xFF) << 24))) + 8L)) + (mdsize += (long)(wpmd.byte_length > 510 ? 4 : 2)) >= (long)buffer_end) {
            return Defines.FALSE;
        }
        buffer_start[bufIdx] = (byte)(wpmd.id | ((wpmd.byte_length & 1) != 0 ? Defines.ID_ODD_SIZE : 0));
        buffer_start[bufIdx + 1] = (byte)(wpmd.byte_length + 1 >> 1);
        if (wpmd.byte_length > 510) {
            int n = bufIdx;
            buffer_start[n] = (byte)(buffer_start[n] | Defines.ID_LARGE);
            buffer_start[bufIdx + 2] = (byte)(wpmd.byte_length + 1 >> 9);
            buffer_start[bufIdx + 3] = (byte)(wpmd.byte_length + 1 >> 17);
        }
        if (wpmd.data.length != 0 && wpmd.byte_length != 0) {
            if (wpmd.byte_length > 510) {
                int n = bufIdx;
                buffer_start[n] = (byte)(buffer_start[n] | Defines.ID_LARGE);
                buffer_start[bufIdx + 2] = (byte)(wpmd.byte_length + 1 >> 9);
                buffer_start[bufIdx + 3] = (byte)(wpmd.byte_length + 1 >> 17);
                System.arraycopy(wpmd.data, 0, buffer_start, bufIdx + 4, (int)(mdsize - 4L));
            } else {
                System.arraycopy(wpmd.data, 0, buffer_start, bufIdx + 2, (int)(mdsize - 2L));
            }
        }
        buffer_start[4] = (byte)(chunkSize += mdsize);
        buffer_start[5] = (byte)(chunkSize >>> 8);
        buffer_start[6] = (byte)(chunkSize >>> 16);
        buffer_start[7] = (byte)(chunkSize >>> 24);
        return Defines.TRUE;
    }
}

