/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.encode;

import com.wavpack.encode.Defines;
import com.wavpack.encode.PackUtils;
import com.wavpack.encode.WavpackConfig;
import com.wavpack.encode.WavpackContext;
import com.wavpack.encode.WavpackStream;

public class WavPackUtils {
    static long[] sample_rates = new long[]{6000L, 8000L, 9600L, 11025L, 12000L, 16000L, 22050L, 24000L, 32000L, 44100L, 48000L, 64000L, 88200L, 96000L, 192000L};

    public static String WavpackGetErrorMessage(WavpackContext wpc) {
        return wpc.error_message;
    }

    public static int WavpackSetConfiguration(WavpackContext wpc, WavpackConfig config, long total_samples) {
        long flags = config.bytes_per_sample - 1;
        WavpackStream wps = wpc.stream;
        int bps = 0;
        if (config.num_channels > 2) {
            wpc.error_message = "too many channels!";
            return Defines.FALSE;
        }
        wpc.total_samples = total_samples;
        wpc.config.sample_rate = config.sample_rate;
        wpc.config.num_channels = config.num_channels;
        wpc.config.bits_per_sample = config.bits_per_sample;
        wpc.config.bytes_per_sample = config.bytes_per_sample;
        wpc.config.block_samples = config.block_samples;
        wpc.config.flags = config.flags;
        if ((wpc.config.flags & Defines.CONFIG_VERY_HIGH_FLAG) > 0L) {
            wpc.config.flags |= Defines.CONFIG_HIGH_FLAG;
        }
        int shift = config.bytes_per_sample * 8 - config.bits_per_sample;
        int i = 0;
        while (i < 15) {
            if (wpc.config.sample_rate == sample_rates[i]) break;
            ++i;
        }
        flags |= (long)(i << Defines.SRATE_LSB);
        flags |= (long)(shift << Defines.SHIFT_LSB);
        if ((config.flags & Defines.CONFIG_HYBRID_FLAG) != 0L) {
            flags |= (long)(Defines.HYBRID_FLAG | Defines.HYBRID_BITRATE | Defines.HYBRID_BALANCE);
            if ((wpc.config.flags & Defines.CONFIG_SHAPE_OVERRIDE) != 0L && (wpc.config.flags & Defines.CONFIG_HYBRID_SHAPE) != 0L && config.shaping_weight != 0) {
                wpc.config.shaping_weight = config.shaping_weight;
                flags |= (long)(Defines.HYBRID_SHAPE | Defines.NEW_SHAPING);
            }
            if ((wpc.config.flags & Defines.CONFIG_OPTIMIZE_WVC) != 0L) {
                flags |= (long)Defines.CROSS_DECORR;
            }
            bps = config.bitrate;
        } else {
            flags |= (long)Defines.CROSS_DECORR;
        }
        if ((config.flags & Defines.CONFIG_JOINT_OVERRIDE) == 0L || (config.flags & Defines.CONFIG_JOINT_STEREO) != 0L) {
            flags |= (long)Defines.JOINT_STEREO;
        }
        if ((config.flags & Defines.CONFIG_CREATE_WVC) != 0L) {
            wpc.wvc_flag = Defines.TRUE;
        }
        wpc.stream_version = Defines.CUR_STREAM_VERS;
        wps.wphdr.ckID[0] = 119;
        wps.wphdr.ckID[1] = 118;
        wps.wphdr.ckID[2] = 112;
        wps.wphdr.ckID[3] = 107;
        wps.wphdr.ckSize = 24L;
        wps.wphdr.total_samples = wpc.total_samples;
        wps.wphdr.version = wpc.stream_version;
        wps.wphdr.flags = flags | (long)Defines.INITIAL_BLOCK | (long)Defines.FINAL_BLOCK;
        wps.bits = bps;
        if (config.num_channels == 1) {
            wps.wphdr.flags &= (long)(~(Defines.JOINT_STEREO | Defines.CROSS_DECORR | Defines.HYBRID_BALANCE));
            wps.wphdr.flags |= (long)Defines.MONO_FLAG;
        }
        return Defines.TRUE;
    }

    public static int WavpackPackInit(WavpackContext wpc) {
        if (wpc.config.block_samples > 0) {
            wpc.block_samples = wpc.config.block_samples;
        } else {
            wpc.block_samples = (wpc.config.flags & Defines.CONFIG_HIGH_FLAG) > 0L ? wpc.config.sample_rate : (wpc.config.sample_rate % 2L == 0L ? wpc.config.sample_rate / 2L : wpc.config.sample_rate);
            while (wpc.block_samples * (long)wpc.config.num_channels > 150000L) {
                wpc.block_samples /= 2L;
            }
            while (wpc.block_samples * (long)wpc.config.num_channels < 40000L) {
                wpc.block_samples *= 2L;
            }
        }
        PackUtils.pack_init(wpc);
        return Defines.TRUE;
    }

    /*
     * Unable to fully structure code
     */
    public static int WavpackPackSamples(WavpackContext wpc, long[] sample_buffer, long sample_count) {
        block4: {
            wps = wpc.stream;
            flags = wps.wphdr.flags;
            if ((flags & Defines.SHIFT_MASK) == 0L) break block4;
            shift = (int)((flags & Defines.SHIFT_MASK) >> Defines.SHIFT_LSB);
            ptr = sample_buffer;
            cnt = sample_count;
            ptrIndex = 0;
            if ((flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) ** GOTO lbl19
            while (cnt > 0L) {
                ptr[ptrIndex] = ptr[ptrIndex] >>> shift;
                ++ptrIndex;
                --cnt;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                ptr[ptrIndex] = ptr[ptrIndex] >>> shift;
                ptr[++ptrIndex] = ptr[ptrIndex] >>> shift;
                ++ptrIndex;
                --cnt;
lbl19:
                // 2 sources

                ** while (cnt > 0L)
            }
        }
        while (sample_count > 0L) {
            if (wpc.acc_samples == 0L) {
                flags &= Defines.MAG_MASK ^ -1L;
                flags += (1L << Defines.MAG_LSB) * ((flags & (long)Defines.BYTES_STORED) * 8L + 7L);
                wps.wphdr.block_index = wps.sample_index;
                wps.wphdr.flags = flags;
                PackUtils.pack_start_block(wpc);
            }
            samples_to_pack = wpc.acc_samples + sample_count > wpc.block_samples ? wpc.block_samples - wpc.acc_samples : sample_count;
            samples_packed = PackUtils.pack_samples(wpc, sample_buffer, samples_to_pack);
            sample_count -= samples_packed;
            if ((wpc.acc_samples += samples_packed) != wpc.block_samples && samples_packed == samples_to_pack || WavPackUtils.finish_block(wpc) != 0) continue;
            return Defines.FALSE;
        }
        return Defines.TRUE;
    }

    public static int WavpackFlushSamples(WavpackContext wpc) {
        if (wpc.acc_samples != 0L && WavPackUtils.finish_block(wpc) == 0) {
            return Defines.FALSE;
        }
        return Defines.TRUE;
    }

    static int finish_block(WavpackContext wpc) {
        WavpackStream wps = wpc.stream;
        int result = 0;
        result = PackUtils.pack_finish_block(wpc);
        wpc.acc_samples = 0L;
        if (result == 0) {
            wpc.error_message = "output buffer overflowed!";
            return result;
        }
        long bcount = (wps.blockbuff[4] & 0xFF) + ((wps.blockbuff[5] & 0xFF) << 8) + ((wps.blockbuff[6] & 0xFF) << 16) + ((wps.blockbuff[7] & 0xFF) << 24) + 8;
        try {
            wpc.outfile.write(wps.blockbuff, 0, (int)bcount);
        }
        catch (Exception e) {
            result = Defines.FALSE;
        }
        if (result == 0) {
            wpc.error_message = "can't write WavPack data, disk probably full!";
            return result;
        }
        wpc.filelen += bcount;
        if (wps.block2buff[0] == 119) {
            bcount = (wps.block2buff[4] & 0xFF) + ((wps.block2buff[5] & 0xFF) << 8) + ((wps.block2buff[6] & 0xFF) << 16) + ((wps.block2buff[7] & 0xFF) << 24) + 8;
            try {
                wpc.correction_outfile.write(wps.block2buff, 0, (int)bcount);
            }
            catch (Exception e) {
                result = Defines.FALSE;
            }
            if (result == 0) {
                wpc.error_message = "can't write WavPack data, disk probably full!";
                return result;
            }
            wpc.file2len += bcount;
        }
        return result;
    }

    public static long WavpackGetNumSamples(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.total_samples;
        }
        return -1L;
    }

    public static long WavpackGetSampleIndex(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.stream.sample_index;
        }
        return -1L;
    }

    static long WavpackGetSampleRate(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.config.sample_rate;
        }
        return 44100L;
    }

    public static int WavpackGetNumChannels(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.config.num_channels;
        }
        return 2;
    }

    static int WavpackGetBitsPerSample(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.config.bits_per_sample;
        }
        return 16;
    }

    public static int WavpackGetBytesPerSample(WavpackContext wpc) {
        if (wpc != null) {
            return wpc.config.bytes_per_sample;
        }
        return 2;
    }
}

