/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.encode;

import com.wavpack.encode.BitsUtils;
import com.wavpack.encode.Bitstream;
import com.wavpack.encode.Defines;
import com.wavpack.encode.WavpackMetadata;
import com.wavpack.encode.WavpackStream;

class WordsUtils {
    static int LIMIT_ONES = 16;
    static int SLS = 8;
    static int SLO = 1 << SLS - 1;
    static int DIV0 = 128;
    static int DIV1 = 64;
    static int DIV2 = 32;
    static long[] bitset = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L};
    static long[] bitmask;
    static char[] nbits_table;
    static int[] log2_table;
    static int[] exp2_table;
    static char[] ones_count_table;

    static {
        long[] lArray = new long[32];
        lArray[1] = 1L;
        lArray[2] = 3L;
        lArray[3] = 7L;
        lArray[4] = 15L;
        lArray[5] = 31L;
        lArray[6] = 63L;
        lArray[7] = 127L;
        lArray[8] = 255L;
        lArray[9] = 511L;
        lArray[10] = 1023L;
        lArray[11] = 2047L;
        lArray[12] = 4095L;
        lArray[13] = 8191L;
        lArray[14] = 16383L;
        lArray[15] = 32767L;
        lArray[16] = 65535L;
        lArray[17] = 131071L;
        lArray[18] = 262143L;
        lArray[19] = 524287L;
        lArray[20] = 1048575L;
        lArray[21] = 0x1FFFFFL;
        lArray[22] = 0x3FFFFFL;
        lArray[23] = 0x7FFFFFL;
        lArray[24] = 0xFFFFFFL;
        lArray[25] = 0x1FFFFFFL;
        lArray[26] = 0x3FFFFFFL;
        lArray[27] = 0x7FFFFFFL;
        lArray[28] = 0xFFFFFFFL;
        lArray[29] = 0x1FFFFFFFL;
        lArray[30] = 0x3FFFFFFFL;
        lArray[31] = Integer.MAX_VALUE;
        bitmask = lArray;
        char[] cArray = new char[256];
        cArray[1] = '\u0001';
        cArray[2] = 2;
        cArray[3] = 2;
        cArray[4] = 3;
        cArray[5] = 3;
        cArray[6] = 3;
        cArray[7] = 3;
        cArray[8] = 4;
        cArray[9] = 4;
        cArray[10] = 4;
        cArray[11] = 4;
        cArray[12] = 4;
        cArray[13] = 4;
        cArray[14] = 4;
        cArray[15] = 4;
        cArray[16] = 5;
        cArray[17] = 5;
        cArray[18] = 5;
        cArray[19] = 5;
        cArray[20] = 5;
        cArray[21] = 5;
        cArray[22] = 5;
        cArray[23] = 5;
        cArray[24] = 5;
        cArray[25] = 5;
        cArray[26] = 5;
        cArray[27] = 5;
        cArray[28] = 5;
        cArray[29] = 5;
        cArray[30] = 5;
        cArray[31] = 5;
        cArray[32] = 6;
        cArray[33] = 6;
        cArray[34] = 6;
        cArray[35] = 6;
        cArray[36] = 6;
        cArray[37] = 6;
        cArray[38] = 6;
        cArray[39] = 6;
        cArray[40] = 6;
        cArray[41] = 6;
        cArray[42] = 6;
        cArray[43] = 6;
        cArray[44] = 6;
        cArray[45] = 6;
        cArray[46] = 6;
        cArray[47] = 6;
        cArray[48] = 6;
        cArray[49] = 6;
        cArray[50] = 6;
        cArray[51] = 6;
        cArray[52] = 6;
        cArray[53] = 6;
        cArray[54] = 6;
        cArray[55] = 6;
        cArray[56] = 6;
        cArray[57] = 6;
        cArray[58] = 6;
        cArray[59] = 6;
        cArray[60] = 6;
        cArray[61] = 6;
        cArray[62] = 6;
        cArray[63] = 6;
        cArray[64] = 7;
        cArray[65] = 7;
        cArray[66] = 7;
        cArray[67] = 7;
        cArray[68] = 7;
        cArray[69] = 7;
        cArray[70] = 7;
        cArray[71] = 7;
        cArray[72] = 7;
        cArray[73] = 7;
        cArray[74] = 7;
        cArray[75] = 7;
        cArray[76] = 7;
        cArray[77] = 7;
        cArray[78] = 7;
        cArray[79] = 7;
        cArray[80] = 7;
        cArray[81] = 7;
        cArray[82] = 7;
        cArray[83] = 7;
        cArray[84] = 7;
        cArray[85] = 7;
        cArray[86] = 7;
        cArray[87] = 7;
        cArray[88] = 7;
        cArray[89] = 7;
        cArray[90] = 7;
        cArray[91] = 7;
        cArray[92] = 7;
        cArray[93] = 7;
        cArray[94] = 7;
        cArray[95] = 7;
        cArray[96] = 7;
        cArray[97] = 7;
        cArray[98] = 7;
        cArray[99] = 7;
        cArray[100] = 7;
        cArray[101] = 7;
        cArray[102] = 7;
        cArray[103] = 7;
        cArray[104] = 7;
        cArray[105] = 7;
        cArray[106] = 7;
        cArray[107] = 7;
        cArray[108] = 7;
        cArray[109] = 7;
        cArray[110] = 7;
        cArray[111] = 7;
        cArray[112] = 7;
        cArray[113] = 7;
        cArray[114] = 7;
        cArray[115] = 7;
        cArray[116] = 7;
        cArray[117] = 7;
        cArray[118] = 7;
        cArray[119] = 7;
        cArray[120] = 7;
        cArray[121] = 7;
        cArray[122] = 7;
        cArray[123] = 7;
        cArray[124] = 7;
        cArray[125] = 7;
        cArray[126] = 7;
        cArray[127] = 7;
        cArray[128] = 8;
        cArray[129] = 8;
        cArray[130] = 8;
        cArray[131] = 8;
        cArray[132] = 8;
        cArray[133] = 8;
        cArray[134] = 8;
        cArray[135] = 8;
        cArray[136] = 8;
        cArray[137] = 8;
        cArray[138] = 8;
        cArray[139] = 8;
        cArray[140] = 8;
        cArray[141] = 8;
        cArray[142] = 8;
        cArray[143] = 8;
        cArray[144] = 8;
        cArray[145] = 8;
        cArray[146] = 8;
        cArray[147] = 8;
        cArray[148] = 8;
        cArray[149] = 8;
        cArray[150] = 8;
        cArray[151] = 8;
        cArray[152] = 8;
        cArray[153] = 8;
        cArray[154] = 8;
        cArray[155] = 8;
        cArray[156] = 8;
        cArray[157] = 8;
        cArray[158] = 8;
        cArray[159] = 8;
        cArray[160] = 8;
        cArray[161] = 8;
        cArray[162] = 8;
        cArray[163] = 8;
        cArray[164] = 8;
        cArray[165] = 8;
        cArray[166] = 8;
        cArray[167] = 8;
        cArray[168] = 8;
        cArray[169] = 8;
        cArray[170] = 8;
        cArray[171] = 8;
        cArray[172] = 8;
        cArray[173] = 8;
        cArray[174] = 8;
        cArray[175] = 8;
        cArray[176] = 8;
        cArray[177] = 8;
        cArray[178] = 8;
        cArray[179] = 8;
        cArray[180] = 8;
        cArray[181] = 8;
        cArray[182] = 8;
        cArray[183] = 8;
        cArray[184] = 8;
        cArray[185] = 8;
        cArray[186] = 8;
        cArray[187] = 8;
        cArray[188] = 8;
        cArray[189] = 8;
        cArray[190] = 8;
        cArray[191] = 8;
        cArray[192] = 8;
        cArray[193] = 8;
        cArray[194] = 8;
        cArray[195] = 8;
        cArray[196] = 8;
        cArray[197] = 8;
        cArray[198] = 8;
        cArray[199] = 8;
        cArray[200] = 8;
        cArray[201] = 8;
        cArray[202] = 8;
        cArray[203] = 8;
        cArray[204] = 8;
        cArray[205] = 8;
        cArray[206] = 8;
        cArray[207] = 8;
        cArray[208] = 8;
        cArray[209] = 8;
        cArray[210] = 8;
        cArray[211] = 8;
        cArray[212] = 8;
        cArray[213] = 8;
        cArray[214] = 8;
        cArray[215] = 8;
        cArray[216] = 8;
        cArray[217] = 8;
        cArray[218] = 8;
        cArray[219] = 8;
        cArray[220] = 8;
        cArray[221] = 8;
        cArray[222] = 8;
        cArray[223] = 8;
        cArray[224] = 8;
        cArray[225] = 8;
        cArray[226] = 8;
        cArray[227] = 8;
        cArray[228] = 8;
        cArray[229] = 8;
        cArray[230] = 8;
        cArray[231] = 8;
        cArray[232] = 8;
        cArray[233] = 8;
        cArray[234] = 8;
        cArray[235] = 8;
        cArray[236] = 8;
        cArray[237] = 8;
        cArray[238] = 8;
        cArray[239] = 8;
        cArray[240] = 8;
        cArray[241] = 8;
        cArray[242] = 8;
        cArray[243] = 8;
        cArray[244] = 8;
        cArray[245] = 8;
        cArray[246] = 8;
        cArray[247] = 8;
        cArray[248] = 8;
        cArray[249] = 8;
        cArray[250] = 8;
        cArray[251] = 8;
        cArray[252] = 8;
        cArray[253] = 8;
        cArray[254] = 8;
        cArray[255] = 8;
        nbits_table = cArray;
        int[] nArray = new int[256];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 6;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 10;
        nArray[8] = 11;
        nArray[9] = 13;
        nArray[10] = 14;
        nArray[11] = 16;
        nArray[12] = 17;
        nArray[13] = 18;
        nArray[14] = 20;
        nArray[15] = 21;
        nArray[16] = 22;
        nArray[17] = 24;
        nArray[18] = 25;
        nArray[19] = 26;
        nArray[20] = 28;
        nArray[21] = 29;
        nArray[22] = 30;
        nArray[23] = 32;
        nArray[24] = 33;
        nArray[25] = 34;
        nArray[26] = 36;
        nArray[27] = 37;
        nArray[28] = 38;
        nArray[29] = 40;
        nArray[30] = 41;
        nArray[31] = 42;
        nArray[32] = 44;
        nArray[33] = 45;
        nArray[34] = 46;
        nArray[35] = 47;
        nArray[36] = 49;
        nArray[37] = 50;
        nArray[38] = 51;
        nArray[39] = 52;
        nArray[40] = 54;
        nArray[41] = 55;
        nArray[42] = 56;
        nArray[43] = 57;
        nArray[44] = 59;
        nArray[45] = 60;
        nArray[46] = 61;
        nArray[47] = 62;
        nArray[48] = 63;
        nArray[49] = 65;
        nArray[50] = 66;
        nArray[51] = 67;
        nArray[52] = 68;
        nArray[53] = 69;
        nArray[54] = 71;
        nArray[55] = 72;
        nArray[56] = 73;
        nArray[57] = 74;
        nArray[58] = 75;
        nArray[59] = 77;
        nArray[60] = 78;
        nArray[61] = 79;
        nArray[62] = 80;
        nArray[63] = 81;
        nArray[64] = 82;
        nArray[65] = 84;
        nArray[66] = 85;
        nArray[67] = 86;
        nArray[68] = 87;
        nArray[69] = 88;
        nArray[70] = 89;
        nArray[71] = 90;
        nArray[72] = 92;
        nArray[73] = 93;
        nArray[74] = 94;
        nArray[75] = 95;
        nArray[76] = 96;
        nArray[77] = 97;
        nArray[78] = 98;
        nArray[79] = 99;
        nArray[80] = 100;
        nArray[81] = 102;
        nArray[82] = 103;
        nArray[83] = 104;
        nArray[84] = 105;
        nArray[85] = 106;
        nArray[86] = 107;
        nArray[87] = 108;
        nArray[88] = 109;
        nArray[89] = 110;
        nArray[90] = 111;
        nArray[91] = 112;
        nArray[92] = 113;
        nArray[93] = 114;
        nArray[94] = 116;
        nArray[95] = 117;
        nArray[96] = 118;
        nArray[97] = 119;
        nArray[98] = 120;
        nArray[99] = 121;
        nArray[100] = 122;
        nArray[101] = 123;
        nArray[102] = 124;
        nArray[103] = 125;
        nArray[104] = 126;
        nArray[105] = 127;
        nArray[106] = 128;
        nArray[107] = 129;
        nArray[108] = 130;
        nArray[109] = 131;
        nArray[110] = 132;
        nArray[111] = 133;
        nArray[112] = 134;
        nArray[113] = 135;
        nArray[114] = 136;
        nArray[115] = 137;
        nArray[116] = 138;
        nArray[117] = 139;
        nArray[118] = 140;
        nArray[119] = 141;
        nArray[120] = 142;
        nArray[121] = 143;
        nArray[122] = 144;
        nArray[123] = 145;
        nArray[124] = 146;
        nArray[125] = 147;
        nArray[126] = 148;
        nArray[127] = 149;
        nArray[128] = 150;
        nArray[129] = 151;
        nArray[130] = 152;
        nArray[131] = 153;
        nArray[132] = 154;
        nArray[133] = 155;
        nArray[134] = 155;
        nArray[135] = 156;
        nArray[136] = 157;
        nArray[137] = 158;
        nArray[138] = 159;
        nArray[139] = 160;
        nArray[140] = 161;
        nArray[141] = 162;
        nArray[142] = 163;
        nArray[143] = 164;
        nArray[144] = 165;
        nArray[145] = 166;
        nArray[146] = 167;
        nArray[147] = 168;
        nArray[148] = 169;
        nArray[149] = 169;
        nArray[150] = 170;
        nArray[151] = 171;
        nArray[152] = 172;
        nArray[153] = 173;
        nArray[154] = 174;
        nArray[155] = 175;
        nArray[156] = 176;
        nArray[157] = 177;
        nArray[158] = 178;
        nArray[159] = 178;
        nArray[160] = 179;
        nArray[161] = 180;
        nArray[162] = 181;
        nArray[163] = 182;
        nArray[164] = 183;
        nArray[165] = 184;
        nArray[166] = 185;
        nArray[167] = 185;
        nArray[168] = 186;
        nArray[169] = 187;
        nArray[170] = 188;
        nArray[171] = 189;
        nArray[172] = 190;
        nArray[173] = 191;
        nArray[174] = 192;
        nArray[175] = 192;
        nArray[176] = 193;
        nArray[177] = 194;
        nArray[178] = 195;
        nArray[179] = 196;
        nArray[180] = 197;
        nArray[181] = 198;
        nArray[182] = 198;
        nArray[183] = 199;
        nArray[184] = 200;
        nArray[185] = 201;
        nArray[186] = 202;
        nArray[187] = 203;
        nArray[188] = 203;
        nArray[189] = 204;
        nArray[190] = 205;
        nArray[191] = 206;
        nArray[192] = 207;
        nArray[193] = 208;
        nArray[194] = 208;
        nArray[195] = 209;
        nArray[196] = 210;
        nArray[197] = 211;
        nArray[198] = 212;
        nArray[199] = 212;
        nArray[200] = 213;
        nArray[201] = 214;
        nArray[202] = 215;
        nArray[203] = 216;
        nArray[204] = 216;
        nArray[205] = 217;
        nArray[206] = 218;
        nArray[207] = 219;
        nArray[208] = 220;
        nArray[209] = 220;
        nArray[210] = 221;
        nArray[211] = 222;
        nArray[212] = 223;
        nArray[213] = 224;
        nArray[214] = 224;
        nArray[215] = 225;
        nArray[216] = 226;
        nArray[217] = 227;
        nArray[218] = 228;
        nArray[219] = 228;
        nArray[220] = 229;
        nArray[221] = 230;
        nArray[222] = 231;
        nArray[223] = 231;
        nArray[224] = 232;
        nArray[225] = 233;
        nArray[226] = 234;
        nArray[227] = 234;
        nArray[228] = 235;
        nArray[229] = 236;
        nArray[230] = 237;
        nArray[231] = 238;
        nArray[232] = 238;
        nArray[233] = 239;
        nArray[234] = 240;
        nArray[235] = 241;
        nArray[236] = 241;
        nArray[237] = 242;
        nArray[238] = 243;
        nArray[239] = 244;
        nArray[240] = 244;
        nArray[241] = 245;
        nArray[242] = 246;
        nArray[243] = 247;
        nArray[244] = 247;
        nArray[245] = 248;
        nArray[246] = 249;
        nArray[247] = 249;
        nArray[248] = 250;
        nArray[249] = 251;
        nArray[250] = 252;
        nArray[251] = 252;
        nArray[252] = 253;
        nArray[253] = 254;
        nArray[254] = 255;
        nArray[255] = 255;
        log2_table = nArray;
        int[] nArray2 = new int[256];
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArray2[3] = 2;
        nArray2[4] = 3;
        nArray2[5] = 3;
        nArray2[6] = 4;
        nArray2[7] = 5;
        nArray2[8] = 6;
        nArray2[9] = 6;
        nArray2[10] = 7;
        nArray2[11] = 8;
        nArray2[12] = 8;
        nArray2[13] = 9;
        nArray2[14] = 10;
        nArray2[15] = 11;
        nArray2[16] = 11;
        nArray2[17] = 12;
        nArray2[18] = 13;
        nArray2[19] = 14;
        nArray2[20] = 14;
        nArray2[21] = 15;
        nArray2[22] = 16;
        nArray2[23] = 16;
        nArray2[24] = 17;
        nArray2[25] = 18;
        nArray2[26] = 19;
        nArray2[27] = 19;
        nArray2[28] = 20;
        nArray2[29] = 21;
        nArray2[30] = 22;
        nArray2[31] = 22;
        nArray2[32] = 23;
        nArray2[33] = 24;
        nArray2[34] = 25;
        nArray2[35] = 25;
        nArray2[36] = 26;
        nArray2[37] = 27;
        nArray2[38] = 28;
        nArray2[39] = 29;
        nArray2[40] = 29;
        nArray2[41] = 30;
        nArray2[42] = 31;
        nArray2[43] = 32;
        nArray2[44] = 32;
        nArray2[45] = 33;
        nArray2[46] = 34;
        nArray2[47] = 35;
        nArray2[48] = 36;
        nArray2[49] = 36;
        nArray2[50] = 37;
        nArray2[51] = 38;
        nArray2[52] = 39;
        nArray2[53] = 40;
        nArray2[54] = 40;
        nArray2[55] = 41;
        nArray2[56] = 42;
        nArray2[57] = 43;
        nArray2[58] = 44;
        nArray2[59] = 44;
        nArray2[60] = 45;
        nArray2[61] = 46;
        nArray2[62] = 47;
        nArray2[63] = 48;
        nArray2[64] = 48;
        nArray2[65] = 49;
        nArray2[66] = 50;
        nArray2[67] = 51;
        nArray2[68] = 52;
        nArray2[69] = 53;
        nArray2[70] = 53;
        nArray2[71] = 54;
        nArray2[72] = 55;
        nArray2[73] = 56;
        nArray2[74] = 57;
        nArray2[75] = 58;
        nArray2[76] = 58;
        nArray2[77] = 59;
        nArray2[78] = 60;
        nArray2[79] = 61;
        nArray2[80] = 62;
        nArray2[81] = 63;
        nArray2[82] = 64;
        nArray2[83] = 65;
        nArray2[84] = 65;
        nArray2[85] = 66;
        nArray2[86] = 67;
        nArray2[87] = 68;
        nArray2[88] = 69;
        nArray2[89] = 70;
        nArray2[90] = 71;
        nArray2[91] = 72;
        nArray2[92] = 72;
        nArray2[93] = 73;
        nArray2[94] = 74;
        nArray2[95] = 75;
        nArray2[96] = 76;
        nArray2[97] = 77;
        nArray2[98] = 78;
        nArray2[99] = 79;
        nArray2[100] = 80;
        nArray2[101] = 81;
        nArray2[102] = 81;
        nArray2[103] = 82;
        nArray2[104] = 83;
        nArray2[105] = 84;
        nArray2[106] = 85;
        nArray2[107] = 86;
        nArray2[108] = 87;
        nArray2[109] = 88;
        nArray2[110] = 89;
        nArray2[111] = 90;
        nArray2[112] = 91;
        nArray2[113] = 92;
        nArray2[114] = 93;
        nArray2[115] = 94;
        nArray2[116] = 94;
        nArray2[117] = 95;
        nArray2[118] = 96;
        nArray2[119] = 97;
        nArray2[120] = 98;
        nArray2[121] = 99;
        nArray2[122] = 100;
        nArray2[123] = 101;
        nArray2[124] = 102;
        nArray2[125] = 103;
        nArray2[126] = 104;
        nArray2[127] = 105;
        nArray2[128] = 106;
        nArray2[129] = 107;
        nArray2[130] = 108;
        nArray2[131] = 109;
        nArray2[132] = 110;
        nArray2[133] = 111;
        nArray2[134] = 112;
        nArray2[135] = 113;
        nArray2[136] = 114;
        nArray2[137] = 115;
        nArray2[138] = 116;
        nArray2[139] = 117;
        nArray2[140] = 118;
        nArray2[141] = 119;
        nArray2[142] = 120;
        nArray2[143] = 121;
        nArray2[144] = 122;
        nArray2[145] = 123;
        nArray2[146] = 124;
        nArray2[147] = 125;
        nArray2[148] = 126;
        nArray2[149] = 127;
        nArray2[150] = 128;
        nArray2[151] = 129;
        nArray2[152] = 130;
        nArray2[153] = 131;
        nArray2[154] = 132;
        nArray2[155] = 133;
        nArray2[156] = 135;
        nArray2[157] = 136;
        nArray2[158] = 137;
        nArray2[159] = 138;
        nArray2[160] = 139;
        nArray2[161] = 140;
        nArray2[162] = 141;
        nArray2[163] = 142;
        nArray2[164] = 143;
        nArray2[165] = 144;
        nArray2[166] = 145;
        nArray2[167] = 146;
        nArray2[168] = 147;
        nArray2[169] = 149;
        nArray2[170] = 150;
        nArray2[171] = 151;
        nArray2[172] = 152;
        nArray2[173] = 153;
        nArray2[174] = 154;
        nArray2[175] = 155;
        nArray2[176] = 156;
        nArray2[177] = 157;
        nArray2[178] = 159;
        nArray2[179] = 160;
        nArray2[180] = 161;
        nArray2[181] = 162;
        nArray2[182] = 163;
        nArray2[183] = 164;
        nArray2[184] = 165;
        nArray2[185] = 166;
        nArray2[186] = 168;
        nArray2[187] = 169;
        nArray2[188] = 170;
        nArray2[189] = 171;
        nArray2[190] = 172;
        nArray2[191] = 173;
        nArray2[192] = 175;
        nArray2[193] = 176;
        nArray2[194] = 177;
        nArray2[195] = 178;
        nArray2[196] = 179;
        nArray2[197] = 180;
        nArray2[198] = 182;
        nArray2[199] = 183;
        nArray2[200] = 184;
        nArray2[201] = 185;
        nArray2[202] = 186;
        nArray2[203] = 188;
        nArray2[204] = 189;
        nArray2[205] = 190;
        nArray2[206] = 191;
        nArray2[207] = 192;
        nArray2[208] = 194;
        nArray2[209] = 195;
        nArray2[210] = 196;
        nArray2[211] = 197;
        nArray2[212] = 198;
        nArray2[213] = 200;
        nArray2[214] = 201;
        nArray2[215] = 202;
        nArray2[216] = 203;
        nArray2[217] = 205;
        nArray2[218] = 206;
        nArray2[219] = 207;
        nArray2[220] = 208;
        nArray2[221] = 210;
        nArray2[222] = 211;
        nArray2[223] = 212;
        nArray2[224] = 214;
        nArray2[225] = 215;
        nArray2[226] = 216;
        nArray2[227] = 217;
        nArray2[228] = 219;
        nArray2[229] = 220;
        nArray2[230] = 221;
        nArray2[231] = 222;
        nArray2[232] = 224;
        nArray2[233] = 225;
        nArray2[234] = 226;
        nArray2[235] = 228;
        nArray2[236] = 229;
        nArray2[237] = 230;
        nArray2[238] = 232;
        nArray2[239] = 233;
        nArray2[240] = 234;
        nArray2[241] = 236;
        nArray2[242] = 237;
        nArray2[243] = 238;
        nArray2[244] = 240;
        nArray2[245] = 241;
        nArray2[246] = 242;
        nArray2[247] = 244;
        nArray2[248] = 245;
        nArray2[249] = 246;
        nArray2[250] = 248;
        nArray2[251] = 249;
        nArray2[252] = 250;
        nArray2[253] = 252;
        nArray2[254] = 253;
        nArray2[255] = 255;
        exp2_table = nArray2;
        char[] cArray2 = new char[256];
        cArray2[1] = '\u0001';
        cArray2[3] = 2;
        cArray2[5] = '\u0001';
        cArray2[7] = 3;
        cArray2[9] = '\u0001';
        cArray2[11] = 2;
        cArray2[13] = '\u0001';
        cArray2[15] = 4;
        cArray2[17] = '\u0001';
        cArray2[19] = 2;
        cArray2[21] = '\u0001';
        cArray2[23] = 3;
        cArray2[25] = '\u0001';
        cArray2[27] = 2;
        cArray2[29] = '\u0001';
        cArray2[31] = 5;
        cArray2[33] = '\u0001';
        cArray2[35] = 2;
        cArray2[37] = '\u0001';
        cArray2[39] = 3;
        cArray2[41] = '\u0001';
        cArray2[43] = 2;
        cArray2[45] = '\u0001';
        cArray2[47] = 4;
        cArray2[49] = '\u0001';
        cArray2[51] = 2;
        cArray2[53] = '\u0001';
        cArray2[55] = 3;
        cArray2[57] = '\u0001';
        cArray2[59] = 2;
        cArray2[61] = '\u0001';
        cArray2[63] = 6;
        cArray2[65] = '\u0001';
        cArray2[67] = 2;
        cArray2[69] = '\u0001';
        cArray2[71] = 3;
        cArray2[73] = '\u0001';
        cArray2[75] = 2;
        cArray2[77] = '\u0001';
        cArray2[79] = 4;
        cArray2[81] = '\u0001';
        cArray2[83] = 2;
        cArray2[85] = '\u0001';
        cArray2[87] = 3;
        cArray2[89] = '\u0001';
        cArray2[91] = 2;
        cArray2[93] = '\u0001';
        cArray2[95] = 5;
        cArray2[97] = '\u0001';
        cArray2[99] = 2;
        cArray2[101] = '\u0001';
        cArray2[103] = 3;
        cArray2[105] = '\u0001';
        cArray2[107] = 2;
        cArray2[109] = '\u0001';
        cArray2[111] = 4;
        cArray2[113] = '\u0001';
        cArray2[115] = 2;
        cArray2[117] = '\u0001';
        cArray2[119] = 3;
        cArray2[121] = '\u0001';
        cArray2[123] = 2;
        cArray2[125] = '\u0001';
        cArray2[127] = 7;
        cArray2[129] = '\u0001';
        cArray2[131] = 2;
        cArray2[133] = '\u0001';
        cArray2[135] = 3;
        cArray2[137] = '\u0001';
        cArray2[139] = 2;
        cArray2[141] = '\u0001';
        cArray2[143] = 4;
        cArray2[145] = '\u0001';
        cArray2[147] = 2;
        cArray2[149] = '\u0001';
        cArray2[151] = 3;
        cArray2[153] = '\u0001';
        cArray2[155] = 2;
        cArray2[157] = '\u0001';
        cArray2[159] = 5;
        cArray2[161] = '\u0001';
        cArray2[163] = 2;
        cArray2[165] = '\u0001';
        cArray2[167] = 3;
        cArray2[169] = '\u0001';
        cArray2[171] = 2;
        cArray2[173] = '\u0001';
        cArray2[175] = 4;
        cArray2[177] = '\u0001';
        cArray2[179] = 2;
        cArray2[181] = '\u0001';
        cArray2[183] = 3;
        cArray2[185] = '\u0001';
        cArray2[187] = 2;
        cArray2[189] = '\u0001';
        cArray2[191] = 6;
        cArray2[193] = '\u0001';
        cArray2[195] = 2;
        cArray2[197] = '\u0001';
        cArray2[199] = 3;
        cArray2[201] = '\u0001';
        cArray2[203] = 2;
        cArray2[205] = '\u0001';
        cArray2[207] = 4;
        cArray2[209] = '\u0001';
        cArray2[211] = 2;
        cArray2[213] = '\u0001';
        cArray2[215] = 3;
        cArray2[217] = '\u0001';
        cArray2[219] = 2;
        cArray2[221] = '\u0001';
        cArray2[223] = 5;
        cArray2[225] = '\u0001';
        cArray2[227] = 2;
        cArray2[229] = '\u0001';
        cArray2[231] = 3;
        cArray2[233] = '\u0001';
        cArray2[235] = 2;
        cArray2[237] = '\u0001';
        cArray2[239] = 4;
        cArray2[241] = '\u0001';
        cArray2[243] = 2;
        cArray2[245] = '\u0001';
        cArray2[247] = 3;
        cArray2[249] = '\u0001';
        cArray2[251] = 2;
        cArray2[253] = '\u0001';
        cArray2[255] = 8;
        ones_count_table = cArray2;
    }

    WordsUtils() {
    }

    static long GET_MED(WavpackStream wps, int med, int chan) {
        return (wps.w.median[med][chan] >> 4) + 1L;
    }

    static WavpackStream INC_MED0(WavpackStream wps, int chan) {
        long[] lArray = wps.w.median[0];
        int n = chan;
        lArray[n] = lArray[n] + (wps.w.median[0][chan] + (long)DIV0) / (long)DIV0 * 5L;
        return wps;
    }

    static WavpackStream DEC_MED0(WavpackStream wps, int chan) {
        long[] lArray = wps.w.median[0];
        int n = chan;
        lArray[n] = lArray[n] - (wps.w.median[0][chan] + (long)(DIV0 - 2)) / (long)DIV0 * 2L;
        return wps;
    }

    static WavpackStream INC_MED1(WavpackStream wps, int chan) {
        long[] lArray = wps.w.median[1];
        int n = chan;
        lArray[n] = lArray[n] + (wps.w.median[1][chan] + (long)DIV1) / (long)DIV1 * 5L;
        return wps;
    }

    static WavpackStream DEC_MED1(WavpackStream wps, int chan) {
        long[] lArray = wps.w.median[1];
        int n = chan;
        lArray[n] = lArray[n] - (wps.w.median[1][chan] + (long)(DIV1 - 2)) / (long)DIV1 * 2L;
        return wps;
    }

    static WavpackStream INC_MED2(WavpackStream wps, int chan) {
        long[] lArray = wps.w.median[2];
        int n = chan;
        lArray[n] = lArray[n] + (wps.w.median[2][chan] + (long)DIV2) / (long)DIV2 * 5L;
        return wps;
    }

    static WavpackStream DEC_MED2(WavpackStream wps, int chan) {
        long[] lArray = wps.w.median[2];
        int n = chan;
        lArray[n] = lArray[n] - (wps.w.median[2][chan] + (long)(DIV2 - 2)) / (long)DIV2 * 2L;
        return wps;
    }

    static int count_bits(long av) {
        if (av < 256L) {
            return nbits_table[(int)av];
        }
        if (av < 65536L) {
            return nbits_table[(int)(av >>> 8)] + 8;
        }
        if (av < 0x1000000L) {
            return nbits_table[(int)(av >>> 16)] + 16;
        }
        return nbits_table[(int)(av >>> 24)] + 24;
    }

    static void init_words(WavpackStream wps) {
        if ((wps.wphdr.flags & (long)Defines.HYBRID_FLAG) > 0L) {
            WordsUtils.word_set_bitrate(wps);
        }
    }

    static void word_set_bitrate(WavpackStream wps) {
        int bitrate_0 = 0;
        int bitrate_1 = 0;
        if ((wps.wphdr.flags & (long)Defines.HYBRID_BITRATE) > 0L) {
            int n = bitrate_0 = wps.bits < 568 ? 0 : wps.bits - 568;
            if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                if ((wps.wphdr.flags & (long)Defines.HYBRID_BALANCE) > 0L) {
                    bitrate_1 = (wps.wphdr.flags & (long)Defines.JOINT_STEREO) > 0L ? 256 : 0;
                } else {
                    bitrate_1 = bitrate_0;
                    if ((wps.wphdr.flags & (long)Defines.JOINT_STEREO) > 0L) {
                        if (bitrate_0 < 128) {
                            bitrate_1 += bitrate_0;
                            bitrate_0 = 0;
                        } else {
                            bitrate_0 -= 128;
                            bitrate_1 += 128;
                        }
                    }
                }
            }
        } else {
            bitrate_1 = 0;
            bitrate_0 = 0;
        }
        wps.w.bitrate_acc[0] = bitrate_0 << 16;
        wps.w.bitrate_acc[1] = bitrate_1 << 16;
    }

    static void write_entropy_vars(WavpackStream wps, WavpackMetadata wpmd) {
        int byte_idx = 0;
        wpmd.data = wpmd.temp_data;
        byte[] byteptr = wpmd.temp_data;
        wpmd.id = (short)5;
        int temp = WordsUtils.mylog2(wps.w.median[0][0]);
        byteptr[byte_idx] = (byte)temp;
        byteptr[++byte_idx] = (byte)(temp >> 8);
        temp = WordsUtils.mylog2(wps.w.median[1][0]);
        byteptr[++byte_idx] = (byte)temp;
        byteptr[++byte_idx] = (byte)(temp >> 8);
        temp = WordsUtils.mylog2(wps.w.median[2][0]);
        byteptr[++byte_idx] = (byte)temp;
        byteptr[++byte_idx] = (byte)(temp >> 8);
        ++byte_idx;
        if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
            temp = WordsUtils.mylog2(wps.w.median[0][1]);
            byteptr[byte_idx] = (byte)temp;
            byteptr[++byte_idx] = (byte)(temp >> 8);
            temp = WordsUtils.mylog2(wps.w.median[1][1]);
            byteptr[++byte_idx] = (byte)temp;
            byteptr[++byte_idx] = (byte)(temp >> 8);
            temp = WordsUtils.mylog2(wps.w.median[2][1]);
            byteptr[++byte_idx] = (byte)temp;
            byteptr[++byte_idx] = (byte)(temp >> 8);
            ++byte_idx;
        }
        wpmd.byte_length = byte_idx;
        WordsUtils.read_entropy_vars(wps, wpmd);
    }

    static void write_hybrid_profile(WavpackStream wps, WavpackMetadata wpmd) {
        int temp;
        int byte_idx = 0;
        WordsUtils.word_set_bitrate(wps);
        wpmd.data = wpmd.temp_data;
        byte[] byteptr = wpmd.temp_data;
        wpmd.id = (short)6;
        if ((wps.wphdr.flags & (long)Defines.HYBRID_BITRATE) != 0L) {
            temp = WordsUtils.log2s((int)wps.w.slow_level[0]);
            byteptr[byte_idx] = (byte)temp;
            byteptr[++byte_idx] = (byte)(temp >> 8);
            ++byte_idx;
            if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                temp = WordsUtils.log2s((int)wps.w.slow_level[1]);
                byteptr[byte_idx] = (byte)temp;
                byteptr[++byte_idx] = (byte)(temp >> 8);
                ++byte_idx;
            }
        }
        temp = (int)(wps.w.bitrate_acc[0] >> 16);
        byteptr[byte_idx] = (byte)temp;
        byteptr[++byte_idx] = (byte)(temp >> 8);
        ++byte_idx;
        if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
            temp = (int)(wps.w.bitrate_acc[1] >> 16);
            byteptr[byte_idx] = (byte)temp;
            byteptr[++byte_idx] = (byte)(temp >> 8);
            ++byte_idx;
        }
        if ((wps.w.bitrate_delta[0] | wps.w.bitrate_delta[1]) != 0L) {
            temp = WordsUtils.log2s((int)wps.w.bitrate_delta[0]);
            byteptr[byte_idx] = (byte)temp;
            byteptr[++byte_idx] = (byte)(temp >> 8);
            ++byte_idx;
            if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                temp = WordsUtils.log2s((int)wps.w.bitrate_delta[1]);
                byteptr[byte_idx] = (byte)temp;
                byteptr[++byte_idx] = (byte)(temp >> 8);
                ++byte_idx;
            }
        }
        wpmd.byte_length = byte_idx;
        WordsUtils.read_hybrid_profile(wps, wpmd);
    }

    static int read_entropy_vars(WavpackStream wps, WavpackMetadata wpmd) {
        byte[] byteptr = wpmd.data;
        if (wpmd.byte_length != ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) != 0L ? 6 : 12)) {
            return Defines.FALSE;
        }
        wps.w.median[0][0] = WordsUtils.exp2s((byteptr[0] & 0xFF) + ((byteptr[1] & 0xFF) << 8));
        wps.w.median[1][0] = WordsUtils.exp2s((byteptr[2] & 0xFF) + ((byteptr[3] & 0xFF) << 8));
        wps.w.median[2][0] = WordsUtils.exp2s((byteptr[4] & 0xFF) + ((byteptr[5] & 0xFF) << 8));
        if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
            wps.w.median[0][1] = WordsUtils.exp2s((byteptr[6] & 0xFF) + ((byteptr[7] & 0xFF) << 8));
            wps.w.median[1][1] = WordsUtils.exp2s((byteptr[8] & 0xFF) + ((byteptr[9] & 0xFF) << 8));
            wps.w.median[2][1] = WordsUtils.exp2s((byteptr[10] & 0xFF) + ((byteptr[11] & 0xFF) << 8));
        }
        return Defines.TRUE;
    }

    static int read_hybrid_profile(WavpackStream wps, WavpackMetadata wpmd) {
        byte[] byteptr = wpmd.data;
        int byte_idx = 0;
        if ((wps.wphdr.flags & (long)Defines.HYBRID_BITRATE) != 0L) {
            wps.w.slow_level[0] = WordsUtils.exp2s((byteptr[byte_idx] & 0xFF) + ((byteptr[byte_idx + 1] & 0xFF) << 8));
            byte_idx += 2;
            if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                wps.w.slow_level[1] = WordsUtils.exp2s((byteptr[byte_idx] & 0xFF) + ((byteptr[byte_idx + 1] & 0xFF) << 8));
                byte_idx += 2;
            }
        }
        wps.w.bitrate_acc[0] = (byteptr[byte_idx] & 0xFF) + ((byteptr[byte_idx + 1] & 0xFF) << 8) << 16;
        byte_idx += 2;
        if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
            wps.w.bitrate_acc[1] = (byteptr[byte_idx] & 0xFF) + ((byteptr[byte_idx + 1] & 0xFF) << 8) << 16;
            byte_idx += 2;
        }
        if (byte_idx < wpmd.byte_length) {
            wps.w.bitrate_delta[0] = WordsUtils.exp2s((short)((byteptr[byte_idx] & 0xFF) + ((byteptr[byte_idx + 1] & 0xFF) << 8)));
            byte_idx += 2;
            if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) == 0L) {
                wps.w.bitrate_delta[1] = WordsUtils.exp2s((short)((byteptr[byte_idx] & 0xFF) + ((byteptr[byte_idx + 1] & 0xFF) << 8)));
                byte_idx += 2;
            }
            if (byte_idx < wpmd.byte_length) {
                return Defines.FALSE;
            }
        } else {
            wps.w.bitrate_delta[1] = 0L;
            wps.w.bitrate_delta[0] = 0L;
        }
        return Defines.TRUE;
    }

    static void update_error_limit(WavpackStream wps) {
        wps.w.bitrate_acc[0] = wps.w.bitrate_acc[0] + wps.w.bitrate_delta[0];
        int bitrate_0 = (int)(wps.w.bitrate_acc[0] >> 16);
        if ((wps.wphdr.flags & (long)(Defines.MONO_FLAG | Defines.FALSE_STEREO)) != 0L) {
            int slow_log_0;
            wps.w.error_limit[0] = (wps.wphdr.flags & (long)Defines.HYBRID_BITRATE) != 0L ? ((slow_log_0 = (int)(wps.w.slow_level[0] + (long)SLO >> SLS)) - bitrate_0 > -256 ? (long)WordsUtils.exp2s(slow_log_0 - bitrate_0 + 256) : 0L) : (long)WordsUtils.exp2s(bitrate_0);
        } else {
            int bitrate_1 = 0;
            wps.w.bitrate_acc[1] = wps.w.bitrate_acc[1] + wps.w.bitrate_delta[1];
            bitrate_1 = (int)(wps.w.bitrate_acc[1] >> 16);
            if ((wps.wphdr.flags & (long)Defines.HYBRID_BITRATE) != 0L) {
                int slow_log_0 = (int)(wps.w.slow_level[0] + (long)SLO >> SLS);
                int slow_log_1 = (int)(wps.w.slow_level[1] + (long)SLO >> SLS);
                if ((wps.wphdr.flags & (long)Defines.HYBRID_BALANCE) != 0L) {
                    int balance = slow_log_1 - slow_log_0 + bitrate_1 + 1 >> 1;
                    if (balance > bitrate_0) {
                        bitrate_1 = bitrate_0 * 2;
                        bitrate_0 = 0;
                    } else if (-balance > bitrate_0) {
                        bitrate_0 *= 2;
                        bitrate_1 = 0;
                    } else {
                        bitrate_1 = bitrate_0 + balance;
                        bitrate_0 -= balance;
                    }
                }
                wps.w.error_limit[0] = slow_log_0 - bitrate_0 > -256 ? (long)WordsUtils.exp2s(slow_log_0 - bitrate_0 + 256) : 0L;
                wps.w.error_limit[1] = slow_log_1 - bitrate_1 > -256 ? (long)WordsUtils.exp2s(slow_log_1 - bitrate_1 + 256) : 0L;
            } else {
                wps.w.error_limit[0] = WordsUtils.exp2s(bitrate_0);
                wps.w.error_limit[1] = WordsUtils.exp2s(bitrate_1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    static int send_word(WavpackStream wps, int value, int chan) {
        block30: {
            block29: {
                v0 = sign = value < 0 ? 1 : 0;
                if ((wps.w.median[0][0] & -2L) != 0L || wps.w.holding_zero != 0 || (wps.w.median[0][1] & -2L) != 0L) break block29;
                if (wps.w.zeros_acc == 0L) ** GOTO lbl11
                if (value != 0) {
                    WordsUtils.flush_word(wps);
                } else {
                    v1 = chan;
                    wps.w.slow_level[v1] = wps.w.slow_level[v1] - (wps.w.slow_level[chan] + (long)WordsUtils.SLO >> WordsUtils.SLS);
                    ++wps.w.zeros_acc;
                    return 0;
lbl11:
                    // 1 sources

                    if (value != 0) {
                        WordsUtils.putbit_0(wps);
                    } else {
                        v2 = chan;
                        wps.w.slow_level[v2] = wps.w.slow_level[v2] - (wps.w.slow_level[chan] + (long)WordsUtils.SLO >> WordsUtils.SLS);
                        wps.w.median[0][0] = 0L;
                        wps.w.median[1][0] = 0L;
                        wps.w.median[2][0] = 0L;
                        wps.w.median[0][1] = 0L;
                        wps.w.median[1][1] = 0L;
                        wps.w.median[2][1] = 0L;
                        wps.w.zeros_acc = 1L;
                        return 0;
                    }
                }
            }
            if (sign != 0) {
                value ^= -1;
            }
            if ((wps.wphdr.flags & (long)Defines.HYBRID_FLAG) != 0L && chan == 0) {
                WordsUtils.update_error_limit(wps);
            }
            if ((long)value < WordsUtils.GET_MED(wps, 0, chan)) {
                low = 0L;
                ones_count = 0L;
                high = WordsUtils.GET_MED(wps, 0, chan) - 1L;
                wps = WordsUtils.DEC_MED0(wps, chan);
            } else {
                low = WordsUtils.GET_MED(wps, 0, chan);
                if ((long)value - low < WordsUtils.GET_MED(wps = WordsUtils.INC_MED0(wps, chan), 1, chan)) {
                    ones_count = 1L;
                    high = low + WordsUtils.GET_MED(wps, 1, chan) - 1L;
                    wps = WordsUtils.DEC_MED1(wps, chan);
                } else if ((long)value - (low += WordsUtils.GET_MED(wps, 1, chan)) < WordsUtils.GET_MED(wps = WordsUtils.INC_MED1(wps, chan), 2, chan)) {
                    ones_count = 2L;
                    high = low + WordsUtils.GET_MED(wps, 2, chan) - 1L;
                    wps = WordsUtils.DEC_MED2(wps, chan);
                } else {
                    ones_count = 2L + ((long)value - low) / WordsUtils.GET_MED(wps, 2, chan);
                    high = (low += (ones_count - 2L) * WordsUtils.GET_MED(wps, 2, chan)) + WordsUtils.GET_MED(wps, 2, chan) - 1L;
                    wps = WordsUtils.INC_MED2(wps, chan);
                }
            }
            mid = high + low + 1L >> 1;
            if (wps.w.holding_zero != 0) {
                if (ones_count != 0L) {
                    ++wps.w.holding_one;
                }
                WordsUtils.flush_word(wps);
                if (ones_count != 0L) {
                    wps.w.holding_zero = 1;
                    --ones_count;
                } else {
                    wps.w.holding_zero = 0;
                }
            } else {
                wps.w.holding_zero = 1;
            }
            wps.w.holding_one = ones_count * 2L;
            if (wps.w.error_limit[chan] != 0L) ** GOTO lbl85
            if (high != low) {
                code = (long)value - low;
                maxcode = high - low;
                bitcount = WordsUtils.count_bits(maxcode);
                extras = WordsUtils.bitset[bitcount] - maxcode - 1L;
                if (code < extras) {
                    wps.w.pend_data |= code << wps.w.pend_count;
                    wps.w.pend_count += bitcount - 1;
                } else {
                    wps.w.pend_data |= code + extras >> 1 << wps.w.pend_count;
                    wps.w.pend_count += bitcount - 1;
                    wps.w.pend_data |= (code + extras & 1L) << wps.w.pend_count++;
                }
            }
            mid = value;
            break block30;
lbl-1000:
            // 1 sources

            {
                if ((long)value < mid) {
                    high = mid - 1L;
                    mid = high + low + 1L >> 1;
                    ++wps.w.pend_count;
                    continue;
                }
                low = mid;
                mid = high + low + 1L >> 1;
                wps.w.pend_data |= WordsUtils.bitset[wps.w.pend_count++];
lbl85:
                // 3 sources

                ** while (high - low > wps.w.error_limit[chan])
            }
        }
        wps.w.pend_data |= (long)(sign << wps.w.pend_count++);
        if (wps.w.holding_zero == 0) {
            WordsUtils.flush_word(wps);
        }
        if (wps.wvcbits.active != 0 && wps.w.error_limit[chan] != 0L) {
            code = (long)value - low;
            maxcode = high - low;
            bitcount = WordsUtils.count_bits(maxcode);
            extras = WordsUtils.bitset[bitcount] - maxcode - 1L;
            if (bitcount != 0) {
                if (code < extras) {
                    WordsUtils.putbits_correction(code, bitcount - 1, wps);
                } else {
                    WordsUtils.putbits_correction(code + extras >> 1, bitcount - 1, wps);
                    WordsUtils.putbit_correction(code + extras & 1L, wps);
                }
            }
        }
        if (wps.wphdr.flags != 0L & Defines.HYBRID_BITRATE != 0) {
            v3 = chan;
            wps.w.slow_level[v3] = wps.w.slow_level[v3] - (wps.w.slow_level[chan] + (long)WordsUtils.SLO >> WordsUtils.SLS);
            v4 = chan;
            wps.w.slow_level[v4] = wps.w.slow_level[v4] + (long)WordsUtils.mylog2(mid);
        }
        if (sign == 1) {
            return (int)(mid ^ -1L);
        }
        return (int)mid;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void send_word_lossless(WavpackStream wps, int value, int chan) {
        long high;
        long ones_count;
        long low;
        int sign;
        int n = sign = value < 0 ? 1 : 0;
        if ((wps.w.median[0][0] & 0xFFFFFFFFFFFFFFFEL) == 0L && wps.w.holding_zero == 0 && (wps.w.median[0][1] & 0xFFFFFFFFFFFFFFFEL) == 0L) {
            if (wps.w.zeros_acc != 0L) {
                if (value == 0) {
                    ++wps.w.zeros_acc;
                    return;
                }
                WordsUtils.flush_word(wps);
            } else {
                if (value == 0) {
                    wps.w.median[0][0] = 0L;
                    wps.w.median[1][0] = 0L;
                    wps.w.median[2][0] = 0L;
                    wps.w.median[0][1] = 0L;
                    wps.w.median[1][1] = 0L;
                    wps.w.median[2][1] = 0L;
                    wps.w.zeros_acc = 1L;
                    return;
                }
                WordsUtils.putbit_0(wps);
            }
        }
        if (sign != 0) {
            value ^= 0xFFFFFFFF;
        }
        if ((long)value < WordsUtils.GET_MED(wps, 0, chan)) {
            low = 0L;
            ones_count = 0L;
            high = WordsUtils.GET_MED(wps, 0, chan) - 1L;
            wps = WordsUtils.DEC_MED0(wps, chan);
        } else {
            low = WordsUtils.GET_MED(wps, 0, chan);
            if ((long)value - low < WordsUtils.GET_MED(wps = WordsUtils.INC_MED0(wps, chan), 1, chan)) {
                ones_count = 1L;
                high = low + WordsUtils.GET_MED(wps, 1, chan) - 1L;
                wps = WordsUtils.DEC_MED1(wps, chan);
            } else if ((long)value - (low += WordsUtils.GET_MED(wps, 1, chan)) < WordsUtils.GET_MED(wps = WordsUtils.INC_MED1(wps, chan), 2, chan)) {
                ones_count = 2L;
                high = low + WordsUtils.GET_MED(wps, 2, chan) - 1L;
                wps = WordsUtils.DEC_MED2(wps, chan);
            } else {
                ones_count = 2L + ((long)value - low) / WordsUtils.GET_MED(wps, 2, chan);
                high = (low += (ones_count - 2L) * WordsUtils.GET_MED(wps, 2, chan)) + WordsUtils.GET_MED(wps, 2, chan) - 1L;
                wps = WordsUtils.INC_MED2(wps, chan);
            }
        }
        if (wps.w.holding_zero != 0) {
            if (ones_count != 0L) {
                ++wps.w.holding_one;
            }
            WordsUtils.flush_word(wps);
            if (ones_count != 0L) {
                wps.w.holding_zero = 1;
                --ones_count;
            } else {
                wps.w.holding_zero = 0;
            }
        } else {
            wps.w.holding_zero = 1;
        }
        wps.w.holding_one = ones_count * 2L;
        if (high != low) {
            long code = (long)value - low;
            long maxcode = high - low;
            int bitcount = WordsUtils.count_bits(maxcode);
            long extras = bitset[bitcount] - maxcode - 1L;
            if (code < extras) {
                wps.w.pend_data |= code << wps.w.pend_count;
                wps.w.pend_count += bitcount - 1;
            } else {
                wps.w.pend_data |= code + extras >> 1 << wps.w.pend_count;
                wps.w.pend_count += bitcount - 1;
                wps.w.pend_data |= (code + extras & 1L) << wps.w.pend_count++;
            }
        }
        wps.w.pend_data |= (long)(sign << wps.w.pend_count++);
        if (wps.w.holding_zero == 0) {
            WordsUtils.flush_word(wps);
        }
    }

    static void putbit_0(WavpackStream wps) {
        Bitstream bs = wps.wvbits;
        if (++bs.bc == 8) {
            wps.blockbuff[bs.buf_index] = (byte)bs.sr;
            ++bs.buf_index;
            bs.bc = 0;
            bs.sr = 0;
            if (bs.buf_index >= bs.end) {
                BitsUtils.bs_wrap(bs);
            }
        }
    }

    static void putbit_1(WavpackStream wps) {
        Bitstream bs = wps.wvbits;
        bs.sr |= 1L << bs.bc;
        if (++bs.bc == 8) {
            wps.blockbuff[bs.buf_index] = (byte)bs.sr;
            ++bs.buf_index;
            bs.bc = 0;
            bs.sr = 0;
            if (bs.buf_index >= bs.end) {
                BitsUtils.bs_wrap(bs);
            }
        }
    }

    static void putbit(long bit, WavpackStream wps) {
        Bitstream bs = wps.wvbits;
        if (bit != 0L) {
            bs.sr |= 1L << bs.bc;
        }
        if (++bs.bc == 8) {
            wps.blockbuff[bs.buf_index] = (byte)bs.sr;
            ++bs.buf_index;
            bs.bc = 0;
            bs.sr = 0;
            if (bs.buf_index >= bs.end) {
                BitsUtils.bs_wrap(bs);
            }
        }
    }

    static void putbits(long value, long nbits, WavpackStream wps) {
        Bitstream bs = wps.wvbits;
        bs.sr |= value << bs.bc;
        bs.bc = (int)((long)bs.bc + nbits);
        if (bs.bc >= 8) {
            do {
                wps.blockbuff[bs.buf_index] = (byte)bs.sr;
                ++bs.buf_index;
                bs.sr >>= 8;
                if ((bs.bc -= 8) > 24) {
                    bs.sr |= value >> (int)(nbits - (long)bs.bc);
                }
                if (bs.buf_index < bs.end) continue;
                BitsUtils.bs_wrap(bs);
            } while (bs.bc >= 8);
        }
    }

    static void putbit_correction_0(WavpackStream wps) {
        Bitstream bs = wps.wvcbits;
        if (++bs.bc == 8) {
            wps.block2buff[bs.buf_index] = (byte)bs.sr;
            ++bs.buf_index;
            bs.bc = 0;
            bs.sr = 0;
            if (bs.buf_index >= bs.end) {
                BitsUtils.bs_wrap(bs);
            }
        }
    }

    static void putbit_correction_1(WavpackStream wps) {
        Bitstream bs = wps.wvcbits;
        bs.sr |= 1L << bs.bc;
        if (++bs.bc == 8) {
            wps.block2buff[bs.buf_index] = (byte)bs.sr;
            ++bs.buf_index;
            bs.bc = 0;
            bs.sr = 0;
            if (bs.buf_index >= bs.end) {
                BitsUtils.bs_wrap(bs);
            }
        }
    }

    static void putbit_correction(long bit, WavpackStream wps) {
        Bitstream bs = wps.wvcbits;
        if (bit != 0L) {
            bs.sr |= 1L << bs.bc;
        }
        if (++bs.bc == 8) {
            wps.block2buff[bs.buf_index] = (byte)bs.sr;
            ++bs.buf_index;
            bs.bc = 0;
            bs.sr = 0;
            if (bs.buf_index >= bs.end) {
                BitsUtils.bs_wrap(bs);
            }
        }
    }

    static void putbits_correction(long value, long nbits, WavpackStream wps) {
        Bitstream bs = wps.wvcbits;
        bs.sr |= value << bs.bc;
        bs.bc = (int)((long)bs.bc + nbits);
        if (bs.bc >= 8) {
            do {
                wps.block2buff[bs.buf_index] = (byte)bs.sr;
                ++bs.buf_index;
                bs.sr >>= 8;
                if ((bs.bc -= 8) > 24) {
                    bs.sr |= value >> (int)(nbits - (long)bs.bc);
                }
                if (bs.buf_index < bs.end) continue;
                BitsUtils.bs_wrap(bs);
            } while (bs.bc >= 8);
        }
    }

    static void flush_word(WavpackStream wps) {
        int cbits;
        if (wps.w.zeros_acc != 0L) {
            cbits = WordsUtils.count_bits(wps.w.zeros_acc);
            while (cbits > 0) {
                WordsUtils.putbit_1(wps);
                --cbits;
            }
            WordsUtils.putbit_0(wps);
            while (wps.w.zeros_acc > 1L) {
                WordsUtils.putbit(wps.w.zeros_acc & 1L, wps);
                wps.w.zeros_acc >>= 1;
            }
            wps.w.zeros_acc = 0L;
        }
        if (wps.w.holding_one != 0L) {
            if (wps.w.holding_one >= (long)LIMIT_ONES) {
                WordsUtils.putbits((1L << LIMIT_ONES) - 1L, LIMIT_ONES + 1, wps);
                wps.w.holding_one -= (long)LIMIT_ONES;
                cbits = WordsUtils.count_bits(wps.w.holding_one);
                while (cbits > 0) {
                    WordsUtils.putbit_1(wps);
                    --cbits;
                }
                WordsUtils.putbit_0(wps);
                while (wps.w.holding_one > 1L) {
                    WordsUtils.putbit(wps.w.holding_one & 1L, wps);
                    wps.w.holding_one >>= 1;
                }
                wps.w.holding_zero = 0;
            } else {
                WordsUtils.putbits(bitmask[(int)wps.w.holding_one], wps.w.holding_one, wps);
            }
            wps.w.holding_one = 0L;
        }
        if (wps.w.holding_zero != 0) {
            WordsUtils.putbit_0(wps);
            wps.w.holding_zero = 0;
        }
        if (wps.w.pend_count != 0) {
            WordsUtils.putbits(wps.w.pend_data, wps.w.pend_count, wps);
            wps.w.pend_count = 0;
            wps.w.pend_data = 0;
        }
    }

    static int mylog2(long avalue) {
        if ((avalue += avalue >> 9) < 256L) {
            char dbits = nbits_table[(int)avalue];
            return (dbits << 8) + log2_table[(int)(avalue << 9 - dbits) & 0xFF];
        }
        int dbits = avalue < 65536L ? nbits_table[(int)(avalue >> 8)] + 8 : (avalue < 0x1000000L ? nbits_table[(int)(avalue >> 16)] + 16 : nbits_table[(int)(avalue >> 24)] + 24);
        return (dbits << 8) + log2_table[(int)(avalue >> dbits - 9) & 0xFF];
    }

    static int log2s(int value) {
        if (value < 0) {
            return -WordsUtils.mylog2(-value);
        }
        return WordsUtils.mylog2(value);
    }

    static int exp2s(int log) {
        if (log < 0) {
            return -WordsUtils.exp2s(-log);
        }
        long value = exp2_table[log & 0xFF] | 0x100;
        if ((log >>= 8) <= 9) {
            return (int)(value >> 9 - log);
        }
        return (int)(value << log - 9);
    }

    static byte store_weight(int weight) {
        if (weight > 1024) {
            weight = 1024;
        } else if (weight < -1024) {
            weight = -1024;
        }
        if (weight > 0) {
            weight -= weight + 64 >> 7;
        }
        return (byte)(weight + 4 >> 3);
    }

    static int restore_weight(byte weight) {
        int result = weight << 3;
        if (result > 0) {
            result += result + 64 >> 7;
        }
        return result;
    }
}

