/*
 * Decompiled with CFR 0.152.
 */
package com.wavpack.encode;

import com.wavpack.encode.Defines;
import com.wavpack.encode.WavPackUtils;
import com.wavpack.encode.WavpackConfig;
import com.wavpack.encode.WavpackContext;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class WvEncode {
    public static void main(String[] args) {
        int result;
        String VERSION_STR = "4.40";
        String DATE_STR = "2007-01-16";
        String sign_on1 = "Java WavPack Encoder (c) 2008 - 2009 Peter McQuillan";
        String sign_on2 = "based on TINYPACK - Tiny Audio Compressor  Version " + VERSION_STR + " " + DATE_STR + " Copyright (c) 1998 - 2009 Conifer Software.  All Rights Reserved.";
        String usage0 = "";
        String usage1 = " Usage:   java WvEncode [-options] infile.wav outfile.wv [outfile.wvc]";
        String usage2 = " (default is lossless)";
        String usage3 = "  Options: -bn = enable hybrid compression, n = 2.0 to 16.0 bits/sample";
        String usage4 = "       -c  = create correction file (.wvc) for hybrid mode (=lossless)";
        String usage5 = "       -cc = maximum hybrid compression (hurts lossy quality & decode speed)";
        String usage6 = "       -f  = fast mode (fast, but some compromise in compression ratio)";
        String usage7 = "       -h  = high quality (better compression in all modes, but slower)";
        String usage8 = "       -hh = very high quality (best compression in all modes, but slowest";
        String usage9 = "                              and NOT recommended for portable hardware use)";
        String usage10 = "       -jn = joint-stereo override (0 = left/right, 1 = mid/side)";
        String usage11 = "       -sn = noise shaping override (hybrid only, n = -1.0 to 1.0, 0 = off)";
        String infilename = "";
        String outfilename = "";
        String out2filename = "";
        WavpackConfig config = new WavpackConfig();
        int error_count = 0;
        int arg_idx = 0;
        while (arg_idx < args.length) {
            if (args[arg_idx].startsWith("-")) {
                String substring;
                String substring22;
                if (args[arg_idx].startsWith("-c") || args[arg_idx].startsWith("-C")) {
                    if (args[arg_idx].startsWith("-cc") || args[arg_idx].startsWith("-CC")) {
                        config.flags |= Defines.CONFIG_CREATE_WVC;
                        config.flags |= Defines.CONFIG_OPTIMIZE_WVC;
                    } else {
                        config.flags |= Defines.CONFIG_CREATE_WVC;
                    }
                } else if (args[arg_idx].startsWith("-f") || args[arg_idx].startsWith("-F")) {
                    config.flags |= Defines.CONFIG_FAST_FLAG;
                } else if (args[arg_idx].startsWith("-h") || args[arg_idx].startsWith("-H")) {
                    config.flags = args[arg_idx].startsWith("-hh") || args[arg_idx].startsWith("-HH") ? (config.flags |= Defines.CONFIG_VERY_HIGH_FLAG) : (config.flags |= Defines.CONFIG_HIGH_FLAG);
                } else if (args[arg_idx].startsWith("-k") || args[arg_idx].startsWith("-K")) {
                    int passedInt = 0;
                    if (args[arg_idx].length() > 2) {
                        try {
                            substring22 = args[arg_idx].substring(2);
                            passedInt = Integer.parseInt(substring22);
                        }
                        catch (NumberFormatException substring22) {}
                    } else {
                        ++arg_idx;
                        try {
                            passedInt = Integer.parseInt(args[arg_idx]);
                        }
                        catch (NumberFormatException substring22) {
                            // empty catch block
                        }
                    }
                    config.block_samples = passedInt;
                } else if (args[arg_idx].startsWith("-b") || args[arg_idx].startsWith("-B")) {
                    double passedDouble = 0.0;
                    config.flags |= Defines.CONFIG_HYBRID_FLAG;
                    if (args[arg_idx].length() > 2) {
                        try {
                            substring = args[arg_idx].substring(2);
                            passedDouble = Double.parseDouble(substring);
                            config.bitrate = (int)(passedDouble * 256.0);
                        }
                        catch (NumberFormatException ne) {
                            config.bitrate = 0;
                        }
                    } else {
                        ++arg_idx;
                        try {
                            passedDouble = Double.parseDouble(args[arg_idx]);
                            config.bitrate = (int)(passedDouble * 256.0);
                        }
                        catch (NumberFormatException ne) {
                            config.bitrate = 0;
                        }
                    }
                    if (config.bitrate < 512 || config.bitrate > 4096) {
                        System.err.println("hybrid spec must be 2.0 to 16.0!");
                        ++error_count;
                    }
                } else if (args[arg_idx].startsWith("-j") || args[arg_idx].startsWith("-J")) {
                    int passedInt = 2;
                    if (args[arg_idx].length() > 2) {
                        try {
                            substring22 = args[arg_idx].substring(2);
                            passedInt = Integer.parseInt(substring22);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        ++arg_idx;
                        try {
                            passedInt = Integer.parseInt(args[arg_idx]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (passedInt == 0) {
                        config.flags |= Defines.CONFIG_JOINT_OVERRIDE;
                        config.flags &= Defines.CONFIG_JOINT_STEREO ^ 0xFFFFFFFFFFFFFFFFL;
                    } else if (passedInt == 1) {
                        config.flags |= Defines.CONFIG_JOINT_OVERRIDE | Defines.CONFIG_JOINT_STEREO;
                    } else {
                        System.err.println("-j0 or -j1 only!");
                        ++error_count;
                    }
                } else if (args[arg_idx].startsWith("-s") || args[arg_idx].startsWith("-S")) {
                    double passedDouble = 0.0;
                    if (args[arg_idx].length() > 2) {
                        try {
                            substring = args[arg_idx].substring(2);
                            passedDouble = Double.parseDouble(substring);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        ++arg_idx;
                        try {
                            passedDouble = Double.parseDouble(args[arg_idx]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    config.shaping_weight = (int)(passedDouble * 1024.0);
                    if (config.shaping_weight == 0) {
                        config.flags |= Defines.CONFIG_SHAPE_OVERRIDE;
                        config.flags &= Defines.CONFIG_HYBRID_SHAPE ^ 0xFFFFFFFFFFFFFFFFL;
                    } else if (config.shaping_weight >= -1024 && config.shaping_weight <= 1024) {
                        config.flags |= Defines.CONFIG_HYBRID_SHAPE | Defines.CONFIG_SHAPE_OVERRIDE;
                    } else {
                        System.err.println("-s-1.00 to -s1.00 only!");
                        ++error_count;
                    }
                } else {
                    System.err.println("illegal option: " + args[arg_idx]);
                    ++error_count;
                }
            } else if (infilename.length() == 0) {
                infilename = args[arg_idx];
            } else if (outfilename.length() == 0) {
                outfilename = args[arg_idx];
            } else if (out2filename.length() == 0) {
                out2filename = args[arg_idx];
            } else {
                System.err.println("extra unknown argument: " + args[arg_idx]);
                ++error_count;
            }
            ++arg_idx;
        }
        if (((config.flags ^ 0xFFFFFFFFFFFFFFFFL) & (Defines.CONFIG_HIGH_FLAG | Defines.CONFIG_FAST_FLAG)) == 0L) {
            System.err.println("high and fast modes are mutually exclusive!");
            ++error_count;
        }
        if ((config.flags & Defines.CONFIG_HYBRID_FLAG) != 0L) {
            if ((config.flags & Defines.CONFIG_CREATE_WVC) != 0L && out2filename.length() == 0) {
                System.err.println("need name for correction file!");
                ++error_count;
            }
        } else if ((config.flags & (Defines.CONFIG_SHAPE_OVERRIDE | Defines.CONFIG_CREATE_WVC)) != 0L) {
            System.err.println("-s and -c options are for hybrid mode (-b) only!");
            ++error_count;
        }
        if (out2filename.length() != 0 && (config.flags & Defines.CONFIG_CREATE_WVC) == 0L) {
            System.err.println("third filename specified without -c option!");
            ++error_count;
        }
        if (error_count == 0) {
            System.err.println(sign_on1);
            System.err.println(sign_on2);
        } else {
            System.exit(1);
        }
        if (infilename.length() == 0 || outfilename.length() == 0 || out2filename.length() == 0 && (config.flags & Defines.CONFIG_CREATE_WVC) != 0L) {
            System.out.println(usage0);
            System.out.println(usage1);
            System.out.println(usage2);
            System.out.println(usage3);
            System.out.println(usage4);
            System.out.println(usage5);
            System.out.println(usage6);
            System.out.println(usage7);
            System.out.println(usage8);
            System.out.println(usage9);
            System.out.println(usage10);
            System.out.println(usage11);
            System.exit(1);
        }
        if ((result = WvEncode.pack_file(infilename, outfilename, out2filename, config)) > 0) {
            System.err.println("error occured!");
            ++error_count;
        }
    }

    public static int pack_file(String infilename, String outfilename, String out2filename, WavpackConfig config) {
        int result;
        block36: {
            long chunkSize;
            FileOutputStream wv_file;
            DataInputStream in;
            FileInputStream infile;
            WavpackContext wpc;
            long whSampleRate;
            int whNumChannels;
            int whBlockAlign;
            WavpackConfig loc_config;
            block35: {
                loc_config = config;
                byte[] riff_chunk_header = new byte[12];
                byte[] chunk_header = new byte[8];
                byte[] WaveHeader2 = new byte[40];
                whBlockAlign = 1;
                int whFormatTag = 0;
                int whSubFormat = 0;
                int whBitsPerSample = 0;
                int whValidBitsPerSample = 0;
                whNumChannels = 0;
                whSampleRate = 0L;
                wpc = new WavpackContext();
                try {
                    infile = new FileInputStream(infilename);
                    in = new DataInputStream(infile);
                }
                catch (FileNotFoundException fe) {
                    System.err.println("Can't open file " + infilename);
                    return Defines.SOFT_ERROR;
                }
                try {
                    wv_file = new FileOutputStream(outfilename);
                }
                catch (FileNotFoundException fe) {
                    System.err.println("can't create file " + outfilename);
                    return Defines.SOFT_ERROR;
                }
                wpc.outfile = wv_file;
                long bcount = 0L;
                bcount = WvEncode.DoReadFile(in, riff_chunk_header, 12);
                if (bcount != 12L || riff_chunk_header[0] != 82 || riff_chunk_header[1] != 73 || riff_chunk_header[2] != 70 || riff_chunk_header[3] != 70 || riff_chunk_header[8] != 87 || riff_chunk_header[9] != 65 || riff_chunk_header[10] != 86 || riff_chunk_header[11] != 69) {
                    System.err.println(String.valueOf(infilename) + " is not a valid .WAV file!");
                    try {
                        infile.close();
                        wv_file.close();
                    }
                    catch (Exception fe) {
                        // empty catch block
                    }
                    return Defines.SOFT_ERROR;
                }
                chunkSize = 0L;
                while (true) {
                    if ((bcount = WvEncode.DoReadFile(in, chunk_header, 8)) != 8L) {
                        System.err.println(String.valueOf(infilename) + " is not a valid .WAV file!");
                        try {
                            infile.close();
                            wv_file.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return Defines.SOFT_ERROR;
                    }
                    chunkSize = (chunk_header[4] & 0xFF) + ((chunk_header[5] & 0xFF) << 8) + ((chunk_header[6] & 0xFF) << 16) + ((chunk_header[7] & 0xFF) << 24);
                    if (chunk_header[0] == 102 && chunk_header[1] == 109 && chunk_header[2] == 116 && chunk_header[3] == 32) {
                        int supported = Defines.TRUE;
                        boolean check = false;
                        if (chunkSize >= 16L && chunkSize <= 40L) {
                            int ckSize = (int)chunkSize;
                            bcount = WvEncode.DoReadFile(in, WaveHeader2, ckSize);
                            if (bcount != (long)ckSize) {
                                check = true;
                            }
                        } else {
                            check = true;
                        }
                        if (check) {
                            System.err.println(String.valueOf(infilename) + " is not a valid .WAV file!");
                            try {
                                infile.close();
                                wv_file.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return Defines.SOFT_ERROR;
                        }
                        whFormatTag = (WaveHeader2[0] & 0xFF) + ((WaveHeader2[1] & 0xFF) << 8);
                        int format = whFormatTag == 65534 && chunkSize == 40L ? (whSubFormat = (WaveHeader2[24] & 0xFF) + ((WaveHeader2[25] & 0xFF) << 8)) : whFormatTag;
                        whBitsPerSample = (WaveHeader2[14] & 0xFF) + ((WaveHeader2[15] & 0xFF) << 8);
                        loc_config.bits_per_sample = chunkSize == 40L ? (whValidBitsPerSample = (WaveHeader2[18] & 0xFF) + ((WaveHeader2[19] & 0xFF) << 8)) : whBitsPerSample;
                        if (format != 1) {
                            supported = Defines.FALSE;
                        }
                        whBlockAlign = (WaveHeader2[12] & 0xFF) + ((WaveHeader2[13] & 0xFF) << 8);
                        whNumChannels = (WaveHeader2[2] & 0xFF) + ((WaveHeader2[3] & 0xFF) << 8);
                        if (whNumChannels == 0 || whNumChannels > 2 || whBlockAlign / whNumChannels < (loc_config.bits_per_sample + 7) / 8 || whBlockAlign / whNumChannels > 3 || whBlockAlign % whNumChannels > 0) {
                            supported = Defines.FALSE;
                        }
                        if (loc_config.bits_per_sample < 1 || loc_config.bits_per_sample > 24) {
                            supported = Defines.FALSE;
                        }
                        whSampleRate = (WaveHeader2[4] & 0xFF) + ((WaveHeader2[5] & 0xFF) << 8) + ((WaveHeader2[6] & 0xFF) << 16) + ((WaveHeader2[7] & 0xFF) << 24);
                        if (supported == Defines.TRUE) continue;
                        System.err.println(String.valueOf(infilename) + " is an unsupported .WAV format!");
                        try {
                            infile.close();
                            wv_file.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return Defines.SOFT_ERROR;
                    }
                    if (chunk_header[0] == 100 && chunk_header[1] == 97 && chunk_header[2] == 116 && chunk_header[3] == 97) break block35;
                    int bytes_to_skip = (int)(chunkSize + 1L & 0xFFFFFFFFFFFFFFFEL);
                    byte[] buff = new byte[bytes_to_skip];
                    bcount = WvEncode.DoReadFile(in, buff, bytes_to_skip);
                    if (bcount != (long)bytes_to_skip) break;
                }
                System.err.println("error occurred in skipping bytes");
                try {
                    infile.close();
                    wv_file.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return Defines.SOFT_ERROR;
            }
            long total_samples = chunkSize / (long)whBlockAlign;
            loc_config.bytes_per_sample = whBlockAlign / whNumChannels;
            loc_config.num_channels = whNumChannels;
            loc_config.sample_rate = whSampleRate;
            WavPackUtils.WavpackSetConfiguration(wpc, loc_config, total_samples);
            if (out2filename.length() > 0) {
                try {
                    FileOutputStream wvc_file;
                    wpc.correction_outfile = wvc_file = new FileOutputStream(out2filename);
                }
                catch (FileNotFoundException fe) {
                    System.err.println("can't create file " + outfilename);
                    return Defines.SOFT_ERROR;
                }
            }
            result = WvEncode.pack_audio(wpc, in);
            try {
                infile.close();
            }
            catch (IOException fe) {
                // empty catch block
            }
            if (result == Defines.NO_ERROR && WavPackUtils.WavpackFlushSamples(wpc) == 0) {
                System.err.println(WavPackUtils.WavpackGetErrorMessage(wpc));
                result = Defines.HARD_ERROR;
            }
            if (result == Defines.NO_ERROR && WavPackUtils.WavpackGetNumSamples(wpc) != WavPackUtils.WavpackGetSampleIndex(wpc)) {
                System.err.println("couldn't read all samples, file may be corrupt!!");
                result = Defines.SOFT_ERROR;
            }
            try {
                wv_file.close();
            }
            catch (IOException e) {
                System.err.println("Can't close WavPack file!");
                if (result != Defines.NO_ERROR) break block36;
                result = Defines.SOFT_ERROR;
            }
        }
        if (result != Defines.NO_ERROR) {
            return result;
        }
        return Defines.NO_ERROR;
    }

    public static int pack_audio(WavpackContext wpc, DataInputStream in) {
        block11: {
            long sample_count;
            WavPackUtils.WavpackPackInit(wpc);
            int bytes_per_sample = WavPackUtils.WavpackGetBytesPerSample(wpc) * WavPackUtils.WavpackGetNumChannels(wpc);
            long samples_remaining = WavPackUtils.WavpackGetNumSamples(wpc);
            byte[] input_buffer = new byte[Defines.INPUT_SAMPLES * bytes_per_sample];
            long[] sample_buffer = new long[Defines.INPUT_SAMPLES * 4 * WavPackUtils.WavpackGetNumChannels(wpc)];
            int temp = 0;
            do {
                long bytes_read = 0L;
                ++temp;
                int bytes_to_read = samples_remaining > (long)Defines.INPUT_SAMPLES ? Defines.INPUT_SAMPLES * bytes_per_sample : (int)(samples_remaining * (long)bytes_per_sample);
                samples_remaining -= (long)(bytes_to_read / bytes_per_sample);
                bytes_read = WvEncode.DoReadFile(in, input_buffer, bytes_to_read);
                sample_count = bytes_read / (long)bytes_per_sample;
                if (sample_count == 0L) break block11;
                if (sample_count > 0L) {
                    int scounter;
                    int dcounter;
                    int cnt = (int)(sample_count * (long)WavPackUtils.WavpackGetNumChannels(wpc));
                    byte[] sptr = input_buffer;
                    long[] dptr = sample_buffer;
                    int loopBps = 0;
                    loopBps = WavPackUtils.WavpackGetBytesPerSample(wpc);
                    if (loopBps == 1) {
                        int intermalCount = 0;
                        while (cnt > 0) {
                            dptr[intermalCount] = (sptr[intermalCount] & 0xFF) - 128;
                            ++intermalCount;
                            --cnt;
                        }
                    } else if (loopBps == 2) {
                        dcounter = 0;
                        scounter = 0;
                        while (cnt > 0) {
                            dptr[dcounter] = sptr[scounter] & 0xFF | sptr[scounter + 1] << 8;
                            scounter += 2;
                            ++dcounter;
                            --cnt;
                        }
                    } else if (loopBps == 3) {
                        dcounter = 0;
                        scounter = 0;
                        while (cnt > 0) {
                            dptr[dcounter] = sptr[scounter] & 0xFF | (sptr[scounter + 1] & 0xFF) << 8 | sptr[scounter + 2] << 16;
                            scounter += 3;
                            ++dcounter;
                            --cnt;
                        }
                    }
                }
                wpc.byte_idx = 0;
            } while (WavPackUtils.WavpackPackSamples(wpc, sample_buffer, sample_count) != 0);
            System.err.println(WavPackUtils.WavpackGetErrorMessage(wpc));
            return Defines.HARD_ERROR;
        }
        if (WavPackUtils.WavpackFlushSamples(wpc) == 0) {
            System.err.println(WavPackUtils.WavpackGetErrorMessage(wpc));
            return Defines.HARD_ERROR;
        }
        return Defines.NO_ERROR;
    }

    static long DoReadFile(DataInputStream hFile, byte[] lpBuffer, int nNumberOfBytesToRead) {
        byte[] tempBuffer = new byte[(int)((long)nNumberOfBytesToRead + 1L)];
        long bufferCounter = 0L;
        long lpNumberOfBytesRead = 0L;
        while (nNumberOfBytesToRead > 0) {
            long bcount;
            try {
                bcount = hFile.read(tempBuffer, 0, nNumberOfBytesToRead);
            }
            catch (Exception e) {
                bcount = 0L;
            }
            if (bcount <= 0L) break;
            long i = 0L;
            while (i < (long)nNumberOfBytesToRead) {
                lpBuffer[(int)(bufferCounter + i)] = tempBuffer[(int)i];
                ++i;
            }
            lpNumberOfBytesRead += bcount;
            nNumberOfBytesToRead = (int)((long)nNumberOfBytesToRead - bcount);
        }
        return lpNumberOfBytesRead;
    }
}

