/*
 * Decompiled with CFR 0.152.
 */
package ips.audio;

import java.io.IOException;
import java.io.InputStream;

public abstract class FramedInputStream
extends InputStream {
    protected int frameSize;
    private byte[] singleByteBuf = new byte[1];
    protected IOException frameSizeException = new IOException("bytes to read must be multiple of frame size");

    public FramedInputStream(int frameSize) {
        this.frameSize = frameSize;
    }

    @Override
    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("read() method is only allowed if frame size equals 1");
        }
        int read = this.read(this.singleByteBuf, 0, 1);
        if (read == -1) {
            return read;
        }
        return 0xFF & this.singleByteBuf[0];
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;
}

