/*
 * Decompiled with CFR 0.152.
 */
package ips.audio.wavpack;

import ips.audio.wavpack.WavPackFileWriter;
import ips.audio.wavpack.WavpackConversionProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class WavPackFileReader
extends AudioFileReader {
    static byte[] WAVPACK_HEADER = new byte[]{119, 118, 112, 107};

    @Override
    public AudioFileFormat getAudioFileFormat(File arg0) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = new FileInputStream(arg0);
        BufferedInputStream bis = new BufferedInputStream(fis, 4096);
        if (this.isWavpackStream(bis)) {
            return WavpackConversionProvider.getAudioFileFormat(bis);
        }
        bis.close();
        throw new UnsupportedAudioFileException();
    }

    private boolean isWavpackStream(InputStream ins) throws IOException {
        int r;
        if (!ins.markSupported()) {
            throw new IOException("Cannot mark 4 bytes.");
        }
        boolean isWavpack = false;
        ins.mark(4);
        byte[] header = new byte[4];
        int read = 0;
        while ((r = ins.read(header, read, 4 - read)) != -1 && read < 4) {
            read += r;
        }
        if (read == 4) {
            boolean isWavpackHeader = true;
            int i = 0;
            while (i < 4) {
                if (header[i] != WAVPACK_HEADER[i]) {
                    isWavpackHeader = false;
                    break;
                }
                ++i;
            }
            ins.reset();
            isWavpack = isWavpackHeader;
        }
        return isWavpack;
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream in) throws UnsupportedAudioFileException, IOException {
        boolean isWavpack = this.isWavpackStream(in);
        if (!isWavpack) {
            throw new UnsupportedAudioFileException("No WavPack header found");
        }
        AudioFormat format = new AudioFormat(WavpackConversionProvider.WAVPACK_ENC, -1.0f, -1, -1, -1, -1.0f, false);
        AudioFileFormat aff = new AudioFileFormat(WavPackFileWriter.FILE_FORMAT_TYPE, format, -1);
        return aff;
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL arg0) throws UnsupportedAudioFileException, IOException {
        InputStream is = arg0.openStream();
        BufferedInputStream bis = new BufferedInputStream(is, 128);
        return this.getAudioFileFormat(bis);
    }

    @Override
    public AudioInputStream getAudioInputStream(File arg0) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = new FileInputStream(arg0);
        BufferedInputStream bis = new BufferedInputStream(fis, 128);
        AudioInputStream ais = null;
        try {
            ais = this.getAudioInputStream(bis);
        }
        catch (IOException e) {
            if (bis != null) {
                bis.close();
            }
            throw e;
        }
        catch (UnsupportedAudioFileException uae) {
            if (bis != null) {
                bis.close();
            }
            throw uae;
        }
        return ais;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream arg0) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat aff = this.getAudioFileFormat(arg0);
        if (WavPackFileWriter.FILE_FORMAT_TYPE.equals(aff.getType())) {
            return new AudioInputStream(arg0, aff.getFormat(), -1L);
        }
        throw new UnsupportedAudioFileException();
    }

    @Override
    public AudioInputStream getAudioInputStream(URL arg0) throws UnsupportedAudioFileException, IOException {
        InputStream is = arg0.openStream();
        BufferedInputStream bis = new BufferedInputStream(is, 2048);
        AudioInputStream ais = null;
        try {
            ais = this.getAudioInputStream(bis);
        }
        catch (Exception e) {
            if (bis != null) {
                bis.close();
            }
            throw e;
        }
        return ais;
    }

    public static void main(String[] args) {
        WavPackFileReader fr = new WavPackFileReader();
        File testInFile = new File(args[0]);
        File testOutFile = new File(args[1]);
        try {
            AudioInputStream ais = fr.getAudioInputStream(testInFile);
            WavpackConversionProvider cp = new WavpackConversionProvider();
            AudioInputStream decAis = cp.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
            AudioSystem.write(decAis, AudioFileFormat.Type.WAVE, testOutFile);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

