/*
 * Decompiled with CFR 0.152.
 */
package ips.audio.wavpack;

import ips.audio.wavpack.WavPackFileFormatType;
import ips.audio.wavpack.WavpackConversionProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileWriter;

public class WavPackFileWriter
extends AudioFileWriter {
    private static final boolean DEBUG = false;
    public static AudioFileFormat.Type FILE_FORMAT_TYPE = new WavPackFileFormatType();

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes() {
        return new AudioFileFormat.Type[]{FILE_FORMAT_TYPE};
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream arg0) {
        if (arg0.getFormat().getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            return new AudioFileFormat.Type[]{FILE_FORMAT_TYPE};
        }
        return new AudioFileFormat.Type[0];
    }

    @Override
    public synchronized int write(AudioInputStream arg0, AudioFileFormat.Type arg1, File arg2) throws IOException {
        if (!arg1.equals(FILE_FORMAT_TYPE)) {
            throw new IllegalArgumentException("File type " + arg1.toString() + " not supported");
        }
        return this.write(arg0, arg1, new FileOutputStream(arg2));
    }

    @Override
    public synchronized int write(AudioInputStream ais, AudioFileFormat.Type arg1, OutputStream arg2) throws IOException {
        if (!arg1.equals(FILE_FORMAT_TYPE)) {
            throw new IllegalArgumentException("File type " + arg1.toString() + " not supported");
        }
        AudioFormat inFmt = ais.getFormat();
        AudioFormat.Encoding inEnc = inFmt.getEncoding();
        AudioInputStream encInStream = null;
        if (AudioFormat.Encoding.PCM_SIGNED.equals(inEnc)) {
            WavpackConversionProvider wcp = new WavpackConversionProvider();
            encInStream = wcp.getAudioInputStream(WavpackConversionProvider.WAVPACK_ENC, ais);
        } else if (WavpackConversionProvider.WAVPACK_ENC.equals(inEnc)) {
            encInStream = ais;
        } else {
            throw new IllegalArgumentException("Source Encoding " + inEnc + " not supported");
        }
        byte[] buf = new byte[32768];
        int written = 0;
        int read = 0;
        while ((read = encInStream.read(buf)) >= 0) {
            arg2.write(buf, 0, read);
            written += read;
        }
        arg2.close();
        encInStream.close();
        return written;
    }

    public static void main(String[] args) {
        WavPackFileWriter fw = new WavPackFileWriter();
        File testInFile = new File(args[0]);
        File testOutFile = new File(args[1]);
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(testInFile);
            fw.write(ais, FILE_FORMAT_TYPE, testOutFile);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

