/*
 * Decompiled with CFR 0.152.
 */
package ips.audio.wavpack;

import com.wavpack.decode.WavpackContext;
import com.wavpack.decode.WvDemo;
import com.wavpack.encode.Defines;
import com.wavpack.encode.WavPackUtils;
import com.wavpack.encode.WavpackConfig;
import ips.audio.FramedInputStream;
import ips.audio.wavpack.WavPackFileWriter;
import ips.io.OutputInputStreamAdapter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;

public class WavpackConversionProvider
extends FormatConversionProvider {
    static final String WAVPACK_NAME = "Wavpack";
    public static final AudioFormat.Encoding WAVPACK_ENC = new AudioFormat.Encoding("Wavpack".toUpperCase(Locale.ENGLISH));
    static final AudioFormat.Encoding[] SUPPORTED_ENCODINGS = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, WAVPACK_ENC};

    public static AudioFileFormat getAudioFileFormat(InputStream srcInputStream) throws IOException {
        DataInputStream in = new DataInputStream(srcInputStream);
        WavpackContext wpc = com.wavpack.decode.WavPackUtils.WavpackOpenFileInput(in);
        if (wpc.error) {
            if (in != null) {
                in.close();
            }
            throw new IllegalArgumentException(wpc.error_message);
        }
        int num_channels = com.wavpack.decode.WavPackUtils.WavpackGetReducedChannels(wpc);
        long total_samples = com.wavpack.decode.WavPackUtils.WavpackGetNumSamples(wpc);
        int bps = com.wavpack.decode.WavPackUtils.WavpackGetBytesPerSample(wpc);
        long sampleRateLong = com.wavpack.decode.WavPackUtils.WavpackGetSampleRate(wpc);
        in.close();
        AudioFormat format = new AudioFormat(WAVPACK_ENC, sampleRateLong, bps * 8, num_channels, bps * num_channels, sampleRateLong, false);
        int frameLength = (int)total_samples;
        AudioFileFormat aff = new AudioFileFormat(WavPackFileWriter.FILE_FORMAT_TYPE, format, frameLength);
        return aff;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream srcInputStream) {
        AudioFormat trgFmt = new AudioFormat(targetEncoding, -1.0f, -1, -1, -1, -1.0f, false);
        return this.getAudioInputStream(trgFmt, srcInputStream);
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream srcInputStream) {
        AudioFormat.Encoding targetEncoding = targetFormat.getEncoding();
        int trgChannels = targetFormat.getChannels();
        float trgSampleRate = targetFormat.getSampleRate();
        int trgFrameSize = targetFormat.getFrameSize();
        int trgSampleSize = -1;
        if (trgFrameSize != -1 && trgChannels != -1) {
            trgSampleSize = trgFrameSize / trgChannels;
        }
        if (AudioFormat.Encoding.PCM_SIGNED.equals(targetEncoding)) {
            DataInputStream in = new DataInputStream(srcInputStream);
            WavpackContext wpc = com.wavpack.decode.WavPackUtils.WavpackOpenFileInput(in);
            if (wpc.error) {
                return null;
            }
            int num_channels = com.wavpack.decode.WavPackUtils.WavpackGetReducedChannels(wpc);
            long total_samples = com.wavpack.decode.WavPackUtils.WavpackGetNumSamples(wpc);
            int bps = com.wavpack.decode.WavPackUtils.WavpackGetBytesPerSample(wpc);
            long sampleRateLong = com.wavpack.decode.WavPackUtils.WavpackGetSampleRate(wpc);
            String excMsg = null;
            if (trgSampleRate != -1.0f && trgSampleRate != (float)sampleRateLong) {
                excMsg = "Sample rate does not match: Source: " + sampleRateLong + " requested: " + trgSampleRate;
            } else if (trgChannels != -1 && trgChannels != num_channels) {
                excMsg = "Channel count does not match: Source: " + num_channels + " requested: " + trgChannels;
            } else if (trgSampleSize != -1 && trgFrameSize != bps) {
                excMsg = "Sample size does not match: Source: " + bps + " requested: " + trgSampleSize;
            }
            if (excMsg != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IllegalArgumentException(excMsg);
            }
            AudioFormat af = new AudioFormat(sampleRateLong, bps * 8, num_channels, true, false);
            WavpackDecodeInputStream wvIs = new WavpackDecodeInputStream(wpc, af);
            AudioInputStream wvAis = new AudioInputStream(wvIs, af, wpc.total_samples);
            return wvAis;
        }
        if (WAVPACK_ENC.equals(targetEncoding)) {
            long srcFrameLength = srcInputStream.getFrameLength();
            if (srcFrameLength == 0L) {
                throw new IllegalArgumentException("Wavpack does not support encodig of zero length audio files");
            }
            AudioFormat af = srcInputStream.getFormat();
            int numChannels = af.getChannels();
            int bytesPerSample = af.getFrameSize() / numChannels;
            long total_samples = srcInputStream.getFrameLength();
            WavpackConfig loc_config = new WavpackConfig();
            loc_config.bits_per_sample = af.getSampleSizeInBits();
            loc_config.bytes_per_sample = bytesPerSample;
            loc_config.num_channels = numChannels;
            loc_config.sample_rate = (long)af.getSampleRate();
            String excMsg = null;
            if (trgSampleRate != -1.0f && trgSampleRate != (float)loc_config.sample_rate) {
                excMsg = "Sample rate does not match: Source: " + loc_config.sample_rate + " requested: " + trgSampleRate;
            } else if (trgChannels != -1 && trgChannels != loc_config.num_channels) {
                excMsg = "Channel count does not match: Source: " + loc_config.num_channels + " requested: " + trgChannels;
            } else if (trgSampleSize != -1 && trgFrameSize != loc_config.bytes_per_sample) {
                excMsg = "Sample size does not match: Source: " + loc_config.bytes_per_sample + " requested: " + trgSampleSize;
            }
            if (excMsg != null) {
                throw new IllegalArgumentException(excMsg);
            }
            com.wavpack.encode.WavpackContext wpc = new com.wavpack.encode.WavpackContext();
            wpc.filelen = 0L;
            WavPackUtils.WavpackSetConfiguration(wpc, loc_config, total_samples);
            WavpackEncodeInputStream weis = new WavpackEncodeInputStream(wpc, af, srcInputStream);
            AudioFormat trgFormat = new AudioFormat(WAVPACK_ENC, af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), -1, af.getFrameRate(), af.isBigEndian());
            AudioInputStream ais = new AudioInputStream(weis, trgFormat, -1L);
            return ais;
        }
        throw new IllegalArgumentException("Encoding " + targetEncoding + " not supported.");
    }

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return SUPPORTED_ENCODINGS;
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return SUPPORTED_ENCODINGS;
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat arg0) {
        AudioFormat.Encoding e = arg0.getEncoding();
        int chs = arg0.getChannels();
        int frameSize = arg0.getFrameSize();
        int sampleSize = frameSize / chs;
        if (AudioFormat.Encoding.PCM_SIGNED.equals(e) && chs > 0 && chs <= 2 && sampleSize == 2) {
            return new AudioFormat.Encoding[]{WAVPACK_ENC};
        }
        if (WAVPACK_ENC.equals(e)) {
            return new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
        }
        return new AudioFormat.Encoding[0];
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding srcEncoding, AudioFormat srcFmt) {
        int channels = srcFmt.getChannels();
        float sampleRate = srcFmt.getSampleRate();
        int sampleSizeInBits = srcFmt.getSampleSizeInBits();
        boolean bigEndian = srcFmt.isBigEndian();
        int frameSize = srcFmt.getFrameSize();
        float frameRate = srcFmt.getFrameRate();
        AudioFormat[] trgFmts = new AudioFormat[]{};
        if (AudioFormat.Encoding.PCM_SIGNED.equals(srcEncoding)) {
            AudioFormat trgFmt = new AudioFormat(WAVPACK_ENC, sampleRate, sampleSizeInBits, channels, -1, -1.0f, bigEndian);
            trgFmts = new AudioFormat[]{trgFmt};
        } else if (WAVPACK_ENC.equals(srcEncoding)) {
            AudioFormat trgFmt = new AudioFormat(WAVPACK_ENC, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
            trgFmts = new AudioFormat[]{trgFmt};
        }
        return trgFmts;
    }

    static class WavpackDecodeInputStream
    extends FramedInputStream {
        private WavpackContext wpc;
        private AudioFormat audioFormat;
        private int[] temp_buffer = new int[com.wavpack.decode.Defines.SAMPLE_BUFFER_SIZE];
        private byte[] pcm_buffer = new byte[4 * com.wavpack.decode.Defines.SAMPLE_BUFFER_SIZE];
        private int available = 0;
        private int srcBufPos = 0;
        private int num_channels;
        private int bps;

        public WavpackDecodeInputStream(WavpackContext wpc, AudioFormat af) {
            super(af.getFrameSize());
            this.audioFormat = af;
            this.wpc = wpc;
            this.num_channels = this.audioFormat.getChannels();
            this.bps = com.wavpack.decode.WavPackUtils.WavpackGetBytesPerSample(wpc);
        }

        @Override
        public int read(byte[] b, int offset, int len) throws IOException {
            int bytesToCopy;
            if (len > 0 && this.available == 0) {
                this.srcBufPos = 0;
                long samples_unpacked = com.wavpack.decode.WavPackUtils.WavpackUnpackSamples(this.wpc, this.temp_buffer, com.wavpack.decode.Defines.SAMPLE_BUFFER_SIZE / this.num_channels);
                if (samples_unpacked > 0L) {
                    this.pcm_buffer = WvDemo.format_samples(this.bps, this.temp_buffer, samples_unpacked *= (long)this.num_channels);
                    this.available = (int)samples_unpacked * this.bps;
                }
                if (samples_unpacked == 0L) {
                    return -1;
                }
            }
            if ((bytesToCopy = len) > this.available) {
                bytesToCopy = this.available;
            }
            int i = 0;
            while (i < bytesToCopy) {
                b[offset + i] = this.pcm_buffer[this.srcBufPos + i];
                ++i;
            }
            this.srcBufPos += bytesToCopy;
            this.available -= bytesToCopy;
            return bytesToCopy;
        }

        @Override
        public void close() throws IOException {
            this.wpc.infile.close();
            super.close();
        }
    }

    static class WavpackEncodeInputStream
    extends InputStream {
        private com.wavpack.encode.WavpackContext wpc;
        private AudioFormat audioFormat;
        private int num_channels;
        private int bytes_per_sample;
        private DataInputStream in;
        private OutputInputStreamAdapter out;
        private InputStream inAdapter;
        private byte[] input_buffer;
        private long[] sample_buffer;
        private long samples_remaining;
        private int temp;
        private boolean eos = false;
        private byte[] singleByteBuf = new byte[1];
        private long totalRead = 0L;

        public WavpackEncodeInputStream(com.wavpack.encode.WavpackContext wpc, AudioFormat af, InputStream srcInputStream) {
            this.audioFormat = af;
            this.wpc = wpc;
            this.num_channels = this.audioFormat.getChannels();
            WavPackUtils.WavpackPackInit(wpc);
            this.bytes_per_sample = WavPackUtils.WavpackGetBytesPerSample(wpc) * WavPackUtils.WavpackGetNumChannels(wpc);
            this.in = new DataInputStream(srcInputStream);
            this.out = new OutputInputStreamAdapter();
            this.inAdapter = this.out.getInputStream();
            wpc.outfile = this.out;
            this.input_buffer = new byte[Defines.INPUT_SAMPLES * this.bytes_per_sample];
            this.sample_buffer = new long[Defines.INPUT_SAMPLES * 4 * WavPackUtils.WavpackGetNumChannels(wpc)];
            this.samples_remaining = WavPackUtils.WavpackGetNumSamples(wpc);
            this.temp = 0;
        }

        @Override
        public int read() throws IOException {
            int read = this.read(this.singleByteBuf, 0, 1);
            if (read == -1) {
                return read;
            }
            return 0xFF & this.singleByteBuf[0];
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int offset, int len) throws IOException {
            int r;
            if (!this.eos && this.inAdapter.available() == 0) {
                long sample_count;
                long bytes_read = 0L;
                ++this.temp;
                int bytes_to_read = this.samples_remaining > (long)Defines.INPUT_SAMPLES ? Defines.INPUT_SAMPLES * this.bytes_per_sample : (int)(this.samples_remaining * (long)this.bytes_per_sample);
                this.samples_remaining -= (long)(bytes_to_read / this.bytes_per_sample);
                int nNumberOfBytesToRead = bytes_to_read;
                byte[] tempBuffer = new byte[(int)((long)nNumberOfBytesToRead + 1L)];
                long bufferCounter = 0L;
                long lpNumberOfBytesRead = 0L;
                while (nNumberOfBytesToRead > 0) {
                    long bcount;
                    try {
                        bcount = this.in.read(tempBuffer, 0, nNumberOfBytesToRead);
                    }
                    catch (Exception e) {
                        bcount = 0L;
                    }
                    if (bcount <= 0L) break;
                    long i = 0L;
                    while (i < (long)nNumberOfBytesToRead) {
                        this.input_buffer[(int)(bufferCounter + i)] = tempBuffer[(int)i];
                        ++i;
                    }
                    lpNumberOfBytesRead += bcount;
                    nNumberOfBytesToRead = (int)((long)nNumberOfBytesToRead - bcount);
                }
                if ((sample_count = (bytes_read = lpNumberOfBytesRead) / (long)this.bytes_per_sample) == 0L) {
                    this.eos = true;
                    if (WavPackUtils.WavpackFlushSamples(this.wpc) == 0) {
                        String errMsg = WavPackUtils.WavpackGetErrorMessage(this.wpc);
                        throw new IOException(errMsg);
                    }
                    this.out.close();
                } else {
                    if (sample_count > 0L) {
                        int cnt = (int)(sample_count * (long)WavPackUtils.WavpackGetNumChannels(this.wpc));
                        byte[] sptr = this.input_buffer;
                        long[] dptr = this.sample_buffer;
                        int loopBps = 0;
                        loopBps = WavPackUtils.WavpackGetBytesPerSample(this.wpc);
                        if (loopBps == 1) {
                            int intermalCount = 0;
                            while (cnt > 0) {
                                dptr[intermalCount] = (sptr[intermalCount] & 0xFF) - 128;
                                ++intermalCount;
                                --cnt;
                            }
                        } else if (loopBps == 2) {
                            int dcounter = 0;
                            int scounter = 0;
                            while (cnt > 0) {
                                dptr[dcounter] = sptr[scounter] & 0xFF | sptr[scounter + 1] << 8;
                                scounter += 2;
                                ++dcounter;
                                --cnt;
                            }
                        } else if (loopBps == 3) {
                            int dcounter = 0;
                            int scounter = 0;
                            while (cnt > 0) {
                                dptr[dcounter] = sptr[scounter] & 0xFF | (sptr[scounter + 1] & 0xFF) << 8 | sptr[scounter + 2] << 16;
                                scounter += 3;
                                ++dcounter;
                                --cnt;
                            }
                        }
                    }
                    this.wpc.byte_idx = 0;
                    if (WavPackUtils.WavpackPackSamples(this.wpc, this.sample_buffer, sample_count) == 0) {
                        String errMsg = WavPackUtils.WavpackGetErrorMessage(this.wpc);
                        throw new IOException(errMsg);
                    }
                }
            }
            if ((r = this.inAdapter.read(b, offset, len)) > 0) {
                this.totalRead += (long)r;
            }
            return r;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
            super.close();
        }
    }
}

