/*
 * Decompiled with CFR 0.152.
 */
package ips.audio.wavpack.test;

import ips.audio.wavpack.test.AudioFormatNotSupportedException;
import ips.audio.wavpack.test.AudioSampleProcessor;
import javax.sound.sampled.AudioFormat;

public class AudioFrameProcessor
extends AudioSampleProcessor {
    static final boolean DEBUG = false;
    private float[] floatValues;

    public AudioFrameProcessor(AudioFormat af) throws AudioFormatNotSupportedException {
        super(af);
        this.floatValues = new float[af.getChannels()];
    }

    public float[] getFloatValues(byte[] frameData) {
        return this.getFloatValues(frameData, 0);
    }

    public float[] getFloatValues(byte[] frameData, int offset) {
        int i = 0;
        while (i < this.channels) {
            this.floatValues[i] = this.getFloatValue(frameData, i * this.sampleSize + offset);
            ++i;
        }
        return this.floatValues;
    }

    public void getNormalizedInterleavedValues(byte[] frameData, int frames, double[][] normBuffer, int normBufferFrameOffset) {
        int f = 0;
        while (f < frames) {
            int i = 0;
            while (i < this.channels) {
                normBuffer[normBufferFrameOffset + f][i] = this.getNormalizedValue(frameData, f * this.frameSize + i * this.sampleSize);
                ++i;
            }
            ++f;
        }
    }

    public void getNormalizedInterleavedValues(byte[] frameData, int frameDataOffset, int frames, double[][] normBuffer, int normBufferFrameOffset) {
        int f = 0;
        while (f < frames) {
            int i = 0;
            while (i < this.channels) {
                normBuffer[normBufferFrameOffset + f][i] = this.getNormalizedValue(frameData, frameDataOffset + f * this.frameSize + i * this.sampleSize);
                ++i;
            }
            ++f;
        }
    }

    public void getNormalizedValues(byte[] frameData, int offset, double[] normBuffer) {
        int i = 0;
        while (i < this.channels) {
            normBuffer[i] = this.getNormalizedValue(frameData, i * this.sampleSize + offset);
            ++i;
        }
    }

    public void getDoubleValues(byte[] frameData, int offset, double[] buffer) {
        int i = 0;
        while (i < this.channels) {
            buffer[i] = this.getDoubleValue(frameData, i * this.sampleSize + offset);
            ++i;
        }
    }

    public void getFloatValues(byte[] frameData, int offset, float[] buffer) {
        int i = 0;
        while (i < this.channels) {
            buffer[i] = this.getFloatValue(frameData, i * this.sampleSize + offset);
            ++i;
        }
    }

    public void encodeToFloatValues(float[] values, byte[] buf, int offset) {
        int i = 0;
        while (i < this.channels) {
            this.encodeValue(values[i], buf, offset + i * this.sampleSize);
            ++i;
        }
    }

    public void encodeValues(float[] values, byte[] buf, int offset) {
        int i = 0;
        while (i < this.channels) {
            this.encodeValue(values[i], buf, offset + i * this.sampleSize);
            ++i;
        }
    }

    public void encodeValues(double[] values, byte[] buf, int offset) {
        int i = 0;
        while (i < this.channels) {
            this.encodeValue(values[i], buf, offset + i * this.sampleSize);
            ++i;
        }
    }

    public void encode(double[][] values, int srcOffset, byte[] buf, int offset, int frames) {
        int trgPos = offset;
        int f = 0;
        while (f < frames) {
            this.encodeValues(values[srcOffset + f], buf, trgPos);
            trgPos += this.frameSize;
            ++f;
        }
    }

    public void encode(double[] values, int srcOffset, byte[] buf, int offset, int samples) {
        int srcPos = srcOffset;
        int trgPos = offset;
        int s = 0;
        while (s < samples) {
            this.encodeValue(values[srcPos], buf, trgPos);
            ++srcPos;
            trgPos += this.sampleSize;
            ++s;
        }
    }
}

