/*
 * Decompiled with CFR 0.152.
 */
package ips.audio.wavpack.test;

import ips.audio.wavpack.test.AudioFormatNotSupportedException;
import javax.sound.sampled.AudioFormat;

public abstract class AudioSampleProcessor {
    public static final double AUDITORY_THRESHOLD = 2.0E-4;
    public static final double DEFAULT_0DB_SOUND_PRESSURE = 0.2;
    static final boolean DEBUG = false;
    protected AudioFormat af;
    protected AudioFormat.Encoding ae;
    protected boolean bigEndian;
    protected boolean signed = false;
    protected int channels;
    protected int frameSize;
    protected int sampleSize;
    protected double maxValue;
    protected double minValue;
    protected int resolutionBits;
    protected double pp;

    public AudioSampleProcessor() {
    }

    public AudioSampleProcessor(AudioFormat af) throws AudioFormatNotSupportedException {
        this.setAudioFormat(af);
    }

    public void setAudioFormat(AudioFormat af) throws AudioFormatNotSupportedException {
        this.af = af;
        if (af.getSampleSizeInBits() > 32) {
            throw new AudioFormatNotSupportedException(af);
        }
        this.ae = af.getEncoding();
        if (this.ae == AudioFormat.Encoding.PCM_SIGNED) {
            this.signed = true;
            this.resolutionBits = af.getSampleSizeInBits();
            this.pp = (float)Math.pow(2.0, this.resolutionBits);
            this.maxValue = this.pp / 2.0;
            this.minValue = -this.maxValue + 1.0;
        } else if (this.ae == AudioFormat.Encoding.PCM_UNSIGNED) {
            this.resolutionBits = af.getSampleSizeInBits();
            this.maxValue = this.pp = (double)((float)Math.pow(2.0, this.resolutionBits));
            this.minValue = 0.0;
        } else {
            throw new AudioFormatNotSupportedException(af);
        }
        this.channels = af.getChannels();
        this.frameSize = af.getFrameSize();
        this.sampleSize = this.frameSize / af.getChannels();
        this.bigEndian = af.isBigEndian();
    }

    public double getNormalizedValue(byte[] sample) {
        return this.getDoubleValue(sample, 0) * 2.0;
    }

    public float getFloatValue(byte[] sample) {
        return this.getFloatValue(sample, 0);
    }

    public double getDoubleValue(byte[] sample, int offset) {
        long is;
        if (this.signed) {
            int is2;
            if (!this.bigEndian) {
                is2 = sample[offset + this.sampleSize - 1];
                int i = this.sampleSize - 2;
                while (i >= 0) {
                    is2 <<= 8;
                    is2 |= 0xFF & sample[offset + i];
                    --i;
                }
            } else {
                is2 = sample[offset];
                int i = 0;
                while (i < this.sampleSize - 1) {
                    is2 <<= 8;
                    is2 |= 0xFF & sample[i + offset];
                    ++i;
                }
            }
            return (double)is2 / this.pp;
        }
        if (!this.bigEndian) {
            is = 0xFFL & (long)sample[offset + this.sampleSize - 1];
            int i = this.sampleSize - 2;
            while (i >= 0) {
                is <<= 8;
                is |= 0xFFL & (long)sample[offset + i];
                --i;
            }
        } else {
            is = 0xFFL & (long)sample[offset];
            int i = 0;
            while (i < this.sampleSize - 1) {
                is <<= 8;
                is |= 0xFFL & (long)sample[i + offset];
                ++i;
            }
        }
        return (double)is / this.pp;
    }

    public double getNormalizedValue(byte[] sample, int offset) {
        return this.getDoubleValue(sample, offset) * 2.0;
    }

    public float getFloatValue(byte[] sample, int offset) {
        long is;
        if (this.signed) {
            int is2;
            if (!this.bigEndian) {
                is2 = sample[offset + this.sampleSize - 1];
                int i = this.sampleSize - 2;
                while (i >= 0) {
                    is2 <<= 8;
                    is2 |= 0xFF & sample[offset + i];
                    --i;
                }
            } else {
                is2 = sample[offset];
                int i = 0;
                while (i < this.sampleSize - 1) {
                    is2 <<= 8;
                    is2 |= 0xFF & sample[i + offset];
                    ++i;
                }
            }
            return (float)is2 / (float)this.pp;
        }
        if (!this.bigEndian) {
            is = 0xFFL & (long)sample[offset + this.sampleSize - 1];
            int i = this.sampleSize - 2;
            while (i >= 0) {
                is <<= 8;
                is |= 0xFFL & (long)sample[offset + i];
                --i;
            }
        } else {
            is = 0xFFL & (long)sample[offset];
            int i = 0;
            while (i < this.sampleSize - 1) {
                is <<= 8;
                is |= 0xFFL & (long)sample[i + offset];
                ++i;
            }
        }
        return (float)is / (float)this.pp;
    }

    public void encodeValue(double f, byte[] buf, int offset) {
        long value = (long)(this.maxValue * f);
        if (this.signed) {
            if (this.bigEndian) {
                int i = this.sampleSize - 1;
                while (i > 0) {
                    buf[offset + i] = (byte)value;
                    value >>= 8;
                    --i;
                }
                buf[offset] = (byte)value;
            } else {
                int i = 0;
                while (i < this.sampleSize - 1) {
                    buf[offset + i] = (byte)value;
                    value >>= 8;
                    ++i;
                }
                buf[offset + this.sampleSize - 1] = (byte)value;
            }
        }
    }

    public double amplitudeToSoundPressure(double ampl) {
        return ampl * 2.0 * 0.2;
    }

    public byte[] getEncodedValue(double f) {
        byte[] buf = new byte[this.sampleSize];
        this.encodeValue(f, buf, 0);
        return buf;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }
}

