/*
 * Decompiled with CFR 0.152.
 */
package ips.audio.wavpack.test;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class EncoderWorker
implements Callable<Boolean> {
    private File srcFile;
    private File trgFile;
    private AudioFormat.Encoding targetEncoding;
    private AudioFileFormat.Type audioFileFormatType;

    public EncoderWorker(File srcFile, File trgFile, AudioFormat.Encoding encoding, AudioFileFormat.Type audioFileFormatType) {
        this.srcFile = srcFile;
        this.trgFile = trgFile;
        this.targetEncoding = encoding;
        this.audioFileFormatType = audioFileFormatType;
    }

    @Override
    public Boolean call() throws UnsupportedAudioFileException, IOException {
        AudioInputStream sourceStream = AudioSystem.getAudioInputStream(this.srcFile);
        if (sourceStream.getFrameLength() == 0L) {
            sourceStream.close();
            return false;
        }
        AudioInputStream trgStream = AudioSystem.getAudioInputStream(this.targetEncoding, sourceStream);
        AudioSystem.write(trgStream, this.audioFileFormatType, this.trgFile);
        trgStream.close();
        return true;
    }
}

