/*
 * Decompiled with CFR 0.152.
 */
package ips.audio.wavpack.test;

import ips.audio.wavpack.WavPackFileWriter;
import ips.audio.wavpack.test.AudioFormatNotSupportedException;
import ips.audio.wavpack.test.EncoderWorker;
import ips.audio.wavpack.test.NoiseGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WavpackTests {
    public static int MAX_THREAD_COUNT = 4;
    public static int TEST_FILE_COUNT = 100;
    public static double MAX_LENGTH_SECONDS = 1200.0;
    private File srcDir;
    private File targetDir;
    private AudioFormat.Encoding targetEncoding;
    private AudioFileFormat.Type type;
    private static String wavExtRegex = "[.][wW][aA][vV]$";
    private static String wvExtRegex = "[.][wW][vV]$";

    public WavpackTests(File srcDir, File targetDir) {
        AudioFormat.Encoding[] encs;
        AudioFileFormat.Type[] types;
        this.srcDir = srcDir;
        this.targetDir = targetDir;
        AudioFileFormat.Type[] typeArray = types = AudioSystem.getAudioFileTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            AudioFileFormat.Type t = typeArray[n2];
            if ("WAVPACK".equalsIgnoreCase(t.toString())) {
                this.type = t;
                break;
            }
            ++n2;
        }
        AudioFormat.Encoding[] encodingArray = encs = AudioSystem.getTargetEncodings(AudioFormat.Encoding.PCM_SIGNED);
        int n3 = encs.length;
        n = 0;
        while (n < n3) {
            AudioFormat.Encoding enc = encodingArray[n];
            if ("WAVPACK".equalsIgnoreCase(enc.toString())) {
                this.targetEncoding = enc;
                break;
            }
            ++n;
        }
    }

    private boolean compareStreams(AudioInputStream srcStream, AudioInputStream trgStream) throws IOException {
        AudioFormat srcFmt = srcStream.getFormat();
        AudioFormat trgFmt = trgStream.getFormat();
        long srcFLen = srcStream.getFrameLength();
        long trgFLen = trgStream.getFrameLength();
        if (srcFLen != -1L && trgFLen != -1L && srcFLen != trgFLen) {
            return false;
        }
        if (srcFmt.getChannels() != trgFmt.getChannels() || !srcFmt.getEncoding().equals(trgFmt.getEncoding()) || srcFmt.getFrameRate() != trgFmt.getFrameRate() || srcFmt.getSampleRate() != trgFmt.getSampleRate() || srcFmt.getSampleSizeInBits() != trgFmt.getSampleSizeInBits() || srcFmt.getFrameSize() != trgFmt.getFrameSize() || srcFmt.isBigEndian() != trgFmt.isBigEndian()) {
            return false;
        }
        long totalbytes = 0L;
        byte[] sb = new byte[2048 * srcFmt.getFrameSize()];
        byte[] tb = new byte[2048 * srcFmt.getFrameSize()];
        int sr = 0;
        boolean eq = true;
        while ((sr = srcStream.read(sb)) >= 0) {
            int trgRead = 0;
            int tr = 0;
            do {
                if ((tr = trgStream.read(tb, trgRead, sr - trgRead)) >= 0) continue;
                eq = false;
                break;
            } while ((trgRead += tr) < sr);
            int i = 0;
            while (i < sr) {
                if (sb[i] != tb[i]) {
                    eq = false;
                    System.err.println("Differ at " + (totalbytes + (long)i));
                    break;
                }
                ++totalbytes;
                ++i;
            }
            if (!eq) break;
        }
        srcStream.close();
        trgStream.close();
        return eq;
    }

    private boolean compareAudioFileContents(File srcFile, File trgFile) throws UnsupportedAudioFileException, IOException {
        AudioInputStream trgStream;
        AudioInputStream srcStream;
        block4: {
            srcStream = AudioSystem.getAudioInputStream(srcFile);
            if (srcStream.getFrameLength() == 0L) {
                System.out.println("Warning: Ignoring zero length source file: " + srcFile);
                return true;
            }
            AudioInputStream srcDecStream = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, srcStream);
            try {
                trgStream = AudioSystem.getAudioInputStream(trgFile);
                if (trgStream.getFrameLength() != 0L) break block4;
                System.out.println("Warning: Ignoring zero length target file: " + trgFile);
                return true;
            }
            catch (Exception ee) {
                System.err.println("Source: " + srcFile);
                ee.printStackTrace();
                return false;
            }
        }
        AudioInputStream trgDecStream = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, trgStream);
        return this.compareStreams(srcStream, trgDecStream);
    }

    private void listFileTypes() {
        AudioFileFormat.Type[] types;
        AudioFileFormat.Type[] typeArray = types = AudioSystem.getAudioFileTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            AudioFileFormat.Type t = typeArray[n2];
            System.out.println(t);
            ++n2;
        }
    }

    private void encode(File srcFile, File trgFile) throws UnsupportedAudioFileException, IOException {
        AudioInputStream sourceStream = AudioSystem.getAudioInputStream(srcFile);
        if (sourceStream.getFrameLength() != 0L) {
            AudioInputStream trgStream = AudioSystem.getAudioInputStream(this.targetEncoding, sourceStream);
            AudioSystem.write(trgStream, this.type, trgFile);
        }
    }

    private void decode(File srcFile, File trgFile) throws UnsupportedAudioFileException, IOException {
        AudioInputStream srcStream = AudioSystem.getAudioInputStream(srcFile);
        AudioInputStream trgStream = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, srcStream);
        AudioSystem.write(trgStream, AudioFileFormat.Type.WAVE, trgFile);
    }

    private boolean compare() throws UnsupportedAudioFileException, IOException {
        File[] files;
        File[] fileArray = files = this.srcDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File enAndDecodedFile;
            boolean eqContents;
            File f = fileArray[n2];
            String fName = f.getName();
            if (fName.matches(".*" + wavExtRegex) && !(eqContents = this.compareAudioFileContents(f, enAndDecodedFile = new File(this.targetDir, fName)))) {
                System.err.println("File contents differ: " + f + " " + enAndDecodedFile);
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean encode() throws UnsupportedAudioFileException, IOException {
        File[] files;
        File[] fileArray = files = this.srcDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String fName = f.getName();
            if (fName.matches(".*" + wavExtRegex)) {
                String fNameBody = fName.replaceFirst(wavExtRegex, "");
                String wvFilename = String.valueOf(fNameBody) + "." + this.type.getExtension();
                File wvFile = new File(this.targetDir, wvFilename);
                this.encode(f, wvFile);
                boolean eqContents = this.compareAudioFileContents(f, wvFile);
                if (!eqContents) {
                    System.err.println("File contents differ: " + fName + " " + wvFilename);
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean decode() throws UnsupportedAudioFileException, IOException {
        File[] files;
        File[] fileArray = files = this.targetDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String fName = f.getName();
            if (fName.matches(".*" + wvExtRegex)) {
                String fNameBody = fName.replaceFirst(wvExtRegex, "");
                String wavFilename = String.valueOf(fNameBody) + "." + AudioFileFormat.Type.WAVE.getExtension();
                File wavFile = new File(this.targetDir, wavFilename);
                this.decode(f, wavFile);
            }
            ++n2;
        }
        return true;
    }

    public static synchronized File createTempDir(String prefix) throws IOException {
        int rand;
        String tmpDirName;
        File directory = new File(System.getProperty("java.io.tmpdir"));
        File tmpDir = null;
        do {
            rand = (int)(Math.random() * 1000000.0);
        } while ((tmpDir = new File(directory, tmpDirName = String.valueOf(prefix) + Integer.toString(rand))).exists());
        boolean created = tmpDir.mkdir();
        if (!created) {
            throw new IOException("Could not create temporary directory!");
        }
        return tmpDir;
    }

    public static void main(String[] args) {
        File targetDir = null;
        File testSrcDir = null;
        if (args.length == 0) {
            try {
                testSrcDir = WavpackTests.createTempDir(String.valueOf(WavpackTests.class.getName()) + "_testSrcDir");
                testSrcDir.mkdirs();
                int i = 0;
                while (i < TEST_FILE_COUNT) {
                    File testFile = new File(testSrcDir, String.valueOf(i) + ".wav");
                    AudioFormat af = new AudioFormat(44100.0f, 16, 2, true, true);
                    double rnd = Math.random();
                    int lenFrames = (int)(rnd * rnd * MAX_LENGTH_SECONDS * 44100.0) + 1;
                    lenFrames = (int)((double)lenFrames - Math.log(lenFrames));
                    NoiseGenerator ng = new NoiseGenerator(af, lenFrames);
                    AudioInputStream ais = new AudioInputStream(ng, af, lenFrames);
                    AudioSystem.write(ais, AudioFileFormat.Type.WAVE, testFile);
                    ++i;
                }
                targetDir = WavpackTests.createTempDir(String.valueOf(WavpackTests.class.getName()) + "_testTargetDir");
            }
            catch (AudioFormatNotSupportedException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (args.length == 2) {
            testSrcDir = new File(args[0]);
            targetDir = new File(args[1]);
        } else {
            System.err.println("Usage: ");
            System.err.println("WavpackTests");
            System.err.println("WavpackTests testSrcDir testTrgDir");
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        WavpackTests test = new WavpackTests(testSrcDir, targetDir);
        try {
            boolean eq = true;
            test.encodeMultiThreaded();
            test.decodeMultiThreaded();
            eq = test.compare();
            if (!eq) {
                System.err.println("Final compare of multithreaded conversion: Files differ!!");
            } else {
                System.out.println("Final compare of multithreaded conversion succeeded. All files contents are equal.");
            }
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void decodeMultiThreaded() throws InterruptedException {
        ExecutorService pool = Executors.newFixedThreadPool(MAX_THREAD_COUNT);
        File[] files = this.targetDir.listFiles();
        if (files == null) {
            System.err.println("File list null !! ");
            return;
        }
        int taskCnt = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String fName = f.getName();
            if (fName.matches(".*" + wvExtRegex)) {
                String fNameBody = fName.replaceFirst(wvExtRegex, "");
                String wavFilename = String.valueOf(fNameBody) + "." + AudioFileFormat.Type.WAVE.getExtension();
                File wavFile = new File(this.targetDir, wavFilename);
                EncoderWorker w = new EncoderWorker(f, wavFile, AudioFormat.Encoding.PCM_SIGNED, AudioFileFormat.Type.WAVE);
                pool.submit(w);
                ++taskCnt;
            }
            ++n2;
        }
        pool.shutdown();
        System.out.println("Submitted " + taskCnt + " decoding tasks,waiting...");
        pool.awaitTermination(365L, TimeUnit.DAYS);
        System.out.println("Decoding finished.");
    }

    /*
     * WARNING - void declaration
     */
    private void encodeMultiThreaded() throws InterruptedException, ExecutionException {
        void var6_9;
        ExecutorService pool = Executors.newFixedThreadPool(MAX_THREAD_COUNT);
        File[] files = this.srcDir.listFiles();
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        int taskCnt = 0;
        File[] fileArray = files;
        int n = files.length;
        boolean n2 = false;
        while (var6_9 < n) {
            File f = fileArray[var6_9];
            String fName = f.getName();
            if (fName.matches(".*" + wavExtRegex)) {
                String fNameBody = fName.replaceFirst(wavExtRegex, "");
                String wvFilename = String.valueOf(fNameBody) + "." + this.type.getExtension();
                File wvFile = new File(this.targetDir, wvFilename);
                EncoderWorker w = new EncoderWorker(f, wvFile, this.targetEncoding, WavPackFileWriter.FILE_FORMAT_TYPE);
                Future<Boolean> fu = pool.submit(w);
                futures.add(fu);
                ++taskCnt;
            }
            ++var6_9;
        }
        pool.shutdown();
        System.out.println("Submitted " + taskCnt + " encoding tasks,waiting...");
        pool.awaitTermination(365L, TimeUnit.DAYS);
        System.out.println("Encoding finished.");
        boolean allOk = true;
        for (Future future : futures) {
            boolean bl = allOk = allOk && (Boolean)future.get() != false;
        }
        if (!allOk) {
            System.err.println("Encoding failed.");
        }
    }
}

