/*
 * Decompiled with CFR 0.152.
 */
package ips.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OutputInputStreamAdapter
extends OutputStream {
    private byte[] buffer = new byte[0];
    private byte[] singleByteBuf = new byte[1];
    private int bufWritePos = 0;
    private int bufReadPos = 0;
    private boolean closed = false;
    private long totalRead = 0L;
    private long totalWritten = 0L;
    private FileOutputStream testFileStream;

    @Override
    public void write(int arg0) throws IOException {
        this.singleByteBuf[0] = (byte)(arg0 & 0xFF);
        this.write(this.singleByteBuf);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        int availForWrite;
        if (this.bufWritePos == this.bufReadPos) {
            this.bufWritePos = 0;
            this.bufReadPos = 0;
        }
        if (len > (availForWrite = this.buffer.length - this.bufWritePos)) {
            byte[] increasedBuffer = new byte[this.bufWritePos + len];
            int i = 0;
            while (i < this.bufWritePos) {
                increasedBuffer[i] = this.buffer[i];
                ++i;
            }
            this.buffer = increasedBuffer;
        }
        int j = 0;
        while (j < len) {
            this.buffer[this.bufWritePos + j] = buf[off + j];
            ++j;
        }
        this.bufWritePos += len;
        this.totalWritten += (long)len;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public InputStream getInputStream() {
        return new AdapterInputStream();
    }

    public class AdapterInputStream
    extends InputStream {
        private byte[] singleByteBuf = new byte[1];

        @Override
        public int read() throws IOException {
            int read = this.read(this.singleByteBuf, 0, 1);
            if (read == -1) {
                return read;
            }
            return 0xFF & this.singleByteBuf[0];
        }

        @Override
        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int offset, int len) {
            assert (len > 0);
            int bytesToRead = len;
            int avail = this.available();
            if (avail == 0 && OutputInputStreamAdapter.this.closed) {
                return -1;
            }
            if (bytesToRead > avail) {
                bytesToRead = avail;
            }
            int i = 0;
            while (i < bytesToRead) {
                b[offset + i] = OutputInputStreamAdapter.this.buffer[OutputInputStreamAdapter.this.bufReadPos + i];
                ++i;
            }
            OutputInputStreamAdapter outputInputStreamAdapter = OutputInputStreamAdapter.this;
            outputInputStreamAdapter.bufReadPos = outputInputStreamAdapter.bufReadPos + bytesToRead;
            OutputInputStreamAdapter outputInputStreamAdapter2 = OutputInputStreamAdapter.this;
            outputInputStreamAdapter2.totalRead = outputInputStreamAdapter2.totalRead + (long)bytesToRead;
            return bytesToRead;
        }

        @Override
        public int available() {
            return OutputInputStreamAdapter.this.bufWritePos - OutputInputStreamAdapter.this.bufReadPos;
        }
    }
}

