/*
 * Decompiled with CFR 0.152.
 */
package ips.security.jaas;

import java.io.Console;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ConsoleCallbackHandler
implements CallbackHandler {
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Console console = System.console();
        for (Callback cb : callbacks) {
            String prompt;
            if (cb instanceof TextOutputCallback) {
                TextOutputCallback tocb = (TextOutputCallback)cb;
                String msg = tocb.getMessage();
                console.printf("%s\n", msg);
                continue;
            }
            if (cb instanceof TextInputCallback) {
                TextInputCallback ticb = (TextInputCallback)cb;
                String defaultText = ticb.getDefaultText();
                String prompt2 = ticb.getPrompt();
                if (prompt2 != null) {
                    console.printf("%s", prompt2);
                }
                String retInput = null;
                String input = console.readLine();
                retInput = input != null && "".equals(input) ? input : defaultText;
                ticb.setText(retInput);
                continue;
            }
            if (cb instanceof NameCallback) {
                NameCallback ncb = (NameCallback)cb;
                prompt = ncb.getPrompt();
                if (prompt != null) {
                    console.printf("%s", prompt);
                }
                String input = console.readLine();
                ncb.setName(input);
                continue;
            }
            if (cb instanceof PasswordCallback) {
                PasswordCallback pwcb = (PasswordCallback)cb;
                prompt = pwcb.getPrompt();
                if (prompt != null) {
                    console.printf("%s", prompt);
                }
                char[] passwInput = console.readPassword();
                pwcb.setPassword(passwInput);
                continue;
            }
            throw new UnsupportedCallbackException(cb, "Cannot handle callback.");
        }
    }
}

