/*
 * Decompiled with CFR 0.152.
 */
package ips.security.jaas;

import ips.security.jaas.JDBCPrincipal;
import ips.security.jaas.RolePrincipal;
import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jasypt.util.password.rfc2307.RFC2307SSHAPasswordEncryptor;

public class JDBCLoginModule
implements LoginModule {
    private boolean debug = false;
    public static final String DB_CONN_URL = "dbURL";
    public static final String DB_USER = "dbUser";
    public static final String DB_PASSWORD = "dbPassword";
    public static final String ACCOUNT_TABLENAME_PARAM_NAME = "userTable";
    public static final String ROLES_TABLENAME_PARAM_NAME = "userRoleTable";
    public static final String USERNAME_COL_PARAM_NAME = "userNameCol";
    public static final String USERNAME_CASE_INSENSITIVE_COL_PARAM_NAME = "userNameCaseInsensitivCol";
    public static final String ROLENAME_COL_PARAM_NAME = "roleNameCol";
    public static final String CRED_COL_PARAM_NAME = "userCredCol";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private String principalName = null;
    private Principal userPrincipal;
    private List<RolePrincipal> rolePrincipalList = new ArrayList<RolePrincipal>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (this.debug) {
            System.out.println(this.getClass().getName() + " Initialized");
        }
    }

    @Override
    public boolean login() throws LoginException {
        String userNameCaseInsensitiveColumnOptStr;
        String userNameCaseInsensitiveColumnOptStrTr;
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available.");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Login: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: Unsupported callback:" + uce.getCallback());
        }
        if (this.debug) {
            System.out.println("[JDBCLoginModule] user entered user name: " + this.username);
            System.out.println("[JDBCLoginModule] user entered a password");
        }
        String tableName = ((String)this.options.get(ACCOUNT_TABLENAME_PARAM_NAME)).trim();
        String userNameColumn = ((String)this.options.get(USERNAME_COL_PARAM_NAME)).trim();
        String userNameCaseInsensitiveColumn = null;
        Object userNameCaseInsensitiveColumnOptObj = this.options.get(USERNAME_CASE_INSENSITIVE_COL_PARAM_NAME);
        if (this.debug) {
            System.out.println("[JDBCLoginModule] userNameCaseInsensitivCol: " + userNameCaseInsensitiveColumn);
        }
        if (userNameCaseInsensitiveColumnOptObj instanceof String && !(userNameCaseInsensitiveColumnOptStrTr = (userNameCaseInsensitiveColumnOptStr = (String)userNameCaseInsensitiveColumnOptObj).trim()).isBlank()) {
            userNameCaseInsensitiveColumn = userNameCaseInsensitiveColumnOptStrTr;
        }
        String passwordColumn = ((String)this.options.get(CRED_COL_PARAM_NAME)).trim();
        String rolesTableName = ((String)this.options.get(ROLES_TABLENAME_PARAM_NAME)).trim();
        String rolesColumn = ((String)this.options.get(ROLENAME_COL_PARAM_NAME)).trim();
        String dbConnectionURL = (String)this.options.get(DB_CONN_URL);
        String dbUser = ((String)this.options.get(DB_USER)).trim();
        String dbPasswd = ((String)this.options.get(DB_PASSWORD)).trim();
        if (this.debug) {
            System.out.println("[JDBCLoginModule] try to connect to " + dbConnectionURL + " as user " + dbUser);
        }
        LoginException loginException = null;
        try {
            ResultSet rs;
            Connection conn = DriverManager.getConnection(dbConnectionURL, dbUser, dbPasswd);
            if (this.debug) {
                System.out.println("[JDBCLoginModule] JDBC connection: " + conn);
            }
            Object query = "SELECT " + userNameColumn;
            if (userNameCaseInsensitiveColumn != null) {
                query = ((String)query).concat("," + userNameCaseInsensitiveColumn);
            }
            query = ((String)query).concat("," + passwordColumn + " FROM " + tableName + " WHERE ");
            if (userNameCaseInsensitiveColumn == null) {
                query = ((String)query).concat(userNameColumn + "=?");
            } else {
                if (this.debug) {
                    System.out.println("[JDBCLoginModule] Case-insensitive column: " + userNameCaseInsensitiveColumn);
                }
                query = ((String)query).concat("((" + userNameColumn + "=? ) OR (" + userNameCaseInsensitiveColumn + "=TRUE AND lower(" + userNameColumn + ") = lower(?)))");
            }
            PreparedStatement pst = conn.prepareStatement((String)query);
            pst.setString(1, this.username);
            if (userNameCaseInsensitiveColumn != null) {
                pst.setString(2, this.username);
            }
            if ((rs = pst.executeQuery()).next()) {
                String rfc2307Password = rs.getString(passwordColumn);
                RFC2307SSHAPasswordEncryptor pwe = new RFC2307SSHAPasswordEncryptor();
                String passwordStr = String.valueOf(this.password);
                this.succeeded = pwe.checkPassword(passwordStr, rfc2307Password);
                this.principalName = rs.getString(userNameColumn);
                if (this.succeeded) {
                    if (this.debug) {
                        System.out.println("[JDBCLoginModule] user " + this.username + " authenticated as " + this.principalName + " .");
                    }
                    String rquery = "SELECT " + userNameColumn + "," + rolesColumn + " FROM " + rolesTableName + " WHERE " + userNameColumn + "=?";
                    PreparedStatement rpst = conn.prepareStatement(rquery);
                    rpst.setString(1, this.principalName);
                    ResultSet rrs = rpst.executeQuery();
                    while (rrs.next()) {
                        String role = rrs.getString(rolesColumn);
                        RolePrincipal rp = new RolePrincipal(role);
                        this.rolePrincipalList.add(rp);
                        if (!this.debug) continue;
                        System.out.println("[JDBCLoginModule] added role " + rp + " to user " + this.principalName);
                    }
                } else {
                    loginException = new FailedLoginException("Password could not be verified.");
                    if (this.debug) {
                        System.out.println("[JDBCLoginModule] password could not be verified for user " + this.username);
                    }
                }
                passwordStr = null;
            } else {
                loginException = new AccountNotFoundException();
                if (this.debug) {
                    System.out.println("[JDBCLoginModule] user " + this.username + " not found in database.");
                }
            }
            conn.close();
            if (this.debug) {
                System.out.println("[JDBCLoginModule] finished password check for user " + this.username);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (this.debug) {
                System.out.println("[JDBCLoginModule] could not connect to database.");
            }
            loginException = new FailedLoginException("Could not connect to database");
        }
        if (loginException != null) {
            throw loginException;
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principalSet = this.subject.getPrincipals();
        this.userPrincipal = new JDBCPrincipal(this.principalName);
        if (!principalSet.contains(this.userPrincipal)) {
            principalSet.add(this.userPrincipal);
            if (this.debug) {
                System.out.println("[JDBCLoginModule] added Principal " + this.userPrincipal.getName() + " to Subject");
            }
        }
        for (RolePrincipal rp : this.rolePrincipalList) {
            if (principalSet.contains(rp)) continue;
            principalSet.add(rp);
            if (!this.debug) continue;
            System.out.println("[JDBCLoginModule] added RolePrincipal " + rp.getName() + " to Subject");
        }
        this.username = null;
        this.principalName = null;
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = 32;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.principalName = null;
            if (this.password != null) {
                for (int i = 0; i < this.password.length; ++i) {
                    this.password[i] = 32;
                }
                this.password = null;
            }
            this.userPrincipal = null;
            this.rolePrincipalList.clear();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().clear();
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        this.rolePrincipalList.clear();
        return true;
    }
}

