/*
 * Decompiled with CFR 0.152.
 */
package ips.security.jaas;

import ips.security.jaas.InetOrgPersonPrincipal;
import ips.security.jaas.RolePrincipal;
import java.io.IOException;
import java.security.Principal;
import java.time.Instant;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LDAPLoginModule
implements LoginModule {
    private boolean debug = false;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> sharedState;
    private Map<String, ?> options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private String baseDN;
    private String userDn;
    private InetOrgPersonPrincipal userPrincipal;
    private RolePrincipal rolePrincipal;
    private DirContext context = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (this.debug) {
            String implVersion = this.getClass().getPackage().getImplementationVersion();
            System.out.println("[LDAPLoginModule] LDAP login module version: " + implVersion);
            System.out.println("[LDAPLoginModule] " + this.getClass().getName() + " Initialized. Object: " + this.toString());
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available.");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Login: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: Unsupported callback:" + uce.getCallback());
        }
        if (this.debug) {
            System.out.println("[LDAPLoginModule] user entered user name: " + this.username);
            System.out.println("[LDAPLoginModule] user entered a password");
        }
        this.baseDN = ((String)this.options.get("baseDN")).trim();
        String accountsDN = ((String)this.options.get("accountsDN")).trim();
        StringBuffer userDNBuffer = new StringBuffer("uid=");
        userDNBuffer.append(this.username);
        userDNBuffer.append(',');
        if (this.debug) {
            System.out.println("[LDAPLoginModule] accountsDN: " + accountsDN);
        }
        if (accountsDN != null && !"".equals(accountsDN)) {
            userDNBuffer.append(accountsDN);
            if (!accountsDN.endsWith(",")) {
                userDNBuffer.append(',');
            }
        }
        userDNBuffer.append(this.baseDN);
        this.userDn = userDNBuffer.toString();
        String connectionURL = (String)this.options.get("connectionURL");
        if (this.debug) {
            System.out.println("[LDAPLoginModule] try to connect to " + connectionURL + " as user " + this.userDn);
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.provider.url", connectionURL);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.principal", this.userDn);
        env.put("java.naming.security.credentials", this.password);
        try {
            this.context = new InitialDirContext(env);
            if (this.debug) {
                System.out.println("[LDAPLoginModule] successfully bound to LDAP.");
            }
            boolean expired = false;
            try {
                Attributes attrs = this.context.getAttributes(this.userDn);
                Attribute inetOrgPersonClassAttr = attrs.get("objectClass");
                NamingEnumeration<?> objClassesEnum = inetOrgPersonClassAttr.getAll();
                while (objClassesEnum.hasMore()) {
                    Attribute expireAttr;
                    Object objClassObj = objClassesEnum.next();
                    if (!"shadowAccount".equals(objClassObj)) continue;
                    if (this.debug) {
                        System.out.println("[LDAPLoginModule] User account has object class shadowAccount.");
                    }
                    if ((expireAttr = attrs.get("shadowExpire")) == null) continue;
                    Object expireObj = expireAttr.get();
                    if (expireObj instanceof String) {
                        String expireStr = (String)expireObj;
                        if (this.debug) {
                            System.out.println("[LDAPLoginModule] User account shadowExpire: " + expireStr);
                        }
                        try {
                            Instant expire;
                            long shadowExpire = Long.valueOf(expireStr);
                            if (shadowExpire < 0L) continue;
                            long expireEpochSeconds = shadowExpire * 60L * 60L * 24L;
                            Instant now = Instant.now();
                            if (now.isAfter(expire = Instant.ofEpochSecond(expireEpochSeconds))) {
                                expired = true;
                                if (!this.debug) continue;
                                System.out.println("[LDAPLoginModule] User account expired.");
                                continue;
                            }
                            if (!this.debug) continue;
                            System.out.println("[LDAPLoginModule] User account not expired.");
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("[LDAPLoginModule] Could not parse shadowExpire value " + expireStr);
                        }
                        continue;
                    }
                    System.err.println("[LDAPLoginModule] Unexpected type of shadowExpire attribute (not a string).");
                }
            }
            catch (NamingException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
            if (expired) {
                throw new AccountExpiredException();
            }
            this.succeeded = true;
            return this.succeeded;
        }
        catch (NamingException e) {
            if (this.debug) {
                System.out.println("[LDAPLoginModule] Could not bind to LDAP.");
            }
            throw new FailedLoginException("Could not bind to LDAP");
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principalSet = this.subject.getPrincipals();
        try {
            Attributes attrs = this.context.getAttributes(this.userDn);
            Attribute inetOrgPersonClassAttr = attrs.get("objectClass");
            NamingEnumeration<?> objClassesEnum = inetOrgPersonClassAttr.getAll();
            while (objClassesEnum.hasMore()) {
                Object objClassObj = objClassesEnum.next();
                if (!"inetOrgPerson".equals(objClassObj)) continue;
                this.userPrincipal = new InetOrgPersonPrincipal(this.userDn, attrs);
                if (!principalSet.contains(this.userPrincipal)) {
                    principalSet.add(this.userPrincipal);
                    if (this.debug) {
                        System.out.println("[LDAPLoginModule] added InetOrgPrincipal " + this.userPrincipal.getName() + " to Subject");
                    }
                }
                if (!this.debug) continue;
                System.out.println("[LDAPLoginModule] Displayname: " + this.userPrincipal.getAttrDisplayname());
                System.out.println("[LDAPLoginModule] Given name: " + this.userPrincipal.getAttrGivenname());
                System.out.println("[LDAPLoginModule] Surname: " + this.userPrincipal.getAttrSurname());
                System.out.println("[LDAPLoginModule] E-Mail: " + this.userPrincipal.getAttrMail());
            }
        }
        catch (NamingException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        StringBuffer rolesNodeDNBuffer = new StringBuffer("");
        String rolesDN = ((String)this.options.get("rolesDN")).trim();
        if (this.debug) {
            System.out.println("[LDAPLoginModule] rolesDN option: " + rolesDN);
        }
        if (rolesDN != null && !"".equals(rolesDN)) {
            rolesNodeDNBuffer.append(rolesDN);
            if (!rolesDN.endsWith(",")) {
                rolesNodeDNBuffer.append(',');
            }
        }
        rolesNodeDNBuffer.append(this.baseDN);
        String rolesNodeDN = rolesNodeDNBuffer.toString();
        BasicAttribute objClassAttr = new BasicAttribute("objectClass", "groupOfNames");
        BasicAttribute memberAttr = new BasicAttribute("member", this.userDn);
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(objClassAttr);
        attrs.put(memberAttr);
        try {
            NamingEnumeration<SearchResult> rolesSearchRes = this.context.search(rolesNodeDN, (Attributes)attrs);
            while (rolesSearchRes.hasMore()) {
                SearchResult sr = rolesSearchRes.next();
                Attributes srAttrs = sr.getAttributes();
                Attribute cnattr = srAttrs.get("cn");
                Object roleObj = cnattr.get();
                if (!(roleObj instanceof String)) continue;
                String role = (String)roleObj;
                this.rolePrincipal = new RolePrincipal(role);
                if (principalSet.contains(this.rolePrincipal)) continue;
                principalSet.add(this.rolePrincipal);
                if (!this.debug) continue;
                System.out.println("[LDAPLoginModule] added RolePrincipal " + this.rolePrincipal.getName() + " to Subject");
            }
        }
        catch (NamingException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        String defaultRolesOpt = (String)this.options.get("defaultRoles");
        if (defaultRolesOpt != null) {
            String[] defaultRoleNms;
            for (String defRoleNm : defaultRoleNms = defaultRolesOpt.trim().split("\\s*,\\s*")) {
                RolePrincipal rolePrincipal = new RolePrincipal(defRoleNm);
                if (principalSet.contains(rolePrincipal)) continue;
                principalSet.add(rolePrincipal);
                if (!this.debug) continue;
                System.out.println("[LDAPLoginModule] added default RolePrincipal " + rolePrincipal.getName() + " to Subject");
            }
        }
        this.username = null;
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = 32;
        }
        this.password = null;
        this.commitSucceeded = true;
        this.closeContext("commit");
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                for (int i = 0; i < this.password.length; ++i) {
                    this.password[i] = 32;
                }
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        this.closeContext("abort");
        if (this.debug) {
            System.out.println("[LDAPLoginModule] login aborted.");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrincipals().remove(this.rolePrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        this.rolePrincipal = null;
        this.closeContext("logout");
        return true;
    }

    private void closeContext(String methodName) {
        try {
            if (this.context != null) {
                this.context.close();
                if (this.debug) {
                    System.out.println("[LDAPLoginModule] closed LDAP context.");
                }
            }
        }
        catch (NamingException e) {
            System.err.println("[LDAPLoginModule] Could not close LDAP context on " + methodName + " :");
            e.printStackTrace(System.err);
        }
    }
}

