/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.LinkID;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.RecordingFile;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.annotations.TextAreaView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;

@Entity
@Table(name="distribution")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="distribution")
@PluralResourceKey(value="distributions")
@PreferredDisplayOrder(value="distributionId,name,version,description,*")
public class Distribution
implements Serializable {
    private int distributionId;
    private String name;
    private String version;
    private String description;
    private List<RecordingFile> recordingFiles = new ArrayList<RecordingFile>();

    @Id
    @Column(name="distribution_id", unique=true)
    @GeneratedValue(generator="id_gen")
    @LinkID
    @ResourceKey(value="id")
    public int getDistributionId() {
        return this.distributionId;
    }

    public void setDistributionId(int distributionId) {
        this.distributionId = distributionId;
    }

    @Column(length=100)
    @ResourceKey(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(length=20)
    @ResourceKey(value="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Column(length=10000)
    @ResourceKey(value="description")
    @TextAreaView
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="distribution_recording_files", joinColumns={@JoinColumn(name="disribution_id")}, inverseJoinColumns={@JoinColumn(name="recording_file_id")})
    @OrderColumn
    @ResourceKey(value="recording_files")
    public List<RecordingFile> getRecordingFiles() {
        return this.recordingFiles;
    }

    public void setRecordingFiles(List<RecordingFile> recordingFiles) {
        this.recordingFiles = recordingFiles;
    }
}

