/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.Unit;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Presenter;
import ipsk.db.speech.PromptItem;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.util.ResourceKey;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="recording")
@DiscriminatorValue(value="nonrecording")
@XmlType(name="nonrecording", namespace="promptitem")
public class Nonrecording
extends PromptItem
implements Serializable,
PropertyChangeListener {
    public static final String ELEMENT_NAME = "nonrecording";
    private static final String ATT_DURATION = "duration";
    private String[] comments;
    private Integer duration;

    public Nonrecording() {
    }

    public Nonrecording(IntegerSequenceGenerator seqGen, Element e) {
        this();
        if (seqGen != null) {
            this.setRecpromptId(seqGen.getAndIncrement());
        }
        NodeList childs = e.getChildNodes();
        ArrayList<String> commentsArrList = new ArrayList<String>();
        for (int ci = 0; ci < childs.getLength(); ++ci) {
            Node n = childs.item(ci);
            if (n.getNodeType() != 8) continue;
            commentsArrList.add(n.getNodeValue());
        }
        this.comments = commentsArrList.toArray(new String[0]);
        NodeList prE = e.getElementsByTagName("presenter");
        int prELen = prE.getLength();
        if (prELen >= 1) {
            Presenter presenter = new Presenter((Element)prE.item(0));
            this.setPresenter(presenter);
        }
        ArrayList<Mediaitem> mis = new ArrayList<Mediaitem>();
        NodeList miE = e.getElementsByTagName("mediaitem");
        int miELen = miE.getLength();
        for (int i = 0; i < miELen; ++i) {
            Mediaitem mi = new Mediaitem((Element)miE.item(i));
            mis.add(mi);
        }
        this.setMediaitems(mis);
        Attr attDuration = e.getAttributeNode(ATT_DURATION);
        if (attDuration != null) {
            this.duration = Integer.parseInt(attDuration.getValue());
        }
    }

    @Override
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="recording_mediaitem", joinColumns={@JoinColumn(name="promptitems_recording_id", referencedColumnName="recording_id")})
    @ResourceKey(value="media.item")
    @XmlElement(name="mediaitems")
    public List<Mediaitem> getMediaitems() {
        return super.getMediaitems();
    }

    @Override
    public void setMediaitems(List<Mediaitem> mediaitems) {
        super.setMediaitems(mediaitems);
    }

    @Override
    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        if (this.duration != null) {
            e.setAttribute(ATT_DURATION, this.duration.toString());
        }
        List<Mediaitem> mis = this.getMediaitems();
        for (Mediaitem mi : mis) {
            e.appendChild(mi.toElement(d));
        }
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        String hPropName = "nonrecording." + propName;
        this.propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
    }

    @Column(name="duration")
    @ResourceKey(value="nonrecording.duration")
    @Unit(value="ms")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        Integer oldDuration = this.duration;
        this.duration = duration;
        this.propertyChangeSupport.firePropertyChange(ATT_DURATION, oldDuration, this.duration);
    }
}

