/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.utils;

public class MIMETypeWorkaround {
    private String convertedMimeType;
    private String convertedCharset;

    public MIMETypeWorkaround(String mimeType, String charset) {
        if (mimeType != null) {
            this.convertedMimeType = mimeType;
            if (charset == null) {
                int sepIndex = mimeType.indexOf("/");
                String type = mimeType.substring(0, sepIndex).trim();
                String subType = mimeType.substring(sepIndex + 1).trim();
                if (type.equalsIgnoreCase("text")) {
                    if (subType.equalsIgnoreCase("UTF-8")) {
                        this.convertedMimeType = "text/plain";
                        this.convertedCharset = null;
                    } else if (subType.matches("ISO[_-].*")) {
                        this.convertedMimeType = "text/plain";
                        this.convertedCharset = subType;
                    }
                }
            }
        }
    }

    public String getConvertedMimeType() {
        return this.convertedMimeType;
    }

    public String getConvertedCharset() {
        return this.convertedCharset;
    }
}

