/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.Recording;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="annotationtemplate")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
public class AnnotationTemplate
extends BasicPropertyChangeSupport
implements Serializable {
    public static final String ELEMENT_NAME = "annotationtemplate";
    public static final String ATTLANGCODE = "languageISO639code";
    public static final String ATTCOUNTRYCODE = "countryISO3166code";
    private int annotationtemplateId;
    private String annotationtemplate;
    private String languageISO639code;
    private String countryISO3166code;
    private Recording recording;
    private String[] comments = new String[0];

    public AnnotationTemplate() {
    }

    public AnnotationTemplate(int annotationtemplateId) {
        this();
        this.annotationtemplateId = annotationtemplateId;
    }

    public AnnotationTemplate(Element e) {
        this();
        Attr attCountryCode;
        NodeList childs = e.getChildNodes();
        ArrayList<String> commentsArrList = new ArrayList<String>();
        int ci = 0;
        while (ci < childs.getLength()) {
            Node n = childs.item(ci);
            if (n.getNodeType() == 8) {
                commentsArrList.add(n.getNodeValue());
            }
            ++ci;
        }
        this.comments = commentsArrList.toArray(new String[0]);
        Attr attLangCode = e.getAttributeNode(ATTLANGCODE);
        if (attLangCode != null) {
            this.languageISO639code = attLangCode.getValue();
        }
        if ((attCountryCode = e.getAttributeNode(ATTCOUNTRYCODE)) != null) {
            this.countryISO3166code = attCountryCode.getValue();
        }
        this.setAnnotationtemplate(e.getTextContent());
    }

    @Id
    @Column(name="annotationtemplate_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @XmlTransient
    public int getAnnotationtemplateId() {
        return this.annotationtemplateId;
    }

    public void setAnnotationtemplateId(int annotationtemplateId) {
        this.annotationtemplateId = annotationtemplateId;
    }

    @Column(name="annotationtemplate", length=100000)
    @ResourceKey(value="annotationtemplate")
    public String getAnnotationtemplate() {
        return this.annotationtemplate;
    }

    public void setAnnotationtemplate(String annotationtemplate) {
        String oldannotationtemplate = this.annotationtemplate;
        this.annotationtemplate = annotationtemplate;
        this.propertyChangeSupport.firePropertyChange(ELEMENT_NAME, oldannotationtemplate, this.annotationtemplate);
    }

    @Column(name="languageISO639code", length=3)
    public String getLanguageISO639code() {
        return this.languageISO639code;
    }

    public void setLanguageISO639code(String languageISO639code) {
        this.languageISO639code = languageISO639code;
    }

    @Column(name="countryISO3166code", length=7)
    public String getCountryISO3166code() {
        return this.countryISO3166code;
    }

    public void setCountryISO3166code(String countryISO3166code) {
        this.countryISO3166code = countryISO3166code;
    }

    @XmlTransient
    @OneToOne
    @JoinColumn(name="recording_id")
    public Recording getRecording() {
        return this.recording;
    }

    public void setRecording(Recording recording) {
        this.recording = recording;
    }

    public String toString() {
        if (this.annotationtemplate != null) {
            return this.annotationtemplate;
        }
        return "";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AnnotationTemplate)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        AnnotationTemplate other = (AnnotationTemplate)o;
        if (other.getAnnotationtemplateId() != this.annotationtemplateId) {
            return false;
        }
        return !(other.getAnnotationtemplate() == null ? this.annotationtemplate != null : !other.getAnnotationtemplate().equals(this.annotationtemplate));
    }

    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        String[] stringArray = this.comments;
        int n = this.comments.length;
        int n2 = 0;
        while (n2 < n) {
            String comm = stringArray[n2];
            e.appendChild(d.createComment(comm));
            ++n2;
        }
        if (this.languageISO639code != null) {
            e.setAttribute(ATTLANGCODE, this.languageISO639code);
        }
        if (this.countryISO3166code != null) {
            e.setAttribute(ATTCOUNTRYCODE, this.countryISO3166code);
        }
        e.appendChild(d.createTextNode(this.getAnnotationtemplate()));
        return e;
    }
}

