/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.Unit;
import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMElements;
import ipsk.db.speech.Project;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="audio_format", schema="public")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="audio.format")
@PluralResourceKey(value="audio.formats")
@PreferredDisplayOrder(value="name,encoding,sampleRate,channels,*,projects")
@DOMAttributes(value={})
@DOMElements(value={"name", "encoding", "channels", "sampleRate", "bigEndian", "quantisation", "frameSize"})
public class AudioFormat {
    private String name = null;
    private String encoding = "PCM_SIGNED";
    private int channels = 2;
    private double sampleRate = 44100.0;
    private boolean bigEndian = false;
    private int quantisation = 16;
    private int frameSize = 4;
    private Set<Project> projects = new HashSet<Project>(0);

    public void setName(String string) {
        this.name = string;
    }

    @Id
    @Column(name="name", unique=true, nullable=false, updatable=false, length=100)
    @ResourceKey(value="name")
    public String getName() {
        return this.name;
    }

    @Column(name="encoding", updatable=false, length=100)
    @ResourceKey(value="encoding")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Column(name="channels", updatable=false)
    @ResourceKey(value="channels")
    public int getChannels() {
        return this.channels;
    }

    @Column(name="framesize", updatable=false)
    @ResourceKey(value="framesize")
    public int getFrameSize() {
        return this.frameSize;
    }

    @Column(name="samplerate", updatable=false)
    @ResourceKey(value="samplerate")
    @Unit(value="Hz")
    public double getSampleRate() {
        return this.sampleRate;
    }

    @Column(name="quantisation", updatable=false)
    @ResourceKey(value="quantisation")
    public int getQuantisation() {
        return this.quantisation;
    }

    @Column(name="bigendian", updatable=false)
    @ResourceKey(value="bigendian")
    public boolean getBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(boolean b) {
        this.bigEndian = b;
    }

    public void setChannels(int i) {
        this.channels = i;
    }

    public void setFrameSize(int i) {
        this.frameSize = i;
    }

    public void setSampleRate(double d) {
        this.sampleRate = d;
    }

    public void setQuantisation(int quantisation) {
        this.quantisation = quantisation;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="audioFormat")
    @ResourceKey(value="projects")
    @XmlTransient
    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }

    @Transient
    public String toString() {
        return this.name;
    }
}

