/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.Recording;
import ipsk.db.speech.utils.MIMETypeWorkaround;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="recinstructions")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@PreferredDisplayOrder(value="recinstructionsId,recinstructions")
public class Recinstructions
extends BasicPropertyChangeSupport
implements Serializable {
    public static final String ELEMENT_NAME = "recinstructions";
    public static final String ATTMIME = "mimetype";
    public static final String ATTCHARSET = "charset";
    public static final String DEF_CHARSET = "UTF-8";
    private int recinstructionsId;
    private String mimetype;
    private String recinstructions;
    private Set<Recording> recordingsSet = new HashSet<Recording>(0);
    private String[] comments = new String[0];
    private String charSet;

    public Recinstructions() {
    }

    public Recinstructions(int recinstructionsId) {
        this();
        this.recinstructionsId = recinstructionsId;
    }

    public Recinstructions(int recinstructionsId, String mimetype, String recinstructions, Set<Recording> recordings) {
        this(recinstructionsId);
        this.mimetype = mimetype;
        this.recinstructions = recinstructions;
        this.recordingsSet = recordings;
    }

    public Recinstructions(Element e) {
        NodeList childs = e.getChildNodes();
        ArrayList<String> commentsArrList = new ArrayList<String>();
        int ci = 0;
        while (ci < childs.getLength()) {
            Node n = childs.item(ci);
            if (n.getNodeType() == 8) {
                commentsArrList.add(n.getNodeValue());
            }
            ++ci;
        }
        this.comments = commentsArrList.toArray(new String[0]);
        Attr attMimetype = e.getAttributeNode(ATTMIME);
        Attr attCharset = e.getAttributeNode(ATTCHARSET);
        String mimetypeAttrVal = null;
        String charsetAttrVal = null;
        if (attMimetype != null) {
            mimetypeAttrVal = attMimetype.getValue();
        }
        if (attCharset != null) {
            charsetAttrVal = attCharset.getValue();
        }
        MIMETypeWorkaround mtw = new MIMETypeWorkaround(mimetypeAttrVal, charsetAttrVal);
        this.setMimetype(mtw.getConvertedMimeType());
        this.setCharSet(mtw.getConvertedCharset());
        this.setRecinstructions(e.getTextContent());
    }

    @Id
    @Column(name="recinstructions_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @XmlTransient
    public int getRecinstructionsId() {
        return this.recinstructionsId;
    }

    public void setRecinstructionsId(int recinstructionsId) {
        int oldRecinstructionsId = this.recinstructionsId;
        this.recinstructionsId = recinstructionsId;
        this.propertyChangeSupport.firePropertyChange("recinstructionsId", oldRecinstructionsId, this.recinstructionsId);
    }

    @Column(name="mimetype", updatable=false, length=100)
    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        String oldMimetype = this.mimetype;
        this.mimetype = mimetype;
        this.propertyChangeSupport.firePropertyChange(ATTMIME, oldMimetype, this.mimetype);
    }

    @Column(name="charset", length=100)
    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    @Transient
    public String getNNCharSet() {
        if (this.charSet == null) {
            return DEF_CHARSET;
        }
        return this.charSet;
    }

    @Column(name="recinstructions", updatable=false, length=1000)
    @ResourceKey(value="recinstructions")
    public String getRecinstructions() {
        return this.recinstructions;
    }

    public void setRecinstructions(String recinstructions) {
        String oldRecinstructions = this.recinstructions;
        this.recinstructions = recinstructions;
        this.propertyChangeSupport.firePropertyChange(ELEMENT_NAME, oldRecinstructions, this.recinstructions);
    }

    @OneToMany(mappedBy="recinstructions")
    @ObjectImmutableIfReferenced
    @XmlTransient
    public Set<Recording> getRecordingsSet() {
        return this.recordingsSet;
    }

    public void setRecordingsSet(Set<Recording> recordings) {
        this.recordingsSet = recordings;
    }

    public String toString() {
        if (this.recinstructions != null) {
            return this.recinstructions;
        }
        return "";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Recinstructions)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Recinstructions other = (Recinstructions)o;
        if (other.getRecinstructionsId() != this.recinstructionsId) {
            return false;
        }
        if (other.getMimetype() == null ? this.mimetype != null : !other.getMimetype().equals(this.mimetype)) {
            return false;
        }
        return !(other.getRecinstructions() == null ? this.recinstructions != null : !other.getRecinstructions().equals(this.recinstructions));
    }

    public Element toElement(Document d) {
        String cs;
        Element e = d.createElement(ELEMENT_NAME);
        String[] stringArray = this.comments;
        int n = this.comments.length;
        int n2 = 0;
        while (n2 < n) {
            String comm = stringArray[n2];
            e.appendChild(d.createComment(comm));
            ++n2;
        }
        String mimeType = this.getMimetype();
        if (mimeType != null) {
            e.setAttribute(ATTMIME, mimeType);
        }
        if ((cs = this.getCharSet()) != null) {
            e.setAttribute(ATTCHARSET, cs);
        }
        e.appendChild(d.createTextNode(this.getRecinstructions()));
        return e;
    }
}

