/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.Unit;
import ipsk.db.speech.AnnotationTemplate;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Reccomment;
import ipsk.db.speech.Recinstructions;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Recprompt;
import ipsk.db.speech.utils.BooleanValue;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="recording")
@DiscriminatorValue(value="recording")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="recording")
@PluralResourceKey(value="recordings")
@PreferredDisplayOrder(value="recpromptId,group,position,itemcode,mediaitem,recduration,rectype,recordingFiles")
@XmlType(name="recording", namespace="promptitem", propOrder={"itemcode", "rectype", "prerecdelay", "postrecdelay", "recduration", "recinstructions", "reccomment", "beep", "blocked", "finalsilence", "annotationTemplate", "mediaitems"})
public class Recording
extends Recprompt
implements PropertyChangeListener {
    public static final String ELEMENT_NAME = "recording";
    public static final boolean DEF_BLOCKED = false;
    public static final Integer DEF_RECDURATION = null;
    public static final int DEF_PRERECDELAY = 1000;
    public static final int DEF_POSTRECDELAY = 500;
    public static final String DEF_RECTYPE = "audio/wav";
    public static final String ATTPREREC = "prerecdelay";
    public static final String ATTRECDUR = "recduration";
    public static final String ATTPOSTREC = "postrecdelay";
    public static final String ATTITEMCODE = "itemcode";
    public static final String ATTTYPE = "rectype";
    public static final String ATTSILENCE = "finalsilence";
    public static final String ATTBEEP = "beep";
    public static final String ATTBLOCKED = "blocked";
    private Reccomment reccomment;
    private Recinstructions recinstructions;
    private AnnotationTemplate annotationTemplate;
    private String itemcode;
    private Integer recduration;
    private Integer prerecdelay;
    private Integer postrecdelay;
    private Integer finalsilence;
    private String beep;
    private String rectype;
    private Boolean blocked;
    private Set<RecordingFile> recordingFiles = new HashSet<RecordingFile>(0);
    private int defaultPrerecdelay = 1000;
    private int defaultPostrecdelay = 500;
    private String[] comments = new String[0];

    public Recording() {
        this.itemcode = "";
        this.recduration = DEF_RECDURATION;
        this.rectype = DEF_RECTYPE;
    }

    public Recording(IntegerSequenceGenerator seqGen, Element e) {
        super(seqGen, (Element)e.getElementsByTagName("recprompt").item(0));
        NodeList atE;
        NodeList instrE;
        NodeList childs = e.getChildNodes();
        ArrayList<String> commentsArrList = new ArrayList<String>();
        int ci = 0;
        while (ci < childs.getLength()) {
            Node n = childs.item(ci);
            if (n.getNodeType() == 8) {
                commentsArrList.add(n.getNodeValue());
            }
            ++ci;
        }
        this.comments = commentsArrList.toArray(new String[0]);
        this.initialize();
        this.setItemcode(e.getAttribute(ATTITEMCODE));
        Attr attr = e.getAttributeNode(ATTPREREC);
        if (attr != null) {
            this.setPrerecdelay(Integer.parseInt(attr.getValue()));
        }
        if ((attr = e.getAttributeNode(ATTRECDUR)) != null) {
            this.setRecduration(Integer.parseInt(attr.getValue()));
        }
        if ((attr = e.getAttributeNode(ATTPOSTREC)) != null) {
            this.setPostrecdelay(Integer.parseInt(attr.getValue()));
        }
        if ((attr = e.getAttributeNode(ATTBEEP)) != null) {
            this.setBeep(attr.getValue());
        }
        if ((attr = e.getAttributeNode(ATTSILENCE)) != null) {
            this.setFinalsilence(Integer.parseInt(attr.getValue()));
        }
        if ((attr = e.getAttributeNode(ATTTYPE)) != null) {
            this.setRectype(attr.getValue());
        }
        if ((attr = e.getAttributeNode(ATTBLOCKED)) != null) {
            this.setBlocked(BooleanValue.parseExtendedBoolean(attr));
        }
        if ((instrE = e.getElementsByTagName("recinstructions")).getLength() > 0) {
            this.setRecinstructions(new Recinstructions((Element)instrE.item(0)));
        }
        ArrayList<Mediaitem> mis = new ArrayList<Mediaitem>();
        NodeList miE = e.getElementsByTagName("mediaitem");
        int miELen = miE.getLength();
        int i = 0;
        while (i < miELen) {
            Mediaitem mi = new Mediaitem((Element)miE.item(i));
            mis.add(mi);
            ++i;
        }
        this.setMediaitems(mis);
        NodeList commentE = e.getElementsByTagName("reccomment");
        if (commentE.getLength() > 0) {
            this.setReccomment(new Reccomment((Element)commentE.item(0)));
        }
        if ((atE = e.getElementsByTagName("annotationtemplate")).getLength() > 0) {
            this.setAnnotationTemplate(new AnnotationTemplate((Element)atE.item(0)));
        }
    }

    private void initialize() {
        this.itemcode = "";
        this.recduration = DEF_RECDURATION;
    }

    @ManyToOne
    @JoinColumn(name="recinstructions_id", unique=false, nullable=true, insertable=true, updatable=true)
    @ResourceKey(value="recinstructions")
    public Recinstructions getRecinstructions() {
        return this.recinstructions;
    }

    public void setRecinstructions(Recinstructions recinstructions) {
        Recinstructions oldRecinstructions = this.recinstructions;
        if (oldRecinstructions != null) {
            oldRecinstructions.removePropertyChangeListener(this);
        }
        this.recinstructions = recinstructions;
        if (this.recinstructions != null) {
            this.recinstructions.addPropertyChangeListener(this);
        }
        this.propertyChangeSupport.firePropertyChange("recinstructions", oldRecinstructions, this.recinstructions);
    }

    @ManyToOne
    @JoinColumn(name="reccomment_id")
    @ResourceKey(value="reccomment")
    public Reccomment getReccomment() {
        return this.reccomment;
    }

    public void setReccomment(Reccomment reccomment) {
        Reccomment oldReccomment = this.reccomment;
        if (oldReccomment != null) {
            oldReccomment.removePropertyChangeListener(this);
        }
        this.reccomment = reccomment;
        if (this.reccomment != null) {
            this.reccomment.addPropertyChangeListener(this);
        }
        this.propertyChangeSupport.firePropertyChange("reccomment", oldReccomment, this.reccomment);
    }

    @OneToOne(mappedBy="recording", cascade={CascadeType.ALL})
    @ResourceKey(value="annotationTemplate")
    public AnnotationTemplate getAnnotationTemplate() {
        return this.annotationTemplate;
    }

    public void setAnnotationTemplate(AnnotationTemplate annotationTemplate) {
        this.annotationTemplate = annotationTemplate;
    }

    @Column(name="itemcode", length=1000)
    @ResourceKey(value="code")
    public String getItemcode() {
        return this.itemcode;
    }

    public void setItemcode(String itemcode) {
        String oldItemcode = this.itemcode;
        this.itemcode = itemcode;
        this.propertyChangeSupport.firePropertyChange(ATTITEMCODE, oldItemcode, this.itemcode);
    }

    @Column(name="recduration")
    @ResourceKey(value="recording.duration")
    @Unit(value="ms")
    public Integer getRecduration() {
        return this.recduration;
    }

    public void setRecduration(Integer recduration) {
        Integer oldRecduration = this.recduration;
        this.recduration = recduration;
        this.propertyChangeSupport.firePropertyChange(ATTRECDUR, oldRecduration, this.recduration);
    }

    @Column(name="prerecdelay")
    @ResourceKey(value="prerecdelay")
    @Unit(value="ms")
    public Integer getPrerecdelay() {
        return this.prerecdelay;
    }

    @Transient
    public int getNNPrerecdelay() {
        if (this.prerecdelay == null) {
            return this.defaultPrerecdelay;
        }
        return this.prerecdelay;
    }

    public void setPrerecdelay(Integer prerecdelay) {
        Integer oldPrerecdelay = this.prerecdelay;
        this.prerecdelay = prerecdelay;
        this.propertyChangeSupport.firePropertyChange(ATTPREREC, oldPrerecdelay, this.prerecdelay);
    }

    @Column(name="postrecdelay")
    @ResourceKey(value="postrecdelay")
    @Unit(value="ms")
    public Integer getPostrecdelay() {
        return this.postrecdelay;
    }

    @Transient
    public int getNNPostrecdelay() {
        if (this.postrecdelay == null) {
            return this.defaultPostrecdelay;
        }
        return this.postrecdelay;
    }

    public void setPostrecdelay(Integer postrecdelay) {
        Integer oldPostrecdelay = this.postrecdelay;
        this.postrecdelay = postrecdelay;
        this.propertyChangeSupport.firePropertyChange(ATTPOSTREC, oldPostrecdelay, this.postrecdelay);
    }

    @Column(name="finalsilence")
    @ResourceKey(value="finalsilence")
    @Unit(value="ms")
    public Integer getFinalsilence() {
        return this.finalsilence;
    }

    public void setFinalsilence(Integer finalsilence) {
        Integer oldFinalsilence = this.finalsilence;
        this.finalsilence = finalsilence;
        this.propertyChangeSupport.firePropertyChange(ATTSILENCE, oldFinalsilence, this.finalsilence);
    }

    @Column(name="beep", length=10)
    @ResourceKey(value="beep")
    public String getBeep() {
        return this.beep;
    }

    public void setBeep(String beep) {
        String oldBeep = this.beep;
        this.beep = beep;
        this.propertyChangeSupport.firePropertyChange(ATTBEEP, oldBeep, this.beep);
    }

    @Column(name="rectype", length=10)
    @ResourceKey(value="type")
    public String getRectype() {
        return this.rectype;
    }

    public void setRectype(String rectype) {
        String oldRectype = this.rectype;
        this.rectype = rectype;
        this.propertyChangeSupport.firePropertyChange(ATTTYPE, oldRectype, this.rectype);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="recording")
    @ResourceKey(value="recording_files")
    @ObjectImmutableIfReferenced
    @XmlTransient
    public Set<RecordingFile> getRecordingFiles() {
        return this.recordingFiles;
    }

    public void setRecordingFiles(Set<RecordingFile> recordingFiles) {
        this.recordingFiles = recordingFiles;
    }

    @Override
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="recording_mediaitem", joinColumns={@JoinColumn(name="promptitems_recording_id", referencedColumnName="recording_id")})
    @ResourceKey(value="media.item")
    @XmlElement(name="mediaitems")
    public List<Mediaitem> getMediaitems() {
        return super.getMediaitems();
    }

    @Override
    public void setMediaitems(List<Mediaitem> mediaitems) {
        super.setMediaitems(mediaitems);
    }

    @Override
    void apply() {
        super.apply();
        if (this.prerecdelay == null) {
            this.setPrerecdelay(this.getNNPrerecdelay());
        }
        if (this.postrecdelay == null) {
            this.setPostrecdelay(this.getNNPostrecdelay());
        }
    }

    @Override
    public Element toElement(Document d) {
        AnnotationTemplate at;
        Recinstructions recInstr;
        Integer postrecdelay;
        Element e = d.createElement(ELEMENT_NAME);
        String[] stringArray = this.comments;
        int n = this.comments.length;
        int n2 = 0;
        while (n2 < n) {
            String comm = stringArray[n2];
            e.appendChild(d.createComment(comm));
            ++n2;
        }
        Integer recDuration = this.getRecduration();
        if (recDuration != null) {
            e.setAttribute(ATTRECDUR, this.recduration.toString());
        }
        e.setAttribute(ATTITEMCODE, this.getItemcode());
        Integer prerecdelay = this.getPrerecdelay();
        if (prerecdelay != null) {
            e.setAttribute(ATTPREREC, prerecdelay.toString());
        }
        if ((postrecdelay = this.getPostrecdelay()) != null) {
            e.setAttribute(ATTPOSTREC, postrecdelay.toString());
        }
        if (this.beep != null) {
            e.setAttribute(ATTBEEP, this.beep);
        }
        if (this.blocked != null) {
            e.setAttribute(ATTBLOCKED, this.blocked.toString());
        }
        if (this.finalsilence != null) {
            e.setAttribute(ATTSILENCE, this.finalsilence.toString());
        }
        if ((recInstr = this.getRecinstructions()) != null) {
            e.appendChild(recInstr.toElement(d));
        }
        e.appendChild(super.toElement(d));
        Reccomment recComment = this.getReccomment();
        if (recComment != null) {
            e.appendChild(recComment.toElement(d));
        }
        if ((at = this.getAnnotationTemplate()) != null) {
            e.appendChild(at.toElement(d));
        }
        return e;
    }

    public String toString() {
        List<Mediaitem> mis = this.getMediaitems();
        int misSize = mis.size();
        StringBuffer prText = new StringBuffer();
        int i = 0;
        while (i < misSize) {
            Mediaitem mi = mis.get(i);
            prText.append(mi.toString());
            if (i + 1 < misSize) {
                prText.append(", ");
            }
            ++i;
        }
        return "prerecdelay=" + this.prerecdelay + "\t" + ATTRECDUR + "=" + this.recduration + "\t" + ATTPOSTREC + "=" + this.postrecdelay + "\tRecinstruction=" + this.getRecinstructions() + "\tPrompttext=" + prText + "\t" + ATTITEMCODE + "=" + this.itemcode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        String hPropName = "recording." + propName;
        this.propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
    }

    @ResourceKey(value="recording.blockedByPromptPlayback")
    public Boolean getBlocked() {
        return this.blocked;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    public void setNNBlocked(boolean blocked) {
        this.blocked = !blocked ? null : Boolean.valueOf(blocked);
    }

    @Transient
    @XmlTransient
    public boolean getNNBlocked() {
        if (this.blocked != null) {
            return this.blocked;
        }
        return false;
    }

    @Transient
    public boolean needsSilenceDetector() {
        return this.finalsilence != null && this.finalsilence > 0;
    }

    @Transient
    public boolean needsBeep() {
        boolean needsBeep = new Boolean(this.getBeep());
        return needsBeep;
    }

    public void setDefaultPrerecdelay(int defaultPrerecdelay) {
        this.defaultPrerecdelay = defaultPrerecdelay;
    }

    @Transient
    @XmlTransient
    public int getDefaultPrerecdelay() {
        return this.defaultPrerecdelay;
    }

    public void setDefaultPostrecdelay(int defaultPostrecdelay) {
        this.defaultPostrecdelay = defaultPostrecdelay;
    }

    @Transient
    @XmlTransient
    public int getDefaultPostrecdelay() {
        return this.defaultPostrecdelay;
    }

    public boolean equals(Object o) {
        Recording or;
        int oId;
        if (o == this) {
            return true;
        }
        return o instanceof Recording && (oId = (or = (Recording)o).getRecpromptId()) == this.getRecpromptId();
    }

    public int hashCode() {
        return this.getRecpromptId();
    }
}

