/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.LinkID;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMCollectionElement;
import ipsk.beans.dom.DOMElements;
import ipsk.db.speech.Group;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Project;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Recording;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Script;
import ipsk.db.speech.Section;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.XMLIntegerAdapter;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.annotations.TextAreaView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@Entity
@Table(name="session")
@NamedQueries(value={@NamedQuery(name="session.bySpeaker", query="SELECT sess FROM Session sess WHERE ?1 MEMBER OF sess.speakers"), @NamedQuery(name="sessions.forProject", query="SELECT s FROM Session s WHERE s.project = ?1")})
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@PreferredDisplayOrder(value="sessionId,uuid,project,status,date,type,script,code,speakers,recordingFiles,exportForAnnotation,comment")
@DOMAttributes(value={"sessionId"})
@DOMElements(value={"date", "code", "speakers", "script", "comment"})
@XmlType(name="session", namespace="session")
public class Session
implements Serializable {
    private Integer sessionId;
    private String uuid;
    private Script script;
    private Project project;
    private Organisation organisation;
    private String code;
    private String environment;
    private String comment;
    private Date date;
    private Type type;
    private Status status = Status.CREATED;
    private String httpSessionId;
    private String storageDirectoryURL;
    private boolean exportForAnnotation = false;
    private Set<RecordingFile> recordingFiles = new HashSet<RecordingFile>(0);
    private Boolean hasRecordings = null;
    private Set<Speaker> speakers = new HashSet<Speaker>(0);

    @Column(nullable=false)
    @ResourceKey(value="session.export_for_annotation")
    public boolean isExportForAnnotation() {
        return this.exportForAnnotation;
    }

    public void setExportForAnnotation(boolean exportForAnnotation) {
        this.exportForAnnotation = exportForAnnotation;
    }

    public Session() {
    }

    public Session(int sessionId) {
        this.sessionId = sessionId;
    }

    @Id
    @Column(name="session_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @LinkID
    @XmlID
    @XmlJavaTypeAdapter(value=XMLIntegerAdapter.class)
    public Integer getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Integer sessionId) {
        this.sessionId = sessionId;
    }

    @Column(name="uuid", length=36, unique=true, nullable=true, updatable=false)
    @ResourceKey(value="uuid")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @ManyToOne
    @JoinColumn(name="script_id")
    @ResourceKey(value="script")
    @XmlIDREF
    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    @Column(name="code", length=10)
    @ResourceKey(value="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="environment", length=100)
    @ResourceKey(value="environment")
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Column(name="comment", length=1000)
    @ResourceKey(value="comments")
    @TextAreaView
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @ManyToOne
    @JoinColumn(name="project")
    @ResourceKey(value="project")
    @XmlIDREF
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Column(updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="point_in_time")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="session")
    @ResourceKey(value="recording_files")
    @XmlTransient
    public Set<RecordingFile> getRecordingFiles() {
        return this.recordingFiles;
    }

    public void setRecordingFiles(Set<RecordingFile> recordingFiles) {
        this.recordingFiles = recordingFiles;
    }

    @Transient
    public void markHasRecordings(Boolean hasRecordings) {
        this.hasRecordings = hasRecordings;
    }

    @Transient
    public boolean hasRecordings() {
        if (this.hasRecordings != null) {
            return this.hasRecordings;
        }
        if (this.recordingFiles != null) {
            return this.recordingFiles.size() > 0;
        }
        return false;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="participates", joinColumns={@JoinColumn(name="session_id")}, inverseJoinColumns={@JoinColumn(name="speaker_id")})
    @DOMCollectionElement(collectionElementName="speaker")
    @ResourceKey(value="participants")
    @XmlIDREF
    public Set<Speaker> getSpeakers() {
        return this.speakers;
    }

    public void setSpeakers(Set<Speaker> speakers) {
        this.speakers = speakers;
    }

    @Column(name="type", length=10)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="type")
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Column(name="status", length=10)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="status")
    @XmlTransient
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Column(name="jsessionid", length=100)
    @XmlTransient
    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public void setHttpSessionId(String httpSessionId) {
        this.httpSessionId = httpSessionId;
    }

    @PrePersist
    public void setCurrentDate() {
        if (this.date == null) {
            this.setDate(new Date());
        }
    }

    public String toString() {
        return "Session: " + this.sessionId;
    }

    @Column(name="storage_dir_url", length=1000)
    @ResourceKey(value="storage.dir")
    @XmlTransient
    public String getStorageDirectoryURL() {
        return this.storageDirectoryURL;
    }

    public void setStorageDirectoryURL(String storageDirectoryURL) {
        this.storageDirectoryURL = storageDirectoryURL;
    }

    @ManyToOne
    @JoinColumn(name="organisation_id")
    @ResourceKey(value="organisation")
    @XmlTransient
    public Organisation getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    @Transient
    public Double getMaxLevel() {
        Double maxLevel = null;
        Set<RecordingFile> recordingFiles = this.getRecordingFiles();
        if (recordingFiles != null) {
            for (RecordingFile rf : recordingFiles) {
                Double rfML;
                Group g;
                Section section;
                Recording r = rf.getRecording();
                if (r != null && (section = (g = r.getGroup()).getSection()) != null && section.isTraining() || (rfML = rf.getMaxLevel()) == null) continue;
                if (maxLevel != null) {
                    if (!(rfML > maxLevel)) continue;
                    maxLevel = rfML;
                    continue;
                }
                maxLevel = rfML;
            }
        }
        return maxLevel;
    }

    @Transient
    public List<Recording> getMissingRecordingItems() {
        ArrayList<Recording> missingRecordingItems = new ArrayList<Recording>();
        Script script = this.getScript();
        if (script == null) {
            return null;
        }
        List<Section> sections = script.getSections();
        for (Section s : sections) {
            if (s.isTraining()) continue;
            List<Group> gs = s.getGroups();
            for (Group g : gs) {
                List<PromptItem> gPis = g.getPromptItems();
                for (PromptItem pi : gPis) {
                    if (!(pi instanceof Recording)) continue;
                    missingRecordingItems.add((Recording)pi);
                }
            }
        }
        Set<RecordingFile> rfs = this.getRecordingFiles();
        for (RecordingFile rf : rfs) {
            Recording r = rf.getRecording();
            missingRecordingItems.remove(r);
        }
        return missingRecordingItems;
    }

    public static enum LogLevel {
        SEVERE,
        WARNING,
        INFO,
        CONFIG,
        FINE,
        FINER,
        FINEST;

    }

    public static enum Status {
        CREATED,
        STARTED,
        CONNECTED,
        PAUSED,
        FINISHED;

    }

    @XmlType(name="sessionType")
    public static enum Type {
        TEST,
        SINE_TEST,
        NORM;

    }
}

