//    IPS Java Speech Database
//    (c) Copyright 2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Speech Database
//
//
//    IPS Java Speech Database is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Speech Database is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Speech Database.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.db.speech;


import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMCollectionElement;
import ipsk.beans.dom.DOMElements;
import ipsk.beans.validation.Input;
import ipsk.db.speech.Section.PromptPhase;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/**
 * Project
 */

@Entity
@Table(name = "project", schema = "public")
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("project")
@PluralResourceKey("projects")
//@PreferredDisplayOrder("name,description,hosts,organisations,dialectRegions,audioDevices,sessionFinishedMessage,*")
@PreferredDisplayOrder("name,uuid,description,defaultResearchPurpose,defaultResearchPurposeLanguageISO3code,organisations,dialectRegions,audioDevices,ownedScripts,scripts,allowPublicPseudonymizedAudioExport,*")
@DOMAttributes({"name"})
@DOMElements({"description","audioFormat","sessionCode","organisations"})
@XmlType(name="project",propOrder={"name","uuid", "description" , "defaultResearchPurpose", "defaultResearchPurposeLanguageISO3code","informedConsentPaperForm", "audioFormat", "audioDevices","speakerFormConfiguration","allowPublicPseudonymizedAudioExport","speakerWindowShowStopRecordAction" })
@XmlRootElement
public class Project implements java.io.Serializable {

//	public enum ScriptSelectionMode {
//	    MANUAL("manual"), LEAST_USAGE("least_usage");
//
//	    ScriptSelectionMode(String value) {
//	    	this.value = value;
//	    }
//	    private final String value;
//
//	    public String value() {
//	    	return value; 
//	    }
//	    public String toString() {
//	    	return value; 
//	    }
//	    public static ScriptSelectionMode getByValue(String value){
//	    	for(ScriptSelectionMode scrSel:ScriptSelectionMode.values()){
//	    		if(scrSel.value.equals(value)){
//	    			return scrSel;
//	    		}
//	    	}
//	    	return null;
//	    }
//	}
//	
	// Fields    

	private String name;
	
	private String uuid;
	
	private String contextPath;

	private String description;

	//private String hosts;
	
	private AudioFormat audioFormat;
	
	private String sessionCode;
	
//	private ScriptSelectionMode scriptSelectionMode;

//	@Column(name = "script_selection_mode", length = 32)
//	@Enumerated(EnumType.STRING)
//	@ResourceKey("script.selection.mode")
//	public ScriptSelectionMode getScriptSelectionMode() {
//		return scriptSelectionMode;
//	}
//
//	public void setScriptSelectionMode(ScriptSelectionMode scriptSelectionMode) {
//		this.scriptSelectionMode = scriptSelectionMode;
//	}
//

	private String defaultResearchPurpose;
	private String defaultResearchPurposeLanguageISO3code;
	
	private Set<Account> adminAccounts=new HashSet<Account>(0);
	
	private Set<Account> accounts=new HashSet<Account>(0);

	private Set<Session> sessions = new HashSet<Session>(0);
	
	private Set<InformedConsent> informedConsents = new HashSet<InformedConsent>(0);
	

	private Set<DialectRegion> dialectRegions = new HashSet<DialectRegion>(0);
	
	private List<SpeechRecorderClient> allowedSpeechRecorderClients=new ArrayList<SpeechRecorderClient>();
	
	private List<AudioDevice> audioDevices = new ArrayList<AudioDevice>(0);
//	private Set<AudioDevice> audioDevices=new HashSet<AudioDevice>(0);
	
	private Set<Organisation> organisations = new HashSet<Organisation>(0);
	
//	private Set<Speaker> speakers = new HashSet<Speaker>(0);
	
	private Set<Script> ownedScripts=new HashSet<Script>();
	
	private Set<Script> scripts = new HashSet<Script>(0);
	
	private boolean speakerWindowShowStopRecordAction=true;
	
	//private LocalizableMessage sessionFinishedMessage=null;
	

	
	
	//private Set<TypedPropertyDescriptor> immediateAnnotations=new HashSet<TypedPropertyDescriptor>(0);
	

	
	
//	private Set<FormConfiguration> formConfigurations=new HashSet<FormConfiguration>();
//	@ManyToMany
//	@ResourceKey("form.configurations")
//	public Set<FormConfiguration> getFormConfigurations() {
//		return formConfigurations;
//	}
//
//	public void setFormConfigurations(Set<FormConfiguration> formConfigurations) {
//		this.formConfigurations = formConfigurations;
//	}
	
	private boolean informedConsentPaperForm=false;
	@ResourceKey("consent.informed.paperform")
	public boolean isInformedConsentPaperForm() {
		return informedConsentPaperForm;
	}

	public void setInformedConsentPaperForm(boolean informedConsentPaperForm) {
		this.informedConsentPaperForm = informedConsentPaperForm;
	}

	
	private FormConfiguration speakerFormConfiguration;
	@ManyToOne
	@ResourceKey("speaker.form.configuration")
	public FormConfiguration getSpeakerFormConfiguration() {
		return speakerFormConfiguration;
	}

	public void setSpeakerFormConfiguration(
			FormConfiguration speakerFormConfiguration) {
		this.speakerFormConfiguration = speakerFormConfiguration;
	}
	
	private boolean allowPublicPseudonymizedAudioExport=false;
	
	@Column(name="allow_pub_pseudonymized_export")
	@ResourceKey("project.allowPublicPseudonymizedAudioExport")
	public boolean isAllowPublicPseudonymizedAudioExport() {
		return allowPublicPseudonymizedAudioExport;
	}

	public void setAllowPublicPseudonymizedAudioExport(boolean allowPublicPseudonymizedAudioExport) {
		this.allowPublicPseudonymizedAudioExport = allowPublicPseudonymizedAudioExport;
	}

	/** default constructor */
	public Project() {
		this(null);
	}

	/** minimal constructor */
	public Project(String name) {
		super();
		this.name = name;
		getAllowedSpeechRecorderClients().add(SpeechRecorderClient.HTML5_ANGULAR);
	}

	
	// Property accessors
	@Id
	@Column(name = "name", unique = true, nullable = false, length = 100)
	@ResourceKey("name")
	@Input(required=true)
	@XmlID
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Column(name = "uuid",length=36, unique = true, nullable = true, updatable=false)
	@ResourceKey("uuid")
	public String getUuid() {
		return uuid;
	}

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	@Column(name = "description", length = 1000)
	@ResourceKey("description")
	@ipsk.util.annotations.TextAreaView
	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

//	@Column(name = "hosts")
//	@ResourceKey("hosts")
//	@XmlTransient
//	public String getHosts() {
//		return this.hosts;
//	}
//
//	public void setHosts(String hosts) {
//		this.hosts = hosts;
//	}

	@OneToMany( fetch = FetchType.LAZY, mappedBy = "project")
	@ResourceKey("sessions")
//	@XmlIDREF
	@XmlTransient
	public Set<Session> getSessions() {
		return this.sessions;
	}

	public void setSessions(Set<Session> sessions) {
		this.sessions = sessions;
	}
	
	@OneToMany( fetch = FetchType.LAZY, mappedBy = "project")
	@ResourceKey("consents.informed")
	@XmlTransient
	public Set<InformedConsent> getInformedConsents() {
		return informedConsents;
	}

	public void setInformedConsents(Set<InformedConsent> informedConsents) {
		this.informedConsents = informedConsents;
	}


	
	@ManyToMany(fetch = FetchType.LAZY)
	@JoinTable(
		        name="project_audio_device",
		        joinColumns={@JoinColumn(name="project")},
		        //inverseJoinColumns={@JoinColumn(name="ad_name",referencedColumnName="name"),@JoinColumn(name="ad_is_playback",referencedColumnName="is_playback"),@JoinColumn(name="ad_api",referencedColumnName="api"),@JoinColumn(name="ad_regex",referencedColumnName="regex")}
		        inverseJoinColumns={@JoinColumn(name="audio_device_id",referencedColumnName="audio_device_id")}
		        )
    @ResourceKey("audio.devices")
    @OrderColumn
	public List<AudioDevice> getAudioDevices() {
		return this.audioDevices;
	}


// @OrderColumn does not work with a ManyToMany relationship with EclipseLink JPA
// see 
// https://bugs.eclipse.org/bugs/show_bug.cgi?id=309039
//
// Storage of the ordered list works, but the SQL SELECT command for reading from DB does not use an ORDER BY clause	
	
//	/**
//	 * Get list of audio devices
//	 * @return
//	 */
//	@ManyToMany(fetch = FetchType.EAGER)
//	@JoinTable(
//		        name="project_audio_device",
//		        joinColumns={@JoinColumn(name="project")},
//		        inverseJoinColumns={@JoinColumn(name="ad_name",referencedColumnName="name"),@JoinColumn(name="ad_is_playback",referencedColumnName="is_playback"),@JoinColumn(name="ad_api",referencedColumnName="api"),@JoinColumn(name="ad_regex",referencedColumnName="regex")})
//	@OrderColumn(name="index",insertable=true,updatable=true)	        
//    @ResourceKey("audio.devices")
//	public List<AudioDevice> getAudioDevices() {
//		return this.audioDevices;
//	}
//
//	public void setAudioDevices(List<AudioDevice> audioDevices) {
//		this.audioDevices = audioDevices;
//	}
	
	
	private List<AudioDevice> filterAudioDeviceList(Collection<AudioDevice> adColl,boolean hasJExt,boolean isRegex){
		ArrayList<AudioDevice> filteredList=new ArrayList<AudioDevice>();
		for(AudioDevice ad:adColl){
			String jExt=ad.getJextension();
			boolean devHasJExt=(jExt!=null && ! jExt.equals(""));
//			boolean devIsRegex=ad.getId().isRegex();
			boolean devIsRegex=ad.isRegex();
			if((devHasJExt == hasJExt) && (devIsRegex == isRegex)){
				filteredList.add(ad);
			}
		}
		return filteredList;
	}
//// Workaround for EclipseLink bug:
//// Order the devices: First order rule is:
////	First devices which need an extension (e.g. DSJavaSound).
////	Next rule:
////	Non regular expressions first, then regular expressions named devices.	
//	
//	@Transient
//	public List<AudioDevice> getSpeechrecorderOrderedAudioDevices(){
//		Set<AudioDevice> aDevSet=getAudioDevices();
//		ArrayList<AudioDevice> aDevList=new ArrayList<AudioDevice>();
//		
//		aDevList.addAll(filterAudioDeviceList(aDevSet, true, false));
//		aDevList.addAll(filterAudioDeviceList(aDevSet, true, true));
//		aDevList.addAll(filterAudioDeviceList(aDevSet, false, false));
//		aDevList.addAll(filterAudioDeviceList(aDevSet, false, true));
//		return aDevList;
//	}
	
	public void setAudioDevices(List<AudioDevice> audioDevices) {
		this.audioDevices = audioDevices;
	}
	
	@ManyToMany(fetch = FetchType.LAZY)
	@JoinTable(
		        name="project_dialect_region",
		        joinColumns={@JoinColumn(name="project")},
		        inverseJoinColumns={@JoinColumn(name="dialect_region")}
		    )
    @ResourceKey("dialect_regions")
    @XmlTransient
	public Set<DialectRegion> getDialectRegions() {
		return this.dialectRegions;
	}

	public void setDialectRegions(Set<DialectRegion> dialectRegions) {
		this.dialectRegions = dialectRegions;
	}
	
	public String toString(){
		return name;
	}
	
//	@ManyToMany(fetch = FetchType.LAZY)
//	@JoinTable(
//		        name="project_speakers",
//		        joinColumns={@JoinColumn(name="project")},
//		        inverseJoinColumns={@JoinColumn(name="speaker")}
//		    )
//	@DOMCollectionElement(collectionElementName="speakers")
//    @ResourceKey("speakers")
//    @XmlTransient
//	public Set<Speaker> getSpeakers() {
//		return speakers;
//	}
//
//	public void setSpeakers(Set<Speaker> speakers) {
//		this.speakers = speakers;
//	}

	@ManyToMany(fetch = FetchType.LAZY)
	@JoinTable(
		        name="project_organisations",
		        joinColumns={@JoinColumn(name="project")},
		        inverseJoinColumns={@JoinColumn(name="organisation")}
		    )
	@DOMCollectionElement(collectionElementName="organisation")
    @ResourceKey("organisations")
    @XmlTransient
	public Set<Organisation> getOrganisations() {
		return organisations;
	}

	public void setOrganisations(Set<Organisation> organisations) {
		this.organisations = organisations;
	}
	
	@ElementCollection(targetClass=SpeechRecorderClient.class)
    @Enumerated(EnumType.STRING)
    @CollectionTable(name="project_spr_client")
    @Column(name="spr_client",length = 100) 
	@ResourceKey("speechrecorder.allowedClients")
	@XmlTransient
	public List<SpeechRecorderClient> getAllowedSpeechRecorderClients() {
	
		return allowedSpeechRecorderClients;
	}

	public void setAllowedSpeechRecorderClients(List<SpeechRecorderClient> allowedSpeechRecorderClients) {
		this.allowedSpeechRecorderClients = allowedSpeechRecorderClients;
	}

	@Column(name = "context_path",length = 20)
	@ResourceKey("context.path")
	@XmlTransient
	public String getContextPath() {
		return contextPath;
	}

	public void setContextPath(String contextPath) {
		this.contextPath = contextPath;
	}

	@ManyToOne
	@JoinColumn(name = "audioformat")
	@ResourceKey("audio.format")
	public AudioFormat getAudioFormat() {
		return audioFormat;
	}

	public void setAudioFormat(AudioFormat audioFormat) {
		this.audioFormat = audioFormat;
	}
	
	@ManyToMany(fetch = FetchType.LAZY)
	@JoinTable(
		        name="project_scripts",
		        joinColumns={@JoinColumn(name="project")},
		        inverseJoinColumns={@JoinColumn(name="script")}
		    )
    @ResourceKey("scripts.active")
    @XmlTransient
	public Set<Script> getScripts() {
		return scripts;
	}

	public void setScripts(Set<Script> scripts) {
		this.scripts = scripts;
	}
	
	@OneToMany(fetch = FetchType.LAZY,mappedBy="owningProject")
	@ResourceKey("scripts.owned")
	@XmlTransient
	public Set<Script> getOwnedScripts() {
		return ownedScripts;
	}

	public void setOwnedScripts(Set<Script> ownedScripts) {
		this.ownedScripts = ownedScripts;
	}
	
	
	@ManyToMany()
	@JoinTable(
		        name="project_account",
		        joinColumns={@JoinColumn(name="project")},
		        inverseJoinColumns={@JoinColumn(name="account")}
		    )
    @ResourceKey("accounts")
    @XmlTransient
	public Set<Account> getAccounts() {
		return accounts;
	}

	public void setAccounts(Set<Account> accounts) {
		this.accounts = accounts;
	}
	
	@ManyToMany()
	@JoinTable(
		        name="project_admin_account",
		        joinColumns={@JoinColumn(name="project")},
		        inverseJoinColumns={@JoinColumn(name="admin_account")}
		    )
    @ResourceKey("accounts.admin")
    @XmlTransient
	public Set<Account> getAdminAccounts() {
		return adminAccounts;
	}

	public void setAdminAccounts(Set<Account> adminAccounts) {
		this.adminAccounts = adminAccounts;
	}
	
	@Column(name = "session_code", length = 100)
	@ResourceKey("session.code")
	@XmlTransient
	public String getSessionCode() {
		return sessionCode;
	}

	public void setSessionCode(String sessionCode) {
		this.sessionCode = sessionCode;
	}
	
	@Column(name = "default_research_purpose", length = 10000)
	@Input(required=true)
	@ResourceKey("research.purpose.default.text")
	@ipsk.util.annotations.TextAreaView
	public String getDefaultResearchPurpose() {
		return defaultResearchPurpose;
	}

	public void setDefaultResearchPurpose(String defaultResearchPurpose) {
		this.defaultResearchPurpose = defaultResearchPurpose;
	}

	@Column(name = "default_research_purpose_lang_iso3", length = 10000)
	@Input(required=true)
	@ResourceKey("research.purpose.default.language")	
	public String getDefaultResearchPurposeLanguageISO3code() {
		return defaultResearchPurposeLanguageISO3code;
	}

	public void setDefaultResearchPurposeLanguageISO3code(String defaultResearchPurposeLanguageISO3code) {
		this.defaultResearchPurposeLanguageISO3code = defaultResearchPurposeLanguageISO3code;
	}


	@Column(name = "show_stop_record_button")
	@ResourceKey("prompter.showStopRecordButton")
	public boolean isSpeakerWindowShowStopRecordAction() {
		return speakerWindowShowStopRecordAction;
	}

	public void setSpeakerWindowShowStopRecordAction(
			boolean speakerWindowShowStopRecordAction) {
		this.speakerWindowShowStopRecordAction = speakerWindowShowStopRecordAction;
	}
		
//	public Set<TypedPropertyDescriptor> getImmediateAnnotations() {
//		return immediateAnnotations;
//	}
//
//	public void setImmediateAnnotations(
//			Set<TypedPropertyDescriptor> immediateAnnotations) {
//		this.immediateAnnotations = immediateAnnotations;
//	}

//	@ManyToOne()
//	@JoinColumn(name = "session_finished_l_msg_id")
//    @ResourceKey("session.finishedMessage")
//	public LocalizableMessage getSessionFinishedMessage() {
//		return sessionFinishedMessage;
//	}
//
//	public void setSessionFinishedMessage(LocalizableMessage sessionFinishedMessage) {
//		this.sessionFinishedMessage = sessionFinishedMessage;
//	}
	
//	@OneToOne()
//	@JoinColumn(name = "speaker_formconfiguration_id")
//    @ResourceKey("speaker.form.configuration")
//	public FormConfiguration getSpeakerFormConfiguration() {
//		return speakerFormConfiguration;
//	}
//
//	public void setSpeakerFormConfiguration(
//			FormConfiguration speakerFormConfiguration) {
//		this.speakerFormConfiguration = speakerFormConfiguration;
//	}
}
