/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Script;
import ipsk.db.speech.utils.BooleanValue;
import ipsk.db.speech.utils.MIMETypeWorkaround;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.annotations.TextAreaView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="mediaitem")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="mediaitem")
@PluralResourceKey(value="mediaitems")
@PreferredDisplayOrder(value="mediaitemId,mimetype,srcStr,text,charset,autoplay,modal,volume,annotationTemplate,languageISO639code,countryISO3166code,author,description")
@XmlType(name="mediaitem", namespace="mediaitem")
public class Mediaitem
extends BasicPropertyChangeSupport
implements Serializable,
Cloneable {
    public static final String ELEMENT_NAME = "mediaitem";
    public static final String ATTSRC = "src";
    public static final String ATTMIME = "mimetype";
    public static final String ATTCHARSET = "charset";
    public static final String ATTLANGCODE = "languageISO639code";
    public static final String ATTCOUNTRYCODE = "countryISO3166code";
    public static final String ATTMODAL = "modal";
    public static final String ATTALT = "alt";
    public static final String ATTAUTOPLAY = "autoplay";
    public static final String ATTWIDTH = "width";
    public static final String ATTHEIGHT = "height";
    public static final String ATTVOLUME = "volume";
    public static final String ATTANNOTATION_TEMPLATE = "annotationTemplate";
    public static final String ATTLANGUAGE = "annotationTemplate";
    public static final String DEF_MIMETYPE = "text/plain";
    public static final String DEF_CHARSET = "UTF-8";
    private static final boolean DEF_MODAL = false;
    private static final int DEF_VOLUME = 100;
    private static final String DEF_ALT = null;
    private static final boolean DEF_AUTOPLAY = false;
    private static final int DEF_WIDTH = 0;
    private static final int DEF_HEIGHT = 0;
    private static final double LN = (float)(20.0 / Math.log(10.0));
    private int mediaitemId;
    private String mimetype = null;
    private String charSet = null;
    private String languageISO639code;
    private String countryISO3166code;
    private String srcStr = null;
    private URI src = null;
    private String alt = null;
    private Boolean autoplay = null;
    private Boolean modal = null;
    private Integer width = null;
    private Integer height = null;
    private Integer volume = null;
    private String text = null;
    private String author = null;
    private Script.Scope scope = Script.Scope.APPLICATION;
    private String description;
    private boolean annotationTemplate = false;
    private Set<PromptItem> recpromptsSet = new HashSet<PromptItem>(0);
    private boolean defaultAutoplay = false;
    private String[] comments = new String[0];

    public Mediaitem() {
        this.init();
    }

    public Mediaitem(int mediaitemId) {
        this();
        this.mediaitemId = mediaitemId;
    }

    private void init() {
        this.setMimetype(null);
        this.setSrc(null);
        this.setVolume(null);
        this.setVolume(null);
        this.setAlt(null);
        this.setWidth(null);
        this.setHeight(null);
        this.setText(null);
    }

    public Mediaitem(Element e) {
        this();
        Attr attrAnnotationTemplate;
        Attr attHeightNode;
        Attr attWidthNode;
        Attr attAutoPlay;
        Attr attAlt;
        Attr attVolumeNode;
        Attr attModal;
        Attr attCountryCode;
        Attr attLangCode;
        NodeList childs = e.getChildNodes();
        ArrayList<String> commentsArrList = new ArrayList<String>();
        for (int ci = 0; ci < childs.getLength(); ++ci) {
            Node n = childs.item(ci);
            if (n.getNodeType() != 8) continue;
            commentsArrList.add(n.getNodeValue());
        }
        this.comments = commentsArrList.toArray(new String[0]);
        Attr attMimetype = e.getAttributeNode(ATTMIME);
        Attr attCharset = e.getAttributeNode(ATTCHARSET);
        String mimetypeAttrVal = null;
        String charsetAttrVal = null;
        if (attMimetype != null) {
            mimetypeAttrVal = attMimetype.getValue();
        }
        if (attCharset != null) {
            charsetAttrVal = attCharset.getValue();
        }
        if ((attLangCode = e.getAttributeNode(ATTLANGCODE)) != null) {
            this.languageISO639code = attLangCode.getValue();
        }
        if ((attCountryCode = e.getAttributeNode(ATTCOUNTRYCODE)) != null) {
            this.countryISO3166code = attCountryCode.getValue();
        }
        MIMETypeWorkaround mtw = new MIMETypeWorkaround(mimetypeAttrVal, charsetAttrVal);
        this.setMimetype(mtw.getConvertedMimeType());
        this.setCharSet(mtw.getConvertedCharset());
        Attr attSrc = e.getAttributeNode(ATTSRC);
        if (attSrc != null) {
            URI srcURI = URI.create(attSrc.getValue());
            this.setSrc(srcURI);
        }
        if ((attModal = e.getAttributeNode(ATTMODAL)) != null) {
            this.setModal(BooleanValue.parseExtendedBoolean(attModal));
        }
        if ((attVolumeNode = e.getAttributeNode(ATTVOLUME)) != null) {
            this.setVolume(Integer.parseInt(attVolumeNode.getValue()));
        }
        if ((attAlt = e.getAttributeNode(ATTALT)) != null) {
            this.setAlt(attAlt.getValue());
        }
        if ((attAutoPlay = e.getAttributeNode(ATTAUTOPLAY)) != null) {
            this.setAutoplay(BooleanValue.parseExtendedBoolean(attAutoPlay));
        }
        if ((attWidthNode = e.getAttributeNode(ATTWIDTH)) != null) {
            this.setWidth(Integer.parseInt(attWidthNode.getValue()));
        }
        if ((attHeightNode = e.getAttributeNode(ATTHEIGHT)) != null) {
            this.setHeight(Integer.parseInt(attHeightNode.getValue()));
        }
        if ((attrAnnotationTemplate = e.getAttributeNode("annotationTemplate")) != null) {
            this.setAnnotationTemplate(BooleanValue.parseExtendedBoolean(attrAnnotationTemplate));
        }
        this.setText(e.getTextContent());
    }

    @Id
    @Column(name="mediaitem_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @XmlTransient
    public int getMediaitemId() {
        return this.mediaitemId;
    }

    public void setMediaitemId(int mediaitemId) {
        int oldMediaItemId = this.mediaitemId;
        this.mediaitemId = mediaitemId;
        this.propertyChangeSupport.firePropertyChange("mediaitemId", oldMediaItemId, this.mediaitemId);
    }

    @Column(name="mimetype", length=100)
    @ResourceKey(value="mimetype")
    public String getMimetype() {
        return this.mimetype;
    }

    @Transient
    @XmlTransient
    public String getNNMimetype() {
        if (this.mimetype == null) {
            return DEF_MIMETYPE;
        }
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        String oldMimeType = this.mimetype;
        this.mimetype = mimetype;
        this.propertyChangeSupport.firePropertyChange(ATTMIME, oldMimeType, this.mimetype);
    }

    @Transient
    public void setNNMimetype(String mimetype) {
        if (DEF_MIMETYPE.equals(mimetype)) {
            this.setMimetype(null);
        } else {
            this.setMimetype(mimetype);
        }
    }

    @Column(name="charset", length=100)
    @ResourceKey(value="charset")
    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    @Transient
    public String getNNCharSet() {
        if (this.charSet == null) {
            return DEF_CHARSET;
        }
        return this.charSet;
    }

    @Column(name="src")
    @ResourceKey(value="url")
    @XmlTransient
    public String getSrcStr() {
        return this.srcStr;
    }

    public void setSrcStr(String src) {
        this.srcStr = src;
        this.src = this.srcStr == null ? null : URI.create(this.srcStr);
    }

    @Transient
    public URI getSrc() {
        return this.src;
    }

    public void setSrc(URI src) {
        URI oldSrc = this.src;
        this.src = src;
        this.srcStr = src == null ? null : src.toString();
        this.propertyChangeSupport.firePropertyChange(ATTSRC, oldSrc, this.src);
    }

    @Column(name="alt", unique=false, nullable=true, insertable=true, updatable=true)
    @ResourceKey(value="text.alternative")
    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String alt) {
        String oldAlt = this.alt;
        this.alt = alt;
        this.propertyChangeSupport.firePropertyChange(ATTALT, oldAlt, this.alt);
    }

    @Column(name="autoplay")
    @ResourceKey(value="autoplay")
    public Boolean getAutoplay() {
        return this.autoplay;
    }

    public void setAutoplay(Boolean autoplay) {
        Boolean oldAutoplay = this.autoplay;
        this.autoplay = autoplay;
        this.propertyChangeSupport.firePropertyChange(ATTAUTOPLAY, oldAutoplay, this.autoplay);
    }

    @Transient
    @XmlTransient
    public boolean getNNAutoplay() {
        if (this.autoplay == null) {
            return this.defaultAutoplay;
        }
        return this.autoplay;
    }

    public void setNNAutoplay(boolean autoPlay) {
        if (!autoPlay) {
            this.setAutoplay(null);
        } else {
            this.setAutoplay(this.autoplay);
        }
    }

    @Column(name="modal")
    @ResourceKey(value="modal")
    public Boolean getModal() {
        return this.modal;
    }

    public void setModal(Boolean modal) {
        Boolean oldModal = this.modal;
        this.modal = modal;
        this.propertyChangeSupport.firePropertyChange(ATTMODAL, oldModal, this.modal);
    }

    @Transient
    @XmlTransient
    public boolean getNNModal() {
        if (this.modal == null) {
            return false;
        }
        return this.modal;
    }

    public void setNNModal(boolean modal) {
        if (!modal) {
            this.setModal(null);
        } else {
            this.setModal(modal);
        }
    }

    @Column(name="width")
    @ResourceKey(value="width")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        Integer oldWidth = this.width;
        this.width = width;
        this.propertyChangeSupport.firePropertyChange(ATTWIDTH, oldWidth, this.width);
    }

    @Transient
    @XmlTransient
    public int getNNWidth() {
        if (this.width == null) {
            return 0;
        }
        return this.width;
    }

    public void setNNWidth(int width) {
        if (width == 0) {
            this.setWidth(null);
        } else {
            this.setWidth(width);
        }
    }

    @Column(name="height")
    @ResourceKey(value="height")
    @XmlTransient
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        Integer oldHeight = this.height;
        this.height = height;
        this.propertyChangeSupport.firePropertyChange(ATTHEIGHT, oldHeight, this.height);
    }

    @Transient
    @XmlTransient
    public int getNNHeight() {
        if (this.height == null) {
            return 0;
        }
        return this.height;
    }

    public void setNNHeight(int height) {
        if (height == 0) {
            this.setHeight(null);
        } else {
            this.setHeight(height);
        }
    }

    @Column(name="volume")
    @ResourceKey(value="volume")
    public Integer getVolume() {
        return this.volume;
    }

    public void setVolume(Integer volume) {
        Integer oldVolume = this.volume;
        this.volume = volume;
        this.propertyChangeSupport.firePropertyChange(ATTVOLUME, oldVolume, this.volume);
    }

    @Transient
    @XmlTransient
    public int getNNVolume() {
        if (this.volume == null) {
            return 100;
        }
        return this.volume;
    }

    public void setNNVolume(int volume) {
        if (volume == 100) {
            this.setVolume(null);
        } else {
            this.setVolume(volume);
        }
    }

    @Transient
    @XmlTransient
    public float getNormalizedVolume() {
        if (this.volume == null) {
            return 1.0f;
        }
        if ((double)this.volume.intValue() == 0.0) {
            return 0.0f;
        }
        double dbLogVolume = this.volume * 60 / 100 - 60;
        float normVol = (float)Math.pow(10.0, dbLogVolume / 20.0);
        return normVol;
    }

    @Column(name="mediaitem", length=100000)
    @TextAreaView
    @ResourceKey(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String oldText = this.text;
        this.text = text;
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "text", oldText, this.text);
        this.propertyChangeSupport.firePropertyChange(pce);
    }

    @Transient
    @XmlTransient
    public String getPromptText() {
        if (this.text == null) {
            return null;
        }
        return this.text.replaceAll("\\s{2,}", " ");
    }

    @Column(name="author", length=100)
    @ResourceKey(value="author")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        String oldAuthor = this.author;
        this.author = author;
        this.propertyChangeSupport.firePropertyChange("author", oldAuthor, this.author);
    }

    @Column(length=20)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="scope")
    @XmlTransient
    public Script.Scope getScope() {
        return this.scope;
    }

    public void setScope(Script.Scope scope) {
        this.scope = scope;
    }

    @ResourceKey(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldDescr = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", oldDescr, this.description);
    }

    @ResourceKey(value="annotation.template")
    public boolean getAnnotationTemplate() {
        return this.annotationTemplate;
    }

    public void setAnnotationTemplate(boolean annotationTemplate) {
        this.annotationTemplate = annotationTemplate;
    }

    @ManyToMany(mappedBy="mediaitems", fetch=FetchType.LAZY)
    @ResourceKey(value="promptitems")
    @XmlTransient
    @ObjectImmutableIfReferenced
    public Set<PromptItem> getPromptItemsSet() {
        return this.recpromptsSet;
    }

    public void setPromptItemsSet(Set<PromptItem> recprompts) {
        this.recpromptsSet = recprompts;
    }

    @PrePersist
    public void prePersist() {
        this.consistencyCheck();
    }

    @PreUpdate
    public void preUpdate() {
        this.consistencyCheck();
    }

    private void consistencyCheck() {
        if ("".equals(this.srcStr) && this.text != null) {
            this.setSrcStr(null);
        }
    }

    public String toString() {
        String mType = this.getNNMimetype();
        String mimeClass = mType.substring(0, mType.indexOf("/"));
        if (this.srcStr != null) {
            return mimeClass + ": [" + this.srcStr + "]";
        }
        if (this.text != null) {
            return mimeClass + ": " + this.text;
        }
        return mimeClass;
    }

    public Element toElement(Document d) {
        String src;
        String cs;
        Element e = d.createElement(ELEMENT_NAME);
        String mimeType = this.getMimetype();
        if (mimeType != null) {
            e.setAttribute(ATTMIME, mimeType);
        }
        if ((cs = this.getCharSet()) != null) {
            e.setAttribute(ATTCHARSET, cs);
        }
        if (this.autoplay != null) {
            e.setAttribute(ATTAUTOPLAY, this.autoplay.toString());
        }
        if (this.modal != null) {
            e.setAttribute(ATTMODAL, this.modal.toString());
        }
        if (this.volume != null) {
            e.setAttribute(ATTVOLUME, this.volume.toString());
        }
        if (this.annotationTemplate) {
            e.setAttribute("annotationTemplate", Boolean.toString(this.annotationTemplate));
        }
        if (this.languageISO639code != null) {
            e.setAttribute(ATTLANGCODE, this.languageISO639code);
        }
        if (this.countryISO3166code != null) {
            e.setAttribute(ATTCOUNTRYCODE, this.countryISO3166code);
        }
        if ((src = this.getSrcStr()) != null) {
            e.setAttribute(ATTSRC, src);
        }
        if (this.text != null) {
            if ("text/html".equals(mimeType) || "text/rtf".equals(mimeType)) {
                e.appendChild(d.createCDATASection(this.text));
            } else {
                e.appendChild(d.createTextNode(this.text));
            }
        }
        return e;
    }

    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        Mediaitem mi = (Mediaitem)c;
        mi.propertyChangeSupport = new PropertyChangeSupport(this);
        return mi;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        String hPropName = "mediaitem." + propName;
        this.propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
    }

    @ResourceKey(value="lang.ISO639code")
    public String getLanguageISO639code() {
        return this.languageISO639code;
    }

    public void setLanguageISO639code(String languageISO639code) {
        this.languageISO639code = languageISO639code;
    }

    @ResourceKey(value="country.ISO3166code")
    public String getCountryISO3166code() {
        return this.countryISO3166code;
    }

    public void setCountryISO3166code(String countryISO3166code) {
        this.countryISO3166code = countryISO3166code;
    }

    @Transient
    @XmlTransient
    public boolean isDefaultAutoplay() {
        return this.defaultAutoplay;
    }

    public void setDefaultAutoplay(boolean defaultAutoplay) {
        this.defaultAutoplay = defaultAutoplay;
    }

    public void apply() {
        this.setAutoplay(this.getNNAutoplay());
    }
}

