/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.Unit;
import ipsk.db.speech.Annotation;
import ipsk.db.speech.Distribution;
import ipsk.db.speech.Recording;
import ipsk.db.speech.RecordingTrack;
import ipsk.db.speech.Session;
import ipsk.db.speech.Signal;
import ipsk.db.speech.Technician;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PostPersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="recording_file")
@Cacheable
@NamedQueries(value={@NamedQuery(name="recording_files.bySession", query="SELECT rf FROM RecordingFile rf WHERE rf.session = ?1"), @NamedQuery(name="recording_file.byId", query="SELECT rf FROM RecordingFile rf WHERE rf.recordingFileId = ?1")})
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="recording_file")
@PluralResourceKey(value="recording_files")
@PreferredDisplayOrder(value="recordingFileId,uuid,date,status,recording,annotations,session,*")
public class RecordingFile
implements Serializable {
    private int recordingFileId;
    private String uuid;
    private Session session;
    private Signal signal;
    private Recording recording;
    private String signalFile;
    private Status status;
    private String format;
    private Double samplerate;
    private Integer quantisation;
    private Long bytes;
    private Integer channels;
    private Date date;
    private String encoding;
    private Boolean bigendian;
    private Long frames;
    private Integer version;
    private Double maxLevel;
    private Set<RecordingTrack> recordingTracks = new HashSet<RecordingTrack>(0);
    private Set<Technician> technicians = new HashSet<Technician>(0);
    private Set<Annotation> annotations = new HashSet<Annotation>(0);
    private Set<Distribution> distributions = new HashSet<Distribution>();

    public RecordingFile() {
    }

    public RecordingFile(int recordingFileId) {
        this.recordingFileId = recordingFileId;
    }

    @Id
    @Column(name="recording_file_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getRecordingFileId() {
        return this.recordingFileId;
    }

    public void setRecordingFileId(int recordingFileId) {
        this.recordingFileId = recordingFileId;
    }

    @Column(name="uuid", length=36, unique=true, nullable=true, updatable=false)
    @ResourceKey(value="uuid")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @ManyToOne
    @JoinColumn(name="session_id")
    @ResourceKey(value="session")
    @XmlTransient
    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    @ManyToOne
    @JoinColumn(name="signal_id")
    @ResourceKey(value="signal")
    @XmlTransient
    public Signal getSignal() {
        return this.signal;
    }

    public void setSignal(Signal signal) {
        this.signal = signal;
    }

    @ManyToOne
    @JoinColumn(name="recording_id")
    @ResourceKey(value="recording.item")
    public Recording getRecording() {
        return this.recording;
    }

    public void setRecording(Recording recording) {
        this.recording = recording;
    }

    @Column(name="signal_file", length=1000)
    @ResourceKey(value="url")
    public String getSignalFile() {
        return this.signalFile;
    }

    public void setSignalFile(String signalFile) {
        this.signalFile = signalFile;
    }

    @Column(name="status", length=100)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="status")
    @XmlTransient
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Column(name="format", length=100)
    @ResourceKey(value="audio.format")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Column(name="quantisation")
    @ResourceKey(value="quantisation")
    public Integer getQuantisation() {
        return this.quantisation;
    }

    public void setQuantisation(Integer quantisation) {
        this.quantisation = quantisation;
    }

    @Column(name="samplerate", precision=8, scale=0)
    @ResourceKey(value="samplerate")
    @Unit(value="Hz")
    public Double getSamplerate() {
        return this.samplerate;
    }

    public void setSamplerate(Double samplerate) {
        this.samplerate = samplerate;
    }

    @Column(name="bytes")
    @ResourceKey(value="length.in_bytes")
    public Long getBytes() {
        return this.bytes;
    }

    public void setBytes(Long bytes) {
        this.bytes = bytes;
    }

    @Column(name="encoding", length=100)
    @ResourceKey(value="encoding")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Column(name="bigendian")
    @ResourceKey(value="bigendian")
    public Boolean getBigendian() {
        return this.bigendian;
    }

    public void setBigendian(Boolean bigendian) {
        this.bigendian = bigendian;
    }

    @Column(name="frames")
    @ResourceKey(value="length.in_frames")
    public Long getFrames() {
        return this.frames;
    }

    public void setFrames(Long frames) {
        this.frames = frames;
    }

    @Transient
    public Double getLengthInSeconds() {
        Long frames = this.getFrames();
        Double sampleRate = this.getSamplerate();
        if (sampleRate != null && frames != null) {
            return (double)frames.longValue() / sampleRate;
        }
        return null;
    }

    @Column(name="channels")
    @ResourceKey(value="channels")
    public Integer getChannels() {
        return this.channels;
    }

    public void setChannels(Integer channels) {
        this.channels = channels;
    }

    @Column(name="date")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="point_in_time")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="recordingFile")
    public Set<RecordingTrack> getRecordingTracks() {
        return this.recordingTracks;
    }

    public void setRecordingTracks(Set<RecordingTrack> recordingTracks) {
        this.recordingTracks = recordingTracks;
    }

    @ManyToMany(mappedBy="recordingFiles", fetch=FetchType.LAZY)
    @ResourceKey(value="technicians")
    @XmlTransient
    public Set<Technician> getTechnicians() {
        return this.technicians;
    }

    public void setTechnicians(Set<Technician> technicians) {
        this.technicians = technicians;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="annotates", joinColumns={@JoinColumn(name="recording_id")}, inverseJoinColumns={@JoinColumn(name="annotation_id")})
    @ResourceKey(value="annotations")
    @XmlTransient
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    @ManyToMany(mappedBy="recordingFiles")
    @ResourceKey(value="distributions")
    @XmlTransient
    public Set<Distribution> getDistributions() {
        return this.distributions;
    }

    public void setDistributions(Set<Distribution> distributions) {
        this.distributions = distributions;
    }

    public String toString() {
        return "Recording file ID " + this.getRecordingFileId() + ": " + this.getSignalFile();
    }

    @Column
    @ResourceKey(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Column(name="max_level")
    @ResourceKey(value="audio.level.max")
    public Double getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(Double maxRecordingLevel) {
        this.maxLevel = maxRecordingLevel;
    }

    @PostPersist
    public void notfiyListeners() {
    }

    public static enum Status {
        REGISTERED,
        RECORDED,
        PROCESS_ERROR,
        PROCESSED;

    }
}

