/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.Recording;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="reccomment")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
public class Reccomment
extends BasicPropertyChangeSupport
implements Serializable {
    public static final String ELEMENT_NAME = "reccomment";
    private int reccommentId;
    private String reccomment;
    private Set<Recording> recordingsSet = new HashSet<Recording>(0);
    private String[] comments = new String[0];

    public Reccomment() {
    }

    public Reccomment(int reccommentId) {
        this();
        this.reccommentId = reccommentId;
    }

    public Reccomment(int reccommentId, String reccomment, Set<Recording> recordings) {
        this(reccommentId);
        this.reccomment = reccomment;
        this.recordingsSet = recordings;
    }

    public Reccomment(Element e) {
        this();
        NodeList childs = e.getChildNodes();
        ArrayList<String> commentsArrList = new ArrayList<String>();
        for (int ci = 0; ci < childs.getLength(); ++ci) {
            Node n = childs.item(ci);
            if (n.getNodeType() != 8) continue;
            commentsArrList.add(n.getNodeValue());
        }
        this.comments = commentsArrList.toArray(new String[0]);
        this.setReccomment(e.getTextContent());
    }

    @Id
    @Column(name="reccomment_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @XmlTransient
    public int getReccommentId() {
        return this.reccommentId;
    }

    public void setReccommentId(int reccommentId) {
        int oldReccommentId = this.reccommentId;
        this.reccommentId = reccommentId;
        this.propertyChangeSupport.firePropertyChange("reccommentId", oldReccommentId, this.reccommentId);
    }

    @Column(name="reccomment", length=1000)
    @ResourceKey(value="reccomment")
    public String getReccomment() {
        return this.reccomment;
    }

    public void setReccomment(String reccomment) {
        String oldReccomment = this.reccomment;
        this.reccomment = reccomment;
        this.propertyChangeSupport.firePropertyChange(ELEMENT_NAME, oldReccomment, this.reccomment);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="reccomment")
    @ObjectImmutableIfReferenced
    @XmlTransient
    public Set<Recording> getRecordingsSet() {
        return this.recordingsSet;
    }

    public void setRecordingsSet(Set<Recording> recordings) {
        this.recordingsSet = recordings;
    }

    public String toString() {
        if (this.reccomment != null) {
            return this.reccomment;
        }
        return "";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Reccomment)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Reccomment other = (Reccomment)o;
        if (other.getReccommentId() != this.reccommentId) {
            return false;
        }
        return !(other.getReccomment() == null ? this.reccomment != null : !other.getReccomment().equals(this.reccomment));
    }

    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        for (String comm : this.comments) {
            e.appendChild(d.createComment(comm));
        }
        e.appendChild(d.createTextNode(this.getReccomment()));
        return e;
    }
}

