/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.Group;
import ipsk.db.speech.Nonrecording;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Recording;
import ipsk.db.speech.Script;
import ipsk.persistence.ImmutibilityProvider;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="section")
@Cacheable
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="section")
@PluralResourceKey(value="sections")
@PreferredDisplayOrder(value="sectionId,name,groups,mode,order,*")
@XmlType(name="section", namespace="section", propOrder={"name", "mode", "order", "promptphase", "training", "speakerDisplay", "groups"})
public class Section
extends BasicPropertyChangeSupport
implements Serializable,
Cloneable,
Transferable,
ImmutibilityProvider {
    public static final String ELEMENT_NAME = "section";
    public static final DataFlavor CLASS_DATA_FLAVOR = new DataFlavor(Section.class, null);
    private DataFlavor textXmlFlavor;
    public static final PromptPhase DEF_PROMPT_PHASE = PromptPhase.IDLE;
    private int sectionId;
    private Script script;
    private String name;
    private Boolean speakerDisplay;
    private String speakerdisplayStr;
    private Integer sectionPosition;
    private PromptPhase promptphase;
    private Mode mode;
    private Order order;
    private List<Group> groups = new ArrayList<Group>();
    private String[] comments = new String[0];
    private boolean defaultSpeakerDisplay = false;
    private Mode defaultMode = Mode.MANUAL;
    private Order defaultOrder = Order.SEQUENTIAL;
    private boolean training = false;
    private List<Group> shuffledPromptGroups = null;
    private boolean propertyChangeSupportEnabled = false;
    private DataFlavor[] dataFlavors;
    private transient DOMConverter domConverter;

    @Transient
    @XmlTransient
    public boolean isPropertyChangeSupportEnabled() {
        return this.propertyChangeSupportEnabled;
    }

    public void setPropertyChangeSupportEnabled(boolean propertyChangeSupportEnabled) {
        this.propertyChangeSupportEnabled = propertyChangeSupportEnabled;
    }

    public Section() {
        this.textXmlFlavor = DataFlavor.stringFlavor;
        this.dataFlavors = this.textXmlFlavor != null ? new DataFlavor[]{CLASS_DATA_FLAVOR, this.textXmlFlavor} : new DataFlavor[]{CLASS_DATA_FLAVOR};
    }

    public Section(IntegerSequenceGenerator seqGen, Element e) {
        if (seqGen != null) {
            this.setSectionId(seqGen.getAndIncrement());
        }
        NodeList childs = e.getChildNodes();
        ArrayList<String> commentsArrList = new ArrayList<String>();
        for (int ci = 0; ci < childs.getLength(); ++ci) {
            Node n = childs.item(ci);
            if (n.getNodeType() != 8) continue;
            commentsArrList.add(n.getNodeValue());
        }
        this.comments = commentsArrList.toArray(new String[0]);
        this.initializeSection();
        Attr attr = e.getAttributeNode("name");
        if (attr != null) {
            this.setName(attr.getValue());
        }
        if ((attr = e.getAttributeNode("mode")) != null) {
            this.setMode(Mode.getByValue(attr.getValue()));
        }
        if ((attr = e.getAttributeNode("order")) != null) {
            this.setOrder(Order.getByValue(attr.getValue()));
        }
        if ((attr = e.getAttributeNode("promptphase")) != null) {
            this.setPromptphase(PromptPhase.getByValue(attr.getValue()));
        }
        if ((attr = e.getAttributeNode("speakerdisplay")) != null) {
            this.setSpeakerdisplayStr(attr.getValue());
        }
        ArrayList<Group> promptItemArrList = new ArrayList<Group>();
        NodeList eNodeList = e.getChildNodes();
        for (int i = 0; i < eNodeList.getLength(); ++i) {
            Group group;
            Node n = eNodeList.item(i);
            if (n.getNodeType() != 1) continue;
            Element piE = (Element)n;
            if (piE.getTagName().equals("recording")) {
                Recording recording = new Recording(seqGen, piE);
                group = new Group(seqGen, recording, this);
                group.setSection(this);
                promptItemArrList.add(group);
                continue;
            }
            if (piE.getTagName().equals("nonrecording")) {
                Nonrecording nonrecording = new Nonrecording(seqGen, piE);
                group = new Group(seqGen, nonrecording, this);
                group.setSection(this);
                promptItemArrList.add(group);
                continue;
            }
            if (!piE.getTagName().equals("group")) continue;
            Group group2 = new Group(seqGen, piE, this);
            group2.setSection(this);
            promptItemArrList.add(group2);
        }
        this.setGroups(promptItemArrList);
    }

    private void initializeSection() {
    }

    public Set<List<String>> requiredMIMETypeCombinations() {
        HashSet<List<String>> reqMIMETypes = new HashSet<List<String>>();
        List<Group> pisList = this.getGroups();
        for (Group g : pisList) {
            for (PromptItem pi : g.getPromptItems()) {
                List<String> piMimes = pi.getMIMETypes();
                reqMIMETypes.add(piMimes);
            }
        }
        return reqMIMETypes;
    }

    @Id
    @Column(name="section_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @XmlTransient
    public int getSectionId() {
        return this.sectionId;
    }

    public void setSectionId(int sectionId) {
        int oldsectionId = this.sectionId;
        this.sectionId = sectionId;
        this.propertyChangeSupport.firePropertyChange("sectionId", oldsectionId, this.sectionId);
    }

    @ManyToOne
    @JoinColumn(name="script_id")
    @ResourceKey(value="script")
    @XmlTransient
    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    @Column(name="name", length=100)
    @ResourceKey(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "name", oldName, this.name);
        this.propertyChangeSupport.firePropertyChange(pce);
    }

    @Column(name="speakerdisplay", length=10)
    @ResourceKey(value="speakerdisplay")
    @XmlTransient
    public String getSpeakerdisplayStr() {
        return this.speakerdisplayStr;
    }

    public void setSpeakerdisplayStr(String speakerdisplayStr) {
        this.speakerdisplayStr = speakerdisplayStr;
        this.speakerDisplay = speakerdisplayStr != null ? (speakerdisplayStr.equalsIgnoreCase("yes") ? Boolean.valueOf(true) : new Boolean(speakerdisplayStr)) : Boolean.valueOf(false);
    }

    @Transient
    public boolean getNNSpeakerDisplay() {
        if (this.speakerDisplay == null) {
            return this.defaultSpeakerDisplay;
        }
        return this.speakerDisplay;
    }

    @Column(name="promptphase", length=100)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="promptphase")
    public PromptPhase getPromptphase() {
        return this.promptphase;
    }

    @Transient
    public PromptPhase getNNPromptphase() {
        if (this.promptphase == null) {
            return DEF_PROMPT_PHASE;
        }
        return this.promptphase;
    }

    public void setPromptphase(PromptPhase promptphase) {
        PromptPhase oldPromptphase = this.promptphase;
        this.promptphase = promptphase;
        if (this.propertyChangeSupportEnabled) {
            this.propertyChangeSupport.firePropertyChange("promptphase", (Object)oldPromptphase, (Object)this.promptphase);
        }
    }

    @Column(name="mode", length=100)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="mode")
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        Mode oldMode = this.mode;
        this.mode = mode;
        if (this.propertyChangeSupportEnabled) {
            this.propertyChangeSupport.firePropertyChange("mode", (Object)oldMode, (Object)this.mode);
        }
    }

    @Transient
    public Mode getNNMode() {
        if (this.mode == null) {
            return this.defaultMode;
        }
        return this.mode;
    }

    @Column(name="ordering", length=100)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="order")
    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        Order oldOrder = this.order;
        this.order = order;
        this.propertyChangeSupport.firePropertyChange("order", (Object)oldOrder, (Object)this.order);
    }

    @Transient
    public Order getNNOrder() {
        if (this.order == null) {
            return this.defaultOrder;
        }
        return this.order;
    }

    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.MERGE}, fetch=FetchType.LAZY, mappedBy="section")
    @OrderColumn(name="group_position")
    @ResourceKey(value="groups")
    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> promptItems) {
        List<Group> oldPromptItems = this.groups;
        this.groups = promptItems;
        this.shuffledPromptGroups = null;
        if (this.propertyChangeSupportEnabled) {
            if (this.groups != null) {
                for (Group g : this.groups) {
                    g.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            String propName = evt.getPropertyName();
                            String hPropName = "promptItems." + propName;
                            Section.this.propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
                        }
                    });
                }
            }
            this.propertyChangeSupport.firePropertyChange("promptItems", oldPromptItems, this.groups);
        }
    }

    @ResourceKey(value="training")
    @Basic
    public boolean isTraining() {
        return this.training;
    }

    public void setTraining(boolean training) {
        this.training = training;
    }

    public Element toElement(Document d) {
        String speakerdisplay;
        Mode mode;
        PromptPhase promptphase;
        Order order;
        Element e = d.createElement(ELEMENT_NAME);
        for (String comm : this.comments) {
            e.appendChild(d.createComment(comm));
        }
        String name = this.getName();
        if (name != null) {
            e.setAttribute("name", name);
        }
        if ((order = this.getOrder()) != null) {
            e.setAttribute("order", order.value());
        }
        if ((promptphase = this.getPromptphase()) != null) {
            e.setAttribute("promptphase", promptphase.value);
        }
        if ((mode = this.getMode()) != null) {
            e.setAttribute("mode", mode.value());
        }
        if ((speakerdisplay = this.getSpeakerdisplayStr()) != null) {
            e.setAttribute("speakerdisplay", speakerdisplay);
        }
        List<Group> gs = this.getGroups();
        for (Group g : gs) {
            List<PromptItem> pis = g.getPromptItems();
            if (pis.size() == 1) {
                e.appendChild(pis.get(0).toElement(d));
                continue;
            }
            e.appendChild(g.toElement(d));
        }
        return e;
    }

    @Transient
    public Boolean getSpeakerDisplay() {
        return this.speakerDisplay;
    }

    public void setSpeakerDisplay(Boolean speakerDisplay) {
        Boolean oldSpeakerDisplay = this.speakerDisplay;
        this.speakerDisplay = speakerDisplay;
        this.speakerdisplayStr = speakerDisplay == null ? null : speakerDisplay.toString();
        if (this.propertyChangeSupportEnabled) {
            this.propertyChangeSupport.firePropertyChange("speakerDisplay", oldSpeakerDisplay, this.speakerDisplay);
        }
    }

    public String toString() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return Integer.toString(this.getSectionId());
    }

    @Transient
    public String getInfo() {
        String attrs = this.getNNMode() + ", " + this.getNNOrder() + ", " + this.getNNPromptphase() + ", " + this.getNNSpeakerDisplay();
        if (this.name == null) {
            return attrs;
        }
        return this.name + ", " + attrs;
    }

    @Override
    @Transient
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor df : this.dataFlavors) {
            if (!df.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Transient
    public void setDefaultMode(Mode defaultMode) {
        this.defaultMode = defaultMode;
    }

    @Transient
    public void setDefaultSpeakerDisplay(boolean defaultSpeakerDisplay) {
        this.defaultSpeakerDisplay = defaultSpeakerDisplay;
    }

    @Transient
    public void defaultPrerecdelay(int defaultPrerecdelay) {
        List<Group> grs = this.getGroups();
        for (Group g : grs) {
            g.defaultPrerecdelay(defaultPrerecdelay);
        }
    }

    @Transient
    public void defaultPostrecdelay(int defaultPostrecdelay) {
        List<Group> grs = this.getGroups();
        for (Group g : grs) {
            g.defaultPostrecdelay(defaultPostrecdelay);
        }
    }

    @Transient
    public void defaultAutoplay(boolean defaultAutoplay) {
        List<Group> grs = this.getGroups();
        for (Group g : grs) {
            g.defaultAutoplay(defaultAutoplay);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        Section cs = (Section)c;
        List<Group> gs = this.groups;
        ArrayList<Group> cGs = new ArrayList<Group>();
        for (Group g : gs) {
            Group cG = (Group)g.clone();
            cGs.add(cG);
        }
        cs.groups = cGs;
        cs.propertyChangeSupport = new PropertyChangeSupport(this);
        return cs;
    }

    @Transient
    @XmlTransient
    public Mode getDefaultMode() {
        return this.defaultMode;
    }

    @Transient
    @XmlTransient
    public boolean isDefaultSpeakerDisplay() {
        return this.defaultSpeakerDisplay;
    }

    @Transient
    public boolean recordingCodesUnique() {
        HashSet<String> itemCodes = new HashSet<String>();
        for (Group g : this.groups) {
            for (PromptItem pi : g.getPromptItems()) {
                Recording r = (Recording)pi;
                String itemCode = r.getItemcode();
                if (itemCodes.contains(itemCode)) {
                    return false;
                }
                itemCodes.add(itemCode);
            }
        }
        return true;
    }

    @Transient
    public void updateUpwardsRelations() {
        for (Group g : this.groups) {
            g.setSection(this);
            g.updateUpwardsRelations();
        }
    }

    @Transient
    private List<PromptItem> toPromptItemList(List<Group> groups) {
        ArrayList<PromptItem> pis = new ArrayList<PromptItem>();
        for (Group g : groups) {
            pis.addAll(g.shuffledPromptItems());
        }
        return pis;
    }

    @Transient
    public void shuffleItems() {
        ArrayList<Group> shuffledUnits = new ArrayList<Group>(this.groups);
        Random rnd = new Random();
        for (int i = this.groups.size(); i > 1; --i) {
            this.swap(shuffledUnits, i - 1, rnd.nextInt(i));
        }
        for (Group g : shuffledUnits) {
            g.shuffleItems();
        }
        this.shuffledPromptGroups = shuffledUnits;
    }

    private void swap(List<Group> items, int i, int j) {
        Group tmp = items.get(i);
        items.set(i, items.get(j));
        items.set(j, tmp);
    }

    @Transient
    public List<PromptItem> getShuffledPromptItems() {
        if (this.getNNOrder().equals((Object)Order.RANDOM)) {
            if (this.shuffledPromptGroups == null) {
                this.shuffleItems();
            }
            return this.toPromptItemList(this.shuffledPromptGroups);
        }
        return this.toPromptItemList(this.groups);
    }

    void apply() {
        this.setSpeakerDisplay(this.getNNSpeakerDisplay());
        this.setMode(this.getNNMode());
        for (Group g : this.getGroups()) {
            g.apply();
        }
        if (this.getNNOrder().equals((Object)Order.RANDOM)) {
            if (this.shuffledPromptGroups == null) {
                this.shuffleItems();
            }
            this.setGroups(this.shuffledPromptGroups);
            this.setOrder(Order.RANDOMIZED);
        }
    }

    @Override
    @Transient
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (CLASS_DATA_FLAVOR.equals(flavor)) {
            return this;
        }
        if (this.textXmlFlavor != null && this.textXmlFlavor.equals(flavor)) {
            try {
                if (this.domConverter == null) {
                    this.domConverter = new DOMConverter();
                }
                Document d = this.domConverter.newDocument();
                d.appendChild(this.toElement(d));
                return this.domConverter.writeFragmentToString(d);
            }
            catch (DOMConverterException e) {
                throw new IOException(e);
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    @Transient
    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavors;
    }

    public static void main(String[] args) {
        Mode m = Mode.getByValue("autoprogress");
        System.out.println(m.value());
    }

    @Transient
    public Set<String> itemCodesSet() {
        HashSet<String> ics = new HashSet<String>();
        List<String> itemCodesList = this.itemCodesList();
        ics.addAll(itemCodesList);
        return ics;
    }

    @Transient
    public List<String> itemCodesList() {
        ArrayList<String> icl = new ArrayList<String>();
        for (Group g : this.groups) {
            for (PromptItem gPi : g.getPromptItems()) {
                Recording gr;
                String ic;
                if (!(gPi instanceof Recording) || (ic = (gr = (Recording)gPi).getItemcode()) == null) continue;
                icl.add(ic);
            }
        }
        return icl;
    }

    @Transient
    public boolean needsSilenceDetector() {
        for (PromptItem pi : this.promptItemsList()) {
            Recording r;
            if (!(pi instanceof Recording) || !(r = (Recording)pi).needsSilenceDetector()) continue;
            return true;
        }
        return false;
    }

    @Transient
    public List<PromptItem> promptItemsList() {
        ArrayList<PromptItem> pis = new ArrayList<PromptItem>();
        for (Group g : this.getGroups()) {
            pis.addAll(g.getPromptItems());
        }
        return pis;
    }

    @Transient
    public boolean needsBeep() {
        for (PromptItem pi : this.promptItemsList()) {
            Recording r;
            if (!(pi instanceof Recording) || !(r = (Recording)pi).needsBeep()) continue;
            return true;
        }
        return false;
    }

    @Transient
    public Set<URI> resourceURIs() {
        HashSet<URI> usedUris = new HashSet<URI>();
        for (PromptItem pi : this.promptItemsList()) {
            usedUris.addAll(pi.resourceURIs());
        }
        return usedUris;
    }

    @Transient
    public boolean isImmutable() {
        Script script = this.getScript();
        return script != null && script.isImmutable();
    }

    @Transient
    public boolean isRemovable() {
        return !this.isImmutable();
    }

    public static enum Mode {
        MANUAL("manual"),
        AUTOPROGRESS("autoprogress"),
        AUTORECORDING("autorecording");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static Mode getByValue(String value) {
            for (Mode pp : Mode.values()) {
                if (!pp.value.equals(value)) continue;
                return pp;
            }
            return null;
        }
    }

    @XmlType(namespace="section")
    public static enum Order {
        SEQUENTIAL("sequential"),
        RANDOM("random"),
        RANDOMIZED("randomized");

        private final String value;

        private Order(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static Order getByValue(String value) {
            for (Order pp : Order.values()) {
                if (!pp.value.equals(value)) continue;
                return pp;
            }
            return null;
        }
    }

    public static enum PromptPhase {
        IDLE("idle"),
        RECORDING("recording"),
        PRERECORDING("prerecording");

        private final String value;

        private PromptPhase(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static PromptPhase getByValue(String value) {
            for (PromptPhase pp : PromptPhase.values()) {
                if (!pp.value.equals(value)) continue;
                return pp;
            }
            return null;
        }
    }
}

